/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class FOMInitDialog
extends AlgorithmDialog {
    public static final int CAST = 1;
    public static final int KMEANS = 2;
    IterationPanel iPanel;
    KMCPanel kPanel;
    CASTPanel cPanel;
    JTabbedPane methodTabPane;
    JCheckBox takeAverageBox;
    SampleSelectionPanel sPanel;
    boolean okPressed = false;

    public FOMInitDialog(JFrame jFrame, boolean bl) {
        super(jFrame, "FOM: Figure of Merit", bl);
        this.setBounds(0, 0, 450, 400);
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.white);
        this.sPanel = new SampleSelectionPanel();
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 10);
        gridBagLayout.setConstraints(this.sPanel, gridBagConstraints);
        jPanel.add(this.sPanel);
        this.iPanel = new IterationPanel();
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 20);
        gridBagLayout.setConstraints(this.iPanel, gridBagConstraints);
        jPanel.add(this.iPanel);
        UIManager.put("TabbedPane.selected", Color.white);
        this.methodTabPane = new JTabbedPane();
        this.kPanel = new KMCPanel();
        this.cPanel = new CASTPanel();
        this.methodTabPane.add("K-Means / K-Medians", this.kPanel);
        this.methodTabPane.add("CAST", this.cPanel);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 90);
        gridBagLayout.setConstraints(this.methodTabPane, gridBagConstraints);
        jPanel.add(this.methodTabPane);
        this.takeAverageBox = new JCheckBox("Take Average", true);
        this.takeAverageBox.setEnabled(false);
        gridBagConstraints.fill = 1;
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 30);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
        this.methodTabPane.addChangeListener(eventListener);
        this.pack();
        this.setSize(600, 450);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            this.okButton.requestFocus();
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public int getMethod() {
        int n = 0;
        if (this.methodTabPane.getSelectedIndex() == 0) {
            n = 2;
        } else if (this.methodTabPane.getSelectedIndex() == 1) {
            n = 1;
        }
        return n;
    }

    public boolean useMeans() {
        return this.kPanel.meansButton.isSelected();
    }

    public float getInterval() {
        String string = this.cPanel.thresholdInputField.getText();
        float f = Float.parseFloat(string);
        return f;
    }

    public int getIterations() {
        String string = this.kPanel.intervalInputField.getText();
        int n = Integer.parseInt(string);
        return n;
    }

    public int getKMCIterations() {
        String string = this.kPanel.iterationInputField.getText();
        int n = Integer.parseInt(string);
        return n;
    }

    public int getFOMIterations() {
        String string = this.iPanel.iterationField.getText();
        return Integer.parseInt(string);
    }

    public boolean isAverage() {
        return this.takeAverageBox.isSelected();
    }

    public boolean isClusterGenes() {
        return this.sPanel.calcGenes.isSelected();
    }

    private void resetControls() {
        this.sPanel.calcGenes.setSelected(true);
        this.kPanel.meansButton.setSelected(true);
        this.kPanel.intervalInputField.setText("20");
        this.kPanel.iterationInputField.setText("50");
        this.cPanel.thresholdInputField.setText("0.1");
        this.iPanel.iterationField.setText("1");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        FOMInitDialog fOMInitDialog = new FOMInitDialog(jFrame, true);
        fOMInitDialog.show();
        System.out.println(fOMInitDialog.getIterations());
        System.exit(0);
    }

    protected class EventListener
    extends WindowAdapter
    implements ActionListener,
    ChangeListener {
        protected EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                FOMInitDialog.this.okPressed = true;
                int n = FOMInitDialog.this.methodTabPane.getSelectedIndex();
                int n2 = 1;
                int n3 = -1;
                float f = -1.0f;
                float f2 = -1.0f;
                float f3 = -1.0f;
                try {
                    if (n == 0) {
                        n2 = Integer.parseInt(FOMInitDialog.this.iPanel.iterationField.getText());
                        f3 += 1.0f;
                        n3 = Integer.parseInt(FOMInitDialog.this.kPanel.intervalInputField.getText());
                        f3 += 1.0f;
                        f2 = Integer.parseInt(FOMInitDialog.this.kPanel.iterationInputField.getText());
                        f3 += 1.0f;
                    } else {
                        f = Float.parseFloat(FOMInitDialog.this.cPanel.thresholdInputField.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (f3 == -1.0f) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Number format error. Expecting an integer for FOM iteration parameter.", "Number Format Error", 0);
                        FOMInitDialog.this.iPanel.iterationField.requestFocus();
                        FOMInitDialog.this.iPanel.iterationField.selectAll();
                    } else if (n == 0) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Number format error.", "Number Format Error", 0);
                        if (f3 == 0.0f) {
                            FOMInitDialog.this.kPanel.intervalInputField.requestFocus();
                            FOMInitDialog.this.kPanel.intervalInputField.selectAll();
                        } else {
                            FOMInitDialog.this.kPanel.iterationInputField.requestFocus();
                            FOMInitDialog.this.kPanel.iterationInputField.selectAll();
                        }
                    } else {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Number format error.", "Number Format Error", 0);
                        FOMInitDialog.this.cPanel.thresholdInputField.requestFocus();
                        FOMInitDialog.this.cPanel.thresholdInputField.selectAll();
                    }
                    return;
                }
                if (n == 0) {
                    if (n2 < 1) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "FOM iterations must be > 0", "Invalid Input Error", 0);
                        FOMInitDialog.this.iPanel.iterationField.requestFocus();
                        FOMInitDialog.this.iPanel.iterationField.selectAll();
                        return;
                    }
                    if (n3 < 1) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Maximum Number of Clusters must be > 0", "Number Format Error", 0);
                        FOMInitDialog.this.kPanel.intervalInputField.requestFocus();
                        FOMInitDialog.this.kPanel.intervalInputField.selectAll();
                        return;
                    }
                    if (f2 < 1.0f) {
                        JOptionPane.showMessageDialog(FOMInitDialog.this, "Maximum Number of intervals per KMC run must be > 0", "Number Format Error", 0);
                        FOMInitDialog.this.kPanel.iterationInputField.requestFocus();
                        FOMInitDialog.this.kPanel.iterationInputField.selectAll();
                        return;
                    }
                } else if (f <= 0.0f || f >= 1.0f) {
                    JOptionPane.showMessageDialog(FOMInitDialog.this, "Interval must be > 0 and < 1.0", "Number Format Error", 0);
                    FOMInitDialog.this.cPanel.thresholdInputField.requestFocus();
                    FOMInitDialog.this.cPanel.thresholdInputField.selectAll();
                    return;
                }
                UIManager.put("TabbedPane.selected", Color.lightGray);
                FOMInitDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                UIManager.put("TabbedPane.selected", Color.lightGray);
                FOMInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                FOMInitDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(FOMInitDialog.this, "FOM Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            UIManager.put("TabbedPane.selected", Color.lightGray);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            if (jTabbedPane.getSelectedIndex() == 0) {
                FOMInitDialog.this.iPanel.setEnabled(true);
            } else {
                FOMInitDialog.this.iPanel.setEnabled(false);
            }
        }
    }

    private class IterationPanel
    extends ParameterPanel {
        JLabel iterationLabel;
        JTextField iterationField;

        public IterationPanel() {
            super("FOM Iteration Selection");
            this.setLayout(new GridBagLayout());
            this.iterationLabel = new JLabel("Number of FOM Iterations");
            this.iterationLabel.setOpaque(false);
            this.iterationField = new JTextField("1", 5);
            this.add((Component)this.iterationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)this.iterationField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        }

        public void setEnabled(boolean bl) {
            this.iterationLabel.setEnabled(bl);
            this.iterationField.setEnabled(bl);
            if (bl) {
                this.iterationField.setBackground(Color.white);
            } else {
                this.iterationField.setBackground(Color.lightGray);
            }
        }
    }

    class SampleSelectionPanel
    extends JPanel {
        JRadioButton calcGenes;
        JRadioButton calcExperiments;

        SampleSelectionPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Sample Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.calcGenes = new JRadioButton("Gene Cluster FOM", true);
            this.calcGenes.setFocusPainted(false);
            this.calcGenes.setBackground(Color.white);
            this.calcGenes.setForeground(UIManager.getColor("Label.foreground"));
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.calcGenes, gridBagConstraints);
            this.add(this.calcGenes);
            this.calcExperiments = new JRadioButton("Sample Cluster FOM");
            this.calcExperiments.setFocusPainted(false);
            this.calcExperiments.setBackground(Color.white);
            this.calcExperiments.setForeground(UIManager.getColor("Label.foreground"));
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.calcExperiments, gridBagConstraints);
            this.add(this.calcExperiments);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.calcGenes);
            buttonGroup.add(this.calcExperiments);
        }
    }

    class CASTPanel
    extends JPanel {
        JTextField thresholdInputField;

        CASTPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            this.setLayout(gridBagLayout);
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray, 2));
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout2);
            jPanel2.setBackground(Color.white);
            JLabel jLabel = new JLabel("Interval ( enter a value between 0 and 1):    ");
            jLabel.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagConstraints.anchor = 13;
            gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            this.thresholdInputField = new JTextField("0.1", 7);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout2.setConstraints(this.thresholdInputField, gridBagConstraints);
            jPanel2.add(this.thresholdInputField);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 60);
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel3.setLayout(gridBagLayout3);
            jPanel3.setBackground(Color.white);
            jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JLabel jLabel2 = new JLabel("CAST will be run with threshold affinities starting with above interval,");
            jLabel2.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 33);
            gridBagConstraints.anchor = 16;
            gridBagLayout3.setConstraints(jLabel2, gridBagConstraints);
            jPanel3.add(jLabel2);
            JLabel jLabel3 = new JLabel("with affinity being incremented by the interval value in subsequent");
            jLabel3.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 33);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(jLabel3, gridBagConstraints);
            jPanel3.add(jLabel3);
            JLabel jLabel4 = new JLabel("iterations, up to a maximum threshold affinity of 1.0");
            jLabel4.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 34);
            gridBagConstraints.anchor = 18;
            gridBagLayout3.setConstraints(jLabel4, gridBagConstraints);
            jPanel3.add(jLabel4);
            gridBagConstraints.anchor = 10;
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 40);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            this.add(jPanel3);
        }
    }

    class KMCPanel
    extends JPanel {
        JRadioButton meansButton;
        JRadioButton mediansButton;
        JTextField intervalInputField;
        JTextField iterationInputField;

        KMCPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.lightGray, 2));
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            jPanel.setBackground(Color.white);
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 15, 10));
            this.meansButton = new JRadioButton("Calculate means", true);
            this.meansButton.setBackground(Color.white);
            this.meansButton.setForeground(UIManager.getColor("Label.foreground"));
            this.meansButton.setFocusPainted(false);
            this.mediansButton = new JRadioButton("Calculate medians", false);
            this.mediansButton.setBackground(Color.white);
            this.mediansButton.setForeground(UIManager.getColor("Label.foreground"));
            this.mediansButton.setFocusPainted(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.meansButton);
            buttonGroup.add(this.mediansButton);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagLayout2.setConstraints(this.meansButton, gridBagConstraints);
            jPanel.add(this.meansButton);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagLayout2.setConstraints(this.mediansButton, gridBagConstraints);
            jPanel.add(this.mediansButton);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 40);
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            jPanel2.setBackground(Color.white);
            gridBagConstraints.fill = 0;
            JLabel jLabel = new JLabel("Maximum number of clusters (enter an integer > 0):   ");
            jLabel.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagConstraints.anchor = 13;
            gridBagLayout3.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            this.intervalInputField = new JTextField("20", 7);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(this.intervalInputField, gridBagConstraints);
            jPanel2.add(this.intervalInputField);
            JLabel jLabel2 = new JLabel("Maximum number of iterations (enter an integer > 0):   ");
            jLabel2.setBackground(Color.white);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 100);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets.top = 10;
            gridBagLayout3.setConstraints(jLabel2, gridBagConstraints);
            jPanel2.add(jLabel2);
            this.iterationInputField = new JTextField("50", 7);
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(this.iterationInputField, gridBagConstraints);
            jPanel2.add(this.iterationInputField);
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.anchor = 10;
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 20);
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            jPanel3.setLayout(gridBagLayout4);
            jPanel3.setBackground(Color.white);
            jPanel3.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
            JLabel jLabel3 = new JLabel("K-Means / K-Medians will be run using a starting K (number of clusters) = 1,");
            jLabel3.setBackground(Color.white);
            gridBagConstraints.anchor = 16;
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 33);
            gridBagLayout4.setConstraints(jLabel3, gridBagConstraints);
            jPanel3.add(jLabel3);
            JLabel jLabel4 = new JLabel("with K being incremented by 1 in each subsequent iteration, up to the");
            jLabel4.setBackground(Color.white);
            gridBagConstraints.anchor = 17;
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 33);
            gridBagLayout4.setConstraints(jLabel4, gridBagConstraints);
            jPanel3.add(jLabel4);
            JLabel jLabel5 = new JLabel("maximum number of clusters specified above");
            jLabel5.setBackground(Color.white);
            gridBagConstraints.anchor = 18;
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 34);
            gridBagLayout4.setConstraints(jLabel5, gridBagConstraints);
            jPanel3.add(jLabel5);
            gridBagConstraints.anchor = 10;
            FOMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 40);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            this.add(jPanel3);
        }
    }
}

