/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class GDMAnnotationSizeDialog
extends JDialog {
    private int result;
    private int size = 100;
    private JLabel sizeLabel;
    private JTextField sizeTextField;
    private GBA gba;
    private final int maxSize = 300;

    public GDMAnnotationSizeDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.setTitle("Set Annotation Size");
        this.gba = new GBA();
        this.sizeLabel = new JLabel("Annotation Size (max = 300):  ");
        this.sizeTextField = new JTextField(10);
        JButton jButton = new JButton("Okay");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(new Listener());
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(new Listener());
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.gba.add(container, (Component)this.sizeLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, (Component)this.sizeTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, (Component)jButton2, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(container, (Component)jButton, 1, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.setResizable(false);
        this.sizeTextField.grabFocus();
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getAnnotationSize() {
        return this.size;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                String string2 = GDMAnnotationSizeDialog.this.sizeTextField.getText();
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 300) {
                        n = 300;
                    } else if (n < 1) {
                        n = 1;
                    }
                    GDMAnnotationSizeDialog.this.size = n;
                    GDMAnnotationSizeDialog.this.result = 0;
                }
                catch (Exception exception) {
                    GDMAnnotationSizeDialog.this.result = 2;
                }
                GDMAnnotationSizeDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                GDMAnnotationSizeDialog.this.result = 2;
                GDMAnnotationSizeDialog.this.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GDMAnnotationSizeDialog.this.result = -1;
            GDMAnnotationSizeDialog.this.dispose();
        }
    }
}

