/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.gdm.GDMScaleListener;
import org.tigr.util.FloatMatrix;

public class GDMColorScaleDialog
extends AlgorithmDialog {
    public static final String OK_CMD = "ok-cmd";
    public static final String CANCEL_CMD = "cancel-cmd";
    public static final String REFRESH_CMD = "refresh-cmd";
    public static final String RESET_CMD = "reset-cmd";
    public static final int REFRESH_RES = 100;
    public static final int RESET_RES = 101;
    private int result;
    private JLabel lowerJL = new JLabel("Lower Limit [0,1):  ", 4);
    private JLabel upperJL = new JLabel("Upper Limit (0,1]: ", 4);
    private JLabel saturationJL = new JLabel("% Saturation: ", 4);
    private JTextField lowerJTF;
    private JTextField upperJTF;
    private JTextField saturationJTF;
    private JPanel buttonsPanel;
    private JButton refreshBut;
    private JButton resetBut;
    private JButton cancelBut;
    private JButton okBut;
    private JButton infoButton;
    private RangePreviewPanel previewPanel;
    private FloatMatrix geneMatrix;
    private int num_genes;
    private float origLower;
    private float origUpper;
    private GDMScaleListener listener;

    public GDMColorScaleDialog(Frame frame, float f, float f2, FloatMatrix floatMatrix, int n, Color color, Color color2) {
        super(frame, "Set Color Scale", true);
        this.geneMatrix = floatMatrix;
        this.num_genes = n;
        this.origLower = f;
        this.origUpper = f2;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.top = 25;
        this.lowerJL.setBackground(Color.white);
        this.lowerJL.setOpaque(true);
        this.lowerJL.setHorizontalAlignment(4);
        this.lowerJL.setHorizontalTextPosition(4);
        jPanel.add((Component)this.lowerJL, gridBagConstraints);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.upperJL, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.bottom = 25;
        jPanel.add((Component)this.saturationJL, gridBagConstraints);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 25;
        Float f3 = new Float(f);
        this.lowerJTF = new JTextField(f3.toString(), 10);
        jPanel.add((Component)this.lowerJTF, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 10;
        Float f4 = new Float(f2);
        this.upperJTF = new JTextField(f4.toString(), 10);
        jPanel.add((Component)this.upperJTF, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 25;
        Float f5 = new Float(this.calcPercentSaturation(f, f2));
        this.saturationJTF = new JTextField(f5.toString(), 10);
        this.saturationJTF.setEditable(false);
        jPanel.add((Component)this.saturationJTF, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.buttonsPanel = new JPanel(new GridLayout(1, 4, 10, 10));
        this.refreshBut = new JButton("Preview");
        this.refreshBut.setBorder(BorderFactory.createBevelBorder(0));
        this.refreshBut.setSize(60, 30);
        this.refreshBut.setPreferredSize(new Dimension(60, 30));
        this.refreshBut.setFocusPainted(false);
        this.refreshBut.setActionCommand(REFRESH_CMD);
        this.refreshBut.addActionListener(listener);
        this.buttonsPanel.add(this.refreshBut);
        this.resetBut = new JButton("Reset");
        this.resetBut.setBorder(BorderFactory.createBevelBorder(0));
        this.resetBut.setFocusPainted(false);
        this.resetBut.setActionCommand(RESET_CMD);
        this.resetBut.addActionListener(listener);
        this.buttonsPanel.add(this.resetBut);
        this.cancelBut = new JButton("Cancel");
        this.cancelBut.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelBut.setSize(60, 30);
        this.cancelBut.setPreferredSize(new Dimension(60, 30));
        this.cancelBut.setFocusPainted(false);
        this.cancelBut.setActionCommand(CANCEL_CMD);
        this.cancelBut.addActionListener(listener);
        this.buttonsPanel.add(this.cancelBut);
        this.okBut = new JButton("OK");
        this.okBut.setBorder(BorderFactory.createBevelBorder(0, new Color(240, 240, 240), new Color(180, 180, 180), new Color(10, 0, 0), new Color(10, 10, 10)));
        this.okBut.setSize(60, 30);
        this.okBut.setPreferredSize(new Dimension(60, 30));
        this.okBut.setFocusPainted(false);
        this.okBut.setActionCommand(OK_CMD);
        this.okBut.addActionListener(listener);
        this.buttonsPanel.add(this.okBut);
        this.infoButton = new JButton(null, GUIFactory.getIcon("Information24.gif"));
        this.infoButton.setActionCommand("info-command");
        this.infoButton.setBorder(BorderFactory.createBevelBorder(0));
        this.infoButton.setSize(30, 30);
        this.infoButton.setPreferredSize(new Dimension(30, 30));
        this.infoButton.setFocusPainted(false);
        this.infoButton.addActionListener(listener);
        jPanel2.add((Component)this.infoButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.previewPanel = new RangePreviewPanel(color, color2, f, f2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.previewPanel, gridBagConstraints);
        this.addContent(jPanel);
        this.supplantButtonPanel(jPanel2);
        this.pack();
    }

    public void setGDMScaleListener(GDMScaleListener gDMScaleListener) {
        this.listener = gDMScaleListener;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        Float f = new Float(this.lowerJTF.getText());
        Float f2 = new Float(this.upperJTF.getText());
        Float f3 = new Float(this.calcPercentSaturation(f.floatValue(), f2.floatValue()));
        this.saturationJTF.setText(f3.toString());
        this.previewPanel.changeLimits(f.floatValue(), f2.floatValue());
        this.show();
        return this.result;
    }

    public float getLowerLimit() {
        return Float.parseFloat(this.lowerJTF.getText());
    }

    public float getUpperLimit() {
        return Float.parseFloat(this.upperJTF.getText());
    }

    public float calcPercentSaturation(float f, float f2) {
        int n = 0;
        for (int i = 0; i < this.num_genes; ++i) {
            for (int j = 0; j < this.num_genes; ++j) {
                float f3 = this.geneMatrix.get(i, j);
                if (!(f3 < f) && !(f3 > f2)) continue;
                ++n;
            }
        }
        float f4 = (float)n / (float)(this.num_genes * this.num_genes) * 100.0f;
        return f4;
    }

    private boolean isValidInput(float f, float f2) {
        if (f2 <= f) {
            JOptionPane.showMessageDialog(this, "The lower limit must be less than or equal to the upper limit.  Please enter new limits.", "Invalid Range Input", 2);
            return false;
        }
        if ((double)f2 > 1.0) {
            JOptionPane.showMessageDialog(this, "The upper limit must be equal to or less than 1.0. Please enter a new value.", "Invalid Range Input", 2);
            return false;
        }
        if ((double)f < 0.0) {
            JOptionPane.showMessageDialog(this, "The lower limit must be equal to or greater than 0.0. Please enter a new value.", "Invalid Range Input", 2);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        FloatMatrix floatMatrix = new FloatMatrix(3, 3);
        floatMatrix.set(0, 0, 1.0f);
        floatMatrix.set(1, 0, 0.1f);
        floatMatrix.set(2, 0, 0.8f);
        floatMatrix.set(0, 1, 1.0f);
        floatMatrix.set(1, 1, 0.134f);
        floatMatrix.set(2, 1, 0.25f);
        floatMatrix.set(0, 2, 0.43f);
        floatMatrix.set(1, 2, 0.37f);
        floatMatrix.set(2, 2, 0.04f);
        GDMColorScaleDialog gDMColorScaleDialog = new GDMColorScaleDialog(new Frame(), 0.0f, 0.1f, floatMatrix, floatMatrix.getRowDimension(), Color.black, Color.red);
        gDMColorScaleDialog.setDefaultCloseOperation(2);
        gDMColorScaleDialog.showModal();
    }

    private class Listener
    extends DialogListener {
        Float lowerF;
        Float upperF;

        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(GDMColorScaleDialog.OK_CMD)) {
                try {
                    this.lowerF = new Float(GDMColorScaleDialog.this.lowerJTF.getText());
                    this.upperF = new Float(GDMColorScaleDialog.this.upperJTF.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(GDMColorScaleDialog.this, "The entered values are not valid numberical entries. Please enter new values", "Invalid Range Input", 2);
                    return;
                }
                if (!GDMColorScaleDialog.this.isValidInput(this.lowerF.floatValue(), this.upperF.floatValue())) {
                    return;
                }
                GDMColorScaleDialog.this.result = 0;
                GDMColorScaleDialog.this.dispose();
            } else if (string.equals(GDMColorScaleDialog.CANCEL_CMD)) {
                GDMColorScaleDialog.this.result = 2;
                GDMColorScaleDialog.this.lowerJTF.setText(String.valueOf(GDMColorScaleDialog.this.origLower));
                GDMColorScaleDialog.this.upperJTF.setText(String.valueOf(GDMColorScaleDialog.this.origUpper));
                this.lowerF = new Float(GDMColorScaleDialog.this.lowerJTF.getText());
                this.upperF = new Float(GDMColorScaleDialog.this.upperJTF.getText());
                Float f = new Float(GDMColorScaleDialog.this.calcPercentSaturation(this.lowerF.floatValue(), this.upperF.floatValue()));
                GDMColorScaleDialog.this.saturationJTF.setText(f.toString());
                GDMColorScaleDialog.this.dispose();
            } else if (string.equals(GDMColorScaleDialog.RESET_CMD)) {
                GDMColorScaleDialog.this.result = 101;
                GDMColorScaleDialog.this.lowerJTF.setText(String.valueOf(GDMColorScaleDialog.this.origLower));
                GDMColorScaleDialog.this.upperJTF.setText(String.valueOf(GDMColorScaleDialog.this.origUpper));
                this.lowerF = new Float(GDMColorScaleDialog.this.lowerJTF.getText());
                this.upperF = new Float(GDMColorScaleDialog.this.upperJTF.getText());
                Float f = new Float(GDMColorScaleDialog.this.calcPercentSaturation(this.lowerF.floatValue(), this.upperF.floatValue()));
                GDMColorScaleDialog.this.saturationJTF.setText(f.toString());
                GDMColorScaleDialog.this.previewPanel.changeLimits(this.lowerF.floatValue(), this.upperF.floatValue());
            } else if (string.equals(GDMColorScaleDialog.REFRESH_CMD)) {
                try {
                    this.lowerF = new Float(GDMColorScaleDialog.this.lowerJTF.getText());
                    this.upperF = new Float(GDMColorScaleDialog.this.upperJTF.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(GDMColorScaleDialog.this, "The entered values are not valid numberical entries. Please enter new values", "Invalid Range Input", 2);
                    return;
                }
                if (!GDMColorScaleDialog.this.isValidInput(this.lowerF.floatValue(), this.upperF.floatValue())) {
                    return;
                }
                Float f = new Float(GDMColorScaleDialog.this.calcPercentSaturation(this.lowerF.floatValue(), this.upperF.floatValue()));
                GDMColorScaleDialog.this.saturationJTF.setText(f.toString());
                GDMColorScaleDialog.this.previewPanel.changeLimits(this.lowerF.floatValue(), this.upperF.floatValue());
                if (GDMColorScaleDialog.this.listener != null) {
                    GDMColorScaleDialog.this.listener.scaleChanged(this.lowerF.floatValue(), this.upperF.floatValue());
                }
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(GDMColorScaleDialog.this, "GDM Color Range Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GDMColorScaleDialog.this.result = -1;
            GDMColorScaleDialog.this.dispose();
        }
    }

    private class RangePreviewPanel
    extends JPanel {
        int GRADIENT_HEIGHT = 40;
        Color lowerColor;
        Color upperColor;
        float lower;
        float upper;
        JPanel lowerPanel;
        JPanel upperPanel;
        GradientPanel midPanel;
        JPanel previewPanel;
        ScalePanel gradientPanel;

        public RangePreviewPanel(Color color, Color color2, float f, float f2) {
            this.lower = f;
            this.upper = f2;
            this.lowerColor = color;
            this.upperColor = color2;
            this.setBackground(Color.white);
            this.lowerPanel = new JPanel();
            this.lowerPanel.setBackground(color);
            Dimension dimension = new Dimension(10, 40);
            this.lowerPanel.setPreferredSize(dimension);
            this.upperPanel = new JPanel();
            this.upperPanel.setBackground(color2);
            this.upperPanel.setPreferredSize(dimension);
            this.midPanel = new GradientPanel();
            this.midPanel.setPreferredSize(dimension);
            this.previewPanel = new JPanel(new GridBagLayout());
            this.previewPanel.setBorder(BorderFactory.createTitledBorder("Effective Range Preview"));
            this.previewPanel.setBackground(Color.white);
            this.gradientPanel = new ScalePanel();
            this.gradientPanel.setLayout(new GridBagLayout());
            this.gradientPanel.setBackground(Color.white);
            this.gradientPanel.add((Component)this.lowerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 20, 0), 0, 0));
            this.gradientPanel.add((Component)this.midPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 20, 0), 0, 0));
            this.gradientPanel.add((Component)this.upperPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 20, 10), 0, 0));
            this.previewPanel.add((Component)this.gradientPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.previewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void changeLimits(float f, float f2) {
            this.lower = f;
            this.upper = f2;
            int n = this.gradientPanel.getWidth() - 20;
            int n2 = this.lowerPanel.getHeight();
            this.lowerPanel.setSize((int)((float)n * f), n2);
            this.lowerPanel.setPreferredSize(new Dimension((int)((float)n * f), n2));
            this.upperPanel.setSize((int)((double)n * (1.0 - (double)f2)), n2);
            this.upperPanel.setPreferredSize(new Dimension((int)((double)n * (1.0 - (double)f2)), n2));
            this.midPanel.setSize((int)((float)n * (f2 - f)), n2);
            this.midPanel.setPreferredSize(new Dimension((int)((float)n * (f2 - f)), n2));
            this.validate();
            this.gradientPanel.repaint();
        }

        private class ScalePanel
        extends JPanel {
            int[] x;
            int[] y;

            public ScalePanel() {
                Font font = this.getFont();
                this.setFont(new Font(font.getFontName(), 1, font.getSize()));
                this.x = new int[3];
                this.y = new int[3];
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                int n = this.getHeight();
                int n2 = this.getWidth() - 20;
                int n3 = this.getHeight() - 20;
                int n4 = (int)(RangePreviewPanel.this.lower * (float)n2) + 10;
                int n5 = (int)(RangePreviewPanel.this.upper * (float)n2) + 10;
                this.x[0] = n4;
                this.x[1] = n4 - 5;
                this.x[2] = n4 + 5;
                this.y[0] = 10;
                this.y[1] = 1;
                this.y[2] = 1;
                graphics.setColor(Color.blue);
                graphics.fillPolygon(this.x, this.y, 3);
                this.x[0] = n5;
                this.x[1] = n5 - 5;
                this.x[2] = n5 + 5;
                graphics.fillPolygon(this.x, this.y, 3);
                graphics.setColor(RangePreviewPanel.this.upperColor);
                graphics.fillRect(n4 - 1, 10, 3, RangePreviewPanel.this.midPanel.getHeight());
                graphics.setColor(RangePreviewPanel.this.lowerColor);
                graphics.fillRect(n5 - 1, 10, 3, RangePreviewPanel.this.midPanel.getHeight());
                graphics.setColor(Color.black);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.drawString("0.0", 10, RangePreviewPanel.this.midPanel.getHeight() + 10 + fontMetrics.getHeight());
                graphics.drawString("0.5", this.getWidth() / 2 - fontMetrics.stringWidth("0.5") / 2, RangePreviewPanel.this.midPanel.getHeight() + 10 + fontMetrics.getHeight());
                graphics.drawString("1.0", this.getWidth() - 10 - fontMetrics.stringWidth("1.0"), RangePreviewPanel.this.midPanel.getHeight() + 10 + fontMetrics.getHeight());
            }
        }

        private class GradientPanel
        extends JPanel {
            GradientPaint gp;

            private GradientPanel() {
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Dimension dimension = this.getSize();
                this.gp = new GradientPaint(0.0f, dimension.height / 2, RangePreviewPanel.this.lowerColor, dimension.width, dimension.height / 2, RangePreviewPanel.this.upperColor);
                graphics2D.setPaint(this.gp);
                graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                graphics2D.setColor(Color.black);
            }
        }
    }
}

