/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;

public class GDMGeneGradientLabelPanel
extends JScrollPane {
    private final int OFFSET = 5;
    private final int RECT_HEIGHT = 10;
    private final int RECT_WIDTH = 200;
    private IData expData;
    private Insets insets;
    private int contentWidth;
    private int contentHeight;
    private int elementWidth;
    private int elementHeight;
    private int tracespace;
    private int maxGeneNameLength;
    private int num_genes;
    private int[] indices;
    private int labelIndex;
    private Experiment experiment;
    private boolean isAntiAliasing = false;
    private boolean isTracing = true;
    private boolean isColumnHeader;
    private int annotationSize;
    private GDMLabelPanel gdmLabelPanel;
    private GDMGradientPanel gdmGradientPanel;
    private float minValue = 0.0f;
    private float maxValue = 1.0f;
    private int maxColorScaleTextWidth = 0;
    private int maxColorScaleTextHeight = 0;
    private DecimalFormat decFormat;

    public GDMGeneGradientLabelPanel(Insets insets, int n, boolean bl, Experiment experiment, int n2, int n3, Dimension dimension, int n4, int n5, int[] nArray) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.insets = new Insets(0, 0, 0, 0);
        this.tracespace = n;
        this.experiment = experiment;
        this.elementWidth = dimension.width;
        this.elementHeight = dimension.height;
        this.isColumnHeader = bl;
        this.contentWidth = n2;
        this.contentHeight = n3;
        this.indices = nArray;
        this.num_genes = n5;
        this.maxGeneNameLength = n4 * this.elementWidth;
        this.gdmGradientPanel = new GDMGradientPanel();
        this.gdmLabelPanel = new GDMLabelPanel();
        this.setViewportView(this.gdmLabelPanel);
        this.setViewport(this.getViewport());
        if (this.isColumnHeader) {
            this.setColumnHeaderView(this.gdmGradientPanel);
            this.setColumnHeader(this.getColumnHeader());
            this.setViewportBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        } else {
            this.setRowHeaderView(this.gdmGradientPanel);
            this.setRowHeader(this.getRowHeader());
            this.setViewportBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
        this.updateSize();
        if (this.isColumnHeader) {
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
        } else {
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(31);
        }
        this.getViewport().setScrollMode(0);
        this.decFormat = new DecimalFormat();
        this.decFormat.setMinimumFractionDigits(1);
        this.decFormat.setMaximumFractionDigits(3);
        this.setBackground(Color.white);
        this.setOpaque(true);
    }

    public void setValues(float f, float f2) {
        this.minValue = f;
        this.maxValue = f2;
    }

    public void setData(IData iData) {
        this.expData = iData;
    }

    public void setNumGenes(int n) {
        this.num_genes = n;
    }

    public void setIndices(int[] nArray) {
        this.indices = nArray;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public void setLabelIndex(int n) {
        this.labelIndex = n;
    }

    public int getLabelIndex() {
        return this.labelIndex;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    void setElementWidth(int n) {
        this.elementWidth = n;
        this.setFontSize(n);
        this.gdmLabelPanel.setFontSize(n);
    }

    int getElementWidth() {
        return this.elementWidth;
    }

    public JComponent getLabelPanel() {
        return this.gdmLabelPanel;
    }

    void setAnnotationSize(int n) {
        this.annotationSize = n;
    }

    void setContentWidth(int n) {
        this.contentWidth = n;
    }

    void setElementHeight(int n) {
        this.elementHeight = n;
        this.setFontSize(n);
        this.gdmLabelPanel.setFontSize(n);
    }

    void setContentHeight(int n) {
        this.contentHeight = n;
    }

    void setTracing(boolean bl) {
        this.isTracing = bl;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int n) {
        if (n > 12) {
            n = 12;
        }
        this.setFont(new Font("monospaced", 0, n));
    }

    private void updateMaxGeneNameLength() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string = "";
        int n = 0;
        int[] nArray = this.getIndices();
        for (int i = 0; i < this.num_genes; ++i) {
            if (nArray != null) {
                if (this.labelIndex >= 0) {
                    string = this.expData.getElementAttribute(this.experiment.getGeneIndexMappedToData(nArray[i]), this.labelIndex);
                }
            } else if (this.labelIndex >= 0) {
                string = this.expData.getElementAttribute(i, this.labelIndex);
            }
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        this.maxGeneNameLength = n;
    }

    private int getMaxGeneNameLength() {
        return this.maxGeneNameLength;
    }

    private void setMaxGeneNameLength(int n) {
        this.maxGeneNameLength = n;
    }

    public void updateSize() {
        this.updateMaxGeneNameLength();
        this.gdmGradientPanel.updateSize();
        this.gdmLabelPanel.updateSize();
        if (this.isColumnHeader) {
            this.getVerticalScrollBar().setValues(190, 10, 100, 200);
        } else {
            this.getHorizontalScrollBar().setValues(190, 10, 100, 200);
        }
        if (this.isColumnHeader) {
            int n = this.contentWidth + this.elementWidth / 2;
            int n2 = 10 + this.maxColorScaleTextHeight + this.annotationSize + 10 + 10 + 4;
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
        } else {
            int n = 10 + this.maxColorScaleTextWidth + this.annotationSize + 10 + 10 + 4;
            int n3 = this.contentHeight + this.elementHeight / 2;
            this.setSize(n, n3);
            this.setPreferredSize(new Dimension(n, n3));
        }
        this.getViewport().setViewSize(this.gdmLabelPanel.getSize());
        this.validate();
    }

    public void setPosColorImages(BufferedImage bufferedImage) {
        this.gdmGradientPanel.setPosColorImages(bufferedImage);
        this.gdmGradientPanel.repaint();
    }

    public void setLeftInset(int n) {
        this.insets.left = n;
    }

    public void setTopInset(int n) {
        this.insets.top = n;
    }

    public boolean areProbesColored() {
        if (this.indices == null) {
            return false;
        }
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.expData.getProbeColor(this.experiment.getGeneIndexMappedToData(this.indices[i])) == null) continue;
            return true;
        }
        return false;
    }

    public Graphics getColorScaleGraphics() {
        return this.gdmGradientPanel.getGraphics();
    }

    public Graphics getLabelPanelGraphics() {
        return this.gdmLabelPanel.getGraphics();
    }

    private class GDMGradientPanel
    extends JPanel {
        private boolean drawBorders = false;
        private Color missingColor = new Color(128, 128, 128);
        private BufferedImage posColorImage;
        private DecimalFormat decFormat;

        public GDMGradientPanel() {
            this.setBackground(Color.white);
            this.setOpaque(true);
            this.decFormat = new DecimalFormat();
            this.decFormat.setMinimumFractionDigits(1);
            this.decFormat.setMaximumFractionDigits(3);
        }

        public void setPosColorImages(BufferedImage bufferedImage) {
            this.posColorImage = bufferedImage;
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setDrawBorders(boolean bl) {
            this.drawBorders = bl;
        }

        public void updateSize() {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            boolean bl = false;
            float f = (GDMGeneGradientLabelPanel.this.minValue + GDMGeneGradientLabelPanel.this.maxValue) / 2.0f;
            String string = this.decFormat.format(f);
            String string2 = this.decFormat.format(GDMGeneGradientLabelPanel.this.maxValue);
            String string3 = this.decFormat.format(GDMGeneGradientLabelPanel.this.minValue);
            if (graphics2D != null) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight = fontMetrics.getHeight();
                int n = fontMetrics.stringWidth(string);
                int n2 = fontMetrics.stringWidth(string2);
                int n3 = fontMetrics.stringWidth(string3);
                GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth = Math.max(n, n2);
                GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth = Math.max(GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth, n3);
            } else {
                GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight = 4;
                GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth = 4;
            }
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                int n = GDMGeneGradientLabelPanel.this.contentWidth + (int)((float)GDMGeneGradientLabelPanel.this.elementWidth / 2.0f);
                int n4 = 20 + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight;
                this.setSize(n, n4);
                this.setPreferredSize(new Dimension(n, n4));
            } else {
                int n = 20 + GDMGeneGradientLabelPanel.this.maxColorScaleTextWidth;
                int n5 = GDMGeneGradientLabelPanel.this.contentHeight + (int)((float)GDMGeneGradientLabelPanel.this.elementHeight / 2.0f);
                this.setSize(n, n5);
                this.setPreferredSize(new Dimension(n, n5));
            }
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (GDMGeneGradientLabelPanel.this.expData == null || GDMGeneGradientLabelPanel.this.expData.getFeaturesCount() == 0) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                graphics2D.drawImage(this.posColorImage, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top, 200, 10, null);
            } else {
                graphics2D.rotate(1.5707963267948966);
                graphics2D.drawImage(this.posColorImage, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top, -10 - ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left, 200, 10, null);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.getDescent();
            graphics2D.setColor(Color.black);
            if (GDMGeneGradientLabelPanel.this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            float f = (GDMGeneGradientLabelPanel.this.minValue + GDMGeneGradientLabelPanel.this.maxValue) / 2.0f;
            String string = this.decFormat.format(f);
            String string2 = this.decFormat.format(GDMGeneGradientLabelPanel.this.minValue);
            String string3 = this.decFormat.format(GDMGeneGradientLabelPanel.this.maxValue);
            int n2 = fontMetrics.stringWidth(string2);
            int n3 = fontMetrics.stringWidth(string3);
            int n4 = fontMetrics.stringWidth(string);
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                graphics2D.drawString(string2, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left, 10 + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight);
                graphics2D.drawString(string, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 100 - n4 / 2, 10 + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight);
                graphics2D.drawString(string3, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 200 - n3, 10 + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight);
            } else {
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.drawString(string2, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 10, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top + GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight);
                graphics2D.drawString(string, (float)(((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 10), (float)(((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top + 100) + (float)GDMGeneGradientLabelPanel.this.maxColorScaleTextHeight / 2.0f);
                graphics2D.drawString(string3, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 10, ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top + 200);
            }
        }
    }

    private class GDMLabelPanel
    extends JPanel {
        public GDMLabelPanel() {
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        private void setFontSize(int n) {
            if (n > 12) {
                n = 12;
            }
            this.setFont(new Font("monospaced", 0, n));
        }

        public void updateSize() {
            int n;
            int n2;
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                n2 = GDMGeneGradientLabelPanel.this.contentWidth + (int)((float)GDMGeneGradientLabelPanel.this.elementWidth / 2.0f);
                n = GDMGeneGradientLabelPanel.this.getMaxGeneNameLength() + 10;
            } else {
                n2 = GDMGeneGradientLabelPanel.this.getMaxGeneNameLength() + 10;
                n = GDMGeneGradientLabelPanel.this.contentHeight + (int)((float)GDMGeneGradientLabelPanel.this.elementHeight / 2.0f);
            }
            this.setSize(n2, n);
            this.setMinimumSize(new Dimension(n2, n));
            this.setPreferredSize(new Dimension(n2, n));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (GDMGeneGradientLabelPanel.this.expData == null || GDMGeneGradientLabelPanel.this.getElementWidth() <= 2) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (GDMGeneGradientLabelPanel.this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.drawLabelHeader(graphics2D);
        }

        private void drawLabelHeader(Graphics2D graphics2D) {
            if (GDMGeneGradientLabelPanel.this.num_genes == 0) {
                return;
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.getDescent();
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                graphics2D.rotate(-1.5707963267948966);
            }
            String string = "";
            int n2 = 0;
            int[] nArray = GDMGeneGradientLabelPanel.this.getIndices();
            for (int i = 0; i < GDMGeneGradientLabelPanel.this.num_genes; ++i) {
                int n3;
                int n4;
                if (nArray != null) {
                    if (GDMGeneGradientLabelPanel.this.labelIndex >= 0) {
                        string = GDMGeneGradientLabelPanel.this.expData.getElementAttribute(GDMGeneGradientLabelPanel.this.experiment.getGeneIndexMappedToData(nArray[i]), GDMGeneGradientLabelPanel.this.labelIndex);
                    }
                } else if (GDMGeneGradientLabelPanel.this.labelIndex >= 0) {
                    string = GDMGeneGradientLabelPanel.this.expData.getElementAttribute(i, GDMGeneGradientLabelPanel.this.labelIndex);
                }
                n2 = Math.max(n2, fontMetrics.stringWidth(string));
                if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                    n4 = ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top - (GDMGeneGradientLabelPanel.this.getMaxGeneNameLength() + 10) + 5;
                    n3 = ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + n + (GDMGeneGradientLabelPanel.this.elementWidth + GDMGeneGradientLabelPanel.this.getSpacing()) * i + GDMGeneGradientLabelPanel.this.elementWidth / 2 + 1;
                } else {
                    n4 = ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.left + 5;
                    n3 = ((GDMGeneGradientLabelPanel)GDMGeneGradientLabelPanel.this).insets.top + n + (GDMGeneGradientLabelPanel.this.elementHeight + GDMGeneGradientLabelPanel.this.getSpacing()) * i + GDMGeneGradientLabelPanel.this.elementHeight / 2;
                }
                graphics2D.drawString(string, n4, n3);
            }
            if (GDMGeneGradientLabelPanel.this.isColumnHeader) {
                graphics2D.rotate(1.5707963267948966);
            }
            GDMGeneGradientLabelPanel.this.setMaxGeneNameLength(n2);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

