/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ptm.PTMExperimentHeader;

public class PTMExperimentViewer
extends ExperimentViewer
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202012010001L;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private JPopupMenu popup;
    private ExperimentViewer expViewer;
    private PTMExperimentHeader header;
    private String[] auxTitles;
    private Object[][] auxData;

    public PTMExperimentViewer(Experiment experiment, int[][] nArray, Vector vector, String[] stringArray, Object[][] objectArray) {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.expViewer = new ExperimentViewer(experiment, nArray);
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.auxTitles = stringArray;
        this.auxData = objectArray;
        this.header = new PTMExperimentHeader(this.expViewer.getHeaderComponent(), vector);
        this.header.setColorImages(this.expViewer.getNegColorImage(), this.expViewer.getPosColorImage());
        this.header.setMissingColor(this.expViewer.getMissingColor());
        this.header.addMouseListener(listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.expViewer);
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeObject(this.auxData);
        objectOutputStream.writeObject(this.auxTitles);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.expViewer = (ExperimentViewer)objectInputStream.readObject();
        this.header = (PTMExperimentHeader)objectInputStream.readObject();
        this.auxData = (Object[][])objectInputStream.readObject();
        this.auxTitles = (String[])objectInputStream.readObject();
        Listener listener = new Listener();
        this.expViewer.getContentComponent().addMouseListener(listener);
        this.header.setMissingColor(this.expViewer.getMissingColor());
        this.header.addMouseListener(listener);
        this.popup = this.createJPopupMenu(listener);
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this.expViewer.getContentComponent();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public BufferedImage getImage() {
        return this.expViewer.getImage();
    }

    public void onSelected(IFramework iFramework) {
        this.expViewer.onSelected(iFramework);
        this.header.setCurrentCluster((Integer)iFramework.getUserObject());
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.header.setUseDoubleGradient(iDisplayMenu.getUseDoubleGradient());
        this.header.setColorImages(iDisplayMenu.getPositiveGradientImage(), iDisplayMenu.getNegativeGradientImage());
        this.header.setValues(iDisplayMenu.getMinRatioScale(), iDisplayMenu.getMidRatioValue(), iDisplayMenu.getMaxRatioScale());
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.header.updateSize(iDisplayMenu.getElementSize());
    }

    public void onDataChanged(IData iData) {
        this.expViewer.onDataChanged(iData);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.expViewer.onMenuChanged(iDisplayMenu);
        this.header.setUseDoubleGradient(iDisplayMenu.getUseDoubleGradient());
        this.header.setColorImages(iDisplayMenu.getPositiveGradientImage(), iDisplayMenu.getNegativeGradientImage());
        this.header.setValues(iDisplayMenu.getMinRatioScale(), iDisplayMenu.getMidRatioValue(), iDisplayMenu.getMaxRatioScale());
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.header.updateSize(iDisplayMenu.getElementSize());
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu, listener);
        return jPopupMenu;
    }

    protected void addMenuItems(JPopupMenu jPopupMenu, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("Store cluster", GUIFactory.getIcon("new16.gif"));
        jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("analysis16.gif"));
        jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon("delete16.gif"));
        jMenuItem.setActionCommand(SET_DEF_COLOR_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_CLUSTER_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon("save16.gif"));
        jMenuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllGeneClustersWithAux((Frame)frame, (Experiment)this.expViewer.getExperiment(), (IData)this.expViewer.getData(), (int[][])this.expViewer.getClusters(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveGeneClusterWithAux((Frame)frame, (Experiment)this.expViewer.getExperiment(), (IData)this.expViewer.getData(), (int[])this.expViewer.getCluster(), (String[])this.auxTitles, (Object[][])this.auxData);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color color = JColorChooser.showDialog(frame, "Choose color", CentroidViewer.DEF_CLUSTER_COLOR);
        if (color != null) {
            this.expViewer.setClusterColor(color);
        }
    }

    private void onSetDefaultColor() {
        this.expViewer.setClusterColor(null);
    }

    public int[][] getClusters() {
        return this.expViewer.getClusters();
    }

    public Experiment getExperiment() {
        return this.expViewer.getExperiment();
    }

    public int getViewerType() {
        return this.expViewer.getViewerType();
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(PTMExperimentViewer.SAVE_CLUSTER_CMD)) {
                PTMExperimentViewer.this.onSaveCluster();
            } else if (string.equals(PTMExperimentViewer.SAVE_ALL_CLUSTERS_CMD)) {
                PTMExperimentViewer.this.onSaveClusters();
            } else if (string.equals(PTMExperimentViewer.SET_DEF_COLOR_CMD)) {
                PTMExperimentViewer.this.onSetDefaultColor();
            } else if (string.equals(PTMExperimentViewer.STORE_CLUSTER_CMD)) {
                PTMExperimentViewer.this.expViewer.storeCluster();
            } else if (string.equals(PTMExperimentViewer.LAUNCH_NEW_SESSION_CMD)) {
                PTMExperimentViewer.this.expViewer.launchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() || PTMExperimentViewer.this.expViewer.getCluster() == null || PTMExperimentViewer.this.expViewer.getCluster().length == 0) {
                return;
            }
            PTMExperimentViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

