/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.som;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.util.FloatMatrix;

public class SOMExperimentHeader
extends JPanel {
    private SOMVectorPanel somVectorPanel;
    private int[][] clusters;
    private int clusterIndex;
    private static final String SOM_VECTOR_STRING = "SOM Vector";
    private Insets insets = new Insets(0, 10, 0, 0);
    private boolean useDoubleGradient = true;

    public SOMExperimentHeader(JComponent jComponent, FloatMatrix floatMatrix, int[][] nArray) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.somVectorPanel = new SOMVectorPanel(floatMatrix);
        this.clusters = nArray;
        this.add((Component)jComponent, "North");
        this.add((Component)this.somVectorPanel, "South");
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    private int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    private void setUseDoubleGradient(boolean bl) {
        this.useDoubleGradient = bl;
    }

    public void updateSize(Dimension dimension) {
        this.somVectorPanel.updateSize(dimension);
    }

    public void setCurrentCluster(int n) {
        this.somVectorPanel.setCurrentCluster(n);
    }

    public void setDrawBorders(boolean bl) {
        this.somVectorPanel.setDrawBorders(bl);
    }

    public void setValues(float f, float f2) {
        this.somVectorPanel.setValues(f, f2);
    }

    public void setValues(float f, float f2, float f3) {
        this.somVectorPanel.setValues(f, f2, f3);
    }

    public void setColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.somVectorPanel.setColorImages(bufferedImage, bufferedImage2);
    }

    public void setMissingColor(Color color) {
        this.somVectorPanel.setMissingColor(color);
    }

    public void setAntiAliasing(boolean bl) {
        this.somVectorPanel.setAntiAliasing(bl);
    }

    private class SOMVectorPanel
    extends JPanel {
        private FloatMatrix codes;
        private int cluster;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private float midValue = 0.0f;
        private Dimension elementSize;
        private boolean drawBorders = true;
        private boolean isAntiAliasing = false;
        private Color missingColor = new Color(128, 128, 128);
        private BufferedImage posColorImage;
        private BufferedImage negColorImage;

        public SOMVectorPanel(FloatMatrix floatMatrix) {
            this.setBackground(Color.white);
            this.codes = floatMatrix;
        }

        public void setColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            this.posColorImage = bufferedImage;
            this.negColorImage = bufferedImage2;
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setCurrentCluster(int n) {
            this.cluster = n;
            SOMExperimentHeader.this.clusterIndex = n;
        }

        public void setDrawBorders(boolean bl) {
            this.drawBorders = bl;
        }

        public void setAntiAliasing(boolean bl) {
            this.isAntiAliasing = bl;
        }

        public void setLeftInset(int n) {
            ((SOMExperimentHeader)SOMExperimentHeader.this).insets.left = n;
        }

        public void setValues(float f, float f2) {
            this.maxValue = f2;
            this.minValue = f;
        }

        public void setValues(float f, float f2, float f3) {
            this.maxValue = f3;
            this.minValue = f;
            this.midValue = f2;
        }

        public void updateSize(Dimension dimension) {
            this.elementSize = new Dimension(dimension);
            this.setFont(new Font("monospaced", 0, dimension.height));
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            if (this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(SOMExperimentHeader.SOM_VECTOR_STRING) + 10;
            int n2 = dimension.width * this.codes.getColumnDimension() + n;
            int n3 = dimension.height + 10;
            this.setSize(n2, n3);
            this.setPreferredSize(new Dimension(n2, n3));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (SOMExperimentHeader.this.getCluster().length < 1) {
                return;
            }
            if (this.isAntiAliasing) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            int n = this.codes.getColumnDimension();
            for (int i = 0; i < n; ++i) {
                this.fillRectAt(graphics, i, this.getColor(this.codes.get(this.cluster, i)));
                if (!this.drawBorders) continue;
                this.drawRectAt(graphics, i, Color.black);
            }
            graphics.setColor(Color.black);
            graphics.drawString(SOMExperimentHeader.SOM_VECTOR_STRING, this.elementSize.width * n + 10 + ((SOMExperimentHeader)SOMExperimentHeader.this).insets.left, this.elementSize.height);
        }

        private void fillRectAt(Graphics graphics, int n, Color color) {
            graphics.setColor(color);
            graphics.fillRect(n * this.elementSize.width + ((SOMExperimentHeader)SOMExperimentHeader.this).insets.left, 0, this.elementSize.width, this.elementSize.height);
        }

        private void drawRectAt(Graphics graphics, int n, Color color) {
            graphics.setColor(color);
            graphics.drawRect(n * this.elementSize.width + ((SOMExperimentHeader)SOMExperimentHeader.this).insets.left, 0, this.elementSize.width - 1, this.elementSize.height - 1);
        }

        private Color getColor(float f) {
            int n;
            if (Float.isNaN(f)) {
                return this.missingColor;
            }
            if (SOMExperimentHeader.this.useDoubleGradient) {
                float f2 = f < this.midValue ? this.minValue : this.maxValue;
                int n2 = (int)(255.0f * (f - this.midValue) / (f2 - this.midValue));
                n2 = n2 > 255 ? 255 : n2;
                n = f < this.midValue ? this.negColorImage.getRGB(255 - n2, 0) : this.posColorImage.getRGB(n2, 0);
            } else {
                float f3 = this.maxValue - this.minValue;
                int n3 = f <= this.minValue ? 0 : (f >= this.maxValue ? 255 : (int)((f - this.minValue) / f3 * 255.0f));
                n = this.posColorImage.getRGB(n3, 0);
            }
            return new Color(n);
        }
    }
}

