/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.io.File;
import java.io.Serializable;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

class SVMData
implements Serializable {
    public static final long serialVersionUID = 202018030001L;
    public float constant;
    public float coefficient;
    public float power;
    public float diagonalFactor;
    public float convergenceThreshold;
    public boolean radial;
    public boolean normalize;
    public float widthFactor;
    public float positiveConstraint;
    public float negativeConstraint;
    public boolean constrainWeights;
    public File classificationFile;
    public boolean useEditor;
    public int distanceFunction;
    public boolean absoluteDistance;
    public float positiveDiagonal;
    public float negativeDiagonal;
    public long seed = 0L;
    public float objective1;
    public float twoSquaredWidth;
    public boolean classifyGenes;
    public boolean calculateHCL;
    public boolean calcGeneHCL;
    public boolean calcSampleHCL;
    public int hclMethod;

    public SVMData() {
        this.constant = 1.0f;
        this.coefficient = 1.0f;
        this.power = 1.0f;
        this.diagonalFactor = 1.0f;
        this.convergenceThreshold = 1.0E-5f;
        this.radial = false;
        this.normalize = false;
        this.widthFactor = 1.0f;
        this.constrainWeights = true;
        this.positiveConstraint = 1.0f;
        this.negativeConstraint = 1.0f;
        this.positiveDiagonal = 0.0f;
        this.negativeDiagonal = 0.0f;
        this.classificationFile = null;
        this.classifyGenes = true;
        this.calculateHCL = false;
        this.calcSampleHCL = false;
        this.calcGeneHCL = false;
        this.hclMethod = 0;
        this.distanceFunction = 4;
        this.useEditor = true;
    }

    public SVMData(SVMData sVMData) {
        this.constant = sVMData.constant;
        this.coefficient = sVMData.coefficient;
        this.power = sVMData.power;
        this.diagonalFactor = sVMData.diagonalFactor;
        this.convergenceThreshold = sVMData.convergenceThreshold;
        this.radial = sVMData.radial;
        this.normalize = sVMData.normalize;
        this.widthFactor = sVMData.widthFactor;
        this.constrainWeights = sVMData.constrainWeights;
        this.positiveConstraint = sVMData.positiveConstraint;
        this.negativeConstraint = sVMData.negativeConstraint;
        this.positiveDiagonal = sVMData.positiveDiagonal;
        this.negativeDiagonal = sVMData.negativeDiagonal;
        this.classificationFile = sVMData.classificationFile;
        this.classifyGenes = sVMData.classifyGenes;
        this.calculateHCL = sVMData.calculateHCL;
        this.calcSampleHCL = sVMData.calcSampleHCL;
        this.calcGeneHCL = sVMData.calcGeneHCL;
        this.hclMethod = sVMData.hclMethod;
        this.distanceFunction = sVMData.distanceFunction;
        this.useEditor = sVMData.useEditor;
        this.seed = sVMData.seed;
        this.objective1 = sVMData.objective1;
        this.twoSquaredWidth = sVMData.twoSquaredWidth;
    }

    public boolean validate(JDialog jDialog) {
        if (this.diagonalFactor < 0.0f) {
            JOptionPane.showMessageDialog(jDialog, "Diagonal Factor must be >= 0", "Error", 0);
            return false;
        }
        if (this.radial && this.widthFactor < 0.0f) {
            JOptionPane.showMessageDialog(jDialog, "Width Factor must be >= 0", "Error", 0);
            return false;
        }
        if (this.convergenceThreshold <= 0.0f) {
            JOptionPane.showMessageDialog(jDialog, "Threshold must be > 0", "Error", 0);
            return false;
        }
        return true;
    }
}

