/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import com.sun.j3d.utils.picking.PickCanvas;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.PickListener;

public class PickBehavior
extends Behavior {
    private PickCanvas pickCanvas;
    private PickListener listener;
    private WakeupOr wakeupCondition;

    public PickBehavior(BranchGroup branchGroup, Canvas3D canvas3D, Bounds bounds) {
        this.pickCanvas = new PickCanvas(canvas3D, branchGroup);
        this.pickCanvas.setTolerance(1.0f);
        this.pickCanvas.setMode(1024);
        this.setSchedulingBounds(bounds);
    }

    public void setTolerance(float f) {
        this.pickCanvas.setTolerance(f);
    }

    public float getTolerance() {
        return this.pickCanvas.getTolerance();
    }

    public void initialize() {
        WakeupCriterion[] wakeupCriterionArray = new WakeupCriterion[]{new WakeupOnAWTEvent(502), new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(506)};
        this.wakeupCondition = new WakeupOr(wakeupCriterionArray);
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    public void setPickListener(PickListener pickListener) {
        this.listener = pickListener;
    }

    public void processStimulus(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            AWTEvent[] aWTEventArray;
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (!(wakeupCriterion instanceof WakeupOnAWTEvent) || (aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent()).length <= 0) continue;
            for (int i = 0; i < aWTEventArray.length - 1; ++i) {
                if (aWTEventArray[i].getID() == aWTEventArray[i + 1].getID()) continue;
                this.processMouseEvent((MouseEvent)aWTEventArray[i]);
            }
            this.processMouseEvent((MouseEvent)aWTEventArray[aWTEventArray.length - 1]);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent mouseEvent) {
        if (this.listener == null) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.listener.onMousePressed(mouseEvent, this.pickCanvas);
                break;
            }
            case 502: {
                this.listener.onMouseReleased(mouseEvent, this.pickCanvas);
                break;
            }
            case 506: {
                this.listener.onMouseDragged(mouseEvent, this.pickCanvas);
            }
        }
    }
}

