/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.Billboard;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.PickCone;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.vecmath.Color3f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ListDialog;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.ControlPanel;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.DomainUtil;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.DriftInterpolator;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.GenesShape;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.KeyMotionBehavior;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.Landscape;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.LinksShape;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.PickBehavior;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.PickListener;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.SelectionShape;
import org.tigr.microarray.mev.cluster.gui.impl.terrain.TerrainBillboard;
import org.tigr.microarray.mev.cluster.gui.impl.util.IntArray;

public class TerrainViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202018020001L;
    private IData data;
    private IFramework framework;
    private int labelIndex = -1;
    private boolean isGenes = true;
    private int[][] clusters;
    private float[][] weights;
    private float[][] locations;
    private float sigma;
    private int grid_size = 65;
    private boolean isBillboard = false;
    private final Color3f BLACK_COLOR = new Color3f(0.0f, 0.0f, 0.0f);
    private final Color3f WHITE_COLOR = new Color3f(1.0f, 1.0f, 1.0f);
    private static final BoundingSphere BILLBOARD_BOUNDS = new BoundingSphere(new Point3d(), 100.0);
    private static final Point3f BILLBOARD_P3F = new Point3f(-0.008f, 8.0E-4f, 0.0f);
    private static final String FILL_POLYGON_CMD = "fill-polygone-cmd";
    private static final String ZOOM_IN_CMD = "zoom-in-cmd";
    private static final String UNDO_CMD = "undo-cmd";
    private static final String SHOW_ALL_CMD = "show-all-cmd";
    private static final String POINTS_SHAPE_CMD = "points-shape-cmd";
    private static final String CUBES_SHAPE_CMD = "cubes-shape-cmd";
    private static final String SPHERES_SHAPE_CMD = "spheres-shape-cmd";
    private static final String GRID_SIZE_CMD = "grid-size-cmd";
    private static final String SHOW_ELEMENTS_CMD = "show-elements-cmd";
    private static final String DESELECT_CMD = "deselect-cmd";
    private static final String SHOW_CONTROLS_CMD = "show-controls-cmd";
    private static final String DRIFT_DIALOG_CMD = "drift-dialog-cmd";
    private static final String LAUNCH_SESSION_CMD = "launch-session-cmd";
    private static final String SET_CLUSTER_CMD = "set-cluster-cmd";
    private static final String SHOW_LINKS_CMD = "show-links-cmd";
    private static final String LINKS_THRESHOLD_CMD = "links-threshold-cmd";
    private static final String LINKS_WIDTH_CMD = "links-width-cmd";
    private static final String HIDE_LABELS_CMD = "hide-labels-cmd";
    private static final String USE_BILLBOARD_CMD = "use-billboard-cmd";
    private JPopupMenu popup;
    private JWindow tipWindow;
    private ControlPanel controlPanel;
    private SimpleUniverse universe;
    private Canvas3D onScreenCanvas;
    private Canvas3D offScreenCanvas;
    private TransformGroup view_tg;
    private GenesShape genesShape;
    private BranchGroup sceneGroup;
    private Landscape landscape;
    private LinksShape linksShape;
    private SelectionShape selectionShape;
    private BranchGroup labelsGroup;
    private KeyMotionBehavior keyMotionBehavior;
    private DriftInterpolator driftInterpolator;
    private PickBehavior pickBehavior;
    private Point2f up_left_point = new Point2f(0.0f, 0.0f);
    private Point2f bottom_right_point = new Point2f(1.0f, 1.0f);
    private UndoManager undoManager = new UndoManager();
    private Experiment experiment;

    public TerrainViewer(boolean bl, Experiment experiment, int[][] nArray, float[][] fArray, float[][] fArray2, float f, int n) {
        this.isGenes = bl;
        this.experiment = experiment;
        this.clusters = nArray;
        this.weights = fArray;
        this.locations = fArray2;
        this.sigma = f;
        this.setPreferredSize(new Dimension(10, 10));
        Listener listener = new Listener();
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(graphicsConfiguration);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.offScreenCanvas = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.onScreenCanvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        BoundingLeaf boundingLeaf = new BoundingLeaf((Bounds)new BoundingSphere(new Point3d(), 100.0));
        boundingLeaf.setCapability(12);
        PlatformGeometry platformGeometry = new PlatformGeometry();
        platformGeometry.addChild((Node)boundingLeaf);
        platformGeometry.compile();
        this.universe.getViewingPlatform().setPlatformGeometry(platformGeometry);
        this.universe.getViewer().getView().setFrontClipDistance(0.001);
        this.universe.getViewer().getView().setBackClipDistance(0.5);
        Point3d point3d = new Point3d(0.5, 0.0, 0.5);
        this.view_tg = this.universe.getViewingPlatform().getViewPlatformTransform();
        this.setInitialViewPoint(this.view_tg, point3d);
        this.driftInterpolator = new DriftInterpolator(this.view_tg, boundingLeaf);
        float[][] fArray3 = DomainUtil.getHeights(this.locations, this.grid_size, this.sigma);
        this.selectionShape = new SelectionShape();
        this.landscape = new Landscape(fArray3);
        this.landscape.setPoligonMode(2);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        transformGroup.addChild((Node)this.landscape);
        this.linksShape = new LinksShape(nArray, fArray, fArray2);
        this.keyMotionBehavior = this.createKeyMotionBehavior(this.view_tg, point3d, boundingLeaf);
        this.controlPanel = new ControlPanel(transformGroup, this.keyMotionBehavior, boundingLeaf);
        Behavior behavior = this.controlPanel.getSliderBehavior();
        this.genesShape = new GenesShape(0, this.locations, this.up_left_point, this.bottom_right_point);
        this.genesShape.setBounds(boundingLeaf.getRegion());
        this.labelIndex = n;
        Node[] nodeArray = new Node[]{this.selectionShape, transformGroup, behavior, this.keyMotionBehavior, this.driftInterpolator, this.genesShape, this.linksShape};
        this.sceneGroup = this.createSceneGraph(nodeArray, boundingLeaf);
        this.pickBehavior = new PickBehavior(this.sceneGroup, this.onScreenCanvas, boundingLeaf.getRegion());
        this.pickBehavior.setPickListener(listener);
        this.sceneGroup.addChild((Node)this.pickBehavior);
        this.sceneGroup.compile();
        this.setLayout(new BorderLayout());
        this.add((Component)this.onScreenCanvas, "Center");
        this.add((Component)this.controlPanel, "South");
        this.popup = this.createJPopupMenu(listener);
        this.onScreenCanvas.addMouseListener((MouseListener)listener);
        this.onScreenCanvas.addMouseMotionListener((MouseMotionListener)listener);
        this.onScreenCanvas.addKeyListener((KeyListener)listener);
    }

    public TerrainViewer() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        System.out.println("Serialize TRN viewer");
        objectOutputStream.writeBoolean(this.isGenes);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeObject(this.weights);
        objectOutputStream.writeObject(this.locations);
        objectOutputStream.writeFloat(this.sigma);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.isGenes = objectInputStream.readBoolean();
        this.experiment = (Experiment)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.weights = (float[][])objectInputStream.readObject();
        this.locations = (float[][])objectInputStream.readObject();
        this.sigma = objectInputStream.readFloat();
        this.setPreferredSize(new Dimension(10, 10));
        Listener listener = new Listener();
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        this.onScreenCanvas = new Canvas3D(graphicsConfiguration);
        this.universe = new SimpleUniverse(this.onScreenCanvas);
        this.offScreenCanvas = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.onScreenCanvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        BoundingLeaf boundingLeaf = new BoundingLeaf((Bounds)new BoundingSphere(new Point3d(), 100.0));
        boundingLeaf.setCapability(12);
        PlatformGeometry platformGeometry = new PlatformGeometry();
        platformGeometry.addChild((Node)boundingLeaf);
        platformGeometry.compile();
        this.universe.getViewingPlatform().setPlatformGeometry(platformGeometry);
        this.universe.getViewer().getView().setFrontClipDistance(0.001);
        this.universe.getViewer().getView().setBackClipDistance(0.5);
        Point3d point3d = new Point3d(0.5, 0.0, 0.5);
        this.view_tg = this.universe.getViewingPlatform().getViewPlatformTransform();
        this.setInitialViewPoint(this.view_tg, point3d);
        this.driftInterpolator = new DriftInterpolator(this.view_tg, boundingLeaf);
        float[][] fArray = DomainUtil.getHeights(this.locations, this.grid_size, this.sigma);
        this.selectionShape = new SelectionShape();
        this.landscape = new Landscape(fArray);
        this.landscape.setPoligonMode(2);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        transformGroup.addChild((Node)this.landscape);
        this.linksShape = new LinksShape(this.clusters, this.weights, this.locations);
        this.keyMotionBehavior = this.createKeyMotionBehavior(this.view_tg, point3d, boundingLeaf);
        this.controlPanel = new ControlPanel(transformGroup, this.keyMotionBehavior, boundingLeaf);
        Behavior behavior = this.controlPanel.getSliderBehavior();
        this.genesShape = new GenesShape(0, this.locations, this.up_left_point, this.bottom_right_point);
        this.genesShape.setBounds(boundingLeaf.getRegion());
        this.labelIndex = this.framework.getDisplayMenu().getLabelIndex();
        Node[] nodeArray = new Node[]{this.selectionShape, transformGroup, behavior, this.keyMotionBehavior, this.driftInterpolator, this.genesShape, this.linksShape};
        this.sceneGroup = this.createSceneGraph(nodeArray, boundingLeaf);
        this.pickBehavior = new PickBehavior(this.sceneGroup, this.onScreenCanvas, boundingLeaf.getRegion());
        this.pickBehavior.setPickListener(listener);
        this.sceneGroup.addChild((Node)this.pickBehavior);
        this.sceneGroup.compile();
        this.setLayout(new BorderLayout());
        this.add((Component)this.onScreenCanvas, "Center");
        this.add((Component)this.controlPanel, "South");
        this.popup = this.createJPopupMenu(listener);
        this.onScreenCanvas.addMouseListener((MouseListener)listener);
        this.onScreenCanvas.addMouseMotionListener((MouseMotionListener)listener);
        this.onScreenCanvas.addKeyListener((KeyListener)listener);
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        if (this.tipWindow == null) {
            this.tipWindow = new JWindow(iFramework.getFrame());
        }
        this.universe.addBranchGraph(this.sceneGroup);
        this.data = iFramework.getData();
        this.onDataChanged(this.data);
        this.onMenuChanged(iFramework.getDisplayMenu());
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        if (this.isGenes) {
            this.genesShape.updateColors(this.data.getColorIndices(), this.data.getColors());
        } else {
            this.genesShape.updateColors(this.data.getExperimentColorIndices(), this.data.getExperimentColors());
        }
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        if (this.labelIndex == iDisplayMenu.getLabelIndex()) {
            return;
        }
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.updateLabelsGroup();
    }

    public void onDeselected() {
        this.sceneGroup.detach();
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, new BufferedImage(this.onScreenCanvas.getWidth(), this.onScreenCanvas.getHeight(), 5));
        this.offScreenCanvas.setOffScreenLocation(this.onScreenCanvas.getLocationOnScreen());
        this.offScreenCanvas.setOffScreenBuffer(imageComponent2D);
        this.offScreenCanvas.renderOffScreenBuffer();
        this.offScreenCanvas.waitForOffScreenRendering();
        BufferedImage bufferedImage = this.offScreenCanvas.getOffScreenBuffer().getImage();
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
        bufferedImage2.setData(bufferedImage.getData());
        return bufferedImage2;
    }

    private void setInitialViewPoint(TransformGroup transformGroup, Point3d point3d) {
        Transform3D transform3D = new Transform3D();
        transform3D.lookAt(new Point3d(1.42, 1.0, 1.42), point3d, new Vector3d(0.0, 1.0, 0.0));
        transform3D.invert();
        transformGroup.setTransform(transform3D);
    }

    private BranchGroup createSceneGraph(Node[] nodeArray, BoundingLeaf boundingLeaf) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(14);
        branchGroup.setCapability(13);
        Background background = new Background(this.BLACK_COLOR);
        background.setApplicationBoundingLeaf(boundingLeaf);
        branchGroup.addChild((Node)background);
        branchGroup.addChild((Node)this.createAmbientLight(boundingLeaf));
        branchGroup.addChild((Node)this.createPointLight(new Point3f(1.5f, 0.5f, 0.5f), boundingLeaf));
        branchGroup.addChild((Node)this.createPointLight(new Point3f(0.5f, 0.5f, 1.5f), boundingLeaf));
        for (int i = 0; i < nodeArray.length; ++i) {
            branchGroup.addChild(nodeArray[i]);
        }
        return branchGroup;
    }

    private TransformGroup createLight(Bounds bounds, Vector3d vector3d) {
        Transform3D transform3D = new Transform3D();
        transform3D.set(vector3d);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transformGroup.setCapability(1);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        Color3f color3f = new Color3f(1.0f, 1.0f, 1.0f);
        coloringAttributes.setColor(color3f);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(coloringAttributes);
        transformGroup.addChild((Node)new Sphere(0.01f, 1, 15, appearance));
        PointLight pointLight = new PointLight(color3f, new Point3f(0.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f));
        pointLight.setInfluencingBounds(bounds);
        transformGroup.addChild((Node)pointLight);
        return transformGroup;
    }

    private Billboard createLabelBillboard(TransformGroup transformGroup) {
        transformGroup.setCapability(18);
        TerrainBillboard terrainBillboard = new TerrainBillboard(transformGroup, 1, BILLBOARD_P3F, this.view_tg);
        terrainBillboard.setSchedulingBounds((Bounds)BILLBOARD_BOUNDS);
        return terrainBillboard;
    }

    private BranchGroup createLabelsGroup(int n, float[][] fArray, Point2f point2f, Point2f point2f2) {
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        if (this.isGenes && n < 0) {
            return branchGroup;
        }
        Transform3D transform3D = new Transform3D();
        Vector3f vector3f = new Vector3f();
        float f = Math.max(Math.abs(point2f.x - point2f2.x), Math.abs(point2f.y - point2f2.y));
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i][0];
            float f3 = fArray[i][1];
            if (!(f2 >= point2f.x) || !(f2 <= point2f.x + f) || !(f3 >= point2f.y) || !(f3 <= point2f.y + f)) continue;
            vector3f.set((f2 - point2f.x) / f + 0.008f, -0.008f, (f3 - point2f.y) / f);
            transform3D.set(vector3f);
            TransformGroup transformGroup = new TransformGroup(transform3D);
            TransformGroup transformGroup2 = new TransformGroup();
            String string = this.isGenes ? this.data.getElementAttribute(i, n) : this.data.getSampleName(i);
            transformGroup2.addChild((Node)this.createText2D(string, this.WHITE_COLOR, polygonAttributes));
            transformGroup.addChild((Node)transformGroup2);
            branchGroup.addChild((Node)transformGroup);
            if (!this.isBillboard) continue;
            Billboard billboard = this.createLabelBillboard(transformGroup2);
            branchGroup.addChild((Node)billboard);
        }
        branchGroup.compile();
        return branchGroup;
    }

    private BranchGroup createViewBehavior(TransformGroup transformGroup, Point3d point3d, BoundingLeaf boundingLeaf) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.addChild((Node)this.createKeyMotionBehavior(transformGroup, point3d, boundingLeaf));
        return branchGroup;
    }

    private KeyMotionBehavior createKeyMotionBehavior(TransformGroup transformGroup, Point3d point3d, BoundingLeaf boundingLeaf) {
        KeyMotionBehavior keyMotionBehavior = new KeyMotionBehavior(transformGroup);
        keyMotionBehavior.setSchedulingBoundingLeaf(boundingLeaf);
        keyMotionBehavior.setBasis(point3d);
        return keyMotionBehavior;
    }

    private AmbientLight createAmbientLight(BoundingLeaf boundingLeaf) {
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setInfluencingBoundingLeaf(boundingLeaf);
        return ambientLight;
    }

    private Light createDirectionLight(BoundingLeaf boundingLeaf) {
        DirectionalLight directionalLight = new DirectionalLight(this.WHITE_COLOR, new Vector3f(-1.0f, 0.0f, -1.0f));
        directionalLight.setInfluencingBoundingLeaf(boundingLeaf);
        return directionalLight;
    }

    private PointLight createPointLight(Point3f point3f, BoundingLeaf boundingLeaf) {
        PointLight pointLight = new PointLight(this.WHITE_COLOR, point3f, new Point3f(1.0f, 0.0f, 0.0f));
        pointLight.setInfluencingBoundingLeaf(boundingLeaf);
        return pointLight;
    }

    private Node createTransformGroup(Transform3D transform3D, Node node) {
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild(node);
        return transformGroup;
    }

    private Text2D createText2D(String string, Color3f color3f, PolygonAttributes polygonAttributes) {
        Text2D text2D = new Text2D("", color3f, "Arial", 12, 1);
        text2D.setRectangleScaleFactor(0.001f);
        text2D.setString(string);
        text2D.getAppearance().setPolygonAttributes(polygonAttributes);
        text2D.setCapability(12);
        text2D.getGeometry().setCapability(18);
        text2D.getGeometry().setCapability(8);
        text2D.getGeometry().setCapability(17);
        text2D.getGeometry().setCapability(0);
        return text2D;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JCheckBoxMenuItem("Control Panel");
        jMenuItem.setSelected(true);
        jMenuItem.setActionCommand(SHOW_CONTROLS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Grid...");
        jMenuItem.setActionCommand(GRID_SIZE_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Fill Polygon");
        jMenuItem.setSelected(true);
        jMenuItem.setActionCommand(FILL_POLYGON_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu("Element Shape");
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItem("Point");
        jMenuItem.setSelected(true);
        jMenuItem.setActionCommand(POINTS_SHAPE_CMD);
        jMenuItem.addActionListener(listener);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItem("Cube");
        jMenuItem.setActionCommand(CUBES_SHAPE_CMD);
        jMenuItem.addActionListener(listener);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItem("Sphere");
        jMenuItem.setActionCommand(SPHERES_SHAPE_CMD);
        jMenuItem.addActionListener(listener);
        buttonGroup.add(jMenuItem);
        jMenu.add(jMenuItem);
        jPopupMenu.add(jMenu);
        JMenu jMenu2 = new JMenu("Labels");
        jMenuItem = new JCheckBoxMenuItem("Hide");
        jMenuItem.setSelected(true);
        jMenuItem.setActionCommand(HIDE_LABELS_CMD);
        jMenuItem.addActionListener(listener);
        jMenu2.add(jMenuItem);
        jMenuItem = new JCheckBoxMenuItem("Billboard");
        jMenuItem.setSelected(false);
        jMenuItem.setActionCommand(USE_BILLBOARD_CMD);
        jMenuItem.addActionListener(listener);
        jMenu2.add(jMenuItem);
        jPopupMenu.add(jMenu2);
        jPopupMenu.addSeparator();
        JMenu jMenu3 = new JMenu("Zoom");
        jMenuItem = new JMenuItem("In");
        jMenuItem.setActionCommand(ZOOM_IN_CMD);
        jMenuItem.addActionListener(listener);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("Undo");
        jMenuItem.setActionCommand(UNDO_CMD);
        jMenuItem.addActionListener(listener);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("Show All");
        jMenuItem.setActionCommand(SHOW_ALL_CMD);
        jMenuItem.addActionListener(listener);
        jMenu3.add(jMenuItem);
        jPopupMenu.add(jMenu3);
        jPopupMenu.addSeparator();
        JMenu jMenu4 = new JMenu("Links");
        jMenuItem = new JCheckBoxMenuItem("Show");
        jMenuItem.setSelected(false);
        jMenuItem.setActionCommand(SHOW_LINKS_CMD);
        jMenuItem.addActionListener(listener);
        jMenu4.add(jMenuItem);
        jMenuItem = new JMenuItem("Threshold...");
        jMenuItem.setActionCommand(LINKS_THRESHOLD_CMD);
        jMenuItem.addActionListener(listener);
        jMenu4.add(jMenuItem);
        jMenuItem = new JMenuItem("Thickness...");
        jMenuItem.setActionCommand(LINKS_WIDTH_CMD);
        jMenuItem.addActionListener(listener);
        jMenu4.add(jMenuItem);
        jPopupMenu.add(jMenu4);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Store cluster");
        jMenuItem.setActionCommand(SET_CLUSTER_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Launch New Session");
        jMenuItem.setActionCommand(LAUNCH_SESSION_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Deselect");
        jMenuItem.setActionCommand(DESELECT_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Elements");
        jMenuItem.setActionCommand(SHOW_ELEMENTS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Drift...");
        jMenuItem.setActionCommand(DRIFT_DIALOG_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private JMenuItem getJMenuItem(JPopupMenu jPopupMenu, String string) {
        Component[] componentArray = jPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (componentArray[i] instanceof JMenu && (jMenuItem = this.getJMenuItem(((JMenu)componentArray[i]).getPopupMenu(), string)) != null) {
                return jMenuItem;
            }
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(this.popup, string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    private void onPicked(MouseEvent mouseEvent, PickCanvas pickCanvas) {
        pickCanvas.setShapeLocation(mouseEvent);
        PickResult pickResult = pickCanvas.pickClosest();
        if (pickResult != null && pickResult.getObject() == this.genesShape) {
            PickIntersection pickIntersection = pickResult.getClosestIntersection(pickCanvas.getStartPosition());
            int[] nArray = pickIntersection.getPrimitiveVertexIndices();
            final int n = this.genesShape.getShapeIndex(nArray[0]);
            if (n < 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TerrainViewer.this.onPicked(n);
                }
            });
        }
    }

    private void onPicked(int n) {
        if (this.isGenes) {
            this.framework.displaySlideElementInfo(0, n);
        } else {
            this.framework.displaySingleArrayViewer(n);
        }
    }

    private void onCtrlPicked(MouseEvent mouseEvent, PickCanvas pickCanvas) {
        pickCanvas.setShapeLocation(mouseEvent);
        PickResult pickResult = pickCanvas.pickClosest();
        if (pickResult != null) {
            if (pickResult.getObject() == this.genesShape) {
                PickIntersection pickIntersection = pickResult.getClosestIntersection(pickCanvas.getStartPosition());
                int[] nArray = pickIntersection.getPrimitiveVertexIndices();
                int n = this.genesShape.getShapeIndex(nArray[0]);
                if (n < 0) {
                    return;
                }
                float f = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
                float f2 = (this.locations[n][0] - this.up_left_point.x) / f;
                float f3 = (this.locations[n][1] - this.up_left_point.y) / f;
                this.driftInterpolator.drift(new Point3d((double)f2, 0.0, (double)f3), new Vector3f(0.0f, 0.0f, 1.0f));
            } else if (pickResult.getObject() == this.landscape) {
                PickIntersection pickIntersection = pickResult.getClosestIntersection(pickCanvas.getStartPosition());
                Point3d point3d = pickIntersection.getPointCoordinates();
                point3d.y += this.controlPanel.getSliderValue();
                Vector3f vector3f = pickIntersection.getPointNormal();
                this.driftInterpolator.drift(point3d, vector3f);
            }
        }
    }

    private void onSetCluster() {
        float f = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        Point2f point2f = this.selectionShape.getStartCoords();
        Point2f point2f2 = this.selectionShape.getEndCoords();
        point2f.scale(f);
        point2f2.scale(f);
        point2f.add((Tuple2f)this.up_left_point);
        point2f2.add((Tuple2f)this.up_left_point);
        IntArray intArray = new IntArray();
        for (int i = 0; i < this.locations.length; ++i) {
            float f2 = this.locations[i][0];
            float f3 = this.locations[i][1];
            if (!(f2 > point2f.x) || !(f2 < point2f2.x) || !(f3 > point2f.y) || !(f3 < point2f2.y)) continue;
            intArray.add(i);
        }
        if (this.isGenes) {
            this.framework.storeSubCluster(intArray.toArray(), this.experiment, 0);
            this.genesShape.updateColors(this.data.getColorIndices(), this.data.getColors());
        } else {
            this.framework.storeSubCluster(intArray.toArray(), this.experiment, 1);
            this.genesShape.updateColors(this.data.getExperimentColorIndices(), this.data.getExperimentColors());
        }
        this.selectionShape.clearSelection();
    }

    private void onLaunchNewSession() {
        float f = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        Point2f point2f = this.selectionShape.getStartCoords();
        Point2f point2f2 = this.selectionShape.getEndCoords();
        point2f.scale(f);
        point2f2.scale(f);
        point2f.add((Tuple2f)this.up_left_point);
        point2f2.add((Tuple2f)this.up_left_point);
        IntArray intArray = new IntArray();
        for (int i = 0; i < this.locations.length; ++i) {
            float f2 = this.locations[i][0];
            float f3 = this.locations[i][1];
            if (!(f2 > point2f.x) || !(f2 < point2f2.x) || !(f3 > point2f.y) || !(f3 < point2f2.y)) continue;
            intArray.add(i);
        }
        if (this.isGenes) {
            this.framework.launchNewMAV(intArray.toArray(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(intArray.toArray(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
        this.selectionShape.clearSelection();
    }

    private int[] getIDataRowIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(i);
        }
        return nArray2;
    }

    private void onFillPolygon() {
        JMenuItem jMenuItem = this.getJMenuItem(this.popup, FILL_POLYGON_CMD);
        if (jMenuItem.isSelected()) {
            this.landscape.setPoligonMode(2);
        } else {
            this.landscape.setPoligonMode(1);
        }
    }

    private void onShowControls() {
        JMenuItem jMenuItem = this.getJMenuItem(this.popup, SHOW_CONTROLS_CMD);
        if (jMenuItem.isSelected()) {
            this.controlPanel.setVisible(true);
        } else {
            this.controlPanel.setVisible(false);
        }
    }

    private Point3d getIntersectionPoint(MouseEvent mouseEvent, PickCanvas pickCanvas) {
        float f = pickCanvas.getTolerance();
        pickCanvas.setTolerance(2.0f);
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickCanvas.setShapeLocation(mouseEvent);
        PickCone pickCone = (PickCone)pickCanvas.getPickShape();
        pickCanvas.setTolerance(f);
        pickCone.getOrigin(point3d);
        pickCone.getDirection(vector3d);
        double d = point3d.x - point3d.y * vector3d.x / vector3d.y;
        double d2 = point3d.z - point3d.y * vector3d.z / vector3d.y;
        if (point3d.y < 0.0 || d < 0.0 || d2 < 0.0 || d > 1.0 || d2 > 1.0) {
            return null;
        }
        return new Point3d(d, 0.0, d2);
    }

    private void onStartSelection(MouseEvent mouseEvent, PickCanvas pickCanvas) {
        this.selectionShape.startSelection(this.getIntersectionPoint(mouseEvent, pickCanvas));
    }

    private void onDragSelection(MouseEvent mouseEvent, PickCanvas pickCanvas) {
        this.selectionShape.dragSelection(this.getIntersectionPoint(mouseEvent, pickCanvas));
    }

    private void onReleaseSelection() {
    }

    private void onDeselect() {
        this.selectionShape.clearSelection();
    }

    private void onShowAll() {
        this.doZoom(new Point2f(0.0f, 0.0f), new Point2f(1.0f, 1.0f));
    }

    private void onZoom() {
        this.undoManager.addEdit(new ZoomUndoable(this.up_left_point, this.bottom_right_point));
        Point2f point2f = this.selectionShape.getStartCoords();
        Point2f point2f2 = this.selectionShape.getEndCoords();
        float f = Math.min(point2f2.x - point2f.x, point2f2.y - point2f.y);
        point2f2.set(point2f.x + f, point2f.y + f);
        float f2 = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        point2f.scale(f2);
        point2f2.scale(f2);
        point2f.add((Tuple2f)this.up_left_point);
        point2f2.add((Tuple2f)this.up_left_point);
        this.doZoom(point2f, point2f2);
    }

    private void doZoom(Point2f point2f, Point2f point2f2) {
        this.up_left_point.set((Tuple2f)point2f);
        this.bottom_right_point.set((Tuple2f)point2f2);
        float f = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        float[][] fArray = DomainUtil.getHeights(this.locations, this.grid_size, this.sigma * f, this.up_left_point, this.bottom_right_point);
        this.landscape.setHeights(fArray);
        this.genesShape.setZoom(this.up_left_point, this.bottom_right_point);
        this.linksShape.setZoom(this.up_left_point, this.bottom_right_point);
        this.selectionShape.clearSelection();
        this.updateLabelsGroup();
    }

    private void onUndo() {
        this.undoManager.undo();
    }

    private void onPointsShape() {
        this.pickBehavior.setTolerance(1.0f);
        this.genesShape.setType(0);
    }

    private void onSpheresShape() {
        this.pickBehavior.setTolerance(0.0f);
        this.genesShape.setType(2);
    }

    private void onCubesShape() {
        this.pickBehavior.setTolerance(0.0f);
        this.genesShape.setType(1);
    }

    private void onGridSize() {
        String string = (String)JOptionPane.showInputDialog(this, "Enter in a number of the grid cells per side.", "Input", 2, null, null, String.valueOf(this.grid_size - 1));
        if (string == null || string.equals("")) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            if (n <= 2 || n >= 500) {
                throw new NumberFormatException("value must be more than 2 and less than 500.");
            }
            this.grid_size = n + 1;
            float f = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
            float[][] fArray = DomainUtil.getHeights(this.locations, this.grid_size, this.sigma * f, this.up_left_point, this.bottom_right_point);
            this.landscape.setHeights(fArray);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Illegal number: " + numberFormatException.getMessage(), "Error", 0);
        }
    }

    private void onDriftDialog() {
        String string = (String)JOptionPane.showInputDialog(this, "Enter in a minimal distance.", "Input", 2, null, null, String.valueOf(this.driftInterpolator.getMinDistance()));
        if (string == null || string.equals("")) {
            return;
        }
        try {
            float f = Float.parseFloat(string);
            if (f <= 0.0f || f >= 1.0f) {
                throw new NumberFormatException("value must be more than 0 and less than 1.");
            }
            this.driftInterpolator.setMinDistance(f);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Illegal number: " + numberFormatException.getMessage(), "Error", 0);
        }
    }

    private void onShowLinks() {
        JMenuItem jMenuItem = this.getJMenuItem(this.popup, SHOW_LINKS_CMD);
        if (jMenuItem.isSelected()) {
            this.linksShape.setVisible(true);
        } else {
            this.linksShape.setVisible(false);
        }
    }

    private void onLinksThreshold() {
        String string = (String)JOptionPane.showInputDialog(this, "Enter in links threshold (between 0 and 1).", "Input", 2, null, null, String.valueOf(this.linksShape.getThreshold()));
        if (string == null || string.equals("")) {
            return;
        }
        try {
            float f = Float.parseFloat(string);
            if (f < 0.0f || f > 1.0f) {
                throw new NumberFormatException("value must be between 0 and 1.");
            }
            this.linksShape.setThreshold(f);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Illegal number: " + numberFormatException.getMessage(), "Error", 0);
        }
    }

    private void onLinksWidth() {
        String string = (String)JOptionPane.showInputDialog(this, "Enter in links thickness (between 1 and 10).", "Input", 2, null, null, String.valueOf(this.linksShape.getLinksWidth()));
        if (string == null || string.equals("")) {
            return;
        }
        try {
            float f = Float.parseFloat(string);
            if (f < 1.0f || f > 10.0f) {
                throw new NumberFormatException("value must be between 1 and 10.");
            }
            this.linksShape.setLinksWidth(f);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Illegal number: " + numberFormatException.getMessage(), "Error", 0);
        }
    }

    private void onHideLabels() {
        JMenuItem jMenuItem = this.getJMenuItem(this.popup, HIDE_LABELS_CMD);
        if (!jMenuItem.isSelected()) {
            this.labelsGroup = this.createLabelsGroup(this.labelIndex, this.locations, this.up_left_point, this.bottom_right_point);
            this.sceneGroup.addChild((Node)this.labelsGroup);
        } else {
            this.labelsGroup.detach();
            this.labelsGroup = null;
        }
    }

    private void onUseBillboard() {
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2 = this.getJMenuItem(this.popup, USE_BILLBOARD_CMD);
        this.isBillboard = jMenuItem2.isSelected();
        if (this.labelsGroup != null) {
            this.labelsGroup.detach();
        }
        if (!(jMenuItem = this.getJMenuItem(this.popup, HIDE_LABELS_CMD)).isSelected()) {
            this.labelsGroup = this.createLabelsGroup(this.labelIndex, this.locations, this.up_left_point, this.bottom_right_point);
            this.sceneGroup.addChild((Node)this.labelsGroup);
        }
    }

    private void onShowElements() {
        float f = Math.max(Math.abs(this.up_left_point.x - this.bottom_right_point.x), Math.abs(this.up_left_point.y - this.bottom_right_point.y));
        Point2f point2f = this.selectionShape.getStartCoords();
        Point2f point2f2 = this.selectionShape.getEndCoords();
        point2f.scale(f);
        point2f2.scale(f);
        point2f.add((Tuple2f)this.up_left_point);
        point2f2.add((Tuple2f)this.up_left_point);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.locations.length; ++i) {
            float f2 = this.locations[i][0];
            float f3 = this.locations[i][1];
            if (!(f2 >= point2f.x) || !(f2 <= point2f2.x) || !(f3 >= point2f.y) || !(f3 <= point2f2.y)) continue;
            arrayList.add(new String("Element[" + String.valueOf(i) + 1 + "]: " + (this.isGenes ? this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(i), this.labelIndex) : this.data.getSampleName(i))));
        }
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        String string = "Selected Elements";
        ListDialog listDialog = new ListDialog(frame, string, arrayList.toArray(new String[arrayList.size()]));
        listDialog.showModal();
    }

    private void updateLabelsGroup() {
        JMenuItem jMenuItem;
        if (this.labelsGroup != null) {
            this.labelsGroup.detach();
            this.labelsGroup = null;
        }
        if (!(jMenuItem = this.getJMenuItem(this.popup, HIDE_LABELS_CMD)).isSelected()) {
            this.labelsGroup = this.createLabelsGroup(this.labelIndex, this.locations, this.up_left_point, this.bottom_right_point);
            this.sceneGroup.addChild((Node)this.labelsGroup);
        }
    }

    private void showElementTip(int n, int n2) {
        if (this.isGenes && this.labelIndex < 0) {
            return;
        }
        PickCanvas pickCanvas = new PickCanvas(this.onScreenCanvas, this.sceneGroup);
        pickCanvas.setTolerance(this.pickBehavior.getTolerance());
        pickCanvas.setShapeLocation(n, n2);
        PickResult[] pickResultArray = pickCanvas.pickAllSorted();
        if (pickResultArray == null) {
            return;
        }
        for (int i = 0; i < pickResultArray.length; ++i) {
            if (pickResultArray[i].getObject() != this.genesShape) continue;
            PickIntersection pickIntersection = pickResultArray[i].getClosestIntersection(pickCanvas.getStartPosition());
            if (pickIntersection == null) {
                return;
            }
            int[] nArray = pickIntersection.getPrimitiveVertexIndices();
            int n3 = this.genesShape.getShapeIndex(nArray[0]);
            if (n3 < 0) {
                return;
            }
            String string = this.isGenes ? this.data.getElementAttribute(n3, this.labelIndex) : this.data.getSampleName(n3);
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText(string);
            Dimension dimension = jToolTip.getPreferredSize();
            Point point = this.onScreenCanvas.getLocationOnScreen();
            this.tipWindow.getContentPane().add((Component)jToolTip, "Center");
            this.tipWindow.setLocation(point.x + n, point.y + n2 + 20);
            this.tipWindow.pack();
            this.tipWindow.setVisible(true);
            return;
        }
    }

    private void hideElementTip() {
        this.tipWindow.getContentPane().removeAll();
        this.tipWindow.setVisible(false);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private class ZoomUndoable
    extends AbstractUndoableEdit {
        private Point2f start;
        private Point2f end;

        public ZoomUndoable(Point2f point2f, Point2f point2f2) {
            this.start = new Point2f(point2f);
            this.end = new Point2f(point2f2);
        }

        public void undo() throws CannotUndoException {
            TerrainViewer.this.doZoom(this.start, this.end);
        }

        public void redo() throws CannotRedoException {
        }

        public String getPresentationName() {
            return "Zoom";
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener,
    KeyListener,
    PickListener {
        private Timer timer = new Timer(1000, this);
        private int x = 0;
        private int y = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.timer) {
                this.onTimerEvent();
                return;
            }
            String string = actionEvent.getActionCommand();
            if (string.equals(TerrainViewer.SET_CLUSTER_CMD)) {
                TerrainViewer.this.onSetCluster();
            } else if (string.equals(TerrainViewer.SHOW_ELEMENTS_CMD)) {
                TerrainViewer.this.onShowElements();
            } else if (string.equals(TerrainViewer.FILL_POLYGON_CMD)) {
                TerrainViewer.this.onFillPolygon();
            } else if (string.equals(TerrainViewer.SHOW_CONTROLS_CMD)) {
                TerrainViewer.this.onShowControls();
            } else if (string.equals(TerrainViewer.ZOOM_IN_CMD)) {
                TerrainViewer.this.onZoom();
            } else if (string.equals(TerrainViewer.UNDO_CMD)) {
                TerrainViewer.this.onUndo();
            } else if (string.equals(TerrainViewer.DESELECT_CMD)) {
                TerrainViewer.this.onDeselect();
            } else if (string.equals(TerrainViewer.SHOW_ALL_CMD)) {
                TerrainViewer.this.onShowAll();
            } else if (string.equals(TerrainViewer.POINTS_SHAPE_CMD)) {
                TerrainViewer.this.onPointsShape();
            } else if (string.equals(TerrainViewer.SPHERES_SHAPE_CMD)) {
                TerrainViewer.this.onSpheresShape();
            } else if (string.equals(TerrainViewer.CUBES_SHAPE_CMD)) {
                TerrainViewer.this.onCubesShape();
            } else if (string.equals(TerrainViewer.GRID_SIZE_CMD)) {
                TerrainViewer.this.onGridSize();
            } else if (string.equals(TerrainViewer.DRIFT_DIALOG_CMD)) {
                TerrainViewer.this.onDriftDialog();
            } else if (string.equals(TerrainViewer.SHOW_LINKS_CMD)) {
                TerrainViewer.this.onShowLinks();
            } else if (string.equals(TerrainViewer.HIDE_LABELS_CMD)) {
                TerrainViewer.this.onHideLabels();
            } else if (string.equals(TerrainViewer.USE_BILLBOARD_CMD)) {
                TerrainViewer.this.onUseBillboard();
            } else if (string.equals(TerrainViewer.LINKS_THRESHOLD_CMD)) {
                TerrainViewer.this.onLinksThreshold();
            } else if (string.equals(TerrainViewer.LINKS_WIDTH_CMD)) {
                TerrainViewer.this.onLinksWidth();
            } else if (string.equals(TerrainViewer.LAUNCH_SESSION_CMD)) {
                TerrainViewer.this.onLaunchNewSession();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.ZOOM_IN_CMD, TerrainViewer.this.selectionShape.hasSelection());
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.DESELECT_CMD, TerrainViewer.this.selectionShape.hasSelection());
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.SET_CLUSTER_CMD, TerrainViewer.this.selectionShape.hasSelection());
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.SHOW_ELEMENTS_CMD, TerrainViewer.this.selectionShape.hasSelection());
                TerrainViewer.this.setEnableMenuItem(TerrainViewer.UNDO_CMD, TerrainViewer.this.undoManager.canUndo());
                TerrainViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void onMousePressed(MouseEvent mouseEvent, PickCanvas pickCanvas) {
            TerrainViewer.this.hideElementTip();
            if (mouseEvent.isMetaDown() || mouseEvent.isAltDown()) {
                return;
            }
            if (mouseEvent.isShiftDown()) {
                TerrainViewer.this.onStartSelection(mouseEvent, pickCanvas);
            } else if (mouseEvent.isControlDown()) {
                TerrainViewer.this.onCtrlPicked(mouseEvent, pickCanvas);
            } else {
                TerrainViewer.this.onPicked(mouseEvent, pickCanvas);
            }
        }

        public void onMouseDragged(MouseEvent mouseEvent, PickCanvas pickCanvas) {
            if (mouseEvent.isShiftDown()) {
                TerrainViewer.this.onDragSelection(mouseEvent, pickCanvas);
            }
        }

        public void onMouseReleased(MouseEvent mouseEvent, PickCanvas pickCanvas) {
            TerrainViewer.this.onReleaseSelection();
        }

        private PickResult[] getPickSortedResult(MouseEvent mouseEvent, PickCanvas pickCanvas) {
            pickCanvas.setShapeLocation(mouseEvent);
            return pickCanvas.pickAllSorted();
        }

        private PickResult[] getPickAllResult(MouseEvent mouseEvent, PickCanvas pickCanvas) {
            pickCanvas.setShapeLocation(mouseEvent);
            return pickCanvas.pickAll();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            TerrainViewer.this.keyMotionBehavior.onKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public Listener() {
            this.timer.setRepeats(false);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.timer.start();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.timer.stop();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            TerrainViewer.this.hideElementTip();
            this.timer.restart();
        }

        private void onTimerEvent() {
            TerrainViewer.this.showElementTip(this.x, this.y);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

