/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ttest;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.awt.ActionInfoDialog;

public class TTestVolcanoPlotViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202021040001L;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private double[] yArray;
    private double[] xArray;
    private boolean[] isSig;
    int originX;
    int originY;
    int currentMouseX;
    int currentMouseY;
    private boolean useRefLines;
    private boolean projectClusters;
    private boolean usePosAndNeg;
    private boolean usePosOnly;
    private boolean useNegOnly;
    private JPopupMenu popup;
    private JCheckBoxMenuItem useRefLinesBox;
    private JCheckBoxMenuItem projectClustersBox;
    int currentXSliderPosition;
    int currentYSliderPosition;
    double currentP;
    double currentMean;
    double oneClassMean;
    int tTestDesign;
    private Vector rawPValues;
    private Vector adjPValues;
    private Vector tValues;
    private Vector dfValues;
    private Vector meansA;
    private Vector meansB;
    private Vector sdA;
    private Vector sdB;
    private Vector oneClassMeans;
    private Vector oneClassSDs;

    public TTestVolcanoPlotViewer(Experiment experiment, double[] dArray, double[] dArray2, boolean[] blArray, int n, double d, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, Vector vector7, Vector vector8, Vector vector9, Vector vector10) {
        this.experiment = experiment;
        this.xArray = dArray;
        this.yArray = dArray2;
        this.isSig = blArray;
        this.rawPValues = vector7;
        this.adjPValues = vector8;
        this.tValues = vector9;
        this.dfValues = vector10;
        this.meansA = vector3;
        this.meansB = vector4;
        this.tTestDesign = n;
        this.oneClassMeans = vector;
        this.oneClassMean = d;
        this.oneClassSDs = vector2;
        this.sdA = vector5;
        this.sdB = vector6;
        this.useRefLines = true;
        this.projectClusters = false;
        this.usePosAndNeg = true;
        this.usePosOnly = false;
        this.useNegOnly = false;
        this.currentMouseX = 0;
        this.currentMouseY = 0;
        this.currentXSliderPosition = 0;
        this.currentYSliderPosition = 0;
        this.setBorder(new EtchedBorder());
        this.setBackground(Color.white);
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (TTestVolcanoPlotViewer.this.useRefLines) {
                    TTestVolcanoPlotViewer.this.currentMouseX = mouseEvent.getX();
                    TTestVolcanoPlotViewer.this.currentMouseY = mouseEvent.getY();
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        this.popup = new JPopupMenu();
        this.useRefLinesBox = new JCheckBoxMenuItem("Use reference lines", true);
        this.useRefLinesBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TTestVolcanoPlotViewer.this.useRefLines = true;
                } else {
                    TTestVolcanoPlotViewer.this.useRefLines = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }
        });
        this.popup.add(this.useRefLinesBox);
        this.popup.addSeparator();
        this.projectClustersBox = new JCheckBoxMenuItem("Project previously stored cluster colors", false);
        this.projectClustersBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TTestVolcanoPlotViewer.this.projectClusters = true;
                    TTestVolcanoPlotViewer.this.repaint();
                } else {
                    TTestVolcanoPlotViewer.this.projectClusters = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }
        });
        this.popup.add(this.projectClustersBox);
        this.popup.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Use gene selection sliders");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionSliderPanel selectionSliderPanel = new SelectionSliderPanel(TTestVolcanoPlotViewer.this.currentYSliderPosition, TTestVolcanoPlotViewer.this.currentXSliderPosition);
                TTestVolcanoPlotViewer.this.repaint();
                selectionSliderPanel.setVisible(true);
            }
        });
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Store selected genes as cluster", GUIFactory.getIcon("new16.gif"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TTestVolcanoPlotViewer.this.storeCluster();
            }
        });
        this.popup.add(jMenuItem2);
        this.popup.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TTestVolcanoPlotViewer.this.launchNewSession();
            }
        });
        this.popup.add(jMenuItem3);
        this.popup.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Save selected genes as cluster", GUIFactory.getIcon("save16.gif"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TTestVolcanoPlotViewer.this.onSaveCluster();
            }
        });
        this.popup.add(jMenuItem4);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    if (TTestVolcanoPlotViewer.this.currentXSliderPosition == 0 && TTestVolcanoPlotViewer.this.currentYSliderPosition == 0 && TTestVolcanoPlotViewer.this.usePosAndNeg) {
                        for (int i = 6; i < TTestVolcanoPlotViewer.this.popup.getComponentCount(); ++i) {
                            Component component = TTestVolcanoPlotViewer.this.popup.getComponent(i);
                            if (!(component instanceof JMenuItem)) continue;
                            component.setEnabled(false);
                        }
                    } else {
                        for (int i = 6; i < TTestVolcanoPlotViewer.this.popup.getComponentCount(); ++i) {
                            Component component = TTestVolcanoPlotViewer.this.popup.getComponent(i);
                            if (!(component instanceof JMenuItem)) continue;
                            component.setEnabled(true);
                        }
                    }
                    TTestVolcanoPlotViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.xArray);
        objectOutputStream.writeObject(this.yArray);
        objectOutputStream.writeObject(this.isSig);
        objectOutputStream.writeObject(this.rawPValues);
        objectOutputStream.writeObject(this.adjPValues);
        objectOutputStream.writeObject(this.tValues);
        objectOutputStream.writeObject(this.dfValues);
        objectOutputStream.writeObject(this.meansA);
        objectOutputStream.writeObject(this.meansB);
        objectOutputStream.writeInt(this.tTestDesign);
        objectOutputStream.writeObject(this.oneClassMeans);
        objectOutputStream.writeObject(this.oneClassSDs);
        objectOutputStream.writeObject(this.sdA);
        objectOutputStream.writeObject(this.sdB);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.xArray = (double[])objectInputStream.readObject();
        this.yArray = (double[])objectInputStream.readObject();
        this.isSig = (boolean[])objectInputStream.readObject();
        this.rawPValues = (Vector)objectInputStream.readObject();
        this.adjPValues = (Vector)objectInputStream.readObject();
        this.tValues = (Vector)objectInputStream.readObject();
        this.dfValues = (Vector)objectInputStream.readObject();
        this.meansA = (Vector)objectInputStream.readObject();
        this.meansB = (Vector)objectInputStream.readObject();
        this.tTestDesign = objectInputStream.readInt();
        this.oneClassMeans = (Vector)objectInputStream.readObject();
        this.oneClassSDs = (Vector)objectInputStream.readObject();
        this.sdA = (Vector)objectInputStream.readObject();
        this.sdB = (Vector)objectInputStream.readObject();
        this.useRefLines = true;
        this.projectClusters = false;
        this.usePosAndNeg = true;
        this.usePosOnly = false;
        this.useNegOnly = false;
        this.currentMouseX = 0;
        this.currentMouseY = 0;
        this.currentXSliderPosition = 0;
        this.currentYSliderPosition = 0;
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (TTestVolcanoPlotViewer.this.useRefLines) {
                    TTestVolcanoPlotViewer.this.currentMouseX = mouseEvent.getX();
                    TTestVolcanoPlotViewer.this.currentMouseY = mouseEvent.getY();
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        this.popup = new JPopupMenu();
        this.useRefLinesBox = new JCheckBoxMenuItem("Use reference lines", true);
        this.useRefLinesBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TTestVolcanoPlotViewer.this.useRefLines = true;
                } else {
                    TTestVolcanoPlotViewer.this.useRefLines = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }
        });
        this.popup.add(this.useRefLinesBox);
        this.popup.addSeparator();
        this.projectClustersBox = new JCheckBoxMenuItem("Project previously stored cluster colors", false);
        this.projectClustersBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TTestVolcanoPlotViewer.this.projectClusters = true;
                    TTestVolcanoPlotViewer.this.repaint();
                } else {
                    TTestVolcanoPlotViewer.this.projectClusters = false;
                    TTestVolcanoPlotViewer.this.repaint();
                }
            }
        });
        this.popup.add(this.projectClustersBox);
        this.popup.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Use gene selection sliders");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectionSliderPanel selectionSliderPanel = new SelectionSliderPanel(TTestVolcanoPlotViewer.this.currentYSliderPosition, TTestVolcanoPlotViewer.this.currentXSliderPosition);
                TTestVolcanoPlotViewer.this.repaint();
                selectionSliderPanel.setVisible(true);
            }
        });
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Store selected genes as cluster", GUIFactory.getIcon("new16.gif"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TTestVolcanoPlotViewer.this.storeCluster();
            }
        });
        this.popup.add(jMenuItem2);
        this.popup.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TTestVolcanoPlotViewer.this.launchNewSession();
            }
        });
        this.popup.add(jMenuItem3);
        this.popup.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Save selected genes as cluster", GUIFactory.getIcon("save16.gif"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TTestVolcanoPlotViewer.this.onSaveCluster();
            }
        });
        this.popup.add(jMenuItem4);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    if (TTestVolcanoPlotViewer.this.currentXSliderPosition == 0 && TTestVolcanoPlotViewer.this.currentYSliderPosition == 0 && TTestVolcanoPlotViewer.this.usePosAndNeg) {
                        for (int i = 6; i < TTestVolcanoPlotViewer.this.popup.getComponentCount(); ++i) {
                            Component component = TTestVolcanoPlotViewer.this.popup.getComponent(i);
                            if (!(component instanceof JMenuItem)) continue;
                            component.setEnabled(false);
                        }
                    } else {
                        for (int i = 6; i < TTestVolcanoPlotViewer.this.popup.getComponentCount(); ++i) {
                            Component component = TTestVolcanoPlotViewer.this.popup.getComponent(i);
                            if (!(component instanceof JMenuItem)) continue;
                            component.setEnabled(true);
                        }
                    }
                    TTestVolcanoPlotViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        double[] dArray = this.getMaxXAndY();
        double[] dArray2 = this.getMinXAndY();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray2[0];
        double d4 = dArray2[1];
        double d5 = this.getXScalingFactor(d, d3);
        double d6 = this.getYScalingFactor(d2, d4);
        float[] fArray = new float[]{10.0f};
        BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(40, 10, this.getWidth() - 10, 10);
        graphics2D.drawLine(this.getWidth() - 10, 10, this.getWidth() - 10, this.getHeight() - 50);
        this.originX = (int)Math.round((double)(this.getWidth() / 2));
        this.originY = (int)Math.round((double)(this.getHeight() - 50));
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(40, (int)Math.round((double)(this.getHeight() - 50)), this.getWidth() - 10, (int)Math.round((double)(this.getHeight() - 50)));
        graphics2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 10, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight() - 50);
        graphics2D.drawLine(40, 10, 40, this.getHeight() - 50);
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.useRefLines && this.currentMouseX >= 40 && this.currentMouseX <= this.getWidth() - 10 && this.currentMouseY >= 10 && this.currentMouseY <= this.getHeight() - 50) {
            graphics2D.setColor(Color.magenta);
            graphics2D.drawLine(40, this.currentMouseY, this.getWidth() - 10, this.currentMouseY);
            graphics2D.drawLine(this.currentMouseX, 10, this.currentMouseX, this.getHeight() - 50);
        }
        graphics2D.setColor(Color.black);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.drawString("-log10(p)", -1 * this.getHeight() / 2, 15);
        graphics2D.rotate(1.5707963267948966);
        double[] dArray3 = new double[6];
        double d7 = 0.0;
        d7 = Math.abs(d) > Math.abs(d3) ? Math.abs(d / 5.0) : Math.abs(d3 / 5.0);
        double d8 = 0.0;
        for (n3 = 0; n3 < dArray3.length; ++n3) {
            dArray3[n3] = d8;
            d8 += d7;
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        for (n3 = 1; n3 < dArray3.length; ++n3) {
            graphics2D.drawLine((int)Math.round(dArray3[n3] * d5) + this.getWidth() / 2, this.getHeight() - 50 - 5, (int)Math.round(dArray3[n3] * d5) + this.getWidth() / 2, this.getHeight() - 50 + 5);
        }
        for (n3 = 1; n3 < dArray3.length; ++n3) {
            graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray3[n3] * d5), this.getHeight() - 50 - 5, this.getWidth() / 2 - (int)Math.round(dArray3[n3] * d5), this.getHeight() - 50 + 5);
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        for (n2 = 1; n2 < dArray3.length; ++n2) {
            graphics2D.drawString(decimalFormat.format(dArray3[n2]), (int)Math.round(dArray3[n2] * d5) + this.getWidth() / 2 - 10, this.getHeight() - 30);
        }
        for (n2 = 1; n2 < dArray3.length; ++n2) {
            graphics2D.drawString("-" + decimalFormat.format(dArray3[n2]), this.getWidth() / 2 - (int)Math.round(dArray3[n2] * d5) - 10, this.getHeight() - 30);
        }
        if (this.tTestDesign == 8) {
            graphics2D.drawString("Gene Mean - Hypothesized Mean (" + this.oneClassMean + ")", this.getWidth() / 2 - 85, this.getHeight() - 15);
        } else {
            graphics2D.drawString("Mean(GroupB) - Mean(GroupA)", this.getWidth() / 2 - 85, this.getHeight() - 15);
        }
        n2 = (int)Math.round(d2);
        graphics2D.setColor(Color.gray);
        graphics2D.setStroke(new BasicStroke(1.0f));
        for (int i = 1; i <= n2 && this.getHeight() - 50 - (int)Math.round((double)i * d6) >= 10; ++i) {
            graphics2D.drawLine(40, this.getHeight() - 50 - (int)Math.round((double)i * d6), this.getWidth() - 10, this.getHeight() - 50 - (int)Math.round((double)i * d6));
        }
        graphics2D.setColor(Color.black);
        for (n = 1; n <= n2; ++n) {
            int n6 = 25;
            if (n >= 10) {
                n6 = 20;
            }
            if (this.getHeight() - 50 - (int)Math.round((double)n * d6) < 10) continue;
            graphics2D.drawString(decimalFormat.format(n), n6, this.getHeight() - 50 - (int)Math.round((double)n * d6));
        }
        for (n = 0; n < this.xArray.length; ++n) {
            if (Double.isNaN(this.xArray[n]) || Double.isNaN(this.yArray[n]) || Double.isInfinite(this.xArray[n]) || Double.isInfinite(this.yArray[n])) continue;
            if (!this.projectClusters) {
                if (this.currentXSliderPosition == 0 && this.currentYSliderPosition == 0 && this.usePosAndNeg) {
                    if (this.isSig[n]) {
                        graphics2D.setColor(Color.red);
                    } else {
                        graphics2D.setColor(Color.black);
                    }
                } else if (this.usePosAndNeg) {
                    if (Math.abs(this.xArray[n]) >= this.currentMean && this.yArray[n] >= this.currentP) {
                        graphics2D.setColor(Color.green);
                    } else if (this.isSig[n]) {
                        graphics2D.setColor(Color.red);
                    } else {
                        graphics2D.setColor(Color.black);
                    }
                } else if (this.usePosOnly) {
                    if (this.xArray[n] >= this.currentMean && this.yArray[n] >= this.currentP) {
                        graphics2D.setColor(Color.green);
                    } else if (this.isSig[n]) {
                        graphics2D.setColor(Color.red);
                    } else {
                        graphics2D.setColor(Color.black);
                    }
                } else if (this.useNegOnly) {
                    if (this.xArray[n] <= -1.0 * this.currentMean && this.yArray[n] >= this.currentP) {
                        graphics2D.setColor(Color.green);
                    } else if (this.isSig[n]) {
                        graphics2D.setColor(Color.red);
                    } else {
                        graphics2D.setColor(Color.black);
                    }
                }
            } else {
                Color color = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(n));
                if (color == null) {
                    color = Color.black;
                }
                graphics2D.setColor(color);
            }
            this.drawPoint(graphics2D, this.xArray[n], this.yArray[n], this.getXScalingFactor(d, d3), this.getYScalingFactor(d2, d4), 5);
        }
        graphics2D.setColor(Color.black);
        if (this.currentYSliderPosition > 0) {
            graphics2D.setStroke(basicStroke);
            graphics2D.drawLine(40, (int)Math.round((double)(this.getHeight() - 50) - this.currentP * d6), this.getWidth() - 10, (int)Math.round((double)(this.getHeight() - 50) - this.currentP * d6));
        }
        if (this.currentXSliderPosition > 0) {
            graphics2D.setStroke(basicStroke);
            if (this.usePosAndNeg) {
                graphics2D.drawLine((int)Math.round((double)Math.round(this.getWidth() / 2) - this.currentMean * d5), 10, (int)Math.round((double)Math.round(this.getWidth() / 2) - this.currentMean * d5), Math.round(this.getHeight() - 50));
                graphics2D.drawLine((int)Math.round((double)Math.round(this.getWidth() / 2) + this.currentMean * d5), 10, (int)Math.round((double)Math.round(this.getWidth() / 2) + this.currentMean * d5), Math.round(this.getHeight() - 50));
            } else if (this.usePosOnly) {
                graphics2D.drawLine((int)Math.round((double)Math.round(this.getWidth() / 2) + this.currentMean * d5), 10, (int)Math.round((double)Math.round(this.getWidth() / 2) + this.currentMean * d5), Math.round(this.getHeight() - 50));
            } else if (this.useNegOnly) {
                graphics2D.drawLine((int)Math.round((double)Math.round(this.getWidth() / 2) - this.currentMean * d5), 10, (int)Math.round((double)Math.round(this.getWidth() / 2) - this.currentMean * d5), Math.round(this.getHeight() - 50));
            }
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(Color.black);
    }

    private void drawPoint(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
        int n2 = (int)Math.round(d * d3);
        int n3 = (int)Math.round(d2 * d4);
        int n4 = 0;
        int n5 = 0;
        n4 = (int)Math.round((double)(this.getWidth() / 2)) + n2;
        n5 = (int)Math.round((double)(this.getHeight() - 50)) - n3;
        graphics2D.fillOval(n4, n5, n, n);
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getArrayMappedToData(), this.experiment, 0);
        }
    }

    public void storeCluster() {
        this.framework.storeSubCluster(this.getArrayMappedToData(), this.experiment, 0);
        this.onDataChanged(this.data);
    }

    public void setData(IData iData) {
        this.data = iData;
    }

    private int[] getArrayMappedToData() {
        int[] nArray = this.getCluster();
        if (nArray == null || nArray.length < 1) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    private int[] getCluster() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.xArray.length; ++i) {
            if (this.usePosAndNeg) {
                if (!(Math.abs(this.xArray[i]) >= this.currentMean) || !(this.yArray[i] >= this.currentP)) continue;
                vector.add(new Integer(i));
                continue;
            }
            if (this.usePosOnly) {
                if (!(this.xArray[i] >= this.currentMean) || !(this.yArray[i] >= this.currentP)) continue;
                vector.add(new Integer(i));
                continue;
            }
            if (!this.useNegOnly || !(this.xArray[i] <= -1.0 * this.currentMean) || !(this.yArray[i] >= this.currentP)) continue;
            vector.add(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getArrayMappedToData(), this.experiment, "Multiple Experiment Viewer - Volcano Plot Selected Genes Viewer", 0);
    }

    private static File getFile(Frame frame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"));
        jFileChooser.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        jFileChooser.setFileView((FileView)new ExpressionFileView());
        int n = jFileChooser.showSaveDialog(frame);
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            this.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    public void saveExperiment(Frame frame, Experiment experiment, IData iData, int[] nArray) throws Exception {
        File file = TTestVolcanoPlotViewer.getFile(frame);
        if (file != null) {
            this.saveCluster(file, experiment, iData, nArray);
        }
    }

    private void saveCluster(File file, Experiment experiment, IData iData, int[] nArray) throws Exception {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        String[] stringArray = iData.getFieldNames();
        printWriter.print("Original row");
        printWriter.print("\t");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.print(stringArray[n]);
            printWriter.print("\t");
        }
        if (this.tTestDesign == 7) {
            printWriter.print("GroupA mean\t");
            printWriter.print("GroupA std.dev.\t");
            printWriter.print("GroupB mean\t");
            printWriter.print("GroupB std.dev.\t");
            printWriter.print("Absolute t value");
        } else if (this.tTestDesign == 8) {
            printWriter.print("Gene mean\t");
            printWriter.print("Gene std.dev.\t");
            printWriter.print("t value");
        }
        printWriter.print("\t");
        printWriter.print("Degrees of freedom\t");
        printWriter.print("Raw p value\t");
        printWriter.print("Adj p value");
        for (n = 0; n < experiment.getNumberOfSamples(); ++n) {
            printWriter.print("\t");
            printWriter.print(iData.getSampleName(experiment.getSampleIndex(n)));
        }
        printWriter.print("\n");
        for (n = 0; n < nArray.length; ++n) {
            int n2;
            printWriter.print(Integer.toString(experiment.getGeneIndexMappedToData(nArray[n]) + 1));
            printWriter.print("\t");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                printWriter.print(iData.getElementAttribute(experiment.getGeneIndexMappedToData(nArray[n]), n2));
                printWriter.print("\t");
            }
            if (this.tTestDesign == 7) {
                printWriter.print(((Float)this.meansA.get(nArray[n])).floatValue() + "\t");
                printWriter.print(((Float)this.sdA.get(nArray[n])).floatValue() + "\t");
                printWriter.print(((Float)this.meansB.get(nArray[n])).floatValue() + "\t");
                printWriter.print(((Float)this.sdB.get(nArray[n])).floatValue() + "\t");
            } else if (this.tTestDesign == 8) {
                printWriter.print(((Float)this.oneClassMeans.get(nArray[n])).floatValue() + "\t");
                printWriter.print(((Float)this.oneClassSDs.get(nArray[n])).floatValue() + "\t");
            }
            printWriter.print("" + ((Float)this.tValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.dfValues.get(nArray[n])).intValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.rawPValues.get(nArray[n])).floatValue());
            printWriter.print("\t");
            printWriter.print("" + ((Float)this.adjPValues.get(nArray[n])).floatValue());
            for (n2 = 0; n2 < experiment.getNumberOfSamples(); ++n2) {
                printWriter.print("\t");
                printWriter.print(Float.toString(experiment.get(nArray[n], n2)));
            }
            printWriter.print("\n");
        }
        printWriter.flush();
        printWriter.close();
    }

    private double[] getMaxXAndY() {
        double[] dArray = new double[2];
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.xArray.length; ++i) {
            if (Double.isInfinite(this.xArray[i]) || Double.isNaN(this.xArray[i]) || Double.isInfinite(this.yArray[i]) || Double.isNaN(this.yArray[i])) continue;
            if (d < this.xArray[i]) {
                d = this.xArray[i];
            }
            if (!(d2 < this.yArray[i])) continue;
            d2 = this.yArray[i];
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    private double[] getMinXAndY() {
        double[] dArray = new double[2];
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.xArray.length; ++i) {
            if (Double.isInfinite(this.xArray[i]) || Double.isNaN(this.xArray[i]) || Double.isInfinite(this.yArray[i]) || Double.isNaN(this.yArray[i])) continue;
            if (d > this.xArray[i]) {
                d = this.xArray[i];
            }
            if (!(d2 > this.yArray[i])) continue;
            d2 = this.yArray[i];
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    private double getXScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = (double)(this.getWidth() / 2 - 50) / d3;
        return d4;
    }

    private double getYScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = (double)(this.getHeight() - 50 - 50) / d3;
        return d4;
    }

    public void showReferenceLines() {
    }

    public void onDeselected() {
    }

    public void onDataChanged(IData iData) {
        this.setData(iData);
    }

    public void onClosed() {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.setData(iFramework.getData());
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    static /* synthetic */ boolean access$302(TTestVolcanoPlotViewer tTestVolcanoPlotViewer, boolean bl) {
        tTestVolcanoPlotViewer.usePosAndNeg = bl;
        return tTestVolcanoPlotViewer.usePosAndNeg;
    }

    static /* synthetic */ boolean access$1002(TTestVolcanoPlotViewer tTestVolcanoPlotViewer, boolean bl) {
        tTestVolcanoPlotViewer.usePosOnly = bl;
        return tTestVolcanoPlotViewer.usePosOnly;
    }

    static /* synthetic */ boolean access$1102(TTestVolcanoPlotViewer tTestVolcanoPlotViewer, boolean bl) {
        tTestVolcanoPlotViewer.useNegOnly = bl;
        return tTestVolcanoPlotViewer.useNegOnly;
    }

    class SelectionSliderPanel
    extends ActionInfoDialog {
        JSlider pValueSlider;
        JSlider meanSlider;
        JTextField pValueField;
        JTextField meanField;
        JRadioButton posAndNeg;
        JRadioButton posOnly;
        JRadioButton negOnly;
        JButton closeButton;
        JButton resetButton;
        int initP;
        int initMean;
        double maxP;
        double maxMean;

        SelectionSliderPanel(int n, int n2) {
            super((JFrame)JOptionPane.getFrameForComponent(TTestVolcanoPlotViewer.this), "Select genes", true);
            this.setBackground(Color.white);
            this.initP = n;
            this.initMean = n2;
            this.maxP = TTestVolcanoPlotViewer.this.getMaxXAndY()[1];
            this.maxMean = Math.max(Math.abs(TTestVolcanoPlotViewer.this.getMaxXAndY()[0]), Math.abs(TTestVolcanoPlotViewer.this.getMinXAndY()[0]));
            this.setBounds(0, 0, 450, 200);
            this.setDefaultCloseOperation(2);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(gridBagLayout);
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout2);
            JLabel jLabel = new JLabel("Select -log10(p) cutoff: ");
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30, 50);
            gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            this.pValueSlider = new JSlider(0, 100, n);
            this.pValueField = new JTextField("" + this.getDisplayPValue(n), 7);
            this.pValueField.addActionListener(new ActionListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String string = this.this$1.pValueField.getText();
                        double d = Double.parseDouble(string);
                        int n = (int)Math.round(d * 100.0 / this.this$1.maxP);
                        if (n >= 100) {
                            this.this$1.pValueSlider.setValue(100);
                            this.this$1.pValueField.setText("" + (float)this.this$1.maxP);
                        } else if (n <= 0) {
                            this.this$1.pValueSlider.setValue(0);
                            this.this$1.pValueField.setText("0.0");
                        } else {
                            this.this$1.pValueSlider.setValue(n);
                            this.this$1.pValueField.setText("" + (float)d);
                        }
                    }
                    catch (Exception exception) {
                        this.this$1.pValueSlider.setValue(0);
                        this.this$1.pValueField.setText("0.0");
                    }
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentYSliderPosition = this.this$1.pValueSlider.getValue();
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentP = SelectionSliderPanel.access$800(this.this$1, SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentYSliderPosition);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }
            });
            this.pValueField.addFocusListener(new FocusListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void focusLost(FocusEvent focusEvent) {
                    try {
                        String string = this.this$1.pValueField.getText();
                        double d = Double.parseDouble(string);
                        int n = (int)Math.round(d * 100.0 / this.this$1.maxP);
                        if (n >= 100) {
                            this.this$1.pValueSlider.setValue(100);
                            this.this$1.pValueField.setText("" + (float)this.this$1.maxP);
                        } else if (n <= 0) {
                            this.this$1.pValueSlider.setValue(0);
                            this.this$1.pValueField.setText("0.0");
                        } else {
                            this.this$1.pValueSlider.setValue(n);
                            this.this$1.pValueField.setText("" + (float)d);
                        }
                    }
                    catch (Exception exception) {
                        this.this$1.pValueSlider.setValue(0);
                        this.this$1.pValueField.setText("0.0");
                    }
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentYSliderPosition = this.this$1.pValueSlider.getValue();
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentP = SelectionSliderPanel.access$800(this.this$1, SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentYSliderPosition);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }

                public void focusGained(FocusEvent focusEvent) {
                }
            });
            this.pValueSlider.addChangeListener(new ChangeListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = this.this$1.pValueSlider.getValue();
                    double d = (double)n * this.this$1.maxP / 100.0;
                    if (n == 0) {
                        d = 0.0;
                    }
                    this.this$1.pValueField.setText("" + (float)d);
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentYSliderPosition = this.this$1.pValueSlider.getValue();
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentP = SelectionSliderPanel.access$800(this.this$1, SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentYSliderPosition);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }
            });
            this.pValueSlider.setBackground(Color.white);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagLayout2.setConstraints(this.pValueSlider, gridBagConstraints);
            jPanel2.add(this.pValueSlider);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 20, 0);
            gridBagLayout2.setConstraints(this.pValueField, gridBagConstraints);
            jPanel2.add(this.pValueField);
            JLabel jLabel2 = new JLabel("Select mean diff. cutoff: ");
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 30, 50);
            gridBagLayout2.setConstraints(jLabel2, gridBagConstraints);
            jPanel2.add(jLabel2);
            this.meanSlider = new JSlider(0, 100, n2);
            this.meanField = new JTextField("" + this.getDisplayMean(n2), 7);
            this.meanSlider.addChangeListener(new ChangeListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = this.this$1.meanSlider.getValue();
                    double d = (double)n * this.this$1.maxMean / 100.0;
                    if (n == 0) {
                        d = 0.0;
                    }
                    this.this$1.meanField.setText("" + (float)d);
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentXSliderPosition = this.this$1.meanSlider.getValue();
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentMean = SelectionSliderPanel.access$900(this.this$1, SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentXSliderPosition);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }
            });
            this.meanField.addActionListener(new ActionListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        String string = this.this$1.meanField.getText();
                        double d = Double.parseDouble(string);
                        int n = (int)Math.round(d * 100.0 / this.this$1.maxMean);
                        if (n >= 100) {
                            this.this$1.meanSlider.setValue(100);
                            this.this$1.meanField.setText("" + (float)this.this$1.maxMean);
                        } else if (n <= 0) {
                            this.this$1.meanSlider.setValue(0);
                            this.this$1.meanField.setText("0.0");
                        } else {
                            this.this$1.meanSlider.setValue(n);
                            this.this$1.meanField.setText("" + (float)d);
                        }
                    }
                    catch (Exception exception) {
                        this.this$1.meanSlider.setValue(0);
                        this.this$1.meanField.setText("0.0");
                    }
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentXSliderPosition = this.this$1.meanSlider.getValue();
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentMean = SelectionSliderPanel.access$900(this.this$1, SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentXSliderPosition);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }
            });
            this.meanField.addFocusListener(new FocusListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void focusLost(FocusEvent focusEvent) {
                    try {
                        String string = this.this$1.meanField.getText();
                        double d = Double.parseDouble(string);
                        int n = (int)Math.round(d * 100.0 / this.this$1.maxMean);
                        if (n >= 100) {
                            this.this$1.meanSlider.setValue(100);
                            this.this$1.meanField.setText("" + (float)this.this$1.maxMean);
                        } else if (n <= 0) {
                            this.this$1.meanSlider.setValue(0);
                            this.this$1.meanField.setText("0.0");
                        } else {
                            this.this$1.meanSlider.setValue(n);
                            this.this$1.meanField.setText("" + (float)d);
                        }
                    }
                    catch (Exception exception) {
                        this.this$1.meanSlider.setValue(0);
                        this.this$1.meanField.setText("0.0");
                    }
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentXSliderPosition = this.this$1.meanSlider.getValue();
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentMean = SelectionSliderPanel.access$900(this.this$1, SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentXSliderPosition);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }

                public void focusGained(FocusEvent focusEvent) {
                }
            });
            this.meanSlider.setBackground(Color.white);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
            gridBagLayout2.setConstraints(this.meanSlider, gridBagConstraints);
            jPanel2.add(this.meanSlider);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 20, 0);
            gridBagLayout2.setConstraints(this.meanField, gridBagConstraints);
            jPanel2.add(this.meanField);
            JPanel jPanel3 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel3.setLayout(gridBagLayout3);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.posAndNeg = new JRadioButton("Both pos. and neg.");
            this.posOnly = new JRadioButton("Pos. only");
            this.negOnly = new JRadioButton("Neg. only");
            if (TTestVolcanoPlotViewer.this.usePosAndNeg) {
                this.posAndNeg.setSelected(true);
                this.posOnly.setSelected(false);
                this.negOnly.setSelected(false);
            } else if (TTestVolcanoPlotViewer.this.usePosOnly) {
                this.posAndNeg.setSelected(false);
                this.posOnly.setSelected(true);
                this.negOnly.setSelected(false);
            } else if (TTestVolcanoPlotViewer.this.useNegOnly) {
                this.posAndNeg.setSelected(false);
                this.posOnly.setSelected(false);
                this.negOnly.setSelected(true);
            }
            this.posAndNeg.addActionListener(new ActionListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TTestVolcanoPlotViewer.access$302(SelectionSliderPanel.access$700(this.this$1), true);
                    TTestVolcanoPlotViewer.access$1002(SelectionSliderPanel.access$700(this.this$1), false);
                    TTestVolcanoPlotViewer.access$1102(SelectionSliderPanel.access$700(this.this$1), false);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }
            });
            this.posAndNeg.setBackground(Color.white);
            this.posOnly.addActionListener(new ActionListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TTestVolcanoPlotViewer.access$302(SelectionSliderPanel.access$700(this.this$1), false);
                    TTestVolcanoPlotViewer.access$1002(SelectionSliderPanel.access$700(this.this$1), true);
                    TTestVolcanoPlotViewer.access$1102(SelectionSliderPanel.access$700(this.this$1), false);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }
            });
            this.posOnly.setBackground(Color.white);
            this.negOnly.addActionListener(new ActionListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TTestVolcanoPlotViewer.access$302(SelectionSliderPanel.access$700(this.this$1), false);
                    TTestVolcanoPlotViewer.access$1002(SelectionSliderPanel.access$700(this.this$1), false);
                    TTestVolcanoPlotViewer.access$1102(SelectionSliderPanel.access$700(this.this$1), true);
                    SelectionSliderPanel.access$700(this.this$1).repaint();
                }
            });
            this.negOnly.setBackground(Color.white);
            buttonGroup.add(this.posAndNeg);
            buttonGroup.add(this.posOnly);
            buttonGroup.add(this.negOnly);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout3.setConstraints(this.posAndNeg, gridBagConstraints);
            jPanel3.add(this.posAndNeg);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout3.setConstraints(this.posOnly, gridBagConstraints);
            jPanel3.add(this.posOnly);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout3.setConstraints(this.negOnly, gridBagConstraints);
            jPanel3.add(this.negOnly);
            JPanel jPanel4 = new JPanel();
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            jPanel4.setLayout(gridBagLayout4);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.pValueSlider.setValue(0);
                    this.this$1.pValueField.setText("0.0");
                    this.this$1.meanSlider.setValue(0);
                    this.this$1.meanField.setText("0.0");
                    this.this$1.posAndNeg.setSelected(true);
                    TTestVolcanoPlotViewer.access$302(SelectionSliderPanel.access$700(this.this$1), true);
                    TTestVolcanoPlotViewer.access$1002(SelectionSliderPanel.access$700(this.this$1), false);
                    TTestVolcanoPlotViewer.access$1102(SelectionSliderPanel.access$700(this.this$1), false);
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentXSliderPosition = 0;
                    SelectionSliderPanel.access$700((SelectionSliderPanel)this.this$1).currentYSliderPosition = 0;
                }
            });
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagConstraints.anchor = 13;
            gridBagLayout4.setConstraints(this.resetButton, gridBagConstraints);
            jPanel4.add(this.resetButton);
            this.closeButton = new JButton("OK");
            this.closeButton.addActionListener(new ActionListener(this, TTestVolcanoPlotViewer.this){
                private final /* synthetic */ TTestVolcanoPlotViewer val$this$0;
                private final /* synthetic */ SelectionSliderPanel this$1;
                {
                    this.this$1 = selectionSliderPanel;
                    this.val$this$0 = tTestVolcanoPlotViewer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dispose();
                }
            });
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout4.setConstraints(this.closeButton, gridBagConstraints);
            jPanel4.add(this.closeButton);
            gridBagConstraints.anchor = 10;
            jPanel2.setBorder(new EtchedBorder());
            jPanel3.setBorder(new EtchedBorder());
            jPanel4.setBorder(new EtchedBorder());
            jPanel2.setBackground(Color.white);
            jPanel3.setBackground(Color.white);
            jPanel4.setBackground(Color.white);
            gridBagConstraints.fill = 1;
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 40);
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 30);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel.add(jPanel3);
            TTestVolcanoPlotViewer.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 30);
            gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
            jPanel.add(jPanel4);
            this.setContentPane(jPanel);
        }

        private float getDisplayPValue(int n) {
            double d = (double)n * this.maxP / 100.0;
            return (float)d;
        }

        private float getDisplayMean(int n) {
            double d = (double)n * this.maxMean / 100.0;
            return (float)d;
        }

        public void setVisible(boolean bl) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
            super.setVisible(bl);
        }

        static /* synthetic */ TTestVolcanoPlotViewer access$700(SelectionSliderPanel selectionSliderPanel) {
            return selectionSliderPanel.TTestVolcanoPlotViewer.this;
        }

        static /* synthetic */ float access$800(SelectionSliderPanel selectionSliderPanel, int n) {
            return selectionSliderPanel.getDisplayPValue(n);
        }

        static /* synthetic */ float access$900(SelectionSliderPanel selectionSliderPanel, int n) {
            return selectionSliderPanel.getDisplayMean(n);
        }
    }
}

