/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colourmask;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import org.biolegato.gdesupport.canvas.colourmap.ColourMap;
import org.biolegato.gdesupport.canvas.colourmask.ColourMaskReader;

public class ImportFileAction
extends Box
implements ActionListener {
    private JDialog window;
    private JComboBox combobox = new JComboBox<Object>(colourMasks.keySet().toArray());
    protected static Hashtable<String, ColourMap> colourMasks = new Hashtable();
    private static final long serialVersionUID = 7526472295622777037L;

    public ImportFileAction(JDialog window, Object defaultMask) {
        super(2);
        this.window = window;
        this.combobox.setSelectedItem(defaultMask);
        this.add(this.combobox);
        JButton importButton = new JButton("Import file...");
        importButton.addActionListener(this);
        this.add(importButton);
    }

    public void actionPerformed(ActionEvent e) {
        int number = 0;
        JFileChooser openDialog = new JFileChooser();
        ColourMap[] importMasks = null;
        openDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
        openDialog.setAcceptAllFileFilterUsed(true);
        if (openDialog.showOpenDialog(this.window) == 0 && openDialog.getSelectedFile() != null && openDialog.getSelectedFile().exists() && openDialog.getSelectedFile().isFile()) {
            if (openDialog.getFileFilter() != null && openDialog.getFileFilter() instanceof ColourMaskReader) {
                importMasks = ((ColourMaskReader)openDialog.getFileFilter()).readColourMapFile(openDialog.getSelectedFile());
            }
            for (ColourMap mask : importMasks) {
                if (colourMasks.contains(mask.getName())) {
                    while (colourMasks.contains(mask.getName() + " (" + number + ")")) {
                        ++number;
                    }
                    mask.setName(mask.getName() + " (" + number + ")");
                }
                this.combobox.addItem(mask.getName());
                colourMasks.put(mask.getName(), mask);
            }
        }
    }

    public Object getSelectedItem() {
        return this.combobox.getSelectedItem();
    }
}

