/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.list;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.Editable;
import org.biolegato.gdesupport.canvas.GDECanvas;
import org.biolegato.gdesupport.canvas.list.GDESequenceWindow;
import org.biolegato.gdesupport.canvas.list.SelectByNameWindow;
import org.biolegato.gdesupport.canvas.list.SequenceListModel;
import org.biolegato.gdesupport.canvas.undo.UndoMulti;
import org.biolegato.gdesupport.canvas.undo.UndoRowDeletion;

public class GDEList
extends JList
implements MouseListener,
FocusListener,
Editable {
    private long lastClickTime = -1000L;
    private int lastClickEntry = -1;
    private final GDEList listSelf = this;
    private GDECanvas canvas = null;
    protected JPopupMenu popup = new JPopupMenu();
    public final AbstractAction selectGroupAction = new AbstractAction("Select group"){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.selectGroup();
        }
    };
    public final AbstractAction getInfoAction = new AbstractAction("Get info..."){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(71));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.getInfo();
        }
    };
    private final JMenuItem deleteMenuItem = new JMenuItem(new AbstractAction("Delete"){
        private static final long serialVersionUID = 7526472295622776157L;
        {
            this.putValue("MnemonicKey", new Integer(68));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.delete();
        }
    });
    private final JMenuItem cutMenuItem = new JMenuItem(new AbstractAction("Cut"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.cut();
        }
    });
    private final JMenuItem copyMenuItem = new JMenuItem(new AbstractAction("Copy"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(89));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.copy();
        }
    });
    private final JMenuItem pasteMenuItem = new JMenuItem(new AbstractAction("Paste"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.paste();
        }
    });
    private final JMenuItem selectAllMenuItem = new JMenuItem(new AbstractAction("Select All"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.selectAll();
        }
    });
    public final AbstractAction selectByNameAction = new AbstractAction("Select sequence by name"){
        private static final long serialVersionUID = 7526472295622777033L;
        {
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent evt) {
            GDEList.this.listSelf.requestFocus();
            GDEList.this.listSelf.requestFocusInWindow();
            new SelectByNameWindow(BLMain.getJFrame(), GDEList.this.listSelf);
        }
    };
    private static final long serialVersionUID = 7526472295622777009L;

    public GDEList(GDECanvas canvas) {
        super(new SequenceListModel(BLMain.getSeqDoc()));
        this.canvas = canvas;
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addPopupMenuItem(this.cutMenuItem);
        this.addPopupMenuItem(this.copyMenuItem);
        this.addPopupMenuItem(this.pasteMenuItem);
        this.addPopupMenuItem(this.deleteMenuItem);
        this.addPopupMenuItem(this.selectAllMenuItem);
        this.addPopupMenuItem(new JMenuItem(this.selectGroupAction));
        this.addPopupMenuItem(new JMenuItem(this.selectByNameAction));
        this.addPopupMenuItem(new JMenuItem(this.getInfoAction));
        this.setForeground(Color.BLACK);
        this.setBackground(Color.LIGHT_GRAY);
        this.setSelectionBackground(Color.WHITE);
        this.setSelectionForeground(Color.GRAY);
        this.setSize(this.getPreferredSize());
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() > 2 || this.getSelectedIndex() == this.lastClickEntry && event.getWhen() - this.lastClickTime < 300L) {
            this.selectGroup();
        }
        this.lastClickTime = event.getWhen();
        this.lastClickEntry = this.getSelectedIndex();
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX() - this.getX(), event.getY() - this.getY());
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX() - this.getX(), event.getY() - this.getY());
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public int row2Y(int r) {
        return r * this.getFontMetrics(this.getFont()).getHeight();
    }

    public int column2X(int c) {
        return c * this.getFontMetrics(this.getFont()).charWidth('a');
    }

    public int Y2Row(int Y) {
        return Y / this.getFontMetrics(this.getFont()).getHeight();
    }

    public int X2Column(int X) {
        return X / this.getFontMetrics(this.getFont()).charWidth('a');
    }

    public void copy() {
        Sequence seqAdd = null;
        LinkedList<Sequence> seqList = new LinkedList<Sequence>();
        for (int line : this.getSelectedIndices()) {
            seqAdd = BLMain.getSeqDoc().getLine(line);
            if (seqAdd == null) continue;
            seqList.add(seqAdd);
        }
        BLMain.setClipboard((Sequence[])seqList.toArray(new Sequence[0]));
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void paste() {
        int row = BLMain.getSeqDoc().getLineCount();
        Sequence[] clipboard = BLMain.getClipboard();
        if (this.getSelectedIndex() >= 0) {
            row = this.getSelectedIndex() + 1;
        }
        for (Sequence seq : clipboard) {
            BLMain.getSeqDoc().addSequence(row, seq);
            ++row;
        }
    }

    public void selectAll() {
        this.setSelectionInterval(0, this.getModel().getSize());
    }

    public void changeCase() {
        String data = null;
        Sequence seq = null;
        for (int sequenceNumber : this.getSelectedIndices()) {
            seq = BLMain.getSeqDoc().getLine(sequenceNumber);
            data = seq.get((Object)"sequence").toString();
            if (data.length() < 0) continue;
            if (Character.isUpperCase(data.charAt(0))) {
                seq.put("sequence", (Object)data.toLowerCase());
                continue;
            }
            seq.put("sequence", (Object)data.toUpperCase());
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setFixedCellHeight(this.getFontMetrics(font).getHeight());
        this.repaint();
    }

    public void addPopupMenuItem(JMenuItem item) {
        this.popup.add(item);
    }

    public void getInfo() {
        LinkedList<Sequence> sequences = new LinkedList<Sequence>();
        for (int y : this.getSelectedIndices()) {
            sequences.add(BLMain.getSeqDoc().getLine(y));
        }
        if (sequences.size() > 0) {
            new GDESequenceWindow(BLMain.getJFrame(), sequences.toArray(new Sequence[0]));
        }
    }

    public void delete() {
        int[] deletionZone = this.getSelectedIndices();
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            UndoMulti undoResult = new UndoMulti();
            for (int lineNum : deletionZone) {
                undoResult.addUndo(new UndoRowDeletion(BLMain.getSeqDoc(), lineNum, BLMain.getSeqDoc().getLine(lineNum)));
            }
            this.canvas.addUndo(undoResult);
        }
        BLMain.getSeqDoc().removeSequences(deletionZone);
    }

    public void focusGained(FocusEvent e) {
        this.setBackground(new Color(255, 255, 240));
        this.setSelectionBackground(Color.BLUE);
        this.setSelectionForeground(Color.WHITE);
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.setBackground(Color.LIGHT_GRAY);
        this.setSelectionBackground(Color.WHITE);
        this.setSelectionForeground(Color.GRAY);
        this.repaint();
    }

    public SequenceListModel getListModel() {
        return (SequenceListModel)super.getModel();
    }

    public Sequence[] getData() {
        LinkedList<Sequence> lines = new LinkedList<Sequence>();
        for (int lineNumber : this.getSelectedIndices()) {
            if (BLMain.getSeqDoc().getLine(lineNumber) == null) continue;
            lines.add(BLMain.getSeqDoc().getLine(lineNumber));
        }
        return lines.toArray(new Sequence[0]);
    }

    public void selectGroup() {
        int[] groupint = null;
        Sequence current = null;
        LinkedList group = null;
        for (int index : this.getSelectedIndices()) {
            current = BLMain.getSeqDoc().getLine(index);
            if (!(current.get((Object)"group") instanceof Integer) || (group = Sequence.getgroup((Integer)((Integer)current.get((Object)"group")))) == null) continue;
            groupint = new int[group.size()];
            for (int count = 0; count < group.size(); ++count) {
                groupint[count] = BLMain.getSeqDoc().indexOf((Sequence)group.get(count));
            }
            this.setSelectedIndices(groupint);
        }
    }
}

