/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.list;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.colourmap.PositionColourMap;
import org.biolegato.gdesupport.canvas.colourmask.ImportFileAction;

public class GDESequenceWindow
extends JDialog
implements ActionListener,
ItemListener {
    private Sequence[] sequences;
    private JTextField name = new JTextField();
    private JCheckBox protectAlignmentCB = new JCheckBox("Alignment gaps");
    private JCheckBox protectAmbiguousCB = new JCheckBox("Ambiguous characters");
    private JCheckBox protectUnambiguousCB = new JCheckBox("Unambiguous characters");
    private JComboBox type = new JComboBox<Object>(new Object[]{"", Sequence.Type.DNA, Sequence.Type.RNA, Sequence.Type.PROTEIN, Sequence.Type.TEXT});
    private JComboBox direction = new JComboBox<Object>(new Object[]{"", Sequence.Direction.FROM5TO3, Sequence.Direction.FROM3TO5});
    private JComboBox topology = new JComboBox<Object>(new Object[]{"", Sequence.Topology.LINEAR, Sequence.Topology.CIRCULAR});
    private JComboBox strandedness = new JComboBox<Object>(new Object[]{"", Sequence.Strandedness.SINGLE, Sequence.Strandedness.MIXED, Sequence.Strandedness.DOUBLE});
    private ImportFileAction mask;
    private static final long serialVersionUID = 7526472295622777013L;

    public GDESequenceWindow(JFrame window, Sequence[] sequences) {
        super((Frame)window, "Sequence properties");
        this.sequences = sequences;
        PositionColourMap currentMask = null;
        if (sequences.length == 1) {
            this.name.setText(sequences[0].get((Object)"name").toString());
            this.type.setSelectedItem(sequences[0].get((Object)"type"));
            this.direction.setSelectedItem(sequences[0].get((Object)"direction"));
            this.topology.setSelectedItem(sequences[0].get((Object)"topology"));
            this.strandedness.setSelectedItem(sequences[0].get((Object)"strandedness"));
            if (sequences[0].get((Object)"mask") != null && sequences[0].get((Object)"mask") instanceof PositionColourMap) {
                currentMask = (PositionColourMap)sequences[0].get((Object)"mask");
            }
        }
        for (int count = 0; !(this.protectAlignmentCB.isSelected() && this.protectAmbiguousCB.isSelected() && this.protectUnambiguousCB.isSelected() || count >= sequences.length); ++count) {
            if (!this.protectAlignmentCB.isSelected() && sequences[count].get((Object)"protect_align") != null && sequences[count].get((Object)"protect_align") instanceof Boolean && ((Boolean)sequences[count].get((Object)"protect_align")).booleanValue()) {
                this.protectAlignmentCB.setSelected(true);
            }
            if (!this.protectAmbiguousCB.isSelected() && sequences[count].get((Object)"protect_ambig") != null && sequences[count].get((Object)"protect_ambig") instanceof Boolean && ((Boolean)sequences[count].get((Object)"protect_ambig")).booleanValue()) {
                this.protectAmbiguousCB.setSelected(true);
            }
            if (this.protectUnambiguousCB.isSelected() || sequences[count].get((Object)"protect_unambig") == null || !(sequences[count].get((Object)"protect_unambig") instanceof Boolean) || !((Boolean)sequences[count].get((Object)"protect_unambig")).booleanValue()) continue;
            this.protectUnambiguousCB.setSelected(true);
        }
        Box mainBox = new Box(3);
        Box nameBox = new Box(2);
        nameBox.add(new JLabel("Name:"));
        nameBox.add(this.name);
        mainBox.add(nameBox);
        Box typeBox = new Box(2);
        typeBox.add(new JLabel("Type:"));
        typeBox.add(this.type);
        this.type.addItemListener(this);
        mainBox.add(typeBox);
        Box directionBox = new Box(2);
        directionBox.add(new JLabel("Direction:"));
        directionBox.add(this.direction);
        mainBox.add(directionBox);
        Box topologyBox = new Box(2);
        topologyBox.add(new JLabel("Topology:"));
        topologyBox.add(this.topology);
        mainBox.add(topologyBox);
        Box strandednessBox = new Box(2);
        strandednessBox.add(new JLabel("Strandedness:"));
        strandednessBox.add(this.strandedness);
        mainBox.add(strandednessBox);
        Box protectionBox = new Box(3);
        protectionBox.add(this.protectAlignmentCB);
        protectionBox.add(this.protectAmbiguousCB);
        protectionBox.add(this.protectUnambiguousCB);
        protectionBox.setBorder(BorderFactory.createTitledBorder("Set character protections"));
        mainBox.add(protectionBox);
        Box maskBox = new Box(2);
        this.mask = new ImportFileAction(this, currentMask);
        maskBox.add(new JLabel("Colour mask:"));
        maskBox.add(this.mask);
        mainBox.add(maskBox);
        JButton update = new JButton("Update");
        update.setActionCommand("update");
        update.addActionListener(this);
        mainBox.add(update);
        this.itemStateChanged(new ItemEvent(this.type, this.type.getSelectedIndex(), this.type.getSelectedItem(), 1));
        this.add(mainBox);
        this.pack();
        this.setLocationRelativeTo(window);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public void actionPerformed(ActionEvent e) {
        if ("update".equals(e.getActionCommand())) {
            for (Sequence seq : this.sequences) {
                LinkedList group;
                if (!"".equals(this.name.getText())) {
                    seq.put("name", (Object)this.name.getText());
                }
                if (!"".equals(this.type.getSelectedItem())) {
                    seq.put("type", this.type.getSelectedItem());
                }
                if (!"".equals(this.direction.getSelectedItem())) {
                    seq.put("direction", this.direction.getSelectedItem());
                }
                if (!"".equals(this.topology.getSelectedItem())) {
                    seq.put("topology", this.topology.getSelectedItem());
                }
                if (!"".equals(this.strandedness.getSelectedItem())) {
                    seq.put("strandedness", this.strandedness.getSelectedItem());
                }
                if (!"".equals(this.mask.getSelectedItem())) {
                    seq.put("mask", this.mask.getSelectedItem());
                }
                seq.put("protect_align", (Object)new Boolean(this.protectAlignmentCB.isSelected()));
                seq.put("protect_ambig", (Object)new Boolean(this.protectAmbiguousCB.isSelected()));
                seq.put("protect_unambig", (Object)new Boolean(this.protectUnambiguousCB.isSelected()));
                if (seq.get((Object)"group") instanceof Integer && (group = Sequence.getgroup((Integer)((Integer)seq.get((Object)"group")))) != null) {
                    for (Sequence groupseq : group) {
                        groupseq.put("protect_align", (Object)new Boolean(this.protectAlignmentCB.isSelected()));
                        groupseq.put("protect_ambig", (Object)new Boolean(this.protectAmbiguousCB.isSelected()));
                        groupseq.put("protect_unambig", (Object)new Boolean(this.protectUnambiguousCB.isSelected()));
                    }
                }
                this.dispose();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (Sequence.Type.DNA.equals(this.type.getSelectedItem()) || Sequence.Type.RNA.equals(this.type.getSelectedItem())) {
            this.direction.setEnabled(true);
            this.topology.setEnabled(true);
            this.strandedness.setEnabled(true);
            this.mask.setEnabled(true);
        } else if (Sequence.Type.PROTEIN.equals(this.type.getSelectedItem())) {
            this.direction.setEnabled(false);
            this.topology.setEnabled(false);
            this.strandedness.setEnabled(false);
            this.mask.setEnabled(true);
        } else if (Sequence.Type.TEXT.equals(this.type.getSelectedItem())) {
            this.direction.setEnabled(false);
            this.topology.setEnabled(false);
            this.strandedness.setEnabled(false);
            this.mask.setEnabled(false);
        }
    }
}

