/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.list;

import java.util.LinkedList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.seqdoc.SeqDocListener;
import org.biolegato.core.data.sequence.Sequence;

public class SequenceListModel
implements ListModel,
SeqDocListener {
    private SeqDoc data;
    private LinkedList<ListDataListener> listeners = new LinkedList();

    public SequenceListModel(SeqDoc data) {
        this.data = data;
        data.addListener((SeqDocListener)this);
    }

    public int getSize() {
        return this.data.getLineCount();
    }

    public Object getElementAt(int index) {
        String name = "";
        Sequence seq = this.data.getLine(index);
        if (seq != null) {
            name = seq.get((Object)"group") != null && seq.get((Object)"group") instanceof Integer ? name + seq.get((Object)"group").toString() + " " : name + "_ ";
            name = name + seq.get((Object)"name").toString();
        }
        return name;
    }

    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void sequenceChanged(SeqDoc source, int index, Sequence sequence, String key) {
        for (ListDataListener l : this.listeners) {
            l.contentsChanged(new ListDataEvent(this, 0, index, index));
        }
    }

    public void sequenceAdded(SeqDoc source, int index, Sequence sequence) {
        for (ListDataListener l : this.listeners) {
            l.intervalAdded(new ListDataEvent(this, 0, index, index));
        }
    }

    public void sequenceRemoved(SeqDoc source, int index, Sequence sequence) {
        for (ListDataListener l : this.listeners) {
            l.intervalRemoved(new ListDataEvent(this, 0, index, index));
        }
    }
}

