/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.textarea;

import java.awt.Font;
import javax.swing.JComponent;

public abstract class BLComponent
extends JComponent {
    protected int rowHeight = 1;
    protected int columnWidth = 1;

    public void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = 0;
        for (int fontWidth : this.getFontMetrics(this.getFont()).getWidths()) {
            this.columnWidth = Math.max(this.columnWidth, fontWidth);
        }
        this.rowHeight = this.getFontMetrics(this.getFont()).getHeight();
        this.repaint();
    }

    protected abstract void refreshSize();

    public int row2Y(int r) {
        return r * this.rowSize();
    }

    public int column2X(int c) {
        return c * this.columnSize();
    }

    public int rowSize() {
        return this.rowHeight;
    }

    public int columnSize() {
        return this.columnWidth;
    }

    public int Y2Row(int Y) {
        return Math.round(Y / this.rowSize());
    }

    public int X2Column(int X) {
        return Math.round(X / this.columnSize());
    }

    public int maxRows() {
        return this.getHeight() / this.rowSize();
    }

    public int maxColumns() {
        return this.getWidth() / this.columnSize();
    }
}

