/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.ezmenu.variables;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.biolegato.core.main.BLMain;
import org.biolegato.ezmenu.variables.GDEVariable;

public class GDEFileChooser
extends GDEVariable
implements ActionListener {
    private JTextField currentFilenameLabel = new JTextField(20);
    private BLMain window = null;
    private String description;

    public GDEFileChooser(Map data) {
        super(data);
        if (data.containsKey("description")) {
            this.description = data.get("description").toString() + ":";
        }
        if (data.containsKey("window") && data.get("window") instanceof BLMain) {
            this.window = (BLMain)data.get("window");
        }
    }

    public Object getValue() {
        return this.currentFilenameLabel.getText();
    }

    public static String getType() {
        return "file_chooser";
    }

    public Container display() {
        JButton pickFile = new JButton("Choose file...");
        pickFile.addActionListener(this);
        Box databox = new Box(2);
        databox.add(new JLabel(this.description));
        databox.add(this.currentFilenameLabel);
        databox.add(pickFile);
        return databox;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser openDialog = new JFileChooser();
        openDialog.setCurrentDirectory(new File(System.getProperty("user.dir")));
        openDialog.setAcceptAllFileFilterUsed(true);
        if (openDialog.showOpenDialog((Component)this.window) == 0 && openDialog.getSelectedFile() != null && openDialog.getSelectedFile().exists() && openDialog.getSelectedFile().isFile()) {
            this.currentFilenameLabel.setText(openDialog.getSelectedFile().getPath());
        }
    }
}

