/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.ezmenu.variables;

import java.awt.Container;
import java.util.Map;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugins.PluginLoader;
import org.biolegato.core.plugins.PluginWrapper;
import org.biolegato.core.plugintypes.MenuType;
import org.biolegato.ezmenu.variables.GDEChoiceList;
import org.biolegato.ezmenu.variables.GDEChooser;
import org.biolegato.ezmenu.variables.GDEComboBox;
import org.biolegato.ezmenu.variables.GDEFileChooser;
import org.biolegato.ezmenu.variables.GDESlider;
import org.biolegato.ezmenu.variables.GDETextField;

public abstract class GDEVariable {
    private String name;

    public GDEVariable(Map data) {
        if (data.containsKey("name")) {
            this.name = data.get("name").toString().trim();
        } else {
            BLMain.error((String)"Field is missing a variable name", (String)"BLVariable constructor");
            this.name = "";
        }
    }

    public String getName() {
        return this.name;
    }

    public abstract Object getValue();

    public static String getType() {
        return "none";
    }

    public Container display() {
        return null;
    }

    public static final GDEVariable createVariable(Map data) {
        String type = null;
        GDEVariable result = null;
        if (data.containsKey("type")) {
            type = data.get("type").toString().trim();
            if ("slider".equalsIgnoreCase(type)) {
                result = new GDESlider(data);
            } else if ("choice_menu".equalsIgnoreCase(type)) {
                result = new GDEComboBox(data);
            } else if ("choice_list".equalsIgnoreCase(type)) {
                BLMain.warning((String)"Using deprecated menu widget \"choice_list\"");
                result = new GDEChoiceList(data);
            } else if ("chooser".equalsIgnoreCase(type)) {
                result = new GDEChooser(data);
            } else if ("text".equalsIgnoreCase(type)) {
                result = new GDETextField(data);
            } else if ("file_chooser".equalsIgnoreCase(type)) {
                result = new GDEFileChooser(data);
            } else if (type != null) {
                for (PluginWrapper plugin : PluginLoader.getPlugins(GDEVariable.class)) {
                    if (!type.equalsIgnoreCase("" + plugin.smethod("getType"))) continue;
                    result = (GDEVariable)plugin.create(new Class[]{Map.class}, new Object[]{data});
                }
            }
        }
        if (result == null) {
            BLMain.error((String)("Invalid variable type: " + type + " (check your plugin directory, properties file, and menu files for possible errors)"), (String)(MenuType.class.getCanonicalName() + ".createVariable"));
            result = new GDEVariable(data){

                public Object getValue() {
                    return "";
                }
            };
        }
        return result;
    }
}

