/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.biolegato.core.data.seqdoc.SeqDoc;
import org.biolegato.core.data.seqdoc.SeqDocListener;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.Editable;
import org.biolegato.gdesupport.canvas.UndoRedoable;
import org.biolegato.gdesupport.canvas.colour.ColourMap;
import org.biolegato.gdesupport.canvas.colour.MonochromeColourMap;
import org.biolegato.gdesupport.canvas.listeners.CursorListener;
import org.biolegato.gdesupport.canvas.listeners.ModeListener;
import org.biolegato.gdesupport.canvas.selections.LineSelection;
import org.biolegato.gdesupport.canvas.selections.Selection;
import org.biolegato.gdesupport.canvas.selections.SelectionListener;
import org.biolegato.gdesupport.canvas.selections.TextLines;
import org.biolegato.gdesupport.canvas.selections.TextRectangle;

public class BLTextArea
extends JComponent
implements FocusListener,
SelectionListener,
Editable,
UndoRedoable,
SeqDocListener,
KeyListener,
MouseMotionListener,
MouseListener {
    protected BLMain instance = null;
    protected boolean insertMode = false;
    protected boolean selectionMove = false;
    protected boolean selectionMouse = false;
    protected boolean selectionBox = false;
    protected int rowHeight = 1;
    protected int columnWidth = 1;
    protected int row = 0;
    protected int column = 0;
    protected Selection selection = new TextLines();
    protected ColourMap greyedOutMap = new MonochromeColourMap(Color.BLACK, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.WHITE);
    protected ColourMap normalMap;
    protected ColourMap colourMap = this.normalMap = new MonochromeColourMap(Color.BLACK, Color.WHITE, Color.WHITE, Color.BLUE);
    protected JPopupMenu popup = new JPopupMenu();
    protected LinkedList<CursorListener> cursorListeners = new LinkedList();
    protected LinkedList<ModeListener> modeListeners = new LinkedList();
    protected final Color invalidzone = Color.RED;
    public final BLTextArea blTextAreaSelf = this;
    public static final long serialVersionUID = 7526472295622777004L;

    public BLTextArea(BLMain instance) {
        this.instance = instance;
        instance.getSeqDoc().addListener((SeqDocListener)this);
        this.selection.addListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Cut"){
            private static final long serialVersionUID = 7526472295622777029L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.cut();
            }
        }));
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Copy"){
            private static final long serialVersionUID = 7526472295622777030L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.copy();
            }
        }));
        this.addPopupMenuItem(new JMenuItem(new AbstractAction("Paste"){
            private static final long serialVersionUID = 7526472295622777031L;

            public void actionPerformed(ActionEvent e) {
                BLTextArea.this.blTextAreaSelf.paste();
            }
        }));
        this.setFont(BLMain.DEFAULT_FONT);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setFocusTraversalKeysEnabled(false);
        this.refreshSize();
        this.setDoubleBuffered(true);
        this.repaint();
    }

    public void addCursorListener(CursorListener listener) {
        this.cursorListeners.add(listener);
    }

    public void addModeListener(ModeListener listener) {
        this.modeListeners.add(listener);
    }

    public void changePosition(int newColumn, int newRow) {
        int oldRow = this.row;
        int oldColumn = this.column;
        newRow = Math.max(0, Math.min(newRow, this.instance.getSeqDoc().getLineCount() - 1));
        newColumn = Math.max(0, Math.min(newColumn, this.instance.getSeqDoc().getLineLength(newRow)));
        this.row = newRow;
        this.column = newColumn;
        this.repaint(this.column2X(oldColumn), this.row2Y(oldRow), this.column2X(oldColumn), this.row2Y(oldRow + 1));
        this.repaint(this.column2X(this.column), this.row2Y(this.row), this.column2X(this.column), this.row2Y(this.row + 1));
        for (CursorListener listener : this.cursorListeners) {
            listener.cursorChange(this, this.column, this.row);
        }
    }

    public SeqDoc getSeqDoc() {
        return this.instance.getSeqDoc();
    }

    public void setColourMap(ColourMap c) {
        this.normalMap = this.colourMap = c;
        c.setBackground(this.getBackground());
        this.repaint();
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.normalMap.setBackground(c);
    }

    public Sequence[] getData() {
        return this.selection.getSelectionSequences(this.instance.getSeqDoc());
    }

    public void paintComponent(Graphics gfx) {
        Rectangle area = gfx.getClipBounds();
        this.paint(gfx, area.x, area.y, area.width, area.height);
    }

    public void paint(Graphics gfx, int x, int y, int width, int height) {
        int startrow = this.Y2Row(y);
        int endrow = Math.min(this.instance.getSeqDoc().getLineCount(), startrow + this.Y2Row(height) + 1);
        int startcol = this.X2Column(x);
        int endcol = startcol + this.X2Column(width);
        int xstart = this.column2X(startcol);
        int ystart = this.row2Y(startrow);
        if (gfx != null) {
            gfx.setColor(this.getBackground());
            gfx.fillRect(xstart, ystart, width, height);
            for (int count = startrow; count < endrow; ++count) {
                Sequence currentLine = this.instance.getSeqDoc().getSequence(count);
                LineSelection intersect = this.selection.intersect(count, currentLine.getField("sequence").toString().length());
                currentLine = currentLine.subseq(startcol, endcol);
                if (intersect != null) {
                    intersect = new LineSelection(intersect.getStart() - startcol, intersect.getEnd() - startcol);
                }
                this.colourMap.drawString(this, gfx, xstart, this.row2Y(count), currentLine, intersect);
            }
            if (this.hasFocus() && this.column2X(this.column) >= x && this.column2X(this.column) <= x + width && this.row2Y(this.row) >= y && this.row2Y(this.row + 1) <= y + height) {
                gfx.setColor(this.getForeground());
                gfx.drawLine(this.column2X(this.column), this.row2Y(this.row), this.column2X(this.column), this.row2Y(this.row + 1));
            }
        }
    }

    public void keyTyped(KeyEvent event) {
        boolean canInsert = true;
        try {
            switch (event.getKeyChar()) {
                case '\b': 
                case '\u007f': {
                    break;
                }
                case '\n': {
                    if (this.row + 1 < this.instance.getSeqDoc().getLineCount()) {
                        this.changePosition(Math.min(this.instance.getSeqDoc().getLineLength(this.row + 1), this.column), this.row + 1);
                        this.selection.reset();
                    }
                    break;
                }
                default: {
                    if (!this.selection.isEmpty()) {
                        this.deleteSelection();
                    } else if (this.insertMode && this.instance.getSeqDoc().getLength() > 0) {
                        canInsert = this.delete(this.getDocPosition(), 1);
                    }
                    if (canInsert && this.insert(event.getKeyChar())) {
                        this.changePosition(this.column + 1, this.row);
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(KeyEvent event) {
        int backspacecol = 0;
        boolean moved = false;
        try {
            switch (event.getKeyChar()) {
                case '\b': {
                    if (!this.selection.isEmpty()) {
                        this.deleteSelection();
                        break;
                    }
                    if (this.row > 0 || this.column > 0) {
                        if (this.column <= 0 && this.row > 0) {
                            backspacecol = this.instance.getSeqDoc().getLineLength(this.row - 1);
                        }
                        if (this.delete(this.getDocPosition() - 1, 1)) {
                            if (this.column <= 0 && this.row > 0) {
                                this.changePosition(backspacecol, this.row - 1);
                                break;
                            }
                            this.changePosition(this.column - 1, this.row);
                        }
                    }
                    break;
                }
                case '\u007f': {
                    if (!this.selection.isEmpty()) {
                        this.deleteSelection();
                        break;
                    }
                    if (this.instance.getSeqDoc().getLength() > 0) {
                        this.delete(this.getDocPosition(), 1);
                    }
                    break;
                }
                case '\uffff': {
                    switch (event.getKeyCode()) {
                        case 16: {
                            if (this.selection.isEmpty()) {
                                this.selection.move(this.column, this.row);
                                this.selection.stretch(this.column, this.row);
                            }
                            this.selectionMove = true;
                            break;
                        }
                        case 17: {
                            this.selectionBox = true;
                            break;
                        }
                        case 37: {
                            if (this.column > 0) {
                                this.changePosition(this.column - 1, this.row);
                                moved = true;
                                break;
                            }
                            if (this.row <= 0) break;
                            this.changePosition(this.instance.getSeqDoc().getLineLength(this.row), this.row - 1);
                            moved = true;
                            break;
                        }
                        case 39: {
                            if (this.column + 1 <= this.instance.getSeqDoc().getLineLength(this.row)) {
                                this.changePosition(this.column + 1, this.row);
                                moved = true;
                                break;
                            }
                            if (this.row + 1 >= this.instance.getSeqDoc().getLineCount()) break;
                            this.changePosition(0, this.row + 1);
                            moved = true;
                            break;
                        }
                        case 38: {
                            if (this.row <= 0) break;
                            this.changePosition(Math.min(this.instance.getSeqDoc().getLineLength(this.row - 1), this.column), this.row - 1);
                            moved = true;
                            break;
                        }
                        case 40: {
                            if (this.row + 1 >= this.instance.getSeqDoc().getLineCount()) break;
                            this.changePosition(Math.min(this.instance.getSeqDoc().getLineLength(this.row + 1), this.column), this.row + 1);
                            moved = true;
                            break;
                        }
                        case 36: {
                            this.changePosition(0, this.row);
                            moved = true;
                            break;
                        }
                        case 35: {
                            this.changePosition(this.instance.getSeqDoc().getLineLength(this.row), this.row);
                            moved = true;
                            break;
                        }
                        case 65485: {
                            this.copy();
                            break;
                        }
                        case 65489: {
                            this.cut();
                            break;
                        }
                        case 65487: {
                            this.paste();
                            break;
                        }
                        case 155: {
                            this.insertMode = !this.insertMode;
                            for (ModeListener listener : this.modeListeners) {
                                listener.insertionMode(this.insertMode);
                            }
                            break;
                        }
                        default: {
                            if (!"true".equalsIgnoreCase(this.instance.getProperty("debug"))) break;
                            BLMain.warning((String)("Unhandled key pressed --- getKeyChar() = " + event.getKeyChar() + "\tgetKeyCode() = " + event.getKeyCode()), (String)"BLTextArea");
                        }
                    }
                    if (this.column >= this.instance.getSeqDoc().getLineLength(this.row)) {
                        this.changePosition(this.instance.getSeqDoc().getLineLength(this.row), this.row);
                    }
                    if (moved) {
                        if (this.selectionMove) {
                            if (this.selectionBox) {
                                this.selectRectangle();
                            } else {
                                this.selectNormal();
                            }
                            this.selection.stretch(this.column, this.row);
                        } else if (!this.selection.isEmpty()) {
                            this.selection.reset();
                        }
                        moved = false;
                    }
                    break;
                }
                default: {
                    this.deleteSelection();
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void keyReleased(KeyEvent event) {
        try {
            block1 : switch (event.getKeyChar()) {
                case '\uffff': {
                    switch (event.getKeyCode()) {
                        case 16: {
                            this.selectionMove = false;
                            break block1;
                        }
                        case 17: {
                            this.selectionBox = false;
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (!event.isPopupTrigger()) {
            this.changePosition(this.X2Column(event.getX()), this.Y2Row(event.getY()));
            if (!this.selectionMove) {
                this.selection.reset();
            } else {
                this.selection.stretch(this.column, this.row);
            }
            this.requestFocus();
            this.requestFocusInWindow();
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.popup.show(this, event.getX(), event.getY());
        } else if (!this.selectionMove) {
            this.selection.reset();
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.selectionMouse = false;
        if (event.isPopupTrigger()) {
            this.popup.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
        this.changePosition(this.X2Column(event.getX()), this.Y2Row(event.getY()));
        if (this.selectionBox && !(this.selection instanceof TextRectangle)) {
            this.selectRectangle();
        } else if (!this.selectionBox && this.selection instanceof TextRectangle) {
            this.selectNormal();
        }
        if (!this.selectionMouse) {
            this.selection.move(this.column, this.row);
            this.selectionMouse = true;
        } else {
            this.selection.stretch(this.column, this.row);
        }
        this.requestFocus();
        this.requestFocusInWindow();
    }

    public void mouseMoved(MouseEvent event) {
    }

    public int row2Y(int r) {
        return r * this.rowSize();
    }

    public int column2X(int c) {
        return c * this.columnSize();
    }

    public int rowSize() {
        return this.rowHeight;
    }

    public int columnSize() {
        return this.columnWidth;
    }

    public int Y2Row(int Y) {
        return Math.round(Y / this.rowSize());
    }

    public int X2Column(int X) {
        return Math.round(X / this.columnSize());
    }

    public int maxRows() {
        return this.getHeight() / this.rowSize();
    }

    public int maxColumns() {
        return this.getWidth() / this.columnSize();
    }

    public int getDocPosition() {
        this.changePosition(this.column, Math.max(0, Math.min(this.row, this.instance.getSeqDoc().getLineCount() - 1)));
        this.changePosition(Math.max(0, Math.min(this.column, this.instance.getSeqDoc().getLineEndOffset(this.row))), this.row);
        return Math.max(0, Math.min(this.instance.getSeqDoc().getLineEndOffset(this.row), this.instance.getSeqDoc().getLineStartOffset(this.row) + this.column));
    }

    protected boolean deleteSelection() {
        boolean result = false;
        if (!this.selection.isEmpty()) {
            this.changePosition(this.selection.getMinX(), this.selection.getMinY());
            result = this.selection.delete(this);
            this.selection.reset();
        }
        return result;
    }

    public void addPopupMenuItem(JMenuItem act) {
        this.popup.add(act);
    }

    public void removePopupMenuItem(JMenuItem act) {
        this.popup.remove(act);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = 0;
        for (int fontWidth : this.getFontMetrics(this.getFont()).getWidths()) {
            this.columnWidth = Math.max(this.columnWidth, fontWidth);
        }
        this.rowHeight = this.getFontMetrics(this.getFont()).getHeight();
        this.refreshSize();
        this.repaint();
    }

    public void copy() {
        if (!this.selection.isEmpty()) {
            this.instance.setClipboard(this.selection.getSelectionSequences(this.instance.getSeqDoc()));
        }
    }

    public void cut() {
        if (!this.selection.isEmpty()) {
            this.copy();
            this.deleteSelection();
        }
    }

    public void paste() {
        this.deleteSelection();
        this.insert(this.instance.getClipboard());
    }

    public void selectAll() {
        this.selectNormal();
        this.changePosition(0, 0);
        this.selection.move(0, 0);
        this.selection.reset();
        this.changePosition(this.column, this.instance.getSeqDoc().getLineCount() - 1);
        this.changePosition(this.instance.getSeqDoc().getLineLength(this.row), this.row);
        this.selection.stretch(this.column, this.row);
    }

    public boolean undo() {
        return this.instance.getSeqDoc().undo();
    }

    public boolean redo() {
        return this.instance.getSeqDoc().redo();
    }

    protected boolean insert(char character) {
        return this.instance.getSeqDoc().insert(this.row, this.column, "" + character);
    }

    public boolean insert(Sequence[] paste) {
        return this.instance.getSeqDoc().insert(this.getDocPosition(), paste);
    }

    public boolean delete(int offset, int length) {
        return this.instance.getSeqDoc().delete(Math.max(0, offset), length);
    }

    public boolean getInsertMode() {
        return this.insertMode;
    }

    protected void refreshSize() {
        Dimension size = new Dimension((this.instance.getSeqDoc().getLongestLineLength() + 1) * this.columnSize(), this.rowSize() * this.instance.getSeqDoc().getLineCount());
        this.setSize(size);
        this.setPreferredSize(size);
    }

    public void sequenceAdded(SeqDoc source, int index, Sequence sequence) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = (int)this.getSize().getHeight();
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    public void sequenceChanged(SeqDoc source, int index, Sequence sequence, String key) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = this.rowSize();
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    public void sequenceRemoved(SeqDoc source, int index, Sequence sequence) {
        boolean x = false;
        int w = (int)this.getSize().getWidth();
        int y = this.row2Y(index);
        int h = (int)this.getSize().getHeight();
        this.refreshSize();
        this.repaint(0, y, w, h);
    }

    public void selectionMoved(int oldx, int oldy, int newx, int newy) {
        boolean x = false;
        int y = this.row2Y(Math.min(oldy, this.selection.getMinY()) - 1);
        int w = (int)this.getSize().getWidth();
        int h = this.row2Y(Math.max(oldy, this.selection.getMaxY()) + 1);
        this.repaint(0, Math.max(0, y), w, Math.min((int)this.getSize().getHeight(), h));
    }

    public void selectionStretched(int oldx, int oldy, int newx, int newy) {
        boolean x = false;
        int y = this.row2Y(Math.min(oldy, this.selection.getMinY()) - 1);
        int w = (int)this.getSize().getWidth();
        int h = this.row2Y(Math.max(oldy, this.selection.getMaxY()) + 1);
        this.repaint(0, Math.max(0, y), w, Math.min((int)this.getSize().getHeight(), h));
    }

    public void focusGained(FocusEvent e) {
        this.colourMap = this.normalMap;
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.colourMap = this.greyedOutMap;
        this.setForeground(Color.BLACK);
        this.setBackground(Color.LIGHT_GRAY);
        this.repaint();
    }

    public void selectRectangle() {
        this.selection = new TextRectangle(this.selection);
        this.repaint();
    }

    public void selectNormal() {
        this.selection = new TextLines(this.selection);
        this.repaint();
    }
}

