/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colour;

import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.BLTextArea;
import org.biolegato.gdesupport.canvas.colour.ColourMap;
import org.biolegato.gdesupport.canvas.colour.MonochromeColourMap;

public class GDECharColourMap
extends MonochromeColourMap {
    public void regularDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq) {
        char[] stringArray = seq.getField("sequence").toString().toCharArray();
        Color fgCurrent = this.foreground;
        if (seq.getField("mask") instanceof ColourMap) {
            ((ColourMap)seq.getField("mask")).regularDrawString(ta, gfx, xstart, ystart, seq);
        } else {
            for (char character : stringArray) {
                if (Sequence.Type.DNA.equals(seq.getField("type")) || Sequence.Type.RNA.equals(seq.getField("type"))) {
                    switch (character) {
                        case 'A': 
                        case 'a': {
                            fgCurrent = colour1;
                            break;
                        }
                        case 'B': 
                        case 'D': 
                        case 'H': 
                        case 'I': 
                        case 'K': 
                        case 'M': 
                        case 'N': 
                        case 'R': 
                        case 'S': 
                        case 'V': 
                        case 'W': 
                        case 'Y': 
                        case 'b': 
                        case 'd': 
                        case 'h': 
                        case 'i': 
                        case 'k': 
                        case 'm': 
                        case 'n': 
                        case 'r': 
                        case 's': 
                        case 'v': 
                        case 'w': 
                        case 'y': {
                            fgCurrent = colour2;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            fgCurrent = colour3;
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            fgCurrent = colour4;
                            break;
                        }
                        case 'T': 
                        case 'U': 
                        case 't': 
                        case 'u': {
                            fgCurrent = colour5;
                            break;
                        }
                        case 'X': {
                            character = 'N';
                            fgCurrent = colour2;
                            break;
                        }
                        case 'x': {
                            character = 'n';
                            fgCurrent = colour2;
                            break;
                        }
                        default: {
                            character = '-';
                            fgCurrent = neutralColour;
                            break;
                        }
                    }
                } else if (Sequence.Type.PROTEIN.equals(seq.getField("type"))) {
                    switch (character) {
                        case 'A': 
                        case 'G': 
                        case 'O': 
                        case 'P': 
                        case 'S': 
                        case 'T': 
                        case 'a': 
                        case 'g': 
                        case 'o': 
                        case 'p': 
                        case 's': 
                        case 't': {
                            fgCurrent = colour6;
                            break;
                        }
                        case 'B': 
                        case 'D': 
                        case 'E': 
                        case 'N': 
                        case 'Q': 
                        case 'Z': 
                        case 'b': 
                        case 'd': 
                        case 'e': 
                        case 'n': 
                        case 'q': 
                        case 'z': {
                            fgCurrent = colour4;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            fgCurrent = colour1;
                            break;
                        }
                        case 'F': 
                        case 'W': 
                        case 'Y': 
                        case 'f': 
                        case 'w': 
                        case 'y': {
                            fgCurrent = colour3;
                            break;
                        }
                        case 'H': 
                        case 'K': 
                        case 'R': 
                        case 'h': 
                        case 'k': 
                        case 'r': {
                            fgCurrent = colour7;
                            break;
                        }
                        case 'I': 
                        case 'J': 
                        case 'L': 
                        case 'M': 
                        case 'V': 
                        case 'i': 
                        case 'j': 
                        case 'l': 
                        case 'm': 
                        case 'v': {
                            fgCurrent = colour5;
                            break;
                        }
                        case '*': 
                        case 'X': 
                        case 'x': {
                            fgCurrent = colour2;
                            break;
                        }
                        default: {
                            fgCurrent = neutralColour;
                            break;
                        }
                    }
                } else {
                    fgCurrent = this.foreground;
                }
                this.drawString(ta, gfx, xstart, ystart, "" + character, fgCurrent, this.background);
                xstart += ta.columnSize();
            }
        }
    }
}

