/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ResultTree
extends JTree
implements Serializable {
    public static final long serialVersionUID = 100010201070001L;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode analysisNode;
    Vector dumpVector;

    public ResultTree() {
        this.setCellRenderer(new ResultTreeNodeRenderer());
    }

    public ResultTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        super(defaultMutableTreeNode);
        this.root = defaultMutableTreeNode;
        this.setCellRenderer(new ResultTreeNodeRenderer());
        this.dumpVector = new Vector();
    }

    public DefaultMutableTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.root = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getAnalysisNode() {
        return this.analysisNode;
    }

    public void setAnalysisNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.analysisNode = defaultMutableTreeNode;
    }

    public void insertNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, int n) {
        if (defaultMutableTreeNode == null || defaultMutableTreeNode2 == null) {
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n);
    }

    public void removeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    public DefaultMutableTreeNode getNode(Object object) {
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() != object) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    public DefaultMutableTreeNode getNode(String[] stringArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.root;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                if (!defaultMutableTreeNode.getChildAt(j).toString().equals(stringArray[i])) continue;
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
            }
        }
        if (defaultMutableTreeNode.toString().equals(stringArray[stringArray.length - 1])) {
            return defaultMutableTreeNode;
        }
        return null;
    }

    public void writeResults(ObjectOutputStream objectOutputStream) throws IOException {
        DefaultTreeModel defaultTreeModel;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.analysisNode.getLastChild();
        boolean bl = false;
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getChildCount() == 0 && defaultMutableTreeNode.getUserObject() instanceof String) {
            defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            bl = true;
        }
        this.writeTree(objectOutputStream, this.analysisNode, 0);
        objectOutputStream.writeInt(-1);
        if (bl) {
            defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.analysisNode, this.analysisNode.getChildCount());
        }
    }

    public void writeHistory(ObjectOutputStream objectOutputStream, DefaultMutableTreeNode defaultMutableTreeNode) throws IOException {
        this.writeTree(objectOutputStream, defaultMutableTreeNode, 0);
        objectOutputStream.writeInt(-1);
    }

    private void writeTree(ObjectOutputStream objectOutputStream, DefaultMutableTreeNode defaultMutableTreeNode, int n) throws IOException {
        int n2 = defaultMutableTreeNode.getChildCount();
        objectOutputStream.writeInt(n);
        Object object = defaultMutableTreeNode.getUserObject();
        objectOutputStream.writeObject(object);
        for (int i = 0; i < n2; ++i) {
            this.writeTree(objectOutputStream, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), n + 1);
        }
    }

    public DefaultMutableTreeNode loadResults(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2) {
            Object object;
            n = objectInputStream.readInt();
            if (n == 0) {
                object = objectInputStream.readObject();
                defaultMutableTreeNode2 = defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode3 = defaultMutableTreeNode;
                n2 = n;
                continue;
            }
            if (n == -1) {
                bl2 = true;
                continue;
            }
            n3 = n - n2;
            n2 = n;
            if (n3 > 0) {
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
            } else if (n3 < 0) {
                for (int i = 0; i > n3; --i) {
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                }
            }
            object = objectInputStream.readObject();
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(object);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
        return defaultMutableTreeNode;
    }

    public Hashtable getResultHash() {
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
        boolean bl = false;
        int n = this.analysisNode.getChildCount();
        String string = "";
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.analysisNode.getChildAt(i);
            Object object = defaultMutableTreeNode.getUserObject();
            if (object == null) continue;
            if (object instanceof LeafInfo) {
                string = ((LeafInfo)object).toString();
            } else if (object instanceof String) {
                string = (String)object;
            }
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            while (!bl && enumeration.hasMoreElements()) {
                IViewer iViewer;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!(defaultMutableTreeNode2.getUserObject() instanceof LeafInfo) || (iViewer = ((LeafInfo)defaultMutableTreeNode2.getUserObject()).getViewer()) == null) continue;
                Experiment experiment = iViewer.getExperiment();
                int[][] nArray = iViewer.getClusters();
                if (experiment == null || nArray == null) continue;
                Object[] objectArray = new Object[]{experiment, nArray};
                hashtable.put(string, objectArray);
                bl = true;
            }
            bl = false;
        }
        return hashtable;
    }

    public Vector findViewerCollection(int[] nArray, boolean bl) {
        Vector<Cloneable> vector = new Vector<Cloneable>();
        Vector<DefaultMutableTreeNode> vector2 = new Vector<DefaultMutableTreeNode>();
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Vector vector3 = new Vector();
        int n = this.analysisNode.getChildCount();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.analysisNode.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getSearchResults(nArray, defaultMutableTreeNode, hashtable, hashtable2, bl);
            if (defaultMutableTreeNode2 == null) continue;
            vector2.addElement(defaultMutableTreeNode2);
        }
        vector.add(vector2);
        vector.add(hashtable);
        vector.add(hashtable2);
        if (hashtable.size() == 0 && hashtable.size() == 0) {
            return null;
        }
        return vector;
    }

    private DefaultMutableTreeNode getSearchResults(int[] nArray, DefaultMutableTreeNode defaultMutableTreeNode, Hashtable hashtable, Hashtable hashtable2, boolean bl) {
        boolean bl2 = false;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Vector<DefaultMutableTreeNode> vector2 = new Vector<DefaultMutableTreeNode>();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(defaultMutableTreeNode.getUserObject());
        while (enumeration.hasMoreElements()) {
            Experiment experiment;
            int[][] nArray2;
            int n;
            Object object;
            LeafInfo leafInfo;
            IViewer iViewer;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object2 = defaultMutableTreeNode3.getUserObject();
            if (!(object2 instanceof LeafInfo) || (iViewer = (leafInfo = (LeafInfo)object2).getViewer()) == null) continue;
            if (bl) {
                if (iViewer instanceof ExperimentViewer) {
                    object = ((LeafInfo)object2).getUserObject();
                    if (object == null || !(object instanceof Integer)) continue;
                    n = (Integer)object;
                    nArray2 = iViewer.getClusters();
                    experiment = iViewer.getExperiment();
                    if (nArray2 == null || experiment == null || !this.containsGeneIndices(nArray, nArray2[n], experiment)) continue;
                    bl2 = true;
                    vector.addElement(defaultMutableTreeNode3);
                    continue;
                }
                if (!(iViewer instanceof ClusterTableViewer) || (object = ((LeafInfo)object2).getUserObject()) == null || !(object instanceof Integer)) continue;
                n = (Integer)object;
                nArray2 = iViewer.getClusters();
                experiment = iViewer.getExperiment();
                if (nArray2 == null || experiment == null || !this.containsGeneIndices(nArray, nArray2[n], experiment)) continue;
                bl2 = true;
                vector2.addElement(defaultMutableTreeNode3);
                continue;
            }
            if (iViewer instanceof ExperimentClusterViewer) {
                object = ((LeafInfo)object2).getUserObject();
                if (object == null || !(object instanceof Integer)) continue;
                n = (Integer)object;
                nArray2 = iViewer.getClusters();
                experiment = iViewer.getExperiment();
                if (nArray2 == null || experiment == null || !this.containsExperimentIndices(nArray, nArray2[n], experiment)) continue;
                bl2 = true;
                vector.addElement(defaultMutableTreeNode3);
                continue;
            }
            if (!(iViewer instanceof ExperimentClusterTableViewer) || (object = ((LeafInfo)object2).getUserObject()) == null || !(object instanceof Integer)) continue;
            n = (Integer)object;
            nArray2 = iViewer.getClusters();
            experiment = iViewer.getExperiment();
            if (nArray2 == null || experiment == null || !this.containsExperimentIndices(nArray, nArray2[n], experiment)) continue;
            bl2 = true;
            vector2.addElement(defaultMutableTreeNode3);
        }
        if (bl2) {
            hashtable.put(defaultMutableTreeNode2, vector);
            hashtable2.put(defaultMutableTreeNode2, vector2);
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private boolean containsGeneIndices(int[] nArray, int[] nArray2, Experiment experiment) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != experiment.getGeneIndexMappedToData(nArray2[j])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsExperimentIndices(int[] nArray, int[] nArray2, Experiment experiment) {
        int[] nArray3 = experiment.getColumnIndicesCopy();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray3[nArray2[j]]) continue;
                return true;
            }
        }
        return false;
    }

    public void clearDataSelection() {
        Enumeration<TreeNode> enumeration = this.root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() == null || !(defaultMutableTreeNode.getUserObject() instanceof LeafInfo)) continue;
            ((LeafInfo)defaultMutableTreeNode.getUserObject()).setSelectedDataSource(false);
        }
    }

    public class ResultTreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private Icon defaultLeafIcon;
        private Icon primaryResultIcon = GUIFactory.getIcon((String)"PrimaryResult.gif");
        private Icon expressionImageIcon = GUIFactory.getIcon((String)"ExpressionImageResult.gif");
        private Icon centroidGraphIcon = GUIFactory.getIcon((String)"CentroidResult.gif");
        private Icon expressionGraphIcon = GUIFactory.getIcon((String)"ExpressionGraphResult.gif");
        private Icon hclIcon = GUIFactory.getIcon((String)"HCLResult.gif");
        private Icon nodeHeightIcon = GUIFactory.getIcon((String)"NodeHeightResult.gif");
        private Icon samGraphIcon = GUIFactory.getIcon((String)"SAMGraphResult.gif");
        private Icon volcanoIcon = GUIFactory.getIcon((String)"VolcanoPlotResult.gif");
        private Icon networkIcon = GUIFactory.getIcon((String)"NetworkResult.gif");
        private Icon SOMColorIcon = GUIFactory.getIcon((String)"SOMColorResult.gif");
        private Icon SOMBWIcon = GUIFactory.getIcon((String)"SOMBWResult.gif");
        private Icon gdmMatrixIcon = GUIFactory.getIcon((String)"GDMMatrixResult.gif");
        private Icon clusterInfoIcon = GUIFactory.getIcon((String)"ClusterInformationResult.gif");
        private Icon generalInfoIcon = GUIFactory.getIcon((String)"Information16.gif");
        private Icon tableIcon = GUIFactory.getIcon((String)"TableViewerResult.gif");
        private Icon pca3DIcon = GUIFactory.getIcon((String)"PCA3DResult.gif");
        private Icon trn3DIcon = GUIFactory.getIcon((String)"TerrainResult.gif");
        private Icon mevIcon = GUIFactory.getIcon((String)"mev_mini_splash.gif");
        private Icon mainViewIcon = GUIFactory.getIcon((String)"MainView.gif");
        private Icon analysisIcon = GUIFactory.getIcon((String)"Analysis.gif");
        private Icon clusterManagerIcon = GUIFactory.getIcon((String)"ClusterManager.gif");
        private Icon historyIcon = GUIFactory.getIcon((String)"History.gif");
        private Icon dotTerminalIcon = GUIFactory.getIcon((String)"TerminalDot.gif");
        private Icon scriptManagerIcon = GUIFactory.getIcon((String)"ScriptManager.gif");
        private Icon scriptIcon = GUIFactory.getIcon((String)"ScriptIcon.gif");
        private Icon scriptTreeViewerIcon = GUIFactory.getIcon((String)"ScriptTreeViewer.gif");
        private Icon scriptXMLViewerIcon = GUIFactory.getIcon((String)"ScriptXMLViewer.gif");
        private Icon searchIcon = GUIFactory.getIcon((String)"search_16.gif");
        private Icon goHierarchyViewerIcon = GUIFactory.getIcon((String)"go_hierarchy_viewer.gif");
        private Icon dataSelectionIcon = GUIFactory.getIcon((String)"data_selection_icon.gif");
        private Icon dataFilterIcon = GUIFactory.getIcon((String)"DataFilterResult.gif");
        private DefaultMutableTreeNode parent;
        private DefaultMutableTreeNode grandParent;
        private JLabel label;

        public ResultTreeNodeRenderer() {
            this.setIcon(this.closedIcon);
            super.setOpaque(false);
            this.setIconTextGap(2);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.selected = bl;
            String string = "";
            String string2 = "";
            String string3 = "";
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            if (!bl3) {
                if (object2 instanceof String) {
                    string = (String)object2;
                    this.setText(string);
                } else if (object2 instanceof LeafInfo) {
                    string = ((LeafInfo)object2).toString();
                    this.setText(string);
                    if (((LeafInfo)object2).isSelectedDataSource()) {
                        this.setBorder(BorderFactory.createLineBorder(Color.green, 2));
                    }
                }
                if (bl2) {
                    this.setIcon(this.openIcon);
                } else {
                    this.setIcon(this.closedIcon);
                }
                if (string.indexOf("Expression Image") != -1) {
                    this.setIcon(this.expressionImageIcon);
                } else if (string.indexOf("Centroid") != -1) {
                    this.setIcon(this.centroidGraphIcon);
                } else if (string.indexOf("Expression Graph") != -1) {
                    this.setIcon(this.expressionGraphIcon);
                } else if (string.equals("Analysis Results")) {
                    this.setIcon(this.analysisIcon);
                } else if (string.equals("Cluster Manager")) {
                    this.setIcon(this.clusterManagerIcon);
                } else if (string.equals("Script Manager")) {
                    this.setIcon(this.scriptManagerIcon);
                } else if (string.equals("History")) {
                    this.setIcon(this.historyIcon);
                } else if (string.equals("General Information")) {
                    this.setIcon(this.generalInfoIcon);
                } else if (string.indexOf(40) != -1 && ((DefaultMutableTreeNode)object).getParent() == ResultTree.this.root.getChildAt(2)) {
                    this.setIcon(this.primaryResultIcon);
                } else if (string.indexOf("F-Ratio") != -1 || string.indexOf("Statistic") != -1 || string.indexOf("Table") != -1) {
                    this.setIcon(this.tableIcon);
                } else if (string.equals("Cluster Information")) {
                    this.setIcon(this.clusterInfoIcon);
                } else if (string.equals("MultipleExperimentViewer")) {
                    this.setText("");
                    this.setBorder(new EmptyBorder(3, 2, 3, 0));
                    this.setIcon(this.mevIcon);
                } else if (string.equals("Hierarchical Trees")) {
                    this.setIcon(this.hclIcon);
                } else if (string.equals("SOM Visualization")) {
                    this.setIcon(this.SOMColorIcon);
                } else if (string.indexOf("Network") != -1) {
                    this.setIcon(this.networkIcon);
                } else if (string.indexOf("Script (") != -1) {
                    this.setIcon(this.scriptIcon);
                } else if (string.equals("Search Result Shortcuts")) {
                    this.setIcon(this.searchIcon);
                } else if (string.indexOf("Data Filter") != -1) {
                    this.setIcon(this.dataFilterIcon);
                }
            } else {
                this.setIcon(this.leafIcon);
                if (object2 instanceof String) {
                    string = (String)object2;
                    this.setText(string);
                    this.setIcon(this.dotTerminalIcon);
                } else if (object2 instanceof LeafInfo) {
                    string = ((LeafInfo)object2).toString();
                    this.setText(string);
                    if (((LeafInfo)object2).isSelectedDataSource()) {
                        this.setBorder(BorderFactory.createLineBorder(Color.green, 2));
                    }
                    this.parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getParent();
                    if (this.parent.getUserObject() instanceof String) {
                        string2 = (String)this.parent.getUserObject();
                    } else if (this.parent.getUserObject() instanceof LeafInfo) {
                        string2 = ((LeafInfo)this.parent.getUserObject()).toString();
                    }
                    this.grandParent = (DefaultMutableTreeNode)this.parent.getParent();
                    if (this.grandParent != null) {
                        if (this.grandParent.getUserObject() instanceof String) {
                            string3 = (String)this.grandParent.getUserObject();
                        } else if (this.grandParent.getUserObject() instanceof LeafInfo) {
                            string3 = ((LeafInfo)this.grandParent.getUserObject()).toString();
                        }
                    } else {
                        string3 = null;
                    }
                    if (string2.indexOf("Expression Image") != -1) {
                        this.setIcon(this.expressionImageIcon);
                    } else if (string2.indexOf("Centroid") != -1) {
                        this.setIcon(this.centroidGraphIcon);
                    } else if (string2.indexOf("Expression Graph") != -1) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (string2.indexOf("Cluster Manager") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (string2.indexOf("F-Ratio") != -1 || string2.indexOf("Statistic") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (string2.equals("Cluster Information") || string.equals("Classification Information")) {
                        this.setIcon(this.clusterInfoIcon);
                    } else if (string.equals("MultipleExperimentViewer")) {
                        this.setIcon(this.openIcon);
                    } else if (string.equals("Main View")) {
                        this.setIcon(this.mainViewIcon);
                    } else if (string.equalsIgnoreCase("Analysis Results")) {
                        this.setIcon(this.analysisIcon);
                    } else if (string.equalsIgnoreCase("Cluster Manager")) {
                        this.setIcon(this.clusterManagerIcon);
                    } else if (string.equals("Script Manager")) {
                        this.setIcon(this.scriptManagerIcon);
                    } else if (string.equalsIgnoreCase("History")) {
                        this.setIcon(this.historyIcon);
                    } else if (string.indexOf("able") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (string2.indexOf("Hierarchical") != -1 || string.indexOf("Dendogram") != -1 || string.indexOf("HCL Tree") != -1 || string.indexOf("Support Tree") != -1) {
                        this.setIcon(this.hclIcon);
                    } else if (string.equals("Expression Image")) {
                        this.setIcon(this.expressionImageIcon);
                    } else if (string.equals("Expression Graph")) {
                        this.setIcon(this.expressionGraphIcon);
                    } else if (string.equals("Centroid Graph")) {
                        this.setIcon(this.centroidGraphIcon);
                    } else if (string2.indexOf("Table") != -1 || string.indexOf("SVM") != -1) {
                        this.setIcon(this.tableIcon);
                    } else if (string.indexOf("Height Plot") != -1 || string.indexOf("SOTA Diversity") != -1 || string.indexOf("Graph - FOM") != -1) {
                        this.setIcon(this.nodeHeightIcon);
                    } else if (string.equals("Volcano Plot")) {
                        this.setIcon(this.volcanoIcon);
                    } else if (string.equals("SAM Graph")) {
                        this.setIcon(this.samGraphIcon);
                    } else if (string.indexOf("Network") != -1) {
                        this.setIcon(this.networkIcon);
                    } else if (string.equals("Matrix View")) {
                        this.setIcon(this.gdmMatrixIcon);
                    } else if (string.equals("U-Matrix Color")) {
                        this.setIcon(this.SOMColorIcon);
                    } else if (string.equals("U-Matrix Distance")) {
                        this.setIcon(this.SOMBWIcon);
                    } else if (string.equals("3D view")) {
                        this.setIcon(this.pca3DIcon);
                    } else if (string.equals("Map") && string2.indexOf("Terrain") != -1) {
                        this.setIcon(this.trn3DIcon);
                    } else if (string.indexOf("Script Tree") != -1) {
                        this.setIcon(this.scriptTreeViewerIcon);
                    } else if (string.equals("Script XML Viewer")) {
                        this.setIcon(this.scriptXMLViewerIcon);
                    } else if (string.indexOf("GO") != -1) {
                        this.setIcon(this.goHierarchyViewerIcon);
                    } else if (string.equals("Data Source Selection")) {
                        this.setIcon(this.dataSelectionIcon);
                    } else if (string3 != null) {
                        if (string3.indexOf("Expression Image") != -1) {
                            this.setIcon(this.expressionImageIcon);
                        } else if (string3.indexOf("Centroid") != -1) {
                            this.setIcon(this.centroidGraphIcon);
                        } else if (string3.indexOf("Expression Graph") != -1) {
                            this.setIcon(this.expressionGraphIcon);
                        }
                    }
                }
            }
            if (bl) {
                this.setOpaque(true);
            } else {
                this.setOpaque(false);
            }
            return this;
        }

        public void paint(Graphics graphics) {
            if (graphics == null) {
                return;
            }
            Color color = this.selected ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor();
            graphics.setColor(color);
            int n = this.getWidth();
            if (this.getIcon() != null) {
                n -= this.getIcon().getIconWidth();
            }
            graphics.fillRect(this.getWidth() - n + 1, 0, n + 1, this.getHeight());
            super.setOpaque(false);
            super.paint(graphics);
        }
    }
}

