/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit.lola;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class LOLADialog
extends AlgorithmDialog {
    private GroupExperimentsPanel gPanel;
    private JButton lola_it;
    private JButton cancel;
    int result = 2;
    String[] sample_names;
    int[] sample_groupings;

    public LOLADialog(String string, String[] stringArray, Cluster cluster) {
        super(new JFrame(), string, true);
        int n;
        this.sample_names = stringArray;
        this.sample_groupings = new int[stringArray.length];
        this.setBounds(0, 0, 800, 500);
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.setLayout(new BorderLayout(1, 2));
        Listener listener = new Listener();
        this.gPanel = new GroupExperimentsPanel(stringArray);
        for (n = 0; n < this.gPanel.groupARadioButtons.length; ++n) {
            this.gPanel.groupARadioButtons[n].addActionListener(new GroupListener(0, n));
        }
        for (n = 0; n < this.gPanel.groupBRadioButtons.length; ++n) {
            this.gPanel.groupBRadioButtons[n].addActionListener(new GroupListener(1, n));
        }
        jPanel.add((Component)this.gPanel, "Center");
        this.addContent(jPanel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    public int[] getGroupAssignments() {
        return this.sample_groupings;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    class GroupExperimentsPanel
    extends JPanel {
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;

        GroupExperimentsPanel(String[] stringArray) {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            JPanel jPanel = new JPanel();
            JLabel[] jLabelArray = new JLabel[stringArray.length];
            this.groupARadioButtons = new JRadioButton[stringArray.length];
            this.groupBRadioButtons = new JRadioButton[stringArray.length];
            this.neitherGroupRadioButtons = new JRadioButton[stringArray.length];
            ButtonGroup[] buttonGroupArray = new ButtonGroup[stringArray.length];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                jLabelArray[i] = new JLabel(string);
                buttonGroupArray[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                buttonGroupArray[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                buttonGroupArray[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither", false);
                buttonGroupArray[i].add(this.neitherGroupRadioButtons[i]);
                this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(jLabelArray[i], gridBagConstraints);
                jPanel.add(jLabelArray[i]);
                this.buildConstraints(gridBagConstraints, 1, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupARadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupARadioButtons[i]);
                this.buildConstraints(gridBagConstraints, 2, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupBRadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupBRadioButtons[i]);
                this.buildConstraints(gridBagConstraints, 3, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.neitherGroupRadioButtons[i], gridBagConstraints);
                jPanel.add(this.neitherGroupRadioButtons[i]);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setPreferredSize(new Dimension(400, 450));
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
        }

        void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            gridBagConstraints.weightx = n5;
            gridBagConstraints.weighty = n6;
        }
    }

    class GroupListener
    implements ActionListener {
        int file_index;
        int group;

        GroupListener(int n, int n2) {
            this.group = n;
            this.file_index = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOLADialog.this.sample_groupings[this.file_index] = this.group;
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                this.onOk();
            } else if (string.equals("cancel-command")) {
                LOLADialog.this.result = 2;
                LOLADialog.this.dispose();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.onOk();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            LOLADialog.this.result = -1;
            LOLADialog.this.dispose();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void onOk() {
            try {
                LOLADialog.this.result = 0;
            }
            catch (Exception exception) {
                LOLADialog.this.result = 2;
            }
            LOLADialog.this.dispose();
        }
    }
}

