/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;

public class SlideLoaderProgressBar
extends JDialog {
    protected static final int BUFFER_SIZE = 131072;
    private int result = 2;
    private ISlideData[] data;
    protected ISlideMetaData meta;
    private File[] files;
    private boolean stop = false;
    private Exception exception;
    private LoadingPanel loadingPanel = new LoadingPanel();
    private boolean fillMissingSpots = false;

    public SlideLoaderProgressBar(JFrame jFrame) {
        super((Frame)jFrame, "Slide Data Loading");
        Listener listener = new Listener();
        JPanel jPanel = this.createBtnsPanel(listener);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)this.loadingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private JPanel createBtnsPanel(ActionListener actionListener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel-command");
        jButton.addActionListener(actionListener);
        jPanel.add((Component)jButton, "East");
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    public void setFilesCount(int n) {
        this.loadingPanel.setFilesCount(n);
    }

    public void setLinesCount(int n) {
        this.loadingPanel.setLinesCount(n);
    }

    public void setFilesProgress(int n) {
        this.loadingPanel.setFilesProgress(n);
    }

    public void setFileProgress(int n) {
        this.loadingPanel.setFileProgress(n);
    }

    public void setFileName(String string) {
        this.loadingPanel.setFileName(string);
    }

    public void setRemain(int n) {
        this.loadingPanel.setRemain(n);
    }

    private class LoadingPanel
    extends JPanel {
        private JProgressBar filesProgress = new JProgressBar();
        private JProgressBar fileProgress = new JProgressBar();
        private JLabel filesLabel = new JLabel("Remain: ");
        private JLabel fileLabel = new JLabel("File: ");

        public LoadingPanel() {
            this.setPreferredSize(new Dimension(350, 120));
            this.setBorder(new BevelBorder(0));
            this.setLayout(new GridBagLayout());
            this.filesProgress.setStringPainted(true);
            this.fileProgress.setStringPainted(true);
            this.add((Component)this.filesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.filesProgress, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.fileProgress, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        public void setFilesCount(int n) {
            this.filesProgress.setMaximum(n);
        }

        public void setLinesCount(int n) {
            this.fileProgress.setMaximum(n);
        }

        public void setFilesProgress(int n) {
            this.filesProgress.setValue(n);
        }

        public void setFileProgress(int n) {
            this.fileProgress.setValue(n);
        }

        public void setFileName(String string) {
            this.fileLabel.setText("File: " + string);
        }

        public void setRemain(int n) {
            this.filesLabel.setText("Remains: " + String.valueOf(n) + " file(s)");
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SlideLoaderProgressBar.this.dispose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            SlideLoaderProgressBar.this.dispose();
        }
    }
}

