/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.file.ExpressionFileFilter;
import org.tigr.util.StringSplitter;

public class TavFileFilter
extends ExpressionFileFilter {
    private static final int BUFFER_SIZE = 131072;

    public boolean accept(File file) {
        String string = "";
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().endsWith(".tav");
    }

    public String getDescription() {
        return "TIGR ArrayViewer Files (*.tav)";
    }

    public Vector loadExpressionFile(File file) throws IOException {
        String string;
        Vector<SlideData> vector = new Vector<SlideData>();
        if (!this.accept(file)) {
            return vector;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 3;
        int n4 = 2;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        float[] fArray = new float[n4];
        String[] stringArray = new String[3];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n5 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n5 < 0) {
                ++n5;
                continue;
            }
            stringSplitter.init(string);
            int n6 = stringSplitter.nextIntToken();
            int n7 = stringSplitter.nextIntToken();
            if (n6 > n) {
                n = n6;
            }
            if (n7 <= n2) continue;
            n2 = n7;
        }
        SlideData slideData = new SlideData(n, n2);
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        n5 = 0;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            int n8;
            if (n5 < 0) {
                ++n5;
                continue;
            }
            stringSplitter.init(string);
            for (n8 = 0; n8 < n3; ++n8) {
                nArray[n8] = stringSplitter.nextIntToken();
                nArray2[n8] = stringSplitter.nextIntToken();
            }
            for (n8 = 0; n8 < n4; ++n8) {
                fArray[n8] = stringSplitter.nextFloatToken(0.0f);
            }
            for (n8 = 0; n8 < stringArray.length; ++n8) {
                if (stringSplitter.hasMoreTokens()) {
                    String string2 = stringSplitter.nextToken();
                    if (string2.equals("null")) {
                        stringArray[n8] = "";
                        continue;
                    }
                    stringArray[n8] = string2;
                    continue;
                }
                stringArray[n8] = "";
            }
            SlideDataElement slideDataElement = new SlideDataElement(nArray, nArray2, fArray, stringArray);
            slideData.addSlideDataElement(slideDataElement);
        }
        bufferedReader.close();
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        vector.add(slideData);
        return vector;
    }
}

