/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ScriptAttributeDialog
extends AlgorithmDialog {
    private int result = 2;
    private JTextField dateField;
    private JTextField nameField;
    private JTextArea descriptionArea;
    private String dateString;

    public ScriptAttributeDialog() {
        super(new JFrame(), "Script Attribute Input", true);
        JLabel jLabel = new JLabel("Creation Date: ");
        Date date = new Date(System.currentTimeMillis());
        TimeZone timeZone = TimeZone.getDefault();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(timeZone);
        this.dateString = dateFormat.format(date);
        jLabel.setHorizontalAlignment(4);
        this.dateField = new JTextField(this.dateString, 20);
        JLabel jLabel2 = new JLabel("Script Name: ");
        jLabel2.setHorizontalAlignment(4);
        this.nameField = new JTextField(20);
        JLabel jLabel3 = new JLabel("Description: ");
        jLabel3.setVerticalAlignment(1);
        jLabel3.setHorizontalAlignment(4);
        this.descriptionArea = new JTextArea(10, 25);
        JScrollPane jScrollPane = new JScrollPane(this.descriptionArea);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.descriptionArea.setWrapStyleWord(true);
        ParameterPanel parameterPanel = new ParameterPanel("Script Attributes");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel.add((Component)jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel.add((Component)jLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)this.dateField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel.add((Component)this.nameField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 10, 0), 0, 0));
        parameterPanel.add((Component)jScrollPane, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add((Component)parameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addContent(jPanel);
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
        this.nameField.requestFocus();
        this.nameField.selectAll();
    }

    public ScriptAttributeDialog(int n, String string, String string2) {
        super(new JFrame(), "Script Attribute Modification", true);
        this.dateField = new JTextField(String.valueOf(n));
        this.dateField.setEditable(false);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.dateField.setText(this.dateString);
        this.nameField.setText("");
        this.descriptionArea.setText("");
        this.nameField.requestFocus();
        this.nameField.selectAll();
    }

    public String getDate() {
        return this.dateField.getText();
    }

    public String getName() {
        return this.nameField.getText();
    }

    public String getFormattedDescription() {
        String string = this.descriptionArea.getText();
        String string2 = "";
        int n = this.descriptionArea.getLineCount();
        if (n < 1) {
            return null;
        }
        Document document = this.descriptionArea.getDocument();
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = this.descriptionArea.getLineStartOffset(i);
                int n3 = this.descriptionArea.getLineEndOffset(i);
                String string3 = document.getText(n2, n3 - n2);
                if (i > 0) {
                    string2 = string2 + "            ";
                }
                string2 = string2 + string3;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return string2;
    }

    public String getDescription() {
        return this.descriptionArea.getText();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                ScriptAttributeDialog.this.result = 0;
                ScriptAttributeDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                ScriptAttributeDialog.this.result = 2;
                ScriptAttributeDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                ScriptAttributeDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)ScriptAttributeDialog.this), "Script Attribute Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            ScriptAttributeDialog.this.result = -1;
            ScriptAttributeDialog.this.dispose();
        }
    }
}

