/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.awt.Frame;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.tigr.microarray.mev.ResultTree;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.action.AnalysisAction;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.script.Script;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.microarray.mev.script.scriptGUI.ScriptCentroidViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptCentroidsViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptClusterSelectionInfoViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptExperimentCentroidViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptExperimentCentroidsViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptExperimentClusterViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptExperimentViewer;
import org.tigr.microarray.mev.script.scriptGUI.ScriptTreeViewer;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.AlgorithmSet;
import org.tigr.microarray.mev.script.util.DataNode;
import org.tigr.microarray.mev.script.util.ScriptDataTransformer;
import org.tigr.microarray.mev.script.util.ScriptTree;
import org.tigr.util.FloatMatrix;

public class ScriptRunner {
    private Script script;
    private ScriptTree scriptTree;
    private Frame parentFrame;
    private ActionManager actionManager;
    private IFramework framework;
    private Hashtable classHash;
    private AlgorithmSet[] algSets;
    private int mode;

    public ScriptRunner(Script script, ActionManager actionManager, IFramework iFramework) {
        this.script = script;
        this.scriptTree = script.getScriptTree();
        this.actionManager = actionManager;
        this.framework = iFramework;
        this.mode = 0;
        this.parentFrame = iFramework.getFrame();
        this.classHash = this.getClassNames();
    }

    public void setOutputMode(int n) {
        this.mode = n;
    }

    public void execute(int n) {
        this.mode = n;
        Thread thread = new Thread(new Runner());
        thread.start();
    }

    public void execute() {
        Thread thread = new Thread(new Runner());
        thread.start();
    }

    private DefaultMutableTreeNode execute(AlgorithmSet algorithmSet) {
        Experiment experiment = algorithmSet.getExperiment();
        if (experiment == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("No Result (empty input data node)");
            return defaultMutableTreeNode;
        }
        int n = algorithmSet.getAlgorithmCount();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (this.mode == 1) {
            JFileChooser jFileChooser = new JFileChooser(TMEV.getFile("data/"));
            if (jFileChooser.showOpenDialog(this.parentFrame) == 0) {
                File file = jFileChooser.getSelectedFile();
            } else {
                return null;
            }
        }
        if (n > 0) {
            // empty if block
        }
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3;
            Object object;
            Object object2;
            AlgorithmNode algorithmNode = algorithmSet.getAlgorithmNodeAt(i);
            AlgorithmData algorithmData = algorithmNode.getAlgorithmData();
            String string = algorithmNode.getAlgorithmName();
            String string2 = algorithmNode.getAlgorithmType();
            if (string2.equals("cluster") || string2.equals("cluster-genes") || string2.equals("cluster-experiments") || string2.equals("data-visualization")) {
                object2 = (String)this.classHash.get(string);
                try {
                    object = Class.forName((String)object2);
                    IScriptGUI iScriptGUI = (IScriptGUI)object.newInstance();
                    defaultMutableTreeNode = iScriptGUI.executeScript(this.framework, algorithmData, experiment);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.parentFrame, "Can't execute script " + string + " algorithm", "Script Parameter Error", 2);
                    exception.printStackTrace();
                }
                if (defaultMutableTreeNode == null) continue;
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode("Results");
                }
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                this.attachResultToChildAlgorithmSets(algorithmNode, experiment, this.extractClusters(defaultMutableTreeNode));
                continue;
            }
            if (string2.equals("data-adjustment")) {
                algorithmData.addParam("name", string);
                object2 = new ScriptDataTransformer(experiment, this.framework);
                object = ((ScriptDataTransformer)object2).transformData(algorithmData);
                int[][] nArrayArray = new int[][]{this.getDefaultGeneIndices(object.getNumberOfGenes())};
                this.attachResultToChildAlgorithmSets(algorithmNode, (Experiment)object, nArrayArray);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode("Results");
                }
                defaultMutableTreeNode3 = this.getViewerNodes((Experiment)object);
                defaultMutableTreeNode3.setUserObject("Data Adjustment: " + string);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                continue;
            }
            if (!string2.equals("cluster-selection")) continue;
            algorithmData.addParam("name", string);
            object2 = new ScriptDataTransformer(experiment, this.framework);
            object = ((ScriptDataTransformer)object2).selectClusters(algorithmData, algorithmSet.getClusters());
            this.attachResultToChildAlgorithmSets(algorithmNode, experiment, (int[][])object);
            boolean bl = algorithmData.getParams().getBoolean("process-gene-clusters");
            defaultMutableTreeNode3 = this.getSelectedClusterViewers(algorithmData, experiment, (int[][])object, bl);
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode("Results");
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode getViewerNodes(Experiment experiment) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Input Data Viewers");
        int[][] nArrayArray = new int[][]{this.getDefaultGeneIndices(experiment.getNumberOfGenes())};
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Expression Image", (IViewer)new ScriptExperimentViewer(experiment, nArrayArray)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        FloatMatrix floatMatrix = experiment.getMatrix();
        FloatMatrix floatMatrix2 = this.getMeans(floatMatrix, nArrayArray);
        FloatMatrix floatMatrix3 = this.getVariances(floatMatrix, floatMatrix2, nArrayArray);
        ScriptCentroidViewer scriptCentroidViewer = new ScriptCentroidViewer(experiment, nArrayArray);
        scriptCentroidViewer.setMeans(floatMatrix2.A);
        scriptCentroidViewer.setVariances(floatMatrix3.A);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Centroid Graph", (IViewer)scriptCentroidViewer, (Object)new CentroidUserObject(0, 0)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Expression Graph", (IViewer)scriptCentroidViewer, (Object)new CentroidUserObject(0, 1)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return defaultMutableTreeNode;
    }

    private Hashtable getClassNames() {
        AnalysisAction analysisAction;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while ((analysisAction = (AnalysisAction)this.actionManager.getAction("analysis-action" + String.valueOf(n))) != null) {
            String string = (String)analysisAction.getValue("Name");
            String string2 = (String)analysisAction.getValue("command-parameter");
            hashtable.put(string, string2);
            ++n;
        }
        return hashtable;
    }

    private FloatMatrix getMeans(FloatMatrix floatMatrix, int[][] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = this.getMeans(floatMatrix, nArray[i]);
        }
        return floatMatrix2;
    }

    private float[] getMeans(FloatMatrix floatMatrix, int[] nArray) {
        int n = floatMatrix.getColumnDimension();
        float[] fArray = new float[n];
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 = 0.0f;
            f = 0.0f;
            for (int j = 0; j < nArray.length; ++j) {
                float f3 = floatMatrix.get(nArray[j], i);
                if (Float.isNaN(f3)) continue;
                f += f3;
                f2 += 1.0f;
            }
            fArray[i] = f2 > 0.0f ? f / f2 : Float.NaN;
        }
        return fArray;
    }

    private FloatMatrix getVariances(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int[][] nArray) {
        int n = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, n);
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = this.getVariances(floatMatrix, floatMatrix2, nArray[i], i);
        }
        return floatMatrix3;
    }

    private float[] getVariances(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int[] nArray, int n) {
        int n2 = floatMatrix.getColumnDimension();
        float[] fArray = new float[n2];
        float f = 0.0f;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            float f2 = floatMatrix2.get(n, i);
            n3 = 0;
            f = 0.0f;
            for (int j = 0; j < nArray.length; ++j) {
                float f3 = floatMatrix.get(nArray[j], i);
                if (Float.isNaN(f3)) continue;
                f += (float)Math.pow(f3 - f2, 2.0);
                ++n3;
            }
            fArray[i] = n3 > 1 ? (float)Math.sqrt(f / (float)(n3 - 1)) : 0.0f;
        }
        return fArray;
    }

    private int[] getDefaultGeneIndices(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private void attachResultToChildAlgorithmSets(AlgorithmNode algorithmNode, Experiment experiment, int[][] nArray) {
        int n = algorithmNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DataNode dataNode = (DataNode)algorithmNode.getChildAt(i);
            for (int j = 0; j < this.algSets.length; ++j) {
                if (dataNode != this.algSets[j].getDataNode()) continue;
                if (!(dataNode.getDataOutputClass().equals("multi-cluster-output") || dataNode.getDataOutputClass().equals("multi-gene-cluster-output") || dataNode.getDataOutputClass().equals("multi-experiment-cluster-output"))) {
                    if (i >= nArray.length) continue;
                    if (algorithmNode.getAlgorithmType().equals("cluster-experiments")) {
                        this.setExperiment(this.algSets[j], experiment, nArray[i], false);
                        continue;
                    }
                    this.setExperiment(this.algSets[j], experiment, nArray[i], true);
                    continue;
                }
                this.setExperimentAndClusters(this.algSets[j], experiment, nArray, algorithmNode);
            }
        }
    }

    private void setExperiment(AlgorithmSet algorithmSet, Experiment experiment, int[] nArray, boolean bl) {
        ScriptDataTransformer scriptDataTransformer = new ScriptDataTransformer(experiment, this.framework);
        Experiment experiment2 = scriptDataTransformer.getTrimmedExperiment(nArray, bl);
        algorithmSet.setExperiment(experiment2);
    }

    private void setExperimentAndClusters(AlgorithmSet algorithmSet, Experiment experiment, int[][] nArray, AlgorithmNode algorithmNode) {
        algorithmSet.setExperiment(experiment);
        algorithmSet.setClusters(nArray);
        if (algorithmNode.getAlgorithmType().equals("cluster-genes")) {
            algorithmSet.setClusterType(0);
        } else {
            algorithmSet.setClusterType(1);
        }
    }

    private int[][] extractClusters(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            IViewer iViewer;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(defaultMutableTreeNode2.getUserObject() instanceof LeafInfo) || (iViewer = ((LeafInfo)defaultMutableTreeNode2.getUserObject()).getViewer()) == null) continue;
            Experiment experiment = iViewer.getExperiment();
            int[][] nArray = iViewer.getClusters();
            if (experiment == null || nArray == null) continue;
            return nArray;
        }
        return null;
    }

    private DefaultMutableTreeNode getSelectedClusterViewers(AlgorithmData algorithmData, Experiment experiment, int[][] nArray, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Cluster Selection Results");
        this.addExpressionImages(defaultMutableTreeNode, experiment, nArray, bl);
        this.addCentroidViews(defaultMutableTreeNode, experiment, nArray, bl);
        this.addSelectionInfoViewer(defaultMutableTreeNode, algorithmData);
        return defaultMutableTreeNode;
    }

    private void addExpressionImages(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Expression Images");
        Object object = bl ? new ScriptExperimentViewer(experiment, nArray) : new ScriptExperimentClusterViewer(experiment, nArray);
        for (int i = 0; i < nArray.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)object, (Object)new Integer(i))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    private void addCentroidViews(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int[][] nArray, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Expression Graphs");
        FloatMatrix floatMatrix = experiment.getMatrix();
        if (!bl) {
            floatMatrix = floatMatrix.transpose();
        }
        FloatMatrix floatMatrix2 = this.getMeans(floatMatrix, nArray);
        FloatMatrix floatMatrix3 = this.getVariances(floatMatrix, floatMatrix2, nArray);
        if (!bl) {
            floatMatrix = floatMatrix.transpose();
        }
        if (bl) {
            ScriptCentroidViewer scriptCentroidViewer = new ScriptCentroidViewer(experiment, nArray);
            scriptCentroidViewer.setMeans(floatMatrix2.A);
            scriptCentroidViewer.setVariances(floatMatrix3.A);
            for (int i = 0; i < nArray.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)scriptCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)scriptCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            ScriptCentroidsViewer scriptCentroidsViewer = new ScriptCentroidsViewer(experiment, nArray);
            scriptCentroidsViewer.setMeans(floatMatrix2.A);
            scriptCentroidsViewer.setVariances(floatMatrix3.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)scriptCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)scriptCentroidsViewer, (Object)new Integer(1))));
        } else {
            ScriptExperimentCentroidViewer scriptExperimentCentroidViewer = new ScriptExperimentCentroidViewer(experiment, nArray);
            scriptExperimentCentroidViewer.setMeans(floatMatrix2.A);
            scriptExperimentCentroidViewer.setVariances(floatMatrix3.A);
            for (int i = 0; i < nArray.length; ++i) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)scriptExperimentCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)scriptExperimentCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            ScriptExperimentCentroidsViewer scriptExperimentCentroidsViewer = new ScriptExperimentCentroidsViewer(experiment, nArray);
            scriptExperimentCentroidsViewer.setMeans(floatMatrix2.A);
            scriptExperimentCentroidsViewer.setVariances(floatMatrix3.A);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)scriptExperimentCentroidsViewer, (Object)new Integer(0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)scriptExperimentCentroidsViewer, (Object)new Integer(1))));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    private void addSelectionInfoViewer(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Selection Information", (IViewer)new ScriptClusterSelectionInfoViewer(algorithmData)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    static /* synthetic */ AlgorithmSet[] access$102(ScriptRunner scriptRunner, AlgorithmSet[] algorithmSetArray) {
        scriptRunner.algSets = algorithmSetArray;
        return algorithmSetArray;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        public void run() {
            ScriptRunner.access$102(ScriptRunner.this, ScriptRunner.this.scriptTree.getAlgorithmSets());
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Script Result");
            if (ScriptRunner.this.algSets.length > 0) {
                // empty if block
            }
            for (int i = 0; i < ScriptRunner.this.algSets.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                DefaultMutableTreeNode defaultMutableTreeNode3;
                AlgorithmSet algorithmSet = ScriptRunner.this.algSets[i];
                if (algorithmSet.getAlgorithmCount() <= 0 || (defaultMutableTreeNode3 = ScriptRunner.this.execute(algorithmSet)) == null) continue;
                Experiment experiment = algorithmSet.getExperiment();
                bl = true;
                DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Algorithm Set");
                DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Input Data");
                ScriptTree scriptTree = new ScriptTree(ScriptRunner.this.scriptTree);
                DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new LeafInfo("Script Tree", (IViewer)new ScriptTreeViewer(scriptTree, ScriptRunner.this.scriptTree.getScriptManager(), algorithmSet.getDataNode())));
                DataNode dataNode = algorithmSet.getDataNode();
                AlgorithmNode algorithmNode = (AlgorithmNode)dataNode.getParent();
                if (algorithmNode != null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode("Algorithm Source: " + algorithmNode.getAlgorithmName() + " [" + algorithmNode.getDataNodeRef() + "," + algorithmNode.getID() + "] ");
                    defaultMutableTreeNode5.add(defaultMutableTreeNode2);
                }
                defaultMutableTreeNode2 = new DefaultMutableTreeNode("Input Data Node: " + dataNode.toString());
                defaultMutableTreeNode5.add(defaultMutableTreeNode2);
                if (experiment != null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode("Number of Experiments: " + experiment.getNumberOfSamples());
                    defaultMutableTreeNode5.add(defaultMutableTreeNode2);
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode("Number of Genes: " + experiment.getNumberOfGenes());
                    defaultMutableTreeNode5.add(defaultMutableTreeNode2);
                    defaultMutableTreeNode2 = ScriptRunner.this.getViewerNodes(algorithmSet.getExperiment());
                    defaultMutableTreeNode5.add(defaultMutableTreeNode2);
                } else {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode("Number of Experiments: 0, null input data");
                    defaultMutableTreeNode5.add(defaultMutableTreeNode2);
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode("Number of Genes: 0, null input data");
                    defaultMutableTreeNode5.add(defaultMutableTreeNode2);
                }
                defaultMutableTreeNode4.add(defaultMutableTreeNode6);
                defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                defaultMutableTreeNode4.add(defaultMutableTreeNode3);
                defaultMutableTreeNode.add(defaultMutableTreeNode4);
            }
            ResultTree resultTree = ScriptRunner.this.framework.getResultTree();
            ScriptRunner.this.framework.addAnalysisResult(defaultMutableTreeNode);
            resultTree.scrollPathToVisible(new TreePath(((DefaultTreeModel)resultTree.getModel()).getPathToRoot(defaultMutableTreeNode)));
        }
    }
}

