/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import java.util.Random;
import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class BootstrappedMatrixByExps {
    public Vector resampledIndices = new Vector();

    float[][] get2DArrFromExpMatrix(FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = floatMatrix.get(i, j);
            }
        }
        return fArray;
    }

    float[][] resampleMatrix(FloatMatrix floatMatrix) {
        float[][] fArray = this.get2DArrFromExpMatrix(floatMatrix);
        float[][] fArray2 = new float[fArray.length][fArray[0].length];
        int n = fArray.length;
        int n2 = fArray[0].length;
        Random random = new Random();
        for (int i = 0; i < n2; ++i) {
            int n3 = random.nextInt(n2);
            for (int j = 0; j < n; ++j) {
                fArray2[j][i] = fArray[j][n3];
            }
            this.resampledIndices.add(new Integer(n3));
        }
        return fArray2;
    }

    public FloatMatrix createResampExpMatrixObject(FloatMatrix floatMatrix) {
        float[][] fArray = this.resampleMatrix(floatMatrix);
        FloatMatrix floatMatrix2 = new FloatMatrix(fArray);
        return floatMatrix2;
    }

    void printMatrix(float[][] fArray) {
        int n = 0;
        for (int i = 0; i < fArray[0].length; ++i) {
            for (n = 0; n < fArray.length; ++n) {
                System.out.print((int)(fArray[n][i] * 100.0f) / 100 + " ");
            }
            System.out.println();
        }
    }
}

