/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.parser;

import java.util.LinkedList;
import java.util.StringTokenizer;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.remote.protocol.parser.FloatVectorParser;
import org.tigr.remote.protocol.parser.IntVectorParser;
import org.tigr.remote.protocol.parser.ParserException;
import org.tigr.remote.protocol.parser.ResponseHandlerBase;
import org.tigr.util.ConfMap;
import org.tigr.util.FloatMatrix;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class MAGEResponseHandler
extends ResponseHandlerBase {
    private MatrixData m_currentMatrix = null;
    private ClusterData m_currentCluster = null;
    private NodeValue m_nodeValue = null;
    private AlgorithmData m_data = new AlgorithmData();
    private boolean m_parameters;

    public MAGEResponseHandler(ConfMap confMap) {
        super(confMap);
    }

    public AlgorithmData getResult() {
        return this.m_data;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block31: {
            super.startElement(string, string2, string3, attributes);
            try {
                String[] stringArray;
                if (string3.equals("DerivedBioAssayData")) {
                    String string4 = attributes.getValue("identifier");
                    if (!string4.equals("parameters")) {
                        this.m_currentMatrix = new MatrixData(string4);
                    } else {
                        this.m_parameters = true;
                    }
                    break block31;
                }
                if (string3.equals("NameValueType")) {
                    IntVectorParser intVectorParser;
                    String[] stringArray2 = new String[]{"NameValueType", "PropertySets_assnlist", "BioDataCube"};
                    String[] stringArray3 = new String[]{"NameValueType", "PropertySets_assnlist", "DerivedBioAssayData"};
                    String[] stringArray4 = new String[]{"NameValueType", "PropertySets_assnlist", "NodeContents", "NodeContents_assnlist", "Node"};
                    if (this.m_path.checkFromBottom(stringArray2)) {
                        Object object;
                        String string5 = attributes.getValue("name");
                        if (string5.equals("cols")) {
                            object = attributes.getValue("value");
                            int n = Integer.parseInt((String)object);
                            this.m_currentMatrix.m_dims.setDimX(n);
                        } else if (string5.equals("rows")) {
                            object = attributes.getValue("value");
                            int n = Integer.parseInt((String)object);
                            this.m_currentMatrix.m_dims.setDimY(n);
                        }
                        object = this.m_currentMatrix.m_dims;
                        if (((MatrixDimensions)object).getDimX() != 0 && ((MatrixDimensions)object).getDimY() != 0) {
                            this.m_currentMatrix.m_matrix = new FloatMatrix(((MatrixDimensions)object).getDimY(), ((MatrixDimensions)object).getDimX());
                        }
                        break block31;
                    }
                    if (this.m_path.checkFromBottom(stringArray3)) {
                        String string6 = attributes.getValue("name");
                        String string7 = attributes.getValue("value");
                        String string8 = attributes.getValue("type");
                        if (string8 != null) {
                            if (!string8.equals("vector-of-int")) break block31;
                            IntVectorParser intVectorParser2 = new IntVectorParser();
                            int[] nArray = null;
                            try {
                                nArray = intVectorParser2.parse(string7);
                            }
                            catch (ParserException parserException) {
                                throw new ParserException("error parsing parameter " + string6, parserException);
                            }
                            this.m_data.addIntArray(string6, nArray);
                            break block31;
                        }
                        this.m_data.addParam(string6, string7);
                        break block31;
                    }
                    if (!this.m_path.checkFromBottom(stringArray4) || this.m_currentCluster == null) break block31;
                    String string9 = attributes.getValue("name");
                    String string10 = attributes.getValue("value");
                    if (string9 == null || string10 == null) break block31;
                    if (string9.equals("features-indexes")) {
                        intVectorParser = new IntVectorParser();
                        try {
                            this.m_currentCluster.getCurrentNode().setFeaturesIndexes(intVectorParser.parse(string10));
                        }
                        catch (ParserException parserException) {
                            throw new ParserException("Cannot parse features indexes. Cluster: " + this.m_currentCluster.m_id + ". Node: " + this.m_currentCluster.getCurrentNode(), parserException);
                        }
                    }
                    if (string9.equals("probes-indexes")) {
                        intVectorParser = new IntVectorParser();
                        try {
                            this.m_currentCluster.getCurrentNode().setProbesIndexes(intVectorParser.parse(string10));
                            break block31;
                        }
                        catch (ParserException parserException) {
                            throw new ParserException("Cannot parse probes indexes. Cluster: " + this.m_currentCluster.m_id + ". Node: " + this.m_currentCluster.getCurrentNode(), parserException);
                        }
                    }
                    this.m_currentCluster.getCurrentNode().setProperty(string9, string10);
                    break block31;
                }
                if (string3.equals("BioAssayDataCluster")) {
                    String string11 = attributes.getValue("identifier");
                    this.m_currentCluster = new ClusterData(string11);
                } else if (string3.equals("Node")) {
                    String[] stringArray5 = new String[]{"Node", "Nodes_assnlist", "Node"};
                    String[] stringArray6 = new String[]{"Node", "Nodes_assnlist", "BioAssayDataCluster"};
                    if ((this.m_path.checkFromBottom(stringArray5) || this.m_path.checkFromBottom(stringArray6)) && this.m_currentCluster != null) {
                        this.m_currentCluster.startNode(new Node());
                    }
                } else if (string3.equals("NodeValue")) {
                    if (this.m_currentCluster != null) {
                        this.m_nodeValue = new NodeValue(attributes.getValue("name"), (Object)attributes.getValue("value"), null);
                    }
                } else if (string3.equals("OntologyEntry") && this.m_path.checkFromBottom(stringArray = new String[]{"OntologyEntry", "Type_assn", "NodeValue"}) && this.m_nodeValue != null) {
                    this.m_nodeValue.description = attributes.getValue("value");
                    String string12 = attributes.getValue("category");
                    if (string12 != null && string12.equals("type")) {
                        this.adjustValueType(this.m_nodeValue, attributes.getValue("value"));
                    }
                }
            }
            catch (Exception exception) {
                this.processError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string3.equals("DerivedBioAssayData")) {
                if (this.m_currentMatrix != null) {
                    if (!"".equals(this.m_currentMatrix.m_prevChunk)) {
                        this.parseFloats(this.m_currentMatrix.m_prevChunk);
                    }
                    this.m_currentMatrix.checkFinalState();
                    this.m_data.addMatrix(this.m_currentMatrix.m_name, this.m_currentMatrix.m_matrix);
                    this.m_currentMatrix = null;
                } else {
                    this.m_parameters = false;
                }
            } else if (string3.equals("BioAssayDataCluster")) {
                this.m_data.addCluster(this.m_currentCluster.m_id, this.m_currentCluster.m_cluster);
                this.m_currentCluster = null;
            } else if (string3.equals("Node")) {
                if (this.m_currentCluster != null) {
                    this.m_currentCluster.endNode();
                }
            } else if (string3.equals("NodeValue") && this.m_nodeValue != null) {
                this.m_currentCluster.getCurrentNode().getValues().addNodeValue(this.m_nodeValue);
                this.m_nodeValue = null;
            }
        }
        catch (Exception exception) {
            this.processError(exception);
        }
        finally {
            super.endElement(string, string2, string3);
        }
    }

    private void parseFloats(String string) throws ParserException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            float f = 0.0f;
            try {
                f = string2.equals("NaN") ? Float.NaN : Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParserException("Failed to parser float: " + string2 + " matrix: " + this.m_currentMatrix.m_name + " order: " + this.m_currentMatrix.getNumbersRead(), numberFormatException);
            }
            this.m_currentMatrix.floatRead(f);
        }
    }

    private static boolean isSpace(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    private int doGlue(char[] cArray, int n, int n2) throws Exception {
        if (!"".equals(this.m_currentMatrix.m_prevChunk)) {
            StringBuffer stringBuffer = new StringBuffer(this.m_currentMatrix.m_prevChunk);
            int n3 = n;
            if (!MAGEResponseHandler.isSpace(cArray[n])) {
                int n4;
                for (n4 = n; !MAGEResponseHandler.isSpace(cArray[n4]) && n + n2 > n4; ++n4) {
                    stringBuffer.append(cArray[n4]);
                }
                n3 = n4;
            }
            this.parseFloats(stringBuffer.toString());
            this.m_currentMatrix.m_prevChunk = "";
            return n3;
        }
        return n;
    }

    private int leaveChunk(char[] cArray, int n, int n2) {
        int n3 = n + n2 - 1;
        if (!MAGEResponseHandler.isSpace(cArray[n3])) {
            int n4 = n2;
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = n3;
            while (!MAGEResponseHandler.isSpace(cArray[n5]) && n5 > n) {
                stringBuffer.append(cArray[n5]);
                --n5;
                --n4;
            }
            this.m_currentMatrix.m_prevChunk = stringBuffer.reverse().toString();
            return n4;
        }
        this.m_currentMatrix.m_prevChunk = "";
        return n2;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = "";
        int n3 = n;
        int n4 = n2;
        try {
            String[] stringArray = new String[]{"DataInternal", "DataInternal_assn", "BioDataCube"};
            if (this.m_path.checkFromBottom(stringArray)) {
                if (this.m_currentMatrix == null) {
                    throw new SAXException("Program error parsing matrix");
                }
                if (this.m_currentMatrix.m_matrix == null) {
                    throw new SAXException("Wrong matrix - no dimensions defined");
                }
                n3 = this.doGlue(cArray, n, n2);
                n4 = this.leaveChunk(cArray, n3, n2 + (n - n3));
                String string2 = new String(cArray, n3, n4);
                this.parseFloats(string2);
            }
        }
        catch (Exception exception) {
            this.processError(exception);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    private void adjustValueType(NodeValue nodeValue, String string) throws Exception {
        if (!"".equals(string)) {
            String string2 = (String)nodeValue.value;
            if (string.equals("integer")) {
                nodeValue.value = new Integer(string2);
            } else if (string.equals("float")) {
                nodeValue.value = new Float(string2);
            } else if (string.equals("int-array")) {
                nodeValue.value = new IntVectorParser().parse(string2);
            } else if (string.equals("float-array")) {
                nodeValue.value = new FloatVectorParser().parse(string2);
            } else {
                throw new Exception("Unknown value type: " + string);
            }
        }
    }

    class ClusterData {
        public String m_id;
        public Cluster m_cluster = new Cluster();
        private LinkedList m_nodes = new LinkedList();

        public ClusterData(String string) {
            this.m_id = string;
        }

        public void startNode(Node node) {
            this.assignParentToStarted(node);
            this.m_nodes.addLast(node);
        }

        public void endNode() {
            this.m_nodes.removeLast();
        }

        public Node getCurrentNode() {
            if (this.m_nodes.size() == 0) {
                return null;
            }
            return (Node)this.m_nodes.getLast();
        }

        private void assignParentToStarted(Node node) {
            Node node2 = this.getCurrentNode();
            if (node2 == null) {
                this.m_cluster.getNodeList().addNode(node);
            } else {
                node2.getChildNodes().addNode(node);
            }
        }
    }

    class MatrixData {
        private int m_numbersRead;
        public String m_name;
        public MatrixDimensions m_dims;
        public FloatMatrix m_matrix;
        public String m_prevChunk;

        public MatrixData(String string) {
            this.m_dims = new MatrixDimensions();
            this.m_prevChunk = "";
            this.m_name = string;
            this.m_matrix = null;
            this.m_numbersRead = 0;
        }

        public void floatRead(float f) throws ParserException {
            try {
                this.checkReadInProgressState();
                int n = this.m_numbersRead / this.m_matrix.getRowDimension();
                int n2 = this.m_numbersRead % this.m_matrix.getRowDimension();
                this.m_matrix.set(n2, n, f);
                ++this.m_numbersRead;
            }
            catch (Exception exception) {
                throw new ParserException("error setting matrix value", exception);
            }
        }

        public void checkReadInProgressState() throws Exception {
            if (this.m_numbersRead + 1 > this.m_dims.getDimX() * this.m_dims.getDimY()) {
                throw new Exception("Error reading matrix data. Has read more data than dims allow: read: " + this.m_numbersRead);
            }
        }

        public void checkFinalState() throws Exception {
            if (this.m_numbersRead != this.m_dims.getDimX() * this.m_dims.getDimY()) {
                String string = "Error reading matrix data: \nDimensions: " + this.m_dims.getDimX() + "x" + this.m_dims.getDimY() + " = " + this.m_dims.getDimX() * this.m_dims.getDimY() + "\n" + "It has been read: " + this.m_numbersRead + "\n";
                throw new Exception(string);
            }
        }

        public int getNumbersRead() {
            return this.m_numbersRead;
        }
    }

    class MatrixDimensions {
        private int m_dimX = 0;
        private int m_dimY = 0;

        public int getDimX() {
            return this.m_dimX;
        }

        public int getDimY() {
            return this.m_dimY;
        }

        public void setDimX(int n) {
            this.m_dimX = n;
        }

        public void setDimY(int n) {
            this.m_dimY = n;
        }
    }
}

