/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.internal.StringHasher;

public final class DefaultStringPool
implements StringPool {
    private static final int INITIAL_CHUNK_SHIFT = 5;
    private static final int INITIAL_CHUNK_SIZE = 32;
    private static final int CHUNK_SHIFT = 10;
    private static final int CHUNK_SIZE = 1024;
    private static final int CHUNK_MASK = 1023;
    private static final int INITIAL_CHUNK_COUNT = 32;
    private ParserState fParserState = null;
    private int fStringCount = 0;
    private int fNullString = 0;
    private int fStringFreeList = -1;
    private String[][] fString = new String[32][];
    private StringProducer[][] fStringProducer = new StringProducer[32][];
    private int[][] fOffset = new int[32][];
    private int[][] fLength = new int[32][];
    private int fStringListCount = 0;
    private int fActiveStringList = -1;
    private int[][] fStringList = new int[32][];
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 128;
    private int[][] fSymbolTable = new int[128][];

    public DefaultStringPool(ParserState parserState) {
        this.fParserState = parserState;
        this.fNullString = this.addSymbol("");
    }

    public void reset(ParserState parserState) {
        this.fParserState = parserState;
        int chunk = 0;
        int index = 0;
        int i = 0;
        while (i < this.fStringCount) {
            this.fString[chunk][index] = null;
            this.fStringProducer[chunk][index] = null;
            if (++index == 1024) {
                ++chunk;
                index = 0;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 128) {
            this.fSymbolTable[i2] = null;
            ++i2;
        }
        this.fStringCount = 0;
        this.fStringFreeList = -1;
        this.fStringListCount = 0;
        this.fActiveStringList = -1;
        this.fNullString = this.addSymbol("");
    }

    public StringPool resetOrCopy(ParserState parserState) {
        return new DefaultStringPool(parserState);
    }

    private boolean ensureCapacity(int chunk, int index) {
        block4: {
            try {
                return this.fOffset[chunk][index] == 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (index == 0) {
                    String[][] newString = new String[chunk * 2][];
                    System.arraycopy(this.fString, 0, newString, 0, chunk);
                    this.fString = newString;
                    StringProducer[][] newProducer = new StringProducer[chunk * 2][];
                    System.arraycopy(this.fStringProducer, 0, newProducer, 0, chunk);
                    this.fStringProducer = newProducer;
                    int[][] newInt = new int[chunk * 2][];
                    System.arraycopy(this.fOffset, 0, newInt, 0, chunk);
                    this.fOffset = newInt;
                    newInt = new int[chunk * 2][];
                    System.arraycopy(this.fLength, 0, newInt, 0, chunk);
                    this.fLength = newInt;
                    break block4;
                }
                String[] newString = new String[index * 2];
                System.arraycopy(this.fString[chunk], 0, newString, 0, index);
                this.fString[chunk] = newString;
                StringProducer[] newProducer = new StringProducer[index * 2];
                System.arraycopy(this.fStringProducer[chunk], 0, newProducer, 0, index);
                this.fStringProducer[chunk] = newProducer;
                int[] newInt = new int[index * 2];
                System.arraycopy(this.fOffset[chunk], 0, newInt, 0, index);
                this.fOffset[chunk] = newInt;
                newInt = new int[index * 2];
                System.arraycopy(this.fLength[chunk], 0, newInt, 0, index);
                this.fLength[chunk] = newInt;
                return true;
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.fString[chunk] = new String[32];
        this.fStringProducer[chunk] = new StringProducer[32];
        this.fOffset[chunk] = new int[32];
        this.fLength[chunk] = new int[32];
        return true;
    }

    private void checkStringCount() {
    }

    public int addString(String str) {
        int index;
        int chunk;
        int stringIndex;
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 10;
            index = stringIndex & 0x3FF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 10;
            index = stringIndex & 0x3FF;
            this.ensureCapacity(chunk, index);
        }
        this.fString[chunk][index] = str;
        this.fStringProducer[chunk][index] = null;
        this.fOffset[chunk][index] = 0;
        this.fLength[chunk][index] = str.length();
        return stringIndex;
    }

    public int addString(StringProducer stringProducer, int offset, int length) {
        int index;
        int chunk;
        int stringIndex;
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 10;
            index = stringIndex & 0x3FF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 10;
            index = stringIndex & 0x3FF;
            this.ensureCapacity(chunk, index);
        }
        this.fString[chunk][index] = null;
        this.fStringProducer[chunk][index] = stringProducer;
        this.fOffset[chunk][index] = offset;
        this.fLength[chunk][index] = length;
        return stringIndex;
    }

    private void hashSymbol(int[] bucket, int hashcode, int chunk, int index) {
        if (bucket == null) {
            bucket = new int[13];
            bucket[0] = 1;
            bucket[1] = hashcode;
            bucket[2] = chunk;
            bucket[3] = index;
            int hc = hashcode % 128;
            this.fSymbolTable[hc] = bucket;
            return;
        }
        int count = bucket[0];
        int offset = 1 + count * 3;
        if (offset == bucket.length) {
            int newSize = count + 4;
            int[] newBucket = new int[1 + newSize * 3];
            System.arraycopy(bucket, 0, newBucket, 0, offset);
            bucket = newBucket;
            int hc = hashcode % 128;
            this.fSymbolTable[hc] = bucket;
        }
        bucket[offset++] = hashcode;
        bucket[offset++] = chunk;
        bucket[offset++] = index;
        bucket[0] = ++count;
    }

    public int addSymbol(String str) {
        int index;
        int chunk;
        int stringIndex;
        int slen = str.length();
        int hashcode = StringHasher.hashString(str, slen);
        int hc = hashcode % 128;
        int[] bucket = this.fSymbolTable[hc];
        if (bucket != null) {
            int j = 1;
            int i = 0;
            while (i < bucket[0]) {
                int index2;
                int chunk2;
                if (bucket[j] == hashcode && str.equals(this.fString[chunk2 = bucket[j + 1]][index2 = bucket[j + 2]])) {
                    return (chunk2 << 10) + index2;
                }
                j += 3;
                ++i;
            }
        }
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 10;
            index = stringIndex & 0x3FF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 10;
            index = stringIndex & 0x3FF;
            this.ensureCapacity(chunk, index);
        }
        this.fString[chunk][index] = str;
        this.fStringProducer[chunk][index] = null;
        this.fOffset[chunk][index] = -1;
        this.fLength[chunk][index] = slen;
        this.hashSymbol(bucket, hashcode, chunk, index);
        return stringIndex;
    }

    public int addSymbol(StringProducer stringProducer, int offset, int length, int hashcode) {
        String str;
        int index;
        int chunk;
        int stringIndex;
        int hc = hashcode % 128;
        int[] bucket = this.fSymbolTable[hc];
        if (bucket != null) {
            int j = 1;
            int i = 0;
            while (i < bucket[0]) {
                int index2;
                int chunk2;
                if (bucket[j] == hashcode && stringProducer.equalsString(offset, length, this.fString[chunk2 = bucket[j + 1]][index2 = bucket[j + 2]], this.fLength[chunk2][index2])) {
                    return (chunk2 << 10) + index2;
                }
                j += 3;
                ++i;
            }
        }
        if (this.fStringFreeList != -1) {
            stringIndex = this.fStringFreeList;
            chunk = stringIndex >> 10;
            index = stringIndex & 0x3FF;
            this.fStringFreeList = this.fOffset[chunk][index];
        } else {
            stringIndex = this.fStringCount++;
            chunk = stringIndex >> 10;
            index = stringIndex & 0x3FF;
            this.ensureCapacity(chunk, index);
        }
        this.fString[chunk][index] = str = stringProducer.toString(offset, length);
        this.fStringProducer[chunk][index] = null;
        this.fOffset[chunk][index] = -1;
        this.fLength[chunk][index] = str.length();
        this.hashSymbol(bucket, hashcode, chunk, index);
        return stringIndex;
    }

    private boolean ensureListCapacity(int chunk, int index) {
        block4: {
            try {
                return this.fStringList[chunk][index] == 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (index == 0) {
                    int[][] newInt = new int[chunk * 2][];
                    System.arraycopy(this.fStringList, 0, newInt, 0, chunk);
                    this.fStringList = newInt;
                    break block4;
                }
                int[] newInt = new int[index * 2];
                System.arraycopy(this.fStringList[chunk], 0, newInt, 0, index);
                this.fStringList[chunk] = newInt;
                return true;
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.fStringList[chunk] = new int[32];
        return true;
    }

    public int startStringList() {
        this.fActiveStringList = this.fStringListCount;
        return this.fStringListCount;
    }

    public boolean addStringToList(int stringListIndex, int stringIndex) {
        if (stringIndex == -1 || stringListIndex != this.fActiveStringList) {
            return false;
        }
        int chunk = this.fStringListCount >> 10;
        int index = this.fStringListCount & 0x3FF;
        this.ensureListCapacity(chunk, index);
        this.fStringList[chunk][index] = stringIndex;
        ++this.fStringListCount;
        return true;
    }

    public void finishStringList(int stringListIndex) {
        if (stringListIndex != this.fActiveStringList) {
            return;
        }
        int chunk = this.fStringListCount >> 10;
        int index = this.fStringListCount & 0x3FF;
        this.ensureListCapacity(chunk, index);
        this.fStringList[chunk][index] = -1;
        this.fActiveStringList = -1;
        ++this.fStringListCount;
    }

    public int stringListLength(int stringListIndex) {
        int chunk = stringListIndex >> 10;
        int index = stringListIndex & 0x3FF;
        int count = 0;
        while (this.fStringList[chunk][index] != -1) {
            ++count;
            if (++index != 1024) continue;
            ++chunk;
            index = 0;
        }
        return count;
    }

    public boolean stringInList(int stringListIndex, int stringIndex) {
        int chunk = stringListIndex >> 10;
        int index = stringListIndex & 0x3FF;
        while (this.fStringList[chunk][index] != stringIndex) {
            if (this.fStringList[chunk][index] == -1) {
                return false;
            }
            if (++index != 1024) continue;
            ++chunk;
            index = 0;
        }
        return true;
    }

    public int[] stringsInList(int stringListIndex) {
        int chunk = stringListIndex >> 10;
        int index = stringListIndex & 0x3FF;
        int[] result = new int[this.stringListLength(stringListIndex)];
        int i = 0;
        while (this.fStringList[chunk][index] != -1 && i < result.length) {
            result[i] = this.fStringList[chunk][index];
            ++i;
            if (++index != 1024) continue;
            ++chunk;
            index = 0;
        }
        return result;
    }

    private void releaseStringInternal(int chunk, int index) {
        int offset;
        this.fString[chunk][index] = null;
        this.fStringProducer[chunk][index] = null;
        this.fLength[chunk][index] = 0;
        this.fOffset[chunk][index] = this.fStringFreeList;
        this.fStringFreeList = offset = (chunk << 10) + index;
    }

    public void releaseString(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.fStringCount) {
            return;
        }
        int chunk = stringIndex >> 10;
        int index = stringIndex & 0x3FF;
        if (this.fOffset[chunk][index] != -1) {
            this.releaseStringInternal(chunk, index);
        }
    }

    public String toString(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.fStringCount) {
            return null;
        }
        int chunk = stringIndex >> 10;
        int index = stringIndex & 0x3FF;
        String s = this.fString[chunk][index];
        if (s != null) {
            return s;
        }
        this.fString[chunk][index] = s = this.fStringProducer[chunk][index].toString(this.fOffset[chunk][index], this.fLength[chunk][index]);
        return s;
    }

    public String orphanString(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.fStringCount) {
            return null;
        }
        int chunk = stringIndex >> 10;
        int index = stringIndex & 0x3FF;
        String s = this.fString[chunk][index];
        if (s == null) {
            s = this.fStringProducer[chunk][index].toString(this.fOffset[chunk][index], this.fLength[chunk][index]);
            this.releaseStringInternal(chunk, index);
        } else if (this.fOffset[chunk][index] != -1) {
            this.releaseStringInternal(chunk, index);
        }
        return s;
    }
}

