/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import java.io.CharConversionException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

public class OpenString
implements Serializable {
    public char[] value;
    public int offset;
    public int count;
    private static final long serialVersionUID = -6849794470754667710L;
    private static boolean v11hash;
    transient int hashcode;

    public OpenString() {
        this.value = new char[0];
    }

    public OpenString(OpenString value) {
        this(value.offset, value.count, value.value);
    }

    public OpenString(String value) {
        this.count = value.length();
        this.value = new char[this.count];
        value.getChars(0, this.count, this.value, 0);
    }

    public OpenString(char[] value) {
        this.count = value.length;
        this.value = value;
    }

    public OpenString(char[] value, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (offset > value.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        this.value = value;
        this.count = count;
        this.offset = offset;
    }

    public OpenString(byte[] ascii, int hibyte, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (offset > ascii.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        char[] value = new char[count];
        this.count = count;
        this.value = value;
        if (hibyte == 0) {
            int i = count;
            while (i-- > 0) {
                value[i] = (char)(ascii[i + offset] & 0xFF);
            }
        } else {
            hibyte <<= 8;
            int i = count;
            while (i-- > 0) {
                value[i] = (char)(hibyte | ascii[i + offset] & 0xFF);
            }
        }
    }

    public OpenString(byte[] ascii, int hibyte) {
        this(ascii, hibyte, 0, ascii.length);
    }

    protected OpenString(byte[] bytes, int offset, int length, ByteToCharConverter btc) {
        int estCount = btc.getMaxCharsPerByte() * length;
        this.value = new char[estCount];
        try {
            this.count = btc.convert(bytes, offset, offset + length, this.value, 0, estCount);
            this.count += btc.flush(this.value, btc.nextCharIndex(), estCount);
        }
        catch (CharConversionException x) {
            this.count = btc.nextCharIndex();
        }
        if (this.count < estCount) {
            char[] trimValue = new char[this.count];
            System.arraycopy(this.value, 0, trimValue, 0, this.count);
            this.value = trimValue;
        }
    }

    public OpenString(byte[] bytes, int offset, int length, String enc) throws UnsupportedEncodingException {
        this(bytes, offset, length, ByteToCharConverter.getConverter((String)enc));
    }

    public OpenString(byte[] bytes, String enc) throws UnsupportedEncodingException {
        this(bytes, 0, bytes.length, enc);
    }

    public OpenString(byte[] bytes, int offset, int length) {
        this(bytes, offset, length, ByteToCharConverter.getDefault());
    }

    public OpenString(byte[] bytes) {
        this(bytes, 0, bytes.length, ByteToCharConverter.getDefault());
    }

    public OpenString(int offset, int count, char[] value) {
        this.value = value;
        this.offset = offset;
        this.count = count;
    }

    public final int length() {
        return this.count;
    }

    public char[] getValue() {
        return this.value;
    }

    public void setValue(char[] val) {
        this.value = val;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int off) {
        this.offset = off;
    }

    public final void setLength(int len) {
        this.count = len;
    }

    public void setCharAt(int index, char toc) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index + this.offset] = toc;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index + this.offset];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        System.arraycopy(this.value, this.offset + srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        int j = dstBegin;
        int n = this.offset + srcEnd;
        int i = this.offset + srcBegin;
        while (i < n) {
            dst[j++] = (byte)this.value[i++];
        }
    }

    protected byte[] getBytes(CharToByteConverter ctb) {
        int length;
        ctb.reset();
        int estLength = ctb.getMaxBytesPerChar() * this.count;
        byte[] result = new byte[estLength];
        try {
            length = ctb.convert(this.value, this.offset, this.offset + this.count, result, 0, estLength);
            length += ctb.flush(result, ctb.nextByteIndex(), estLength);
        }
        catch (CharConversionException e) {
            length = ctb.nextByteIndex();
        }
        if (length < estLength) {
            byte[] trimResult = new byte[length];
            System.arraycopy(result, 0, trimResult, 0, length);
            return trimResult;
        }
        return result;
    }

    public final byte[] getBytes(String enc) throws UnsupportedEncodingException {
        return this.getBytes(CharToByteConverter.getConverter((String)enc));
    }

    public final byte[] getBytes() {
        return this.getBytes(CharToByteConverter.getDefault());
    }

    public boolean equals(Object anObject) {
        if (anObject == null) {
            return false;
        }
        if (anObject instanceof String) {
            anObject = new OpenString((String)anObject);
        }
        if (anObject instanceof OpenString) {
            OpenString anotherString = (OpenString)anObject;
            int n = this.count;
            if (n == anotherString.count) {
                char[] v1 = this.value;
                char[] v2 = anotherString.value;
                int i = this.offset;
                int j = anotherString.offset;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final boolean equalsIgnoreCase(OpenString anotherString) {
        return anotherString != null && anotherString.count == this.count && this.regionMatches(true, 0, anotherString, 0, this.count);
    }

    public final boolean equalsIgnoreCase(String anotherString) {
        return anotherString != null && anotherString.length() == this.count && this.regionMatches(true, 0, anotherString, 0, this.count);
    }

    public int compareTo(OpenString anotherString) {
        int len1 = this.count;
        int len2 = anotherString.count;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = anotherString.value;
        int i = this.offset;
        int j = anotherString.offset;
        while (n-- != 0) {
            char c2;
            char c1;
            if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public int compareTo(OpenString anotherString, boolean ignoreCase) {
        int len1 = this.count;
        int len2 = anotherString.count;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = anotherString.value;
        int i = this.offset;
        int j = anotherString.offset;
        while (n-- != 0) {
            char c1 = v1[i++];
            char c2 = v2[j++];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public int dictionaryCompareTo(OpenString anotherString, boolean ignoreCase) {
        int len1 = this.count;
        int len2 = anotherString.count;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = anotherString.value;
        int i = this.offset;
        int j = anotherString.offset;
        while (n-- != 0) {
            char c1 = '\u0000';
            while (i < len1 && !Character.isLetterOrDigit(c1)) {
                c1 = v1[i++];
            }
            char c2 = '\u0000';
            while (j < len2 && !Character.isLetterOrDigit(c2)) {
                c2 = v2[j++];
            }
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    /*
     * Unable to fully structure code
     */
    public boolean regionMatches(int toffset, OpenString other, int ooffset, int len) {
        ta = this.value;
        to = this.offset + toffset;
        tlim = this.offset + this.count;
        pa = other.value;
        po = other.offset + ooffset;
        if (ooffset >= 0 && toffset >= 0 && toffset <= this.count - len && ooffset <= other.count - len) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (ta[to++] == pa[po++]) continue;
            return false;
lbl10:
            // 2 sources

            ** while (len-- > 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        int otherlen = other.length();
        if (ooffset < 0 || toffset < 0 || toffset > this.count - len || ooffset > otherlen - len) {
            return false;
        }
        char[] ta = this.value;
        int to = this.offset + toffset;
        int po = ooffset;
        while (len-- > 0) {
            if (ta[to++] == other.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean regionMatches(boolean ignoreCase, int toffset, OpenString other, int ooffset, int len) {
        ta = this.value;
        to = this.offset + toffset;
        tlim = this.offset + this.count;
        pa = other.value;
        po = other.offset + ooffset;
        if (ooffset >= 0 && toffset >= 0 && toffset <= this.count - len && ooffset <= other.count - len) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if ((c1 = ta[to++]) == (c2 = pa[po++]) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
lbl10:
            // 2 sources

            ** while (len-- > 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        if (ooffset < 0 || toffset < 0 || toffset > this.count - len || ooffset > other.length() - len) {
            return false;
        }
        char[] ta = this.value;
        int to = this.offset + toffset;
        int tlim = this.offset + this.count;
        int po = ooffset;
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = ta[to++]) == (c2 = other.charAt(po++)) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(OpenString prefix, int toffset) {
        ta = this.value;
        to = this.offset + toffset;
        tlim = this.offset + this.count;
        pa = prefix.value;
        po = prefix.offset;
        pc = prefix.count;
        if (toffset >= 0 && toffset <= this.count - pc) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            if (ta[to++] == pa[po++]) continue;
            return false;
lbl11:
            // 2 sources

            ** while (--pc >= 0)
        }
lbl12:
        // 1 sources

        return true;
    }

    public final boolean startsWith(OpenString prefix) {
        return this.startsWith(prefix, 0);
    }

    public final boolean startsWith(String prefix, int toffset) {
        return this.startsWith(new OpenString(prefix), toffset);
    }

    public final boolean startsWith(String prefix) {
        return this.startsWith(new OpenString(prefix), 0);
    }

    public final boolean endsWith(OpenString suffix) {
        return this.startsWith(suffix, this.count - suffix.count);
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        this.hashcode = v11hash ? this.hashCode11() : this.hashCode12();
        return this.hashcode;
    }

    public int hashCode11() {
        int h = 0;
        int off = this.offset;
        char[] val = this.value;
        int len = this.count;
        if (len < 16) {
            int i = len;
            while (i > 0) {
                h = h * 37 + val[off++];
                --i;
            }
        } else {
            int skip = len / 8;
            int i = len;
            while (i > 0) {
                h = h * 39 + val[off];
                i -= skip;
                off += skip;
            }
        }
        return h;
    }

    public int hashCode12() {
        int h = 0;
        int off = this.offset;
        char[] val = this.value;
        int len = this.count;
        int i = 0;
        while (i < len) {
            h = 31 * h + val[off++];
            ++i;
        }
        return h;
    }

    public final int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.offset + this.count;
        char[] v = this.value;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.count) {
            return -1;
        }
        int i = this.offset + fromIndex;
        while (i < max) {
            if (v[i] == ch) {
                return i - this.offset;
            }
            ++i;
        }
        return -1;
    }

    public final int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.count - 1);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        int min = this.offset;
        char[] v = this.value;
        int i = this.offset + (fromIndex >= this.count ? this.count - 1 : fromIndex);
        while (i >= min) {
            if (v[i] == ch) {
                return i - this.offset;
            }
            --i;
        }
        return -1;
    }

    public final int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public final int indexOf(String str, int fromIndex) {
        return this.indexOf(new OpenString(str), fromIndex);
    }

    public final int indexOf(OpenString str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(OpenString str, int fromIndex) {
        char[] v1 = this.value;
        char[] v2 = str.value;
        int max = this.offset + (this.count - str.count);
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.count) {
            return -1;
        }
        if (str.count == 0) {
            return fromIndex;
        }
        int str_offset = str.offset;
        char first = v2[str_offset];
        int i = this.offset + fromIndex;
        block0: while (true) {
            if (i <= max && v1[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + str.count - 1;
            int k = str_offset + 1;
            while (j < end) {
                if (v1[j++] == v2[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i - this.offset;
    }

    public final int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public final int lastIndexOf(String str, int fromIndex) {
        return this.lastIndexOf(new OpenString(str), fromIndex);
    }

    public final int lastIndexOf(OpenString str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(OpenString str, int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > this.count - str.count) {
            fromIndex = this.count - str.count;
        }
        if (str.count == 0) {
            return fromIndex;
        }
        char[] v1 = this.value;
        char[] v2 = str.value;
        int i = this.offset + fromIndex;
        while (i >= this.offset) {
            int n = str.count;
            int thisIndex = i;
            int strIndex = str.offset;
            while (v1[thisIndex++] == v2[strIndex++]) {
                if (--n > 0) continue;
                return i - this.offset;
            }
            --i;
        }
        return -1;
    }

    public final OpenString substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    public OpenString substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.count) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        return beginIndex == 0 && endIndex == this.count ? this : new OpenString(this.offset + beginIndex, endIndex - beginIndex, this.value);
    }

    public OpenString concat(OpenString str) {
        int otherLen = str.length();
        if (otherLen == 0) {
            return this;
        }
        char[] buf = new char[this.count + otherLen];
        this.getChars(0, this.count, buf, 0);
        str.getChars(0, otherLen, buf, this.count);
        return new OpenString(0, this.count + otherLen, buf);
    }

    public OpenString replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            int len = this.count;
            int i = -1;
            while (++i < len) {
                if (this.value[this.offset + i] == oldChar) break;
            }
            if (i < len) {
                char[] buf = new char[len];
                int j = 0;
                while (j < i) {
                    buf[j] = this.value[this.offset + j];
                    ++j;
                }
                while (i < len) {
                    char c = this.value[this.offset + i];
                    buf[i] = c == oldChar ? newChar : c;
                    ++i;
                }
                return new OpenString(0, len, buf);
            }
        }
        return this;
    }

    public void lowerCase() {
        this.hashcode = 0;
        int i = this.count;
        while (i-- > 0) {
            this.value[this.offset + i] = Character.toLowerCase(this.value[this.offset + i]);
        }
    }

    public void upperCase() {
        this.hashcode = 0;
        int i = this.count;
        while (i-- > 0) {
            this.value[this.offset + i] = Character.toUpperCase(this.value[this.offset + i]);
        }
    }

    public String toLowerCase() {
        StringBuffer result = new StringBuffer();
        int len = this.count;
        int i = 0;
        while (i < len) {
            result.append(Character.toLowerCase(this.value[this.offset + i]));
            ++i;
        }
        return result.toString();
    }

    public String toUpperCase() {
        StringBuffer result = new StringBuffer();
        int len = this.count;
        int i = 0;
        while (i < len) {
            result.append(Character.toUpperCase(this.value[this.offset + i]));
            ++i;
        }
        return result.toString();
    }

    public OpenString trim() {
        int len = this.count;
        int st = 0;
        while (st < len && this.value[this.offset + st] <= ' ') {
            ++st;
        }
        while (st < len && this.value[this.offset + len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < this.count ? this.substring(st, len) : this;
    }

    public final String toString() {
        return new String(this.value, this.offset, this.count);
    }

    public char[] toCharArray() {
        int max = this.length();
        char[] result = new char[max];
        this.getChars(0, max, result, 0);
        return result;
    }

    public static final OpenString valueOf(char[] data) {
        return new OpenString(0, data.length, data);
    }

    public static final OpenString valueOf(char[] data, int offset, int count) {
        return new OpenString(offset, count, data);
    }

    public static final OpenString copyValueOf(char[] data, int offset, int count) {
        return new OpenString(data, offset, count);
    }

    public static final OpenString copyValueOf(char[] data) {
        return OpenString.copyValueOf(data, 0, data.length);
    }

    static {
        String v = System.getProperty("java.version", "1.0.0");
        v11hash = v.startsWith("1.1") || v.startsWith("1.0");
    }
}

