/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import iubio.readseq.GenbankDoc;
import iubio.readseq.SeqFileInfo;
import java.text.SimpleDateFormat;
import java.util.Date;

class GenbankSeqWriter
extends BioseqWriter {
    static final int seqwidth = 60;
    static final int ktab = 0;
    static final int kspacer = 10;
    static final int knumwidth = 9;
    static final int knumflags = 0;
    String datestr;
    int seqkind;

    GenbankSeqWriter() {
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.spacer = 10;
        this.opts.seqwidth = 60;
        this.opts.numleft = true;
        this.opts.numwidth = 9;
        this.seqkind = this.bioseq.getSeqtype();
    }

    public void writeRecordEnd() {
        this.writeln("//");
    }

    public void writeSeq() {
        int nout = 0;
        int origin = this.opts.origin;
        boolean rev = this.opts.reversed;
        boolean newline = true;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] ba = this.bioseq.toBytes();
            int i = 0;
            while (i < this.seqlen) {
                if (newline) {
                    int ib = rev ? origin - i : origin + i;
                    this.writeString(Fmt.fmt(ib, 9, 0));
                    this.writeByte(32);
                    newline = false;
                }
                this.writeByte(ba[this.offset + i]);
                if (i % 60 == 59) {
                    this.writeln();
                    newline = true;
                } else if (i % 10 == 9) {
                    this.writeByte(32);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.seqlen) {
                if (newline) {
                    int ib = rev ? origin - nout : origin + nout;
                    this.writeString(Fmt.fmt(ib, 9, 0));
                    this.writeByte(32);
                    newline = false;
                }
                char bc = this.bioseq.base(this.offset + i, this.fBasePart);
                if (this.testbaseKind == 1) {
                    bc = (char)this.testbase.outSeqChar(bc);
                }
                if (bc > '\u0000') {
                    this.writeByte(bc);
                    if ((++nout - 1) % 60 == 59) {
                        this.writeln();
                        newline = true;
                    } else if ((nout - 1) % 10 == 9) {
                        this.writeByte(32);
                    }
                }
                ++i;
            }
        }
        if (!newline) {
            this.writeln();
        }
    }

    protected void writeID() {
        this.writeString("LOCUS       ");
        this.writeString(Fmt.fmt(this.idword, 11, 2));
        this.writeString(Fmt.fmt(this.seqlen, 7, 0));
        if (this.seqkind == 4) {
            this.writeString(" aa ");
        } else {
            this.writeString(" bp ");
        }
        String skind = SeqInfo.getKindLabel(this.seqkind);
        this.writeString(Fmt.fmt(skind, 6, 0));
        this.writeString("             UNA       ");
        if (this.datestr == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
            this.datestr = sdf.format(new Date());
        }
        this.writeString(this.datestr);
        this.writeln();
    }

    protected final void writeTitle() {
        this.writeString("DEFINITION  ");
        this.writeln(this.seqid);
    }

    public void writeDoc() {
        String cks = this.checksumString();
        if (this.seqdoc instanceof BioseqDoc) {
            GenbankDoc doc = new GenbankDoc((BioseqDoc)this.seqdoc);
            if (this.seqkind == 4) {
                doc.setAmino(true);
            }
            boolean doid = true;
            String docid = doc.getID();
            if (docid == null || !this.idword.startsWith(SeqFileInfo.gBlankSeqid) && !docid.equals(this.idword)) {
                this.writeID();
                doid = false;
            }
            if (!doid && doc.getTitle() == null) {
                this.writeTitle();
            }
            doc.replaceDocField(112, String.valueOf(this.seqlen));
            if (cks.length() > 0) {
                doc.replaceDocField(114, cks);
            }
            this.linesout += doc.writeTo(this.douts, doid);
        } else {
            this.writeID();
            this.writeTitle();
            if (cks.length() > 0) {
                this.writeString("COMMENT     ");
                this.writeln(cks);
            }
        }
        this.writeln("ORIGIN      ");
    }
}

