/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Utils;
import iubio.readseq.BioseqDocImpl;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

class GetFeaturelist {
    static String[] flist;
    static String footer;
    String title;
    String message;
    Object[] messagepack;
    int[] selindices = new int[0];
    JFrame frame;
    JList jlist;

    static void initlist() {
        flist = BioseqDocImpl.getStandardFeatureList();
        if (flist == null) {
            flist = new String[]{"exon", "intron", "CDS"};
        }
    }

    GetFeaturelist(JFrame frame, String title, String message) {
        this.message = message;
        this.title = title;
        this.frame = frame;
        this.makeUi();
    }

    String getValue() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.selindices.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(flist[this.selindices[i]]);
            ++i;
        }
        String val = sb.toString();
        return val;
    }

    void setValue(String vals) {
        String[] ss = Utils.splitString(vals, ", ");
        int n = 0;
        if (ss != null) {
            int i = 0;
            while (i < ss.length) {
                int k = 0;
                while (k < flist.length) {
                    if (flist[k].equals(ss[i])) {
                        ++n;
                    }
                    ++k;
                }
                ++i;
            }
        }
        this.selindices = new int[n];
        n = 0;
        if (ss != null) {
            int i = 0;
            while (i < ss.length) {
                int k = 0;
                while (k < flist.length) {
                    if (flist[k].equals(ss[i])) {
                        this.selindices[n++] = k;
                    }
                    ++k;
                }
                ++i;
            }
        }
    }

    public boolean choose() {
        this.jlist.setSelectedIndices(this.selindices);
        int result = JOptionPane.showConfirmDialog(this.frame, this.messagepack, this.title, 2, 3);
        if (result != 0) {
            return false;
        }
        this.selindices = this.jlist.getSelectedIndices();
        return this.selindices.length > 0;
    }

    void makeUi() {
        this.jlist = new JList<String>(flist);
        this.jlist.setVisibleRowCount(10);
        JScrollPane sp = new JScrollPane(this.jlist);
        JLabel jfoot = new JLabel(footer, 0);
        jfoot.setFont(new Font("sanserif", 0, 10));
        jfoot.setEnabled(true);
        jfoot.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        this.messagepack = new Object[3];
        this.messagepack[0] = this.message;
        this.messagepack[1] = jfoot;
        this.messagepack[2] = sp;
    }

    static {
        GetFeaturelist.initlist();
        footer = "Selections apply when input data have feature tables.";
    }
}

