/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.MobyContentClipboard;
import ca.ucalgary.seahawk.gui.MobyContentGUI;
import ca.ucalgary.seahawk.util.HTMLUtils;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.biomoby.shared.data.MobyContentInstance;

public class FileAndTextTransferHandler
extends TransferHandler {
    private DataFlavor fileFlavor;
    private DataFlavor stringFlavor;
    private MobyContentGUI gui;
    private boolean openDataInNewTab;

    public FileAndTextTransferHandler(MobyContentGUI mcg) {
        this(mcg, true);
    }

    public FileAndTextTransferHandler(MobyContentGUI mcg, boolean openNewDataInNewTab) {
        this.gui = mcg;
        this.openDataInNewTab = openNewDataInNewTab;
        this.fileFlavor = DataFlavor.javaFileListFlavor;
        this.stringFlavor = DataFlavor.stringFlavor;
    }

    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            System.err.println("Cannot drop data into Seahawk: " + t);
            return false;
        }
        MobyContentClipboard clipboard = null;
        if (!this.openDataInNewTab) {
            for (Container container = c; container != null; container = container.getParent()) {
                if (!(container instanceof MobyContentClipboard)) continue;
                clipboard = (MobyContentClipboard)container;
                break;
            }
        }
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                for (File file : (List)t.getTransferData(DataFlavor.javaFileListFlavor)) {
                    URL u = HTMLUtils.checkForURLShortcut(file);
                    if (u != null) {
                        System.err.println("Dropped item appears to be a URL shortcut...");
                        if (clipboard != null) {
                            clipboard.addCollectionData(u);
                            continue;
                        }
                        this.gui.loadPaneFromURL(u, this.openDataInNewTab);
                        continue;
                    }
                    System.err.println("Dropped item appears to be a file...");
                    if (clipboard != null) {
                        clipboard.addCollectionData(file.toURI().toURL());
                        continue;
                    }
                    this.gui.loadPaneFromURL(file.toURI().toURL(), this.openDataInNewTab);
                }
                return true;
            }
            if (this.hasTextFlavor(t.getTransferDataFlavors())) {
                MobyContentInstance content;
                boolean NOT_JUST_PLAIN_TEXT = false;
                String text = this.convertToString(t, NOT_JUST_PLAIN_TEXT);
                String linktext = HTMLUtils.checkForHyperlinkText(text);
                URL u = null;
                try {
                    u = new URL(linktext == null ? text : linktext);
                }
                catch (MalformedURLException murle) {
                    // empty catch block
                }
                if (u != null) {
                    System.err.println("Dropped item appears to be a URL...");
                    if (clipboard != null) {
                        clipboard.addCollectionData(u);
                    } else {
                        this.gui.loadPaneFromURL(u, this.openDataInNewTab);
                    }
                    return true;
                }
                if (clipboard != null) {
                    boolean PLAIN_TEXT = true;
                    text = this.convertToString(t, PLAIN_TEXT);
                }
                if ((content = HTMLUtils.checkForMobyXML(text)) != null) {
                    System.err.println("Dropped item appears to be moby xml...");
                    if (clipboard != null) {
                        clipboard.addCollectionData(content);
                    } else {
                        this.gui.loadPaneFromObject(content, this.openDataInNewTab);
                    }
                    return true;
                }
                String suffix = "";
                if (text.indexOf("{\\rtf") == 0) {
                    suffix = ".rtf";
                } else if (text.indexOf("<") != -1 && text.indexOf(">") > text.indexOf("<") && text.indexOf("/") != -1) {
                    suffix = ".html";
                }
                File savedFile = File.createTempFile("seahawkDataDrop", suffix);
                savedFile.deleteOnExit();
                FileOutputStream out = new FileOutputStream(savedFile);
                if (suffix.equals(".html")) {
                    if (text.indexOf("??") == 0) {
                        text = text.substring(2);
                    }
                    if (text.indexOf("<html") == -1) {
                        out.write("<html>".getBytes());
                        out.write(text.getBytes());
                        out.write("</html>".getBytes());
                    }
                } else {
                    out.write(text.getBytes());
                }
                out.close();
                if (clipboard != null) {
                    clipboard.addCollectionData(savedFile.toURI().toURL());
                } else {
                    this.gui.loadPaneFromURL(savedFile.toURI().toURL(), this.openDataInNewTab);
                }
                return true;
            }
            System.err.println("Cannot drop data into Seahawk, data was neither a file, nor text");
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor:" + ufe);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("importData: I/O exception: " + ioe);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("importData: General exception: " + e);
        }
        return false;
    }

    public String convertToString(Transferable t, boolean get_plain_text) throws Exception {
        StringBuffer textBuffer = new StringBuffer();
        Reader reader = get_plain_text ? DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(t) : DataFlavor.selectBestTextFlavor(t.getTransferDataFlavors()).getReaderForText(t);
        char[] buffer = new char[4096];
        int charsRead = reader.read(buffer);
        while (charsRead != -1) {
            textBuffer.append(buffer, 0, charsRead);
            charsRead = reader.read(buffer);
        }
        return textBuffer.toString().replaceAll("\u0000", "");
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        if (this.hasFileFlavor(flavors)) {
            return true;
        }
        return this.hasTextFlavor(flavors);
    }

    protected boolean hasFileFlavor(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasTextFlavor(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!flavor.isFlavorTextType()) continue;
            return true;
        }
        return false;
    }
}

