/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.FileAndTextTransferHandler;
import ca.ucalgary.seahawk.gui.MobyContentGUI;
import ca.ucalgary.seahawk.gui.MobyContentPane;
import ca.ucalgary.seahawk.gui.MobyServicesGUI;
import ca.ucalgary.seahawk.services.MobyClient;
import ca.ucalgary.seahawk.util.DataRecorder;
import ca.ucalgary.seahawk.util.HTMLUtils;
import ca.ucalgary.seahawk.util.MobyUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;
import org.biomoby.client.MobyRequestEventHandler;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataJob;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataString;
import org.biomoby.shared.data.MobyDataUtils;

public class MobyContentClipboard
extends MobyContentPane
implements ActionListener {
    public static final String CLEAR_CLIPBOARD_OPTION = "Clear Clipboard";
    public static final String CLIPBOARD_FILE_NAME = "SeaHawkClipboard";
    public static final String CLIPBOARD_COLLECTION_NAME = "Clipboard Collection";
    public static final String CLIPBOARD_QUERY_NAME = "Clipboard";
    public static final String CLIPBOARD_TAB_NAME = "Clipboard";
    public static final Color CLIPBOARD_TAB_COLOR = Color.blue;
    public static final String CLIPBOARD_TAB_ICON_RESOURCE = "ca/ucalgary/seahawk/resources/images/clipboard.gif";
    private static ImageIcon clipboardIcon;
    private MobyContentInstance content;
    private File clipboardFile;
    private MobyDataJob query;
    private MobyDataObjectSet collection;
    private String previousImportDataType = null;
    private JMenuItem deleteDataPopupItem;
    private MobyDataInstance itemToDelete;
    private static Logger logger;

    public MobyContentClipboard(MobyContentGUI cGUI, MobyServicesGUI sGUI, JTabbedPane parentComponent, DataRecorder recorder, JLabel statusBar) {
        super(cGUI, sGUI, parentComponent, recorder, statusBar);
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (clipboardIcon == null) {
            URL u = cl.getResource(CLIPBOARD_TAB_ICON_RESOURCE);
            if (u == null) {
                logger.warn("Could not find icon resource ca/ucalgary/seahawk/resources/images/clipboard.gif");
            } else {
                clipboardIcon = new ImageIcon(u);
            }
        }
        this.query = new MobyDataJob();
        this.content = new MobyContentInstance();
        this.content.put("Clipboard", this.query);
        this.collection = new MobyDataObjectSet(CLIPBOARD_COLLECTION_NAME);
        this.deleteDataPopupItem = new JMenuItem("Delete from Clipboard");
        this.deleteDataPopupItem.addActionListener(this);
        try {
            this.clipboardFile = File.createTempFile(CLIPBOARD_FILE_NAME, ".xml");
        }
        catch (Exception e) {
            logger.error("Clipboard failed to initialize, cannot create temp file:" + e);
            return;
        }
        this.clipboardFile.deleteOnExit();
        this.setTransferHandler(new FileAndTextTransferHandler(cGUI, false));
        this.editorPane.setTransferHandler(this.getTransferHandler());
        sGUI.setClipboard(this);
    }

    public void stateChanged(ChangeEvent ce) {
    }

    public void init() {
        int index = this.tabbedPane.indexOfComponent(this);
        this.tabbedPane.setIconAt(index, clipboardIcon);
        this.tabbedPane.setForegroundAt(index, CLIPBOARD_TAB_COLOR);
        this.tabbedPane.setTitleAt(index, "Clipboard");
    }

    public boolean canGoBack() {
        return false;
    }

    public boolean canGoForward() {
        return false;
    }

    protected void addExtraMobyOptions(JPopupMenu popup, MobyDataInstance mdi) {
        if (!(mdi instanceof MobyDataObject) || !this.collection.contains(mdi)) {
            mdi.setXmlMode(891);
            System.err.println("Skipping " + mdi.toXML());
            mdi.setXmlMode(124);
            return;
        }
        this.itemToDelete = mdi;
        popup.add(this.deleteDataPopupItem);
        popup.setVisible(true);
    }

    public boolean removeCollectionData(MobyDataInstance itemToDelete) {
        return this.collection.remove(itemToDelete);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteDataPopupItem) {
            if (this.itemToDelete != null) {
                this.collection.remove(this.itemToDelete);
                this.updateDisplay();
            }
        } else {
            logger.warn("Clipboard: ignoring unrecognized source of event " + e);
        }
    }

    public void addData(String title, MobyDataInstance mdi) {
        this.query.put(title, mdi);
        this.updateDisplay();
    }

    public void addCollectionData(MobyDataInstance mdi) {
        this.addCollectionData(mdi, true);
    }

    public void addCollectionData(MobyDataInstance mdi, boolean updateDisplay) {
        if (mdi == null) {
            logger.warn("Cannot add null object to the clipboard.");
            return;
        }
        if (!this.query.containsKey(CLIPBOARD_COLLECTION_NAME)) {
            this.query.put(CLIPBOARD_COLLECTION_NAME, this.collection);
        }
        if (mdi instanceof MobyDataObjectSet) {
            this.collection.addAll((MobyDataObjectSet)mdi);
        } else if (mdi instanceof MobyDataObject) {
            this.collection.add((MobyDataObject)mdi);
        } else {
            logger.warn("Cannot add object of class " + mdi.getClass() + " to the clipboard, only MobyDataObject and MobyDataObjectSet" + " are supported");
            return;
        }
        if (updateDisplay) {
            this.updateDisplay();
        }
    }

    public void addCollectionData(MobyContentInstance mci) {
        for (MobyDataJob job : mci.values()) {
            for (MobyDataInstance data : job.getPrimaryData()) {
                this.addCollectionData(data, false);
            }
        }
        this.updateDisplay();
    }

    public void addCollectionData(URL u) {
        String selection;
        MobyDataObject[] mobyDataFound;
        try {
            MobyContentInstance mobyContents = MobyUtils.convertURLtoMobyBinaryData(this.servicesGUI.getMobyClient(), u);
            if (mobyContents != null) {
                this.addCollectionData(mobyContents);
                return;
            }
        }
        catch (Exception e) {
            logger.warn("Could not transform binary file (" + u + "): " + e);
        }
        MobyClient client = this.servicesGUI.getMobyClient();
        if (client == null) {
            logger.warn("Could not get MOBY client from MOBY services GUI, cannot transform incoming clipboard data to MOBY objects");
        }
        String urlContents = null;
        try {
            urlContents = HTMLUtils.getURLContents(u);
        }
        catch (Exception e) {
            logger.warn("Could not read contents of the URL to import to the clipboard (" + u + "):" + e);
            return;
        }
        MobyDataType targetDataType = null;
        if (this.collection != null) {
            targetDataType = this.collection.getDataType();
        }
        if ((mobyDataFound = client.getMobyObjects(urlContents, targetDataType)).length == 1) {
            this.addCollectionData(mobyDataFound[0]);
            return;
        }
        if (mobyDataFound.length == 0) {
            if (targetDataType == null || "Object".equals(targetDataType.getName())) {
                this.addCollectionData(new MobyDataString((CharSequence)urlContents));
                return;
            }
            mobyDataFound = client.getMobyObjects(urlContents);
            if (mobyDataFound.length == 1) {
                this.addCollectionData(mobyDataFound[0]);
                return;
            }
            if (mobyDataFound.length == 0) {
                this.addCollectionData(new MobyDataString((CharSequence)urlContents));
                return;
            }
        }
        Object[] selectionValues = new String[mobyDataFound.length];
        for (int i = 0; i < mobyDataFound.length; ++i) {
            selectionValues[i] = mobyDataFound[i].getDataType().getName();
            if (!"Object".equals(selectionValues[i]) || mobyDataFound[i].getPrimaryNamespace() == null) continue;
            int n = i;
            selectionValues[n] = (String)selectionValues[n] + " (" + mobyDataFound[i].getPrimaryNamespace().getName() + ")";
        }
        Object initialSelectionValue = selectionValues[0];
        if (this.previousImportDataType != null) {
            for (Object selectionValue : selectionValues) {
                if (!this.previousImportDataType.equals(selectionValue)) continue;
                initialSelectionValue = selectionValue;
                break;
            }
        }
        if ((selection = (String)JOptionPane.showInputDialog(this, "Paste data as...", "Data import choice", -1, null, selectionValues, initialSelectionValue)) == null) {
            logger.warn("No data type for import selected, abandoning import");
            return;
        }
        for (int i = 0; i < selectionValues.length; ++i) {
            if (!selection.equals(selectionValues[i])) continue;
            this.addCollectionData(mobyDataFound[i]);
            this.previousImportDataType = selection;
            return;
        }
    }

    public boolean hasXMLSource() {
        return true;
    }

    public String getXMLSource() throws IOException {
        return HTMLUtils.getInputStreamContents(this.clipboardFile.toURI().toURL().openStream());
    }

    public URL getCurrentURL() {
        try {
            return this.clipboardFile.toURI().toURL();
        }
        catch (MalformedURLException murle) {
            logger.warn("Could not get clipboard file URL: " + murle);
            return null;
        }
    }

    public void updateDisplay() {
        try {
            FileOutputStream os = new FileOutputStream(this.clipboardFile);
            MobyDataUtils.toXMLDocument(os, this.content);
            os.close();
            this.gotoURL(this.clipboardFile.toURI().toURL(), false);
        }
        catch (Exception e) {
            logger.error("Clipboard failed to update the display, cannot write or load temp file:" + e);
            e.printStackTrace();
            return;
        }
        this.tabbedPane.setTitleAt(this.tabbedPane.indexOfComponent(this), "Clipboard: " + this.getResponseType(this.content));
        this.contentGUI.setVisible(true);
    }

    public MobyContentInstance getContents() {
        return this.content;
    }

    public MobyDataObjectSet getCollection() {
        return this.collection;
    }

    protected MobyRequestEventHandler getDefaultHandler() {
        return null;
    }

    public void clearData() {
        this.query.clear();
        this.collection.clear();
        this.updateDisplay();
    }

    static {
        logger = Logger.getLogger(MobyContentClipboard.class);
    }
}

