/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.gui;

import ca.ucalgary.seahawk.gui.FileAndTextTransferHandler;
import ca.ucalgary.seahawk.gui.MobyContentGUI;
import ca.ucalgary.seahawk.gui.MobySaveDialog;
import ca.ucalgary.seahawk.gui.MobyServicesGUI;
import ca.ucalgary.seahawk.util.BrowserLauncher;
import ca.ucalgary.seahawk.util.CloseTabIcon;
import ca.ucalgary.seahawk.util.DataRecorder;
import ca.ucalgary.seahawk.util.DynamicJPopupMenu;
import ca.ucalgary.seahawk.util.HTMLUtils;
import ca.ucalgary.seahawk.util.MobyUtils;
import ca.ucalgary.seahawk.util.PrintableJEditorPane;
import ca.ucalgary.seahawk.util.SeahawkOptions;
import ca.ucalgary.seahawk.util.TEX2HTML;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.biomoby.client.MobyRequest;
import org.biomoby.client.MobyRequestEvent;
import org.biomoby.client.MobyRequestEventHandler;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.NoSuccessException;
import org.biomoby.shared.SOAPException;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataJob;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataString;
import org.biomoby.shared.data.MobyDataUtils;
import org.biomoby.shared.parser.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MobyContentPane
extends JPanel
implements Printable,
CaretListener,
HyperlinkListener,
MouseListener,
MobyRequestEventHandler,
KeyListener,
ChangeListener {
    public static final String MOBY_SERVICE_POPUP_NAME = "seahawkServicePopup";
    public static final String WAITING_TAB_ICON_RESOURCE = "ca/ucalgary/seahawk/resources/images/hourglass.gif";
    public static final String FAILED_TAB_ICON_RESOURCE = "ca/ucalgary/seahawk/resources/images/failed.gif";
    public static final String LOADED_TAB_ICON_RESOURCE = "ca/ucalgary/seahawk/resources/images/document.gif";
    private static final int TAB_ICON_SPACER = 2;
    private static ImageIcon hourglassIcon;
    private static ImageIcon failedIcon;
    private static ImageIcon loadedIcon;
    private static ImageIcon closeIcon;
    public static final String XSL_DOC_SOURCE_PARAM = "sourceURL";
    private JScrollPane scrollPane;
    protected JTabbedPane tabbedPane;
    private JLabel status;
    protected PrintableJEditorPane editorPane;
    protected MobyServicesGUI servicesGUI;
    protected MobyContentGUI contentGUI;
    private Vector<URL> history;
    private HashMap<URL, String> historyTabLabels;
    private int historyIndex = -1;
    private int lastClickX = 1;
    private int lastClickY = 1;
    private boolean hasFailed = false;
    private boolean isContentsXML = false;
    private DataRecorder dataRecorder;
    private int dot;
    private int mark;
    private String selectedTextData;
    private static Logger logger;

    public MobyContentPane(MobyContentGUI cGUI, MobyServicesGUI sGUI, JTabbedPane parentComponent, DataRecorder recorder, JLabel statusBar) {
        URL u;
        this.tabbedPane = parentComponent;
        this.status = statusBar;
        this.contentGUI = cGUI;
        this.servicesGUI = sGUI;
        this.dataRecorder = recorder;
        this.addKeyListener(this);
        this.setTransferHandler(new FileAndTextTransferHandler(cGUI));
        this.tabbedPane.addChangeListener(this);
        this.editorPane = new PrintableJEditorPane();
        this.editorPane.addKeyListener(this);
        this.editorPane.setTransferHandler(this.getTransferHandler());
        this.editorPane.setEditable(false);
        this.editorPane.addMouseListener(this);
        this.editorPane.addHyperlinkListener(this);
        this.editorPane.addCaretListener(this);
        this.scrollPane = new JScrollPane(this.editorPane);
        this.add(this.scrollPane);
        this.history = new Vector();
        this.historyTabLabels = new HashMap();
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (hourglassIcon == null) {
            u = cl.getResource(WAITING_TAB_ICON_RESOURCE);
            if (u == null) {
                logger.warn("Could not find icon resource ca/ucalgary/seahawk/resources/images/hourglass.gif");
            } else {
                hourglassIcon = new ImageIcon(u);
            }
        }
        if (failedIcon == null) {
            u = cl.getResource(FAILED_TAB_ICON_RESOURCE);
            if (u == null) {
                logger.warn("Could not find icon resource ca/ucalgary/seahawk/resources/images/failed.gif");
            } else {
                failedIcon = new ImageIcon(u);
            }
        }
        if (loadedIcon == null) {
            u = cl.getResource(LOADED_TAB_ICON_RESOURCE);
            if (u == null) {
                logger.warn("Could not find icon resource ca/ucalgary/seahawk/resources/images/document.gif");
            } else {
                loadedIcon = new ImageIcon(u);
            }
        }
    }

    public void stateChanged(ChangeEvent ce) {
        block8: {
            Icon currentIcon;
            int tabIndex = this.tabbedPane.indexOfComponent(this);
            Icon icon = currentIcon = tabIndex < 0 ? null : this.tabbedPane.getIconAt(tabIndex);
            if (tabIndex == this.tabbedPane.getSelectedIndex() && this.tabbedPane.getTabCount() > 1) {
                try {
                    if (currentIcon == null) {
                        this.tabbedPane.setIconAt(tabIndex, new CloseTabIcon());
                        return;
                    }
                    if (currentIcon instanceof CloseTabIcon) break block8;
                    try {
                        this.tabbedPane.setIconAt(tabIndex, new CloseTabIcon(currentIcon, 2));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.tabbedPane.setDisabledIconAt(tabIndex, currentIcon);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (currentIcon != null && currentIcon instanceof CloseTabIcon) {
                this.tabbedPane.setIconAt(tabIndex, ((CloseTabIcon)currentIcon).getSecondIcon());
                this.tabbedPane.setDisabledIconAt(tabIndex, ((CloseTabIcon)currentIcon).getSecondIcon());
            }
        }
    }

    public void setPreferredSize(Dimension dims) {
        super.setPreferredSize(dims);
        this.scrollPane.setPreferredSize(dims);
    }

    public boolean hasXMLSource() {
        return this.isContentsXML && this.historyIndex != -1;
    }

    public String getXMLSource() throws IOException {
        if (!this.hasXMLSource()) {
            return null;
        }
        return HTMLUtils.getURLContents(this.history.elementAt(this.historyIndex));
    }

    public String getHTMLSource() {
        return this.editorPane.getText();
    }

    public void gotoURL(URL url, boolean addToHistory) {
        if (url == null) {
            logger.warn("Ignoring null URL in MobyContentPane.gotoURL()");
            return;
        }
        try {
            StringBuffer resultBuffer = new StringBuffer(1000);
            String urlString = url.toString().toLowerCase();
            String protocol = url.getProtocol();
            URLConnection urlCon = url.openConnection();
            boolean unformatted = false;
            if (urlString.endsWith(".xml") || "text/xml".equals(urlCon.getContentType())) {
                this.editorPane.setContentType("text/html");
                this.isContentsXML = true;
                this.contentGUI.getTransformer().setParameter(XSL_DOC_SOURCE_PARAM, url.toString());
                String htmlContents = "[Seahawk Internal Error]";
                try {
                    StringWriter stringWriter = new StringWriter(1000);
                    this.contentGUI.getTransformer().transform(new StreamSource(url.openStream()), new StreamResult(stringWriter));
                    htmlContents = stringWriter.toString();
                    htmlContents = HTMLUtils.encapsulateBinaryData(url, htmlContents, SeahawkOptions.getRegistry());
                }
                catch (TransformerException te) {
                    this.status.setText("Sorry!  Could not transform the MOBY data into presentation form");
                    logger.error("Sorry!  Could not transform the MOBY data into presentation form: " + te);
                    return;
                }
                catch (Exception e) {
                    this.status.setText("Note: There was an error transforming the MOBY data into presentation form, it may not be displayed correctly");
                    logger.error("Note: There was an error transforming the MOBY data into presentation form, it may not be displayed correctly");
                }
                htmlContents = htmlContents.replaceAll(">[ \\t\\r\\n]+<", "><");
                int origHash = htmlContents.hashCode();
                htmlContents = htmlContents.replaceAll(">(([^<]*\t){3,}[^<]+)<", "><pre>$1</pre><");
                htmlContents = htmlContents.replaceAll(">([^<]*       [^<]*)<", "><pre>$1</pre><");
                if (htmlContents.hashCode() == origHash) {
                    htmlContents = htmlContents.replaceAll("([a-zA-Z]{80})", "\n<br><tt>$1</tt>");
                    htmlContents = htmlContents.replaceAll("([a-zA-Z]{80}</tt>)([a-zA-Z]{1,})", "$1\n<br><tt>$2</tt><br>\n");
                }
                resultBuffer.append(htmlContents);
            } else if ((protocol.equals("file") || protocol.equals("jar")) && (urlString.lastIndexOf(".xhtml") == urlString.length() - 6 || urlString.lastIndexOf(".html") == urlString.length() - 5 || urlString.lastIndexOf(".htm") == urlString.length() - 4) || urlString.lastIndexOf(".tex") == urlString.length() - 4) {
                this.editorPane.setContentType("text/html");
                this.isContentsXML = false;
                if (urlString.lastIndexOf(".tex") == urlString.length() - 4) {
                    resultBuffer.append(TEX2HTML.convert((String)HTMLUtils.getInputStreamContents(urlCon.getInputStream())));
                } else {
                    resultBuffer.append(HTMLUtils.getInputStreamContents(urlCon.getInputStream()));
                }
            } else if (protocol.equals("file") && urlString.lastIndexOf(".rtf") == urlString.length() - 4 || "text/richtext".equals(urlCon.getContentType()) || "text/rtf".equals(urlCon.getContentType())) {
                this.isContentsXML = false;
                this.editorPane.setContentType("text/rtf");
                resultBuffer.append(HTMLUtils.getInputStreamContents(urlCon.getInputStream()));
            } else {
                if (MobySaveDialog.isConvertible(urlCon)) {
                    urlCon = MobySaveDialog.convertToDisplayable(urlCon);
                    url = urlCon.getURL();
                }
                this.isContentsXML = false;
                this.editorPane.setContentType("text/html");
                String body = HTMLUtils.getURLContents(url);
                resultBuffer = body.toLowerCase().indexOf("<html") != -1 ? null : new StringBuffer("<html><body><pre>" + body.replaceAll("&", "&amp;").replaceAll("<", "&lt;") + "</pre></body></html>");
            }
            if (resultBuffer == null) {
                this.editorPane.setPage(url);
            } else if (resultBuffer.length() == 0 || unformatted) {
                try {
                    MobyContentInstance mobyContents = MobyUtils.convertURLtoMobyBinaryData(this.servicesGUI.getMobyClient(), url);
                    if (mobyContents != null) {
                        File mobyRepresentation = File.createTempFile("seahawkBase64BinData", ".xml");
                        mobyRepresentation.deleteOnExit();
                        FileWriter fw = new FileWriter(mobyRepresentation);
                        MobyDataUtils.toXMLDocument(fw, mobyContents);
                        fw.close();
                        this.gotoURL(mobyRepresentation.toURI().toURL(), addToHistory);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.editorPane.setText("Failure in loading MOBYfied binary data:\n" + e);
                    logger.error("Failure in loading MOBYfied binary data:\n" + e);
                }
                if (resultBuffer.length() == 0) {
                    this.editorPane.setPage(url);
                } else {
                    this.editorPane.setText(resultBuffer.toString());
                }
            } else {
                this.editorPane.setText(resultBuffer.toString());
                this.editorPane.getDocument().putProperty("stream", url);
            }
            this.editorPane.scrollToReference("start");
        }
        catch (Exception e) {
            this.status.setText("Warning: Could not read transformed (HTML) response from MOBY, or given panel contents: " + e);
            e.printStackTrace();
        }
        if (addToHistory) {
            if (this.historyIndex != this.history.size() - 1) {
                this.history.setSize(this.historyIndex + 1);
            }
            this.history.add(url);
            this.historyIndex = this.history.size() - 1;
            this.contentGUI.updateHistory(this);
        }
        if (this.historyTabLabels.containsKey(url)) {
            this.tabbedPane.setTitleAt(this.tabbedPane.indexOfComponent(this), this.historyTabLabels.get(url));
        }
    }

    public int getHistorySize() {
        return this.history.size();
    }

    public int getHistoryIndex() {
        return this.historyIndex;
    }

    public URL getCurrentURL() {
        if (this.historyIndex < 0 || this.historyIndex > this.history.size() - 1) {
            return null;
        }
        return this.history.elementAt(this.historyIndex);
    }

    public boolean canGoBack() {
        return this.historyIndex > 0;
    }

    public boolean canGoForward() {
        return this.historyIndex < this.history.size() - 1;
    }

    public void goForward() {
        if (this.canGoForward()) {
            this.gotoURL(this.history.elementAt(++this.historyIndex), false);
        }
    }

    public void goBackward() {
        if (this.canGoBack()) {
            this.gotoURL(this.history.elementAt(--this.historyIndex), false);
        }
    }

    public void start(MobyRequestEvent requestEvent) {
        this.hasFailed = false;
        this.tabbedPane.setSelectedComponent(this);
        this.tabbedPane.setTitleAt(this.tabbedPane.indexOfComponent(this), "" + requestEvent.getID() + "-" + requestEvent.getService().getName());
        this.setWaitScreen();
        try {
            this.dataRecorder.saveInputData(requestEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(MobyRequest request, int requestID) {
    }

    public void processEvent(MobyRequestEvent mre) {
        Throwable e = mre.getException();
        if (e != null) {
            this.failed("Exception occurred");
            if (e instanceof MobyException) {
                this.editorPane.setText("Failure in MOBY protocol:\n" + e);
                logger.error("Failure in MOBY protocol:\n" + e);
                return;
            }
            if (e instanceof SOAPException) {
                this.editorPane.setText("Failure in SOAP transaction:\n" + e);
                logger.error("Failure in SOAP transaction:\n" + e);
                return;
            }
            if (e instanceof NoSuccessException) {
                this.editorPane.setText("Failure in MOBY logic (input was not acceptable for this service):\n" + e);
                logger.error("Failure in MOBY logic (input was not acceptable for this service):\n" + e);
                return;
            }
            this.editorPane.setText("General Failure during MOBY action:\n" + e);
            logger.error("General Failure during MOBY action:\n" + e);
            e.printStackTrace();
            return;
        }
        this.loadDataInBrowser(mre);
    }

    public void failed(String msg) {
        int tabIndex = this.tabbedPane.indexOfComponent(this);
        if (tabIndex > -1) {
            try {
                this.tabbedPane.setIconAt(tabIndex, new CloseTabIcon((Icon)failedIcon, 2));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.tabbedPane.setIconAt(tabIndex, failedIcon);
            }
        } else {
            this.tabbedPane.setIconAt(tabIndex, failedIcon);
        }
        this.tabbedPane.setDisabledIconAt(tabIndex, failedIcon);
        this.tabbedPane.setTitleAt(tabIndex, msg);
        if (this.historyIndex != -1) {
            ++this.historyIndex;
            this.contentGUI.updateHistory(this);
        }
        this.isContentsXML = false;
        this.hasFailed = true;
    }

    public void succeeded(String msg) {
        int tabIndex = this.tabbedPane.indexOfComponent(this);
        if (tabIndex > -1 && this.tabbedPane.getTabCount() > 1) {
            try {
                this.tabbedPane.setIconAt(tabIndex, new CloseTabIcon((Icon)loadedIcon, 2));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.tabbedPane.setIconAt(tabIndex, loadedIcon);
            }
        } else {
            this.tabbedPane.setIconAt(tabIndex, loadedIcon);
        }
        this.tabbedPane.setDisabledIconAt(tabIndex, loadedIcon);
        this.tabbedPane.setTitleAt(tabIndex, msg);
        this.historyTabLabels.put(this.history.elementAt(this.historyIndex), msg);
        this.hasFailed = false;
    }

    public boolean hasFailure() {
        return this.hasFailed;
    }

    public String toScufl() throws Exception {
        URL[] historyToExport = this.history.toArray(new URL[this.history.size()]);
        if (this.historyIndex != historyToExport.length - 1) {
            URL[] truncatedHistory = new URL[this.historyIndex];
            System.arraycopy(historyToExport, 0, truncatedHistory, 0, this.historyIndex);
            historyToExport = truncatedHistory;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.dataRecorder.exportWorkflow(historyToExport, (OutputStream)output, 167);
        return output.toString();
    }

    protected void loadDataInBrowser(MobyRequestEvent mre) {
        ServiceException[] exs;
        MobyRequest mobyRequest = mre.getSource();
        MobyContentInstance responses = mre.getContent();
        if (responses == null || responses.size() == 0) {
            this.failed("No results");
            this.editorPane.setText("Warning: MOBY Service " + mobyRequest.getService().getName() + " did not return any results\n");
            return;
        }
        String responseType = this.getResponseType(responses);
        boolean hasContents = this.hasContents(responses);
        if (!hasContents && (exs = responses.getExceptions()) != null && exs.length != 0) {
            hasContents = true;
        }
        if (!hasContents) {
            this.failed("Empty response");
            this.editorPane.setText("Sorry: " + mobyRequest.getService().getName() + " executed successfully, but did not return data\n");
            return;
        }
        try {
            URL outputURL = this.dataRecorder.saveOutputData(mre);
            this.gotoURL(outputURL, true);
        }
        catch (Exception e) {
            this.failed("Could not write a local file");
            this.editorPane.setText("ERROR: Could not write temporary file for MOBY results: " + e);
            e.printStackTrace();
            return;
        }
        this.succeeded(responseType);
    }

    protected boolean hasContents(MobyContentInstance responses) {
        MobyDataObjectSet retrievedObjects = responses.retrieveObjects();
        return retrievedObjects != null && retrievedObjects.size() > 0;
    }

    protected String getResponseType(MobyContentInstance responses) {
        Iterator<String> i = responses.keySet().iterator();
        String responseType = "Empty";
        block0: while (i.hasNext()) {
            String responseName = i.next();
            MobyDataJob response = responses.get(responseName);
            if (response == null) {
                logger.warn("Skipping null response " + responseName);
            }
            for (String dataName : ((AbstractMap)response).keySet()) {
                String namespace;
                MobyDataType dataType;
                Object data = ((AbstractMap)response).get(dataName);
                if (data == null) {
                    logger.warn("Skipping null data '" + dataName + "' in response" + responseName);
                    continue;
                }
                if (data instanceof MobyPrimaryDataSimple) {
                    dataType = ((MobyPrimaryDataSimple)data).getDataType();
                    responseType = dataType == null ? "Object" : ((MobyPrimaryDataSimple)data).getDataType().getName();
                    namespace = this.getCommonNamespace((MobyPrimaryDataSimple)data);
                    if (namespace == null) continue block0;
                    responseType = responseType + " (" + namespace + ")";
                    continue block0;
                }
                if (!(data instanceof MobyPrimaryDataSet) || ((MobyPrimaryDataSet)data).getElements().length <= 0) continue;
                dataType = ((MobyPrimaryDataSet)data).getDataType();
                responseType = dataType == null ? "Object" : ((MobyPrimaryDataSet)data).getDataType().getName();
                if (((MobyPrimaryDataSet)data).getElements().length == 1) {
                    char c = responseType.toLowerCase().charAt(0);
                    responseType = "A" + (c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' ? "n" : "") + " " + responseType;
                } else {
                    responseType = ((MobyPrimaryDataSet)data).getElements().length + " " + responseType + "s";
                }
                if ((namespace = this.getCommonNamespace((MobyPrimaryDataSet)data)) == null) continue block0;
                responseType = responseType + " (" + namespace + ")";
                continue block0;
            }
        }
        return responseType;
    }

    protected String getCommonNamespace(MobyPrimaryData data) {
        MobyNamespace[] ns = data.getNamespaces();
        if (ns != null && ns.length == 1 && ns[0] != null && ns[0].getName() != null && ns[0].getName().length() != 0) {
            return ns[0].getName();
        }
        return null;
    }

    public void hyperlinkUpdate(HyperlinkEvent he) {
        String desc;
        URL targetURL = he.getURL();
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (targetURL == null) {
                desc = he.getDescription();
                if (desc.startsWith("#")) {
                    this.editorPane.scrollToReference(desc.substring(1));
                } else {
                    this.status.setText("Failed: could not parse hyperlink: " + he.getDescription());
                    logger.warn("Failed: could not parse hyperlink: " + he.getDescription());
                }
            } else if (targetURL.getHost() == null) {
                this.status.setText("Failed: could not get hyperlink host: " + targetURL);
                logger.warn("Failed: could not get hyperlink host: " + targetURL);
            } else if (this.isMobyURL(targetURL)) {
                this.status.setText("Retrieving service list for selected data");
                this.showMobyOptions(targetURL);
            } else {
                this.status.setText("Launching Web browser for external link...");
                try {
                    BrowserLauncher.openURL(targetURL.toString());
                }
                catch (IOException ioe) {
                    this.status.setText("Couldn't launch external browser");
                    logger.debug("Couldn't launch external browser for " + targetURL + " because of I/O exception: " + ioe);
                }
            }
        }
        if (he.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            if (this.isMobyURL(targetURL)) {
                this.status.setText("Click to discover more MOBY services");
            } else if (targetURL == null) {
                desc = he.getDescription();
                if (desc.startsWith("#")) {
                    this.status.setText("Scroll to section '" + desc.substring(1) + "'");
                }
            } else {
                this.status.setText("Launch external link " + targetURL);
            }
        }
        if (he.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.status.setText("");
        }
    }

    protected void showMobyOptions(URL targetURL) {
        String docFragID = targetURL.getRef();
        MobyDataInstance mobyData = null;
        mobyData = docFragID != null && docFragID.length() > 0 && this.contentGUI.getDocumentBuilder() != null ? this.loadMobyDataFromXPointer(targetURL) : this.loadMobyDataFromURLQuery(targetURL);
        if (mobyData == null) {
            logger.warn("Cannot create MOBY service list, could not extract MOBY Data Object from " + targetURL);
            return;
        }
        DynamicJPopupMenu popup = new DynamicJPopupMenu();
        popup.setName(MOBY_SERVICE_POPUP_NAME);
        this.addExtraMobyOptions(popup, mobyData);
        JMenuItem checkingLinksPopupItem = new JMenuItem("Check for services...");
        ((JPopupMenu)popup).add(checkingLinksPopupItem);
        popup.show(this, this.lastClickX + this.editorPane.getX(), this.lastClickY + this.editorPane.getY());
        this.servicesGUI.addPopupOptions(mobyData, (JPopupMenu)popup, true, this.getDefaultHandler());
        this.status.setText("Shift+Click=Service in new tab, Ctrl+Click=Use default 2nd params");
        if (popup.getSubElements().length > 0) {
            popup.setSelected(null);
            ((JPopupMenu)popup).setVisible(false);
            ((Container)popup).remove(checkingLinksPopupItem);
            if (popup.getSubElements().length > 0) {
                ((JPopupMenu)popup).setVisible(true);
            }
        }
    }

    protected void addExtraMobyOptions(JPopupMenu popup, MobyDataInstance mdi) {
    }

    protected MobyRequestEventHandler getDefaultHandler() {
        return this;
    }

    public void setWaitScreen() {
        this.editorPane.setContentType("text/plain");
        this.editorPane.setText("Your request is being processed. You can continue exploring in other tabs and windows while I wait for the results.");
        if (this.tabbedPane != null) {
            int tabIndex = this.tabbedPane.indexOfComponent(this);
            if (tabIndex > -1) {
                try {
                    this.tabbedPane.setIconAt(tabIndex, new CloseTabIcon((Icon)hourglassIcon, 2));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.tabbedPane.setIconAt(tabIndex, hourglassIcon);
                }
            } else {
                this.tabbedPane.setIconAt(tabIndex, hourglassIcon);
            }
            this.tabbedPane.setDisabledIconAt(tabIndex, hourglassIcon);
        }
    }

    protected MobyDataObject loadMobyDataFromURLQuery(URL targetURL) {
        String namespace = targetURL.getPath();
        namespace = namespace.substring(1);
        String query = targetURL.getQuery();
        String mobyID = null;
        String mobyString = null;
        String mobyName = "";
        MobyDataObject mobyData = null;
        if (query != null && query.length() > 0) {
            StringTokenizer queryTokenizer = new StringTokenizer(query, "&");
            while (queryTokenizer.hasMoreTokens()) {
                String token = queryTokenizer.nextToken();
                if (token == null) continue;
                if (mobyID == null && token.startsWith("id=")) {
                    if (token.length() > 3) {
                        mobyID = token.substring(3);
                        continue;
                    }
                    mobyID = "";
                    continue;
                }
                if (mobyString == null && token.startsWith("string=") && token.length() >= 7) {
                    if (token.length() > 7) {
                        mobyString = token.substring(7);
                        continue;
                    }
                    mobyString = "";
                    continue;
                }
                if (mobyName.length() == 0 && token.startsWith("name=") && token.length() >= 5) {
                    if (token.length() > 5) {
                        mobyName = token.substring(5);
                        continue;
                    }
                    mobyName = "";
                    continue;
                }
                logger.warn("Warning: unrecognized or duplicate query part '" + token + "' in moby link " + targetURL);
            }
        }
        mobyData = mobyString != null ? new MobyDataString(mobyName, (CharSequence)mobyString, SeahawkOptions.getRegistry()) : new MobyDataObject(mobyName, SeahawkOptions.getRegistry());
        mobyData.addNamespace(MobyNamespace.getNamespace(namespace, SeahawkOptions.getRegistry()));
        if (mobyID != null) {
            mobyData.setId(mobyID);
        }
        return mobyData;
    }

    protected MobyDataInstance loadMobyDataFromXPointer(URL targetURL) {
        MobyDataInstance mobyData;
        block18: {
            mobyData = null;
            String childXPath = targetURL.getRef().replaceAll("/(\\d+)", "/*[$1]");
            URL currentURL = null;
            try {
                currentURL = new URL(targetURL.toString().replaceAll(targetURL.getRef(), ""));
            }
            catch (Exception e) {
                logger.error("Couldn't extract referenceless URL from " + targetURL);
            }
            Element mobyDOMRoot = null;
            Document domDoc = null;
            try {
                domDoc = this.contentGUI.getDocumentBuilder().parse(targetURL.openStream());
            }
            catch (SAXException saxe) {
                logger.error("The document defining the MOBY data could not be parsed: " + saxe);
                return null;
            }
            catch (IOException ioe) {
                logger.error("The document defining the MOBY data  could not be read (from " + targetURL + "): " + ioe);
                return null;
            }
            if (domDoc != null) {
                mobyDOMRoot = domDoc.getDocumentElement();
            }
            if (mobyDOMRoot == null) {
                logger.warn("Error: Could not get MOBY document as DOM from source URL " + targetURL + " (empty or malformed document?)");
                return null;
            }
            Element mobyObject = null;
            NodeList idSearchResult = null;
            XObject xobject = null;
            try {
                xobject = XPathAPI.eval(domDoc, childXPath);
                if (!(xobject instanceof XNodeSet)) {
                    if (xobject != null) {
                        logger.warn("Output of XPath was not a XNodeSet as expected, found " + xobject.getClass().getName());
                        return null;
                    }
                    logger.warn("Could not find Moby object in document " + currentURL + ", referred to by the reference ID in Moby link " + targetURL + " (document changed?)");
                    return null;
                }
                idSearchResult = ((XNodeSet)xobject).nodelist();
            }
            catch (TransformerException te) {
                logger.error("Error: Could not search Moby data instance for XPath " + childXPath + "):" + te);
                return null;
            }
            if (idSearchResult.getLength() == 0) {
                logger.warn("Error: Could not find Moby data instance with XPath (" + childXPath + " in " + targetURL);
                return null;
            }
            if (idSearchResult.getLength() > 1) {
                logger.warn("Error: Moby data instance could not beresolved because there are multiple elements with XPath " + childXPath + " in " + currentURL);
                return null;
            }
            if (!(idSearchResult.item(0) instanceof Element)) {
                logger.warn("Error: Moby data instance with XPath " + childXPath + " in " + currentURL + " was not an element as required!");
                return null;
            }
            mobyObject = (Element)idSearchResult.item(0);
            try {
                MobyDataInstance mdi = MobyDataObject.createInstanceFromDOM(mobyObject, SeahawkOptions.getRegistry());
                if (mdi instanceof MobyDataObject) {
                    mobyData = mdi;
                    break block18;
                }
                if (mdi instanceof MobyDataObjectSet) {
                    mobyData = mdi;
                    break block18;
                }
                logger.warn("Error: Moby data instance retrieved with XPath " + childXPath + " in " + currentURL + " was not a primary MOBY input object as expected");
                return null;
            }
            catch (MobyException mobye) {
                logger.error("Error: Could not construct Moby data instance from document fragment:" + mobye);
                mobye.printStackTrace();
            }
        }
        return mobyData;
    }

    protected MobyDataInstance[] loadMobyDataFromString(String data) {
        return MobyUtils.convertStringToObjects(data);
    }

    public boolean isMobyURL(URL u) {
        return u != null && (u.toString().indexOf(".xml#/") != -1 || u.toString().indexOf("http://moby/") != -1);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 2 || e.getButton() == 3 && e.isAltDown()) {
            this.paste();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.servicesGUI.isSecondaryParamDialogNew()) {
            return;
        }
        if (!this.requestFocusInWindow()) {
            this.requestFocus();
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.lastClickX = e.getX();
        this.lastClickY = e.getY();
        if (this.checkSelectionPressed(this.lastClickX, this.lastClickY)) {
            if (this.selectedTextData == null) {
                return;
            }
            MobyDataInstance[] mobyData = this.loadMobyDataFromString(this.selectedTextData);
            if (mobyData == null || mobyData.length == 0) {
                logger.warn("No MobyData could be made from the selected text");
                return;
            }
            DynamicJPopupMenu popup = new DynamicJPopupMenu();
            popup.setName(MOBY_SERVICE_POPUP_NAME);
            popup.show(this, this.lastClickX + this.editorPane.getX(), this.lastClickY + this.editorPane.getY());
            JMenuItem checkingLinksPopupItem = new JMenuItem("Checking for services...");
            ((JPopupMenu)popup).add(checkingLinksPopupItem);
            ((JPopupMenu)popup).setVisible(true);
            for (int i = 0; i < mobyData.length; ++i) {
                this.servicesGUI.addPopupOptions(mobyData[i], (JPopupMenu)popup, true, this.getDefaultHandler());
            }
            this.servicesGUI.addPopupOptions(this.selectedTextData, (JPopupMenu)popup, true, this.getDefaultHandler());
            this.status.setText("Shift+Click=Service in new tab, Ctrl+Click=Use default 2nd params");
            if (popup.getSubElements().length > 0) {
                popup.setSelected(null);
                ((JPopupMenu)popup).setVisible(false);
                ((Container)popup).remove(checkingLinksPopupItem);
                ((JPopupMenu)popup).setVisible(true);
            }
        }
    }

    protected boolean checkSelectionPressed(int x, int y) {
        if (this.mark == this.dot) {
            return false;
        }
        int pressedLoc = this.editorPane.viewToModel(new Point(x, y));
        return this.mark < this.dot && pressedLoc >= this.mark && pressedLoc <= this.dot || this.mark > this.dot && pressedLoc <= this.mark && pressedLoc >= this.dot;
    }

    public void mouseReleased(MouseEvent e) {
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        return this.editorPane.print(g, pf, pageIndex);
    }

    public PrintableJEditorPane getDisplay() {
        return this.editorPane;
    }

    public void caretUpdate(CaretEvent e) {
        this.dot = e.getDot();
        this.mark = e.getMark();
        if (this.dot == this.mark) {
            this.selectedTextData = null;
            return;
        }
        this.selectedTextData = this.editorPane.getSelectedText();
        this.status.setText("Click your selection to use as MOBY data!");
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 65487 || e.getKeyCode() == 86 && e.isControlDown()) {
            this.paste();
        }
        if (e.getKeyCode() == 84 && e.isControlDown()) {
            MobyContentPane tab = this.contentGUI.createTab("New Tab");
            this.tabbedPane.setSelectedComponent(tab);
            tab.getDisplay().setText("Use the file/globe icon at the bottom of this window to load data,or drag'n'drop/paste data from your desktop or Web browser.");
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void paste() {
        this.getTransferHandler().importData(this, Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this));
    }

    static {
        logger = Logger.getLogger(MobyContentPane.class);
    }
}

