/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.util;

import ca.ucalgary.seahawk.gui.MobyContentGUI;
import ca.ucalgary.seahawk.gui.MobyServicesGUI;
import ca.ucalgary.seahawk.services.MobyClient;
import ca.ucalgary.seahawk.util.SeahawkOptions;
import ca.ucalgary.seahawk.util.Sequence;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.JLabel;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataComposite;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataInt;
import org.biomoby.shared.data.MobyDataJob;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataString;

public class MobyUtils {
    public static final int MAX_OBJ_NAME_LEN = 18;
    private static MobyContentGUI mobyContentGUI = null;
    private static MobyServicesGUI mobyServicesGUI = null;

    public static Transferable createTransferable(MobyContentInstance contents) {
        return null;
    }

    public static MobyContentInstance convertURLtoMobyBinaryData(MobyClient client, URL url) throws Exception {
        if (url == null || client == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        InputStream is = url.openStream();
        byte[] buffer = new byte[4096];
        int bytesRead = is.read(buffer);
        while (bytesRead != -1) {
            bytes.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer);
        }
        MobyDataObject[] foundObjects = client.getMobyObjects(bytes.toByteArray(), MobyDataType.getDataType("text-base64", SeahawkOptions.getRegistry()));
        if (foundObjects != null && foundObjects.length == 1) {
            MobyContentInstance mci = new MobyContentInstance();
            String[] dataName = url.getPath().split("/");
            MobyDataJob job = new MobyDataJob();
            job.put(dataName[dataName.length - 1], foundObjects[0]);
            System.err.println("Namespace of found object was " + foundObjects[0].getPrimaryNamespace().getName());
            mci.put(dataName[dataName.length - 1], job);
            return mci;
        }
        return null;
    }

    public static MobyDataInstance[] convertStringToObjects(String data) {
        if (data == null) {
            return new MobyDataInstance[0];
        }
        Vector<MobyDataObject> objects = new Vector<MobyDataObject>();
        String objectName = data;
        if (objectName.length() > 21) {
            objectName = objectName.substring(0, 18) + "...";
        }
        MobyDataString strObject = new MobyDataString(objectName, (CharSequence)data, SeahawkOptions.getRegistry());
        strObject.setPrimaryNamespace(new MobyNamespace("seahawk"));
        objects.add(strObject);
        MobyDataComposite mdc = MobyUtils.createMobySequence(data, "user-selection");
        if (mdc != null) {
            mdc.setName(objectName);
            objects.add(mdc);
        } else if (data.trim().matches("^[A-Za-z0-9_-]{3,35}$")) {
            objects.add(new MobyDataComposite("Global_Keyword", "dummy_name", "unknown", data.trim(), SeahawkOptions.getRegistry()));
        }
        return objects.toArray(new MobyDataInstance[objects.size()]);
    }

    public static void clearGUIs() {
        mobyServicesGUI = null;
        mobyContentGUI = null;
    }

    public static MobyServicesGUI getMobyServicesGUI(JLabel status) {
        if (mobyServicesGUI != null) {
            return mobyServicesGUI;
        }
        try {
            mobyServicesGUI = new MobyServicesGUI();
            MobyContentGUI handler = null;
            if (mobyContentGUI == null) {
                mobyContentGUI = new MobyContentGUI(mobyServicesGUI);
            }
            if (status == null) {
                status = mobyContentGUI.getStatusComponent();
            }
            handler = mobyContentGUI;
            mobyServicesGUI.setResponseHandler(handler);
        }
        catch (Exception e) {
            System.out.println("Caught exception while trying to initiate MOBY client: " + e);
            e.printStackTrace();
            return null;
        }
        return mobyServicesGUI;
    }

    public static MobyContentGUI getMobyContentGUI(JLabel status) {
        if (mobyContentGUI != null) {
            return mobyContentGUI;
        }
        MobyUtils.getMobyServicesGUI(status);
        return mobyContentGUI;
    }

    public static void destroyMobyGUI() {
        mobyContentGUI = null;
        mobyServicesGUI = null;
    }

    public static MobyDataComposite createMobySequence(String sequenceData, String id) {
        MobyDataComposite sequence = null;
        if (Sequence.isDNA(sequenceData)) {
            sequence = new MobyDataComposite("DNASequence", "dummy_name", "seahawk", id, SeahawkOptions.getRegistry());
        } else if (Sequence.isRNA(sequenceData)) {
            sequence = new MobyDataComposite("RNASequence", "dummy_name", "seahawk", id, SeahawkOptions.getRegistry());
        } else if (Sequence.isProtein(sequenceData)) {
            sequence = new MobyDataComposite("AminoAcidSequence", "dummy_name", "seahawk", id, SeahawkOptions.getRegistry());
        } else {
            return null;
        }
        sequenceData = sequenceData.replaceAll("[ \t\r\n0-9]", "");
        sequence.put("SequenceString", new MobyDataString((CharSequence)sequenceData, SeahawkOptions.getRegistry()));
        sequence.put("Length", new MobyDataInt(sequenceData.length(), SeahawkOptions.getRegistry()));
        return sequence;
    }
}

