/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JEditorPane;
import javax.swing.RepaintManager;

public class PrintableJEditorPane
extends JEditorPane
implements Printable {
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        Dimension d = this.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageWidth = pf.getImageableWidth();
        double pageHeight = pf.getImageableHeight();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.translate(0.0, (double)(-pageIndex) * pageHeight);
        g2.scale(scale, scale);
        this.paint(g2);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
        return 0;
    }
}

