/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.seahawk.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.biomoby.registry.meta.RegistriesList;
import org.biomoby.registry.meta.Registry;
import org.biomoby.registry.meta.RegistryCache;

public class SeahawkOptions {
    public static final String CACHE_POLICY_PROP = "cacheExpiryInHours";
    public static final String REFERRER_POLICY_PROP = "sendReferrerHeader";
    public static final String TEMP_DIR_PROP = "tempDataDir";
    public static final String REGISTRY_SYNONYM_PROP = "registrySynonym";
    public static final String REGISTRY_ENDPOINT_PROP = "registryEndpoint";
    public static final String REGISTRY_NAMESPACE_PROP = "registryNamespace";
    public static final String CONVERTER_HOST_PROP = "documentConverterHost";
    public static final String CONVERTER_PORT_PROP = "documentConverterPort";
    public static final String CUSTOM_REGISTRY_SYNONYM = "custom";
    public static final String PROPS_FILE_NAME = "seahawkUserPrefs.xml";
    public static final String PROPS_FILE_COMMENT = "This is the only file Seahawk stores on your system indefinitely.\nIf you delete it, your preferences will be reset the next time you run Seahawk.";
    public static final String PROPS_FILE_ENCODING = "UTF-8";
    public static final String PROPS_FILE_SYS_PROPERTY = "seahawk.prefs";
    private static Registry registry = null;
    private static File tmpDir = new File(System.getProperty("java.io.tmpdir"));
    private static boolean referrerPolicy = true;
    private static double cacheExpiryInHours = 24.0;
    private static String documentConverterHost = "136.159.169.81";
    private static int documentConverterPort = 8100;

    public static void restoreSettings() {
        File defaultsFile;
        String sysProp = System.getProperty(PROPS_FILE_SYS_PROPERTY);
        if (sysProp != null && sysProp.length() > 0) {
            URL url = null;
            File overrideFile = new File(sysProp);
            if (overrideFile.exists()) {
                if (!overrideFile.isFile()) {
                    System.err.println("Could not load '" + sysProp + "'. It exists, but is not a file.");
                } else if (!overrideFile.canRead()) {
                    System.err.println("Could not load file '" + sysProp + "'. It exists, but is not readable.");
                } else {
                    try {
                        url = overrideFile.toURI().toURL();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Could not load file '" + sysProp + "'. It exists, but could not be converted to a URL.");
                    }
                }
            }
            if (url == null) {
                url = new SeahawkOptions().getClass().getClassLoader().getResource(sysProp);
            }
            if (url == null) {
                try {
                    url = new URL(sysProp);
                }
                catch (MalformedURLException murle) {
                    // empty catch block
                }
            }
            if (url == null) {
                System.err.println("The preferences file specified via the system property seahawk.prefs could not be resolved to a valid file, resopurce or URL.  Using the default preferences file.");
            } else {
                try {
                    SeahawkOptions.restoreSettings(url);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("There was an error loading the preferences file specified (seahawk.prefs). Loading the default preferences file instead.");
                }
            }
        }
        if ((defaultsFile = SeahawkOptions.getDefaultsFile()).exists()) {
            try {
                SeahawkOptions.restoreSettings(defaultsFile.toURI().toURL());
            }
            catch (Exception e) {
                System.err.println("There was an error loading the preferences file (" + defaultsFile + "), using default values instead.");
            }
        }
    }

    public static void restoreSettings(URL u) throws Exception {
        String intString;
        String convHost;
        String dirPath;
        Properties properties = new Properties();
        properties.loadFromXML(u.openStream());
        String boolString = properties.getProperty(REFERRER_POLICY_PROP);
        if (boolString != null && boolString.length() > 0) {
            referrerPolicy = Boolean.parseBoolean(boolString);
        } else {
            System.err.println("No referrer header policy (sendReferrerHeader) provided in the Seahawk config file (" + u + "), using default of \"true\" " + "(will send referrer service header to services).");
        }
        String floatString = properties.getProperty(CACHE_POLICY_PROP);
        if (floatString != null && floatString.length() > 0) {
            double hours = cacheExpiryInHours;
            try {
                hours = Double.parseDouble(floatString);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                System.err.println("Ignoring the cache expiry policy (cacheExpiryInHours) provided in the Seahawk config file (" + u + "), it is not in valid floating-point number format: " + floatString);
            }
            SeahawkOptions.setCacheExpiry(hours);
        }
        if ((dirPath = properties.getProperty(TEMP_DIR_PROP)) != null && dirPath.length() > 0) {
            try {
                SeahawkOptions.setTempDir(new File(dirPath));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Ignoring the temporary data directory location (tempDataDir) provided in the Seahawk config file (" + u + "), it is not in valid (either can't be created, or written to): " + dirPath);
            }
        }
        String regSynonym = properties.getProperty(REGISTRY_SYNONYM_PROP);
        String regNamespace = properties.getProperty(REGISTRY_NAMESPACE_PROP);
        String regEndpoint = properties.getProperty(REGISTRY_ENDPOINT_PROP);
        URL endpointURL = null;
        if (regEndpoint != null && regEndpoint.length() > 0) {
            try {
                endpointURL = new URL(regEndpoint);
            }
            catch (MalformedURLException murle) {
                murle.printStackTrace();
                System.err.println("Ignoring the registry endpoint (registryEndpoint) provided in the Seahawk config file (" + u + "), it is not in valid URL format: " + regEndpoint);
            }
        }
        if ((convHost = properties.getProperty(CONVERTER_HOST_PROP)) != null && convHost.length() > 0) {
            SeahawkOptions.setDocConverterHost(convHost);
        }
        if ((intString = properties.getProperty(CONVERTER_PORT_PROP)) != null && intString.length() > 0) {
            int portNum = documentConverterPort;
            try {
                portNum = Integer.parseInt(intString);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                System.err.println("Ignoring the document converter port number (documentConverterPort) provided in the Seahawk config file (" + u + "), it is not in valid integer number format: " + intString);
            }
            SeahawkOptions.setDocConverterPort(portNum);
        }
        if (regSynonym != null && regSynonym.length() > 0) {
            RegistriesList regList = new RegistriesList();
            for (Registry reg : regList.getAll()) {
                if (!regSynonym.equals(reg.getSynonym())) continue;
                SeahawkOptions.setRegistry(reg);
                return;
            }
            if (endpointURL == null) {
                System.err.println("The registry alias '" + regSynonym + "' specified in the " + "config file (" + u.toString() + ") is unknown to Seahawk, and " + "a valid registry endpoint was not specified.  Using the " + "default registry instead.");
            } else if (regNamespace == null || regNamespace.length() == 0) {
                System.err.println("The registry alias '" + regSynonym + "' specified in the " + "config file (" + u.toString() + ") is unknown to Seahawk, and " + "a registry namespace was not specified.  Using the " + "default registry instead.");
            } else {
                SeahawkOptions.setRegistry(new Registry(regSynonym, regEndpoint, regNamespace));
            }
        } else if (endpointURL == null) {
            System.err.println("A valid registry endpoint was not specified.  Using the default registry instead.");
        } else if (regNamespace == null || regNamespace.length() == 0) {
            System.err.println("A valid registry namespace (parameter registryNamespace in file " + u + ") was not specified.  Using the " + "default registry instead.");
        } else {
            SeahawkOptions.setRegistry(new Registry(CUSTOM_REGISTRY_SYNONYM, regEndpoint, regNamespace));
        }
    }

    public static void saveSettings(OutputStream os) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(CACHE_POLICY_PROP, "" + cacheExpiryInHours);
        properties.setProperty(REFERRER_POLICY_PROP, "" + referrerPolicy);
        properties.setProperty(TEMP_DIR_PROP, tmpDir.getCanonicalFile().getPath());
        properties.setProperty(CONVERTER_HOST_PROP, documentConverterHost);
        properties.setProperty(CONVERTER_PORT_PROP, "" + documentConverterPort);
        if (registry != null) {
            properties.setProperty(REGISTRY_SYNONYM_PROP, registry.getSynonym());
            properties.setProperty(REGISTRY_ENDPOINT_PROP, registry.getEndpoint());
            properties.setProperty(REGISTRY_NAMESPACE_PROP, registry.getNamespace());
        }
        properties.storeToXML(os, PROPS_FILE_COMMENT, PROPS_FILE_ENCODING);
    }

    public static boolean saveSettings() {
        File defaultsFile = SeahawkOptions.getDefaultsFile();
        File defaultsParentFile = defaultsFile.getParentFile();
        if (defaultsParentFile != null && !defaultsParentFile.exists() && !defaultsParentFile.mkdirs()) {
            System.err.println("Warning: the preferences file (" + defaultsFile + ") is not writeable because its parent directory " + "could not be created, preferences will be lost when " + "Seahawk terminates.");
            return false;
        }
        if (defaultsFile.isDirectory()) {
            System.err.println("Warning: the preferences file (" + defaultsFile + ") is not writeable because a directory with the same " + "name already exists, preferences will be lost when " + "Seahawk terminates.");
            return false;
        }
        if (defaultsFile.exists() && !defaultsFile.canWrite()) {
            System.err.println("Warning: the preferences file (" + defaultsFile + ") is not writeable, preferences will be lost when " + "Seahawk terminates.");
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(defaultsFile);
            SeahawkOptions.saveSettings(fileOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Warning: could not save preferences (file " + defaultsFile + "), they will be lost when Seahawk terminates.");
            return false;
        }
        return true;
    }

    public static File getDefaultsFile() {
        return new File(System.getProperty("user.home"), PROPS_FILE_NAME);
    }

    public static void setCacheExpiry(double hours) {
        cacheExpiryInHours = hours < 0.0 || hours == Double.NaN ? 0.0 : hours;
    }

    public static double getCacheExpiry() {
        return cacheExpiryInHours;
    }

    public static Registry getRegistry() {
        return registry;
    }

    public static void setRegistry(Registry reg) {
        registry = reg;
    }

    public static File getTempDir() {
        return tmpDir;
    }

    public static void setTempDir(File dir) throws Exception {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw new IOException("The temporary data path given (" + dir.toString() + ") is not a directory as required");
        }
        if (!dir.canWrite()) {
            throw new IOException("The temporary data path given (" + dir.toString() + ") is not writeable as required");
        }
        if (!dir.canRead()) {
            throw new IOException("The temporary data path given (" + dir.toString() + ") is not readable as required");
        }
        tmpDir = dir;
        RegistryCache.setTempDir(dir);
    }

    public static void setSendReferrerPolicy(boolean send) {
        referrerPolicy = send;
    }

    public static boolean getSendReferrerPolicy() {
        return referrerPolicy;
    }

    public static void setDocConverterPort(int port) throws Exception {
        if (port < 0) {
            throw new Exception("The port number for the document converter must be greater than 0, but an attempt was made to set it to " + port);
        }
        documentConverterPort = port;
    }

    public static int getDocConverterPort() {
        return documentConverterPort;
    }

    public static void setDocConverterHost(String hostname) {
        if (hostname == null || hostname.length() == 0) {
            hostname = null;
        }
        documentConverterHost = hostname;
    }

    public static String getDocConverterHost() {
        return documentConverterHost;
    }
}

