/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchIterator;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.mem.NodeToTriplesMap;
import com.hp.hpl.jena.mem.TrackingTripleIterator;
import com.hp.hpl.jena.mem.TripleFieldIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashSet;
import java.util.Set;

public class GraphMem
extends GraphBase
implements Graph {
    Set triples = new HashSet();
    NodeToTriplesMap subjects = new NodeToTriplesMap();
    NodeToTriplesMap predicates = new NodeToTriplesMap();
    NodeToTriplesMap objects = new NodeToTriplesMap();
    protected int count = 1;
    private QueryHandler q;

    public GraphMem() {
        this(ReificationStyle.Minimal);
    }

    public GraphMem(ReificationStyle reificationStyle) {
        super(reificationStyle);
    }

    public void close() {
        if (--this.count == 0) {
            this.triples = null;
            this.objects = null;
            this.predicates = null;
            this.subjects = null;
            super.close();
        }
    }

    public GraphMem openAgain() {
        ++this.count;
        return this;
    }

    public void performAdd(Triple triple) {
        if (this.getReifier().handledAdd(triple) || this.triples.contains(triple)) {
            return;
        }
        if (this.triples.add(triple)) {
            this.subjects.add(triple.getSubject(), triple);
            this.predicates.add(triple.getPredicate(), triple);
            this.objects.add(triple.getObject(), triple);
        }
    }

    public void performDelete(Triple triple) {
        if (this.getReifier().handledRemove(triple)) {
            return;
        }
        if (this.triples.remove(triple)) {
            this.subjects.remove(triple.getSubject(), triple);
            this.predicates.remove(triple.getPredicate(), triple);
            this.objects.remove(triple.getObject(), triple);
        }
    }

    public int size() {
        this.checkOpen();
        return this.triples.size();
    }

    public boolean isEmpty() {
        this.checkOpen();
        return this.triples.isEmpty();
    }

    public QueryHandler queryHandler() {
        if (this.q == null) {
            this.q = new GraphMemQueryHandler(this);
        }
        return this.q;
    }

    public boolean contains(Triple triple) {
        this.checkOpen();
        return triple.isConcrete() ? this.triples.contains(triple) : this.containsByFind(triple);
    }

    public boolean contains(Node node, Node node2, Node node3) {
        this.checkOpen();
        if (node == null || node2 == null || node3 == null) {
            throw new JenaException("null not allowed");
        }
        return this.contains(Triple.create(node, node2, node3));
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        this.checkOpen();
        Triple triple = tripleMatch.asTriple();
        Node node = tripleMatch.getMatchPredicate();
        Node node2 = tripleMatch.getMatchObject();
        Node node3 = triple.getSubject();
        if (node3.isConcrete()) {
            return this.subjectIterator(triple, node3);
        }
        if (node2 != null && !node2.isLiteral()) {
            return this.objectIterator(triple, node2);
        }
        if (node != null) {
            return this.predicateIterator(triple, node);
        }
        return this.baseIterator(triple);
    }

    protected TripleMatchIterator objectIterator(Triple triple, Node node) {
        return new TripleFieldIterator(triple, this.objects.iterator(node), this.triples, this.subjects, this.predicates){

            public void remove() {
                super.remove();
                GraphMem.this.subjects.remove(this.current.getSubject(), this.current);
                GraphMem.this.predicates.remove(this.current.getPredicate(), this.current);
            }
        };
    }

    protected TripleMatchIterator subjectIterator(Triple triple, Node node) {
        return new TripleFieldIterator(triple, this.subjects.iterator(node), this.triples, this.predicates, this.objects){

            public void remove() {
                super.remove();
                GraphMem.this.predicates.remove(this.current.getPredicate(), this.current);
                GraphMem.this.objects.remove(this.current.getObject(), this.current);
            }
        };
    }

    protected TripleMatchIterator predicateIterator(Triple triple, Node node) {
        return new TripleFieldIterator(triple, this.predicates.iterator(node), this.triples, this.subjects, this.objects){

            public void remove() {
                super.remove();
                GraphMem.this.subjects.remove(this.current.getSubject(), this.current);
                GraphMem.this.objects.remove(this.current.getObject(), this.current);
            }
        };
    }

    protected ExtendedIterator baseIterator(Triple triple) {
        return new TrackingTripleIterator(triple, this.triples.iterator()){

            public void remove() {
                super.remove();
                GraphMem.this.subjects.remove(this.current.getSubject(), this.current);
                GraphMem.this.predicates.remove(this.current.getPredicate(), this.current);
                GraphMem.this.objects.remove(this.current.getObject(), this.current);
            }
        };
    }

    private static class GraphMemQueryHandler
    extends SimpleQueryHandler {
        GraphMemQueryHandler(GraphMem graphMem) {
            super(graphMem);
        }
    }
}

