/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.lang;

import com.hp.hpl.jena.rdf.arp.lang.IanaLanguageTag;
import com.hp.hpl.jena.rdf.arp.lang.Iso3166;
import com.hp.hpl.jena.rdf.arp.lang.Iso639;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagCodes;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagSyntaxException;
import java.util.Vector;

public class LanguageTag
implements LanguageTagCodes {
    String[] tags;

    public LanguageTag(String string) throws LanguageTagSyntaxException {
        int n;
        int n2;
        int n3;
        String string2 = string.toLowerCase();
        Vector<String> vector = new Vector<String>();
        while ((n3 = string2.indexOf(45)) != -1) {
            vector.add(string2.substring(0, n3));
            string2 = string2.substring(n3 + 1);
        }
        vector.add(string2);
        this.tags = new String[vector.size()];
        vector.copyInto(this.tags);
        int n4 = this.tags[0].length();
        if (n4 == 0 || n4 > 8) {
            throw new LanguageTagSyntaxException("Primary subtag must be between 1 and 8 alpha characters: " + string);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            n = this.tags[0].charAt(n2);
            if (97 <= n && n <= 122) continue;
            throw new LanguageTagSyntaxException("Primary subtag must be between 1 and 8 alpha characters: " + string);
        }
        for (n2 = 1; n2 < this.tags.length; ++n2) {
            n4 = this.tags[n2].length();
            if (n4 == 0 || n4 > 8) {
                throw new LanguageTagSyntaxException("Subtag " + (n2 + 1) + " must be between 1 and 8 alphanumeric characters: " + string);
            }
            for (n = 0; n < n4; ++n) {
                char c = this.tags[n2].charAt(n);
                if ('a' <= c && c <= 'z' || '0' <= c && c <= '9') continue;
                throw new LanguageTagSyntaxException("Subtag " + (n2 + 1) + " must be between 1 and 8 alphanumeric characters: " + string);
            }
        }
    }

    public int tagType() {
        int n;
        IanaLanguageTag ianaLanguageTag = IanaLanguageTag.find((LanguageTag)this);
        Iso639 iso639 = Iso639.find((String)this.tags[0]);
        int n2 = n = ianaLanguageTag == null ? 0 : ianaLanguageTag.classification;
        if (ianaLanguageTag != null && ianaLanguageTag.tags.length < this.tags.length) {
            n |= 0x80;
        }
        switch (this.tags[0].length()) {
            case 1: {
                switch (this.tags[0].charAt(0)) {
                    case 'x': {
                        return 2;
                    }
                    case 'i': {
                        if (ianaLanguageTag != null) {
                            return n;
                        }
                        return 32768;
                    }
                }
                return 32768;
            }
            case 2: {
                if (iso639 == null) {
                    return 32768;
                }
                n |= iso639.classification;
                break;
            }
            case 3: {
                if (iso639 == null) {
                    return 32768;
                }
                if (iso639.twoCharCode != null) {
                    return 32768;
                }
                if (!iso639.terminologyCode.equals(this.tags[0])) {
                    return 32768;
                }
                n |= iso639.classification;
                break;
            }
            default: {
                return 32768;
            }
        }
        if (this.tags.length == 1) {
            return n;
        }
        switch (this.tags[1].length()) {
            case 1: {
                return 32768;
            }
            case 2: {
                if (Iso3166.find((String)this.tags[1]) != null) break;
                return 32768;
            }
            default: {
                if (ianaLanguageTag != null) break;
                n |= 0x80;
            }
        }
        if (this.tags.length > 2 && ianaLanguageTag == null) {
            n |= 0x80;
        }
        return n;
    }

    public String errorMessage() {
        switch (this.tags[0].length()) {
            case 1: {
                switch (this.tags[0].charAt(0)) {
                    case 'x': {
                        return null;
                    }
                    case 'i': {
                        if (IanaLanguageTag.find((LanguageTag)this) != null) {
                            return null;
                        }
                        return this.toString() + " not found in IANA langauge registry.";
                    }
                }
                return "Only 'x' and 'i' single character primary language subtags are defined in RFC3066.";
            }
            case 2: {
                if (Iso639.find((String)this.tags[0]) != null) break;
                return "ISO-639 does not define langauge: '" + this.tags[0] + "'.";
            }
            case 3: {
                Iso639 iso639 = Iso639.find((String)this.tags[0]);
                if (iso639 == null) {
                    return "ISO-639 does not define langauge: '" + this.tags[0] + "'.";
                }
                if (iso639.twoCharCode != null) {
                    return "RFC 3066 section 2.3 mandates the use of '" + iso639.twoCharCode + "' instead of '" + this.tags[0] + "'.";
                }
                if (iso639.terminologyCode.equals(this.tags[0])) break;
                return "RFC 3066 section 2.3 mandates the use of '" + iso639.terminologyCode + "' instead of '" + this.tags[0] + "'.";
            }
            default: {
                return "No primary language subtags of length greater than 3 are currently defined.";
            }
        }
        if (this.tags.length == 1) {
            return null;
        }
        switch (this.tags[1].length()) {
            case 1: {
                return "Second language subtags of length 1 are prohibited by RFC3066.";
            }
            case 2: {
                if (Iso3166.find((String)this.tags[1]) != null) break;
                return "Country code, '" + this.tags[1] + "', not found in ISO 3166.";
            }
        }
        return null;
    }
}

