/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.EmptyListException;
import com.hp.hpl.jena.rdf.model.EmptyListUpdateException;
import com.hp.hpl.jena.rdf.model.InvalidListException;
import com.hp.hpl.jena.rdf.model.ListIndexException;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.RDFListImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RDFListImpl
extends ResourceImpl
implements RDFList {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                RDFListImpl rDFListImpl = new RDFListImpl(node, enhGraph);
                if (enhGraph instanceof OntModel) {
                    Profile profile = ((OntModel)((Object)enhGraph)).getProfile();
                    rDFListImpl.m_listFirst = profile.FIRST();
                    rDFListImpl.m_listRest = profile.REST();
                    rDFListImpl.m_listNil = profile.NIL();
                    rDFListImpl.m_listType = profile.LIST();
                }
                return rDFListImpl;
            }
            throw new JenaException("Cannot convert node " + node + " to RDFList");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            Graph graph = enhGraph.asGraph();
            Property property = RDF.first;
            Property property2 = RDF.rest;
            Resource resource = RDF.nil;
            if (enhGraph instanceof OntModel) {
                Profile profile = ((OntModel)((Object)enhGraph)).getProfile();
                property = profile.FIRST();
                property2 = profile.REST();
                resource = profile.NIL();
            }
            return node.equals(resource.asNode()) || graph.find(node, property.asNode(), Node.ANY).hasNext() || graph.find(node, property2.asNode(), Node.ANY).hasNext() || graph.find(node, RDF.type.asNode(), RDF.List.asNode()).hasNext();
        }
    };
    protected static boolean s_checkValid = false;
    protected String m_errorMsg = null;
    protected RDFList m_tail = null;
    protected Property m_listFirst = RDF.first;
    protected Property m_listRest = RDF.rest;
    protected Resource m_listNil = RDF.nil;
    protected Resource m_listType = RDF.List;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFList;

    public RDFListImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public Resource listType() {
        return this.m_listType;
    }

    public Resource listNil() {
        return this.m_listNil;
    }

    public Property listFirst() {
        return this.m_listFirst;
    }

    public Property listRest() {
        return this.m_listRest;
    }

    public Class listAbstractionClass() {
        return class$com$hp$hpl$jena$rdf$model$RDFList == null ? (class$com$hp$hpl$jena$rdf$model$RDFList = RDFListImpl.class$("com.hp.hpl.jena.rdf.model.RDFList")) : class$com$hp$hpl$jena$rdf$model$RDFList;
    }

    public int size() {
        if (s_checkValid) {
            this.checkValid();
        }
        int n = 0;
        ExtendedIterator extendedIterator = this.iterator();
        while (extendedIterator.hasNext()) {
            ++n;
            extendedIterator.next();
        }
        return n;
    }

    public RDFNode getHead() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the head of an empty list");
        return this.getRequiredProperty(this.listFirst()).getObject();
    }

    public RDFNode setHead(RDFNode rDFNode) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to set the head of an empty list");
        Statement statement = this.getRequiredProperty(this.listFirst());
        RDFNode rDFNode2 = statement.getObject();
        statement.remove();
        this.addProperty(this.listFirst(), rDFNode);
        return rDFNode2;
    }

    public RDFList getTail() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get the tail of an empty list");
        Resource resource = this.getRequiredProperty(this.listRest()).getResource();
        return (RDFList)resource.as(this.listAbstractionClass());
    }

    public RDFList setTail(RDFList rDFList) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to set the tail of an empty list");
        return (RDFList)RDFListImpl.setTailAux(this, rDFList, this.listRest()).as(this.listAbstractionClass());
    }

    public boolean isEmpty() {
        if (s_checkValid) {
            this.checkValid();
        }
        return this.equals(this.listNil());
    }

    public RDFList cons(RDFNode rDFNode) {
        if (s_checkValid) {
            this.checkValid();
        }
        return (RDFList)this.newListCell(rDFNode, this).as(this.listAbstractionClass());
    }

    public void add(RDFNode rDFNode) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            throw new EmptyListUpdateException("Attempt to add() to the empty list (rdf:nil)");
        }
        RDFList rDFList = this.findElement(true, 0);
        RDFListImpl.setTailAux(rDFList, this.newListCell(rDFNode, this.listNil()), this.listRest());
    }

    public RDFList with(RDFNode rDFNode) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            return this.cons(rDFNode);
        }
        RDFList rDFList = this.findElement(true, 0);
        RDFListImpl.setTailAux(rDFList, this.newListCell(rDFNode, this.listNil()), this.listRest());
        return this;
    }

    public RDFNode get(int n) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to get an element from the empty list");
        return this.findElement(false, n).getHead();
    }

    public RDFNode replace(int n, RDFNode rDFNode) {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Tried to replace a value in the empty list");
        return this.findElement(false, n).setHead(rDFNode);
    }

    public boolean contains(RDFNode rDFNode) {
        return this.indexOf(rDFNode, 0) >= 0;
    }

    public int indexOf(RDFNode rDFNode) {
        return this.indexOf(rDFNode, 0);
    }

    public int indexOf(RDFNode rDFNode, int n) {
        if (s_checkValid) {
            this.checkValid();
        }
        Resource resource = this.findElement(false, n);
        int n2 = n;
        Property property = this.listFirst();
        Property property2 = this.listRest();
        Resource resource2 = this.listNil();
        boolean bl = resource.hasProperty(property, rDFNode);
        while (!bl && !((Object)resource).equals(resource2)) {
            resource = resource.getRequiredProperty(property2).getResource();
            ++n2;
            bl = resource.hasProperty(property, rDFNode);
        }
        return bl ? n2 : -1;
    }

    public RDFList append(Iterator iterator) {
        return this.append(this.copy(iterator));
    }

    public RDFList append(RDFList rDFList) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            return rDFList;
        }
        RDFList rDFList2 = this.copy(this.iterator());
        rDFList2.concatenate(rDFList);
        return rDFList2;
    }

    public void concatenate(RDFList rDFList) {
        if (s_checkValid) {
            this.checkValid();
        }
        if (this.isEmpty()) {
            throw new EmptyListUpdateException("Tried to concatenate onto the empty list");
        }
        this.findElement(true, 0).setTail(rDFList);
    }

    public void concatenate(Iterator iterator) {
        this.concatenate(this.copy(iterator));
    }

    public RDFList copy() {
        if (s_checkValid) {
            this.checkValid();
        }
        return this.copy(this.iterator());
    }

    public void apply(RDFList.ApplyFn applyFn) {
        if (s_checkValid) {
            this.checkValid();
        }
        ExtendedIterator extendedIterator = this.iterator();
        while (extendedIterator.hasNext()) {
            applyFn.apply((RDFNode)extendedIterator.next());
        }
    }

    public Object reduce(RDFList.ReduceFn reduceFn, Object object) {
        if (s_checkValid) {
            this.checkValid();
        }
        Object object2 = object;
        ExtendedIterator extendedIterator = this.iterator();
        while (extendedIterator.hasNext()) {
            object2 = reduceFn.reduce((RDFNode)extendedIterator.next(), object2);
        }
        return object2;
    }

    public ExtendedIterator mapWith(Map1 map1) {
        return this.iterator().mapWith(map1);
    }

    public RDFList removeHead() {
        if (s_checkValid) {
            this.checkValid();
        }
        this.checkNotNil("Attempted to delete the head of a nil list");
        RDFList rDFList = this.getTail();
        this.removeProperties();
        return rDFList;
    }

    public RDFList remove(RDFNode rDFNode) {
        if (s_checkValid) {
            this.checkValid();
        }
        RDFListImpl rDFListImpl = null;
        RDFList rDFList = this;
        boolean bl = true;
        while (bl && !rDFList.isEmpty()) {
            if (rDFList.getHead().equals(rDFNode)) {
                RDFList rDFList2 = rDFList.getTail();
                if (rDFListImpl != null) {
                    rDFListImpl.setTail(rDFList2);
                }
                rDFList.removeProperties();
                return rDFListImpl == null ? rDFList2 : this;
            }
            rDFListImpl = rDFList;
            rDFList = rDFList.getTail();
        }
        return this;
    }

    public void removeAll() {
        RDFList rDFList = this;
        while (!rDFList.isEmpty()) {
            rDFList = rDFList.removeHead();
        }
    }

    public ExtendedIterator iterator() {
        return new RDFListIterator(this, (RDFList)this);
    }

    public List asJavaList() {
        ArrayList arrayList = new ArrayList();
        ExtendedIterator extendedIterator = this.iterator();
        while (extendedIterator.hasNext()) {
            arrayList.add(extendedIterator.next());
        }
        return arrayList;
    }

    public boolean sameListAs(RDFList rDFList) {
        if (s_checkValid) {
            this.checkValid();
        }
        Resource resource = this;
        Resource resource2 = rDFList;
        Property property = this.listFirst();
        Property property2 = this.listRest();
        Resource resource3 = this.listNil();
        while (!((Object)resource).equals(resource3) && !resource2.equals(resource3)) {
            RDFNode rDFNode = resource.getRequiredProperty(property).getObject();
            RDFNode rDFNode2 = resource2.getRequiredProperty(property).getObject();
            if (rDFNode == null || !rDFNode.equals(rDFNode2)) {
                return false;
            }
            resource = resource.getRequiredProperty(property2).getResource();
            resource2 = resource2.getRequiredProperty(property2).getResource();
        }
        return ((Object)resource).equals(resource3) && resource2.equals(resource3);
    }

    public boolean getStrict() {
        return s_checkValid;
    }

    public void setStrict(boolean bl) {
        s_checkValid = bl;
    }

    public boolean isValid() {
        this.m_errorMsg = null;
        try {
            this.checkValid();
        }
        catch (InvalidListException invalidListException) {
            this.m_errorMsg = invalidListException.getMessage();
        }
        return this.m_errorMsg == null;
    }

    public String getValidityErrorMessage() {
        return this.m_errorMsg;
    }

    public Resource newListCell(RDFNode rDFNode, Resource resource) {
        Resource resource2 = this.getModel().createResource();
        resource2.addProperty(this.listFirst(), rDFNode);
        resource2.addProperty(this.listRest(), resource);
        return resource2;
    }

    protected void checkValid() {
        if (!this.equals(this.listNil())) {
            this.checkValidProperty(this.listFirst(), null);
            this.checkValidProperty(this.listRest(), null);
        }
    }

    private void checkValidProperty(Property property, RDFNode rDFNode) {
        int n = 0;
        StmtIterator stmtIterator = this.getModel().listStatements((Resource)this, property, rDFNode);
        while (stmtIterator.hasNext()) {
            ++n;
            stmtIterator.next();
        }
        if (n == 0) {
            throw new InvalidListException("List node " + this.toString() + " is not valid: it should have property " + property.toString() + (rDFNode == null ? "" : " with value " + rDFNode));
        }
        if (n > 1) {
            throw new InvalidListException("List node " + this.toString() + " is not valid: it has more than one value for " + property.toString());
        }
    }

    protected void checkNotNil(String string) {
        if (this.isEmpty()) {
            throw new EmptyListException(string);
        }
    }

    protected RDFList findElement(boolean bl, int n) {
        boolean bl2;
        Property property = this.listRest();
        Resource resource = this.listNil();
        Resource resource2 = this;
        int n2 = n;
        boolean bl3 = bl2 = bl && resource2.hasProperty(property, resource) || !bl && n2 == 0;
        while (!bl2 && !((Object)resource2).equals(resource)) {
            resource2 = resource2.getRequiredProperty(property).getResource();
            bl2 = bl && resource2.hasProperty(property, resource) || !bl && --n2 == 0;
        }
        if (!bl2) {
            if (!bl) {
                throw new ListIndexException("Tried to access element " + n + " that is beyond the length of the list");
            }
            throw new InvalidListException("Could not find last element of list (suggests list is not valid)");
        }
        return (RDFList)resource2.as(this.listAbstractionClass());
    }

    protected RDFList copy(Iterator iterator) {
        Resource resource = null;
        RDFNode rDFNode = null;
        Property property = this.listFirst();
        Property property2 = this.listRest();
        Resource resource2 = this.listType();
        while (iterator.hasNext()) {
            Resource resource3 = this.getModel().createResource(resource2);
            resource3.addProperty(property, (RDFNode)iterator.next());
            if (resource != null) {
                resource.addProperty(property2, resource3);
            } else {
                rDFNode = resource3;
            }
            resource = resource3;
        }
        resource.addProperty(property2, this.listNil());
        return (RDFList)rDFNode.as(this.listAbstractionClass());
    }

    protected static Resource setTailAux(Resource resource, Resource resource2, Property property) {
        Statement statement = resource.getRequiredProperty(property);
        Resource resource3 = statement.getResource();
        statement.remove();
        resource.addProperty(property, resource2);
        return resource3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

