/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.NormalizerImpl;
import com.ibm.icu.impl.UCharacterName;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.impl.UCharacterUtility;
import com.ibm.icu.impl.UPropertyAliases;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UCharacterNameIterator;
import com.ibm.icu.lang.UCharacterTypeIterator;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.RangeValueIterator;
import com.ibm.icu.util.ValueIterator;
import com.ibm.icu.util.VersionInfo;
import java.util.Locale;

/*
 * Exception performing whole class analysis ignored.
 */
public final class UCharacter {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final int REPLACEMENT_CHAR = 65533;
    public static final double NO_NUMERIC_VALUE = -1.23456789E8;
    private static final int FOLD_CASE_OPTIONS_MASK = 255;
    public static final int FOLD_CASE_DEFAULT = 0;
    public static final int FOLD_CASE_EXCLUDE_SPECIAL_I = 1;
    static UCharacterName NAME_ = null;
    static UPropertyAliases PNAMES_ = null;
    private static final UCharacterProperty PROPERTY_;
    private static final char[] PROPERTY_TRIE_INDEX_;
    private static final char[] PROPERTY_TRIE_DATA_;
    private static final int[] PROPERTY_DATA_;
    private static final int PROPERTY_INITIAL_VALUE_;
    private static final int LAST_CHAR_MASK_ = 65535;
    private static final int LAST_BYTE_MASK_ = 255;
    private static final int SHIFT_16_ = 16;
    private static final int SHIFT_24_ = 24;
    private static final int DECIMAL_RADIX_ = 10;
    private static final int NO_BREAK_SPACE_ = 160;
    private static final int NARROW_NO_BREAK_SPACE_ = 8239;
    private static final int ZERO_WIDTH_NO_BREAK_SPACE_ = 65279;
    private static final int IDEOGRAPHIC_NUMBER_ZERO_ = 12295;
    private static final int CJK_IDEOGRAPH_FIRST_ = 19968;
    private static final int CJK_IDEOGRAPH_SECOND_ = 20108;
    private static final int CJK_IDEOGRAPH_THIRD_ = 19977;
    private static final int CJK_IDEOGRAPH_FOURTH_ = 22232;
    private static final int CJK_IDEOGRAPH_FIFTH_ = 20116;
    private static final int CJK_IDEOGRAPH_SIXTH_ = 20845;
    private static final int CJK_IDEOGRAPH_SEVENTH_ = 19971;
    private static final int CJK_IDEOGRAPH_EIGHTH_ = 20843;
    private static final int CJK_IDEOGRAPH_NINETH_ = 20061;
    private static final int APPLICATION_PROGRAM_COMMAND_ = 159;
    private static final int UNIT_SEPARATOR_ = 31;
    private static final int DELETE_ = 127;
    private static final int ISO_CONTROL_FIRST_RANGE_MAX_ = 31;
    private static final int NUMERIC_TYPE_SHIFT_ = 12;
    private static final int NUMERIC_TYPE_MASK_ = 28672;
    private static final int BIDI_SHIFT_ = 6;
    private static final int BIDI_MASK_AFTER_SHIFT_ = 31;
    private static final int CJK_IDEOGRAPH_COMPLEX_ZERO_ = 38646;
    private static final int CJK_IDEOGRAPH_COMPLEX_ONE_ = 22777;
    private static final int CJK_IDEOGRAPH_COMPLEX_TWO_ = 36019;
    private static final int CJK_IDEOGRAPH_COMPLEX_THREE_ = 21443;
    private static final int CJK_IDEOGRAPH_COMPLEX_FOUR_ = 32902;
    private static final int CJK_IDEOGRAPH_COMPLEX_FIVE_ = 20237;
    private static final int CJK_IDEOGRAPH_COMPLEX_SIX_ = 38520;
    private static final int CJK_IDEOGRAPH_COMPLEX_SEVEN_ = 26578;
    private static final int CJK_IDEOGRAPH_COMPLEX_EIGHT_ = 25420;
    private static final int CJK_IDEOGRAPH_COMPLEX_NINE_ = 29590;
    private static final int CJK_IDEOGRAPH_TEN_ = 21313;
    private static final int CJK_IDEOGRAPH_COMPLEX_TEN_ = 25342;
    private static final int CJK_IDEOGRAPH_HUNDRED_ = 30334;
    private static final int CJK_IDEOGRAPH_COMPLEX_HUNDRED_ = 20336;
    private static final int CJK_IDEOGRAPH_THOUSAND_ = 21315;
    private static final int CJK_IDEOGRAPH_COMPLEX_THOUSAND_ = 20191;
    private static final int CJK_IDEOGRAPH_TEN_THOUSAND_ = 33356;
    private static final int CJK_IDEOGRAPH_HUNDRED_MILLION_ = 20740;
    private static final int NUMERATOR_POWER_LIMIT_ = 0x7FFFFF00;
    private static final int JOINING_TYPE_MASK_ = 14336;
    private static final int JOINING_TYPE_SHIFT_ = 11;
    private static final int JOINING_GROUP_MASK_ = 2016;
    private static final int JOINING_GROUP_SHIFT_ = 5;
    private static final int DECOMPOSITION_TYPE_MASK_ = 31;
    private static final int EAST_ASIAN_MASK_ = 229376;
    private static final int EAST_ASIAN_SHIFT_ = 15;
    private static final int ZERO_WIDTH_NON_JOINER_ = 8204;
    private static final int ZERO_WIDTH_JOINER_ = 8205;
    private static final int LINE_BREAK_MASK_ = 0x7C0000;
    private static final int LINE_BREAK_SHIFT_ = 18;
    private static final int BLOCK_MASK_ = 32640;
    private static final int BLOCK_SHIFT_ = 7;
    private static final int SCRIPT_MASK_ = 127;

    public static int digit(int ch, int radix) {
        int result;
        int props = UCharacter.getProperty(ch);
        if (UCharacter.getNumericType(props) != 1) {
            return radix <= 10 ? -1 : UCharacter.getEuropeanDigit(ch);
        }
        if (UCharacter.isNotExceptionIndicator(props)) {
            if (props >= 0) {
                return UCharacterProperty.getSignedValue(props);
            }
        } else {
            int result2;
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 4) && (result2 = PROPERTY_.getException(index, 4)) >= 0) {
                return result2;
            }
        }
        if (radix > 10 && (result = UCharacter.getEuropeanDigit(ch)) >= 0 && result < radix) {
            return result;
        }
        return -1;
    }

    public static int digit(int ch) {
        return UCharacter.digit(ch, 10);
    }

    public static int getNumericValue(int ch) {
        int props = UCharacter.getProperty(ch);
        if ((props & 0x7000) == 0) {
            return UCharacter.getEuropeanDigit(ch);
        }
        if (UCharacter.isNotExceptionIndicator(props)) {
            return props >>> 20;
        }
        int index = UCharacterProperty.getExceptionIndex(props);
        if (!PROPERTY_.hasExceptionValue(index, 5) && PROPERTY_.hasExceptionValue(index, 4)) {
            return PROPERTY_.getException(index, 4);
        }
        int europeannumeric = UCharacter.getEuropeanDigit(ch);
        if (europeannumeric >= 0) {
            return europeannumeric;
        }
        return -2;
    }

    public static double getUnicodeNumericValue(int ch) {
        int props = PROPERTY_.getProperty(ch);
        int numericType = UCharacter.getNumericType(props);
        if (numericType > 0 && numericType < 4) {
            if (UCharacter.isNotExceptionIndicator(props)) {
                return UCharacterProperty.getSignedValue(props);
            }
            int index = UCharacterProperty.getExceptionIndex(props);
            boolean nex = false;
            boolean dex = false;
            double numerator = 0.0;
            if (PROPERTY_.hasExceptionValue(index, 4)) {
                int num = PROPERTY_.getException(index, 4);
                numerator = num >= 0x7FFFFF00 ? Math.pow(10.0, num &= 0xFF) : (double)num;
                nex = true;
            }
            double denominator = 0.0;
            if (PROPERTY_.hasExceptionValue(index, 5)) {
                denominator = PROPERTY_.getException(index, 5);
                if (numerator != 0.0) {
                    return numerator / denominator;
                }
                dex = true;
            }
            if (nex) {
                if (dex) {
                    return numerator / denominator;
                }
                return numerator;
            }
            if (dex) {
                return 1.0 / denominator;
            }
        }
        return -1.23456789E8;
    }

    public static int getType(int ch) {
        return UCharacter.getProperty(ch) & 0x1F;
    }

    public static boolean isDefined(int ch) {
        return UCharacter.getType(ch) != 0;
    }

    public static boolean isDigit(int ch) {
        return UCharacter.getType(ch) == 9;
    }

    public static boolean isISOControl(int ch) {
        return ch >= 0 && ch <= 159 && (ch <= 31 || ch >= 127);
    }

    public static boolean isLetter(int ch) {
        return (1 << UCharacter.getType(ch) & 0x3E) != 0;
    }

    public static boolean isLetterOrDigit(int ch) {
        return (1 << UCharacter.getType(ch) & 0x23E) != 0;
    }

    public static boolean isLowerCase(int ch) {
        return UCharacter.getType(ch) == 2;
    }

    public static boolean isWhitespace(int ch) {
        return (1 << UCharacter.getType(ch) & 0x7000) != 0 && ch != 160 && ch != 8239 && ch != 65279 || ch >= 9 && ch <= 13 || ch >= 28 && ch <= 31;
    }

    public static boolean isSpaceChar(int ch) {
        return (1 << UCharacter.getType(ch) & 0x7000) != 0;
    }

    public static boolean isTitleCase(int ch) {
        return UCharacter.getType(ch) == 3;
    }

    public static boolean isUnicodeIdentifierPart(int ch) {
        return (1 << UCharacter.getType(ch) & 0x40077E) != 0 || UCharacter.isIdentifierIgnorable(ch);
    }

    public static boolean isUnicodeIdentifierStart(int ch) {
        return (1 << UCharacter.getType(ch) & 0x43E) != 0;
    }

    public static boolean isIdentifierIgnorable(int ch) {
        if (ch <= 159) {
            return !(!UCharacter.isISOControl(ch) || ch >= 9 && ch <= 13 || ch >= 28 && ch <= 31);
        }
        return UCharacter.getType(ch) == 16;
    }

    public static boolean isUpperCase(int ch) {
        return UCharacter.getType(ch) == 1;
    }

    public static int toLowerCase(int ch) {
        int props = PROPERTY_.getProperty(ch);
        if (UCharacter.isNotExceptionIndicator(props)) {
            int cat = 0x1F & props;
            if (cat == 1 || cat == 3) {
                return ch + UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 1)) {
                return PROPERTY_.getException(index, 1);
            }
        }
        return ch;
    }

    public static String toString(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            return null;
        }
        if (ch < 65536) {
            return String.valueOf((char)ch);
        }
        StringBuffer result = new StringBuffer();
        result.append(UTF16.getLeadSurrogate((int)ch));
        result.append(UTF16.getTrailSurrogate((int)ch));
        return result.toString();
    }

    public static int toTitleCase(int ch) {
        int props = PROPERTY_.getProperty(ch);
        if (UCharacter.isNotExceptionIndicator(props)) {
            if ((0x1F & props) == 2) {
                return ch - UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 2)) {
                return PROPERTY_.getException(index, 2);
            }
            if (PROPERTY_.hasExceptionValue(index, 0)) {
                return PROPERTY_.getException(index, 0);
            }
        }
        return ch;
    }

    public static int toUpperCase(int ch) {
        int props = PROPERTY_.getProperty(ch);
        if (UCharacter.isNotExceptionIndicator(props)) {
            if ((0x1F & props) == 2) {
                return ch - UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 0)) {
                return PROPERTY_.getException(index, 0);
            }
        }
        return ch;
    }

    public static boolean isSupplementary(int ch) {
        return ch >= 65536 && ch <= 0x10FFFF;
    }

    public static boolean isBMP(int ch) {
        return ch >= 0 && ch <= 65535;
    }

    public static boolean isPrintable(int ch) {
        int cat = UCharacter.getType(ch);
        return cat != 0 && cat != 15 && cat != 16 && cat != 17 && cat != 18 && cat != 0;
    }

    public static boolean isBaseForm(int ch) {
        int cat = UCharacter.getType(ch);
        return cat == 9 || cat == 11 || cat == 10 || cat == 1 || cat == 2 || cat == 3 || cat == 4 || cat == 5 || cat == 6 || cat == 7 || cat == 8;
    }

    public static int getDirection(int ch) {
        return UCharacter.getProperty(ch) >> 6 & 0x1F;
    }

    public static boolean isMirrored(int ch) {
        return (PROPERTY_.getProperty(ch) & 0x800) != 0;
    }

    public static int getMirror(int ch) {
        int props = PROPERTY_.getProperty(ch);
        if ((props & 0x800) != 0) {
            if (UCharacter.isNotExceptionIndicator(props)) {
                return ch + UCharacterProperty.getSignedValue(props);
            }
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 6)) {
                return PROPERTY_.getException(index, 6);
            }
        }
        return ch;
    }

    public static int getCombiningClass(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return NormalizerImpl.getCombiningClass(ch);
    }

    public static boolean isLegal(int ch) {
        if (ch < 0) {
            return false;
        }
        if (ch < 55296) {
            return true;
        }
        if (ch <= 57343) {
            return false;
        }
        if (UCharacterUtility.isNonCharacter((int)ch)) {
            return false;
        }
        return ch <= 0x10FFFF;
    }

    public static boolean isLegal(String str) {
        int size = str.length();
        int i = 0;
        while (i < size) {
            int codepoint = UTF16.charAt((String)str, (int)i);
            if (!UCharacter.isLegal(codepoint)) {
                return false;
            }
            if (UCharacter.isSupplementary(codepoint)) {
                ++i;
            }
            ++i;
        }
        return true;
    }

    public static VersionInfo getUnicodeVersion() {
        return UCharacter.PROPERTY_.m_unicodeVersion_;
    }

    public static String getName(int ch) {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return NAME_.getName(ch, 0);
    }

    public static String getName1_0(int ch) {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return NAME_.getName(ch, 1);
    }

    public static String getExtendedName(int ch) {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return NAME_.getName(ch, 2);
    }

    public static String getISOComment(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            return null;
        }
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        String result = NAME_.getGroupName(ch, 3);
        return result;
    }

    public static int getCharFromName(String name) {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return NAME_.getCharFromName(0, name);
    }

    public static int getCharFromName1_0(String name) {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return NAME_.getCharFromName(1, name);
    }

    public static int getCharFromExtendedName(String name) {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return NAME_.getCharFromName(2, name);
    }

    public static String getPropertyName(int property, int nameChoice) {
        return PNAMES_.getPropertyName(property, nameChoice);
    }

    public static int getPropertyEnum(String propertyAlias) {
        return PNAMES_.getPropertyEnum(propertyAlias);
    }

    public static String getPropertyValueName(int property, int value, int nameChoice) {
        return PNAMES_.getPropertyValueName(property, value, nameChoice);
    }

    public static int getPropertyValueEnum(int property, String valueAlias) {
        return PNAMES_.getPropertyValueEnum(property, valueAlias);
    }

    public static int getCodePoint(char lead, char trail) {
        if (lead >= '\ud800' && lead <= '\udbff' && trail >= '\udc00' && trail <= '\udfff') {
            return UCharacterProperty.getRawSupplementary(lead, trail);
        }
        throw new IllegalArgumentException("Illegal surrogate characters");
    }

    public static int getCodePoint(char char16) {
        if (UCharacter.isLegal(char16)) {
            return char16;
        }
        throw new IllegalArgumentException("Illegal codepoint");
    }

    public static String toUpperCase(String str) {
        return UCharacter.toUpperCase(Locale.getDefault(), str);
    }

    public static String toLowerCase(String str) {
        return UCharacter.toLowerCase(Locale.getDefault(), str);
    }

    public static String toTitleCase(String str, BreakIterator breakiter) {
        return UCharacter.toTitleCase(Locale.getDefault(), str, breakiter);
    }

    public static String toUpperCase(Locale locale, String str) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return PROPERTY_.toUpperCase(locale, str, 0, str.length());
    }

    public static String toLowerCase(Locale locale, String str) {
        int length = str.length();
        StringBuffer result = new StringBuffer(length);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        PROPERTY_.toLowerCase(locale, str, 0, length, result);
        return result.toString();
    }

    public static String toTitleCase(Locale locale, String str, BreakIterator breakiter) {
        if (breakiter == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            breakiter = BreakIterator.getWordInstance((Locale)locale);
        }
        return PROPERTY_.toTitleCase(locale, str, breakiter);
    }

    public static int foldCase(int ch, boolean defaultmapping) {
        int props = PROPERTY_.getProperty(ch);
        if (UCharacter.isNotExceptionIndicator(props)) {
            int type = 0x1F & props;
            if (type == 1 || type == 3) {
                return ch + UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 8)) {
                int exception = PROPERTY_.getException(index, 8);
                if (exception != 0) {
                    int foldedcasech = PROPERTY_.getFoldCase(exception & 0xFFFF);
                    if (foldedcasech != 0) {
                        return foldedcasech;
                    }
                } else {
                    if (defaultmapping) {
                        if (ch == 73 || ch == 304) {
                            return 105;
                        }
                    } else {
                        if (ch == 73) {
                            return 305;
                        }
                        if (ch == 304) {
                            return 105;
                        }
                    }
                    return ch;
                }
            }
            if (PROPERTY_.hasExceptionValue(index, 1)) {
                return PROPERTY_.getException(index, 1);
            }
        }
        return ch;
    }

    public static String foldCase(String str, boolean defaultmapping) {
        int size = str.length();
        StringBuffer result = new StringBuffer(size);
        int offset = 0;
        while (offset < size) {
            int ch = UTF16.charAt((String)str, (int)offset);
            offset += UTF16.getCharCount((int)ch);
            int props = PROPERTY_.getProperty(ch);
            if (UCharacter.isNotExceptionIndicator(props)) {
                int type = 0x1F & props;
                if (type == 1 || type == 3) {
                    ch += UCharacterProperty.getSignedValue(props);
                }
            } else {
                int index = UCharacterProperty.getExceptionIndex(props);
                if (PROPERTY_.hasExceptionValue(index, 8)) {
                    int exception = PROPERTY_.getException(index, 8);
                    if (exception != 0) {
                        PROPERTY_.getFoldCase(exception & 0xFFFF, exception >> 24, result);
                        continue;
                    }
                    if (ch != 73 && ch != 304) {
                        UTF16.append((StringBuffer)result, (int)ch);
                        continue;
                    }
                    if (defaultmapping) {
                        if (ch == 73) {
                            result.append('i');
                            continue;
                        }
                        if (ch != 304) continue;
                        result.append('i');
                        result.append('\u0307');
                        continue;
                    }
                    if (ch == 73) {
                        result.append('\u0131');
                        continue;
                    }
                    if (ch != 304) continue;
                    result.append('i');
                    continue;
                }
                if (PROPERTY_.hasExceptionValue(index, 1)) {
                    ch = PROPERTY_.getException(index, 1);
                }
            }
            UTF16.append((StringBuffer)result, (int)ch);
        }
        return result.toString();
    }

    public static int foldCase(int ch, int options) {
        int props = PROPERTY_.getProperty(ch);
        if (UCharacter.isNotExceptionIndicator(props)) {
            int type = 0x1F & props;
            if (type == 1 || type == 3) {
                return ch + UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 8)) {
                int exception = PROPERTY_.getException(index, 8);
                if (exception != 0) {
                    int foldedcasech = PROPERTY_.getFoldCase(exception & 0xFFFF);
                    if (foldedcasech != 0) {
                        return foldedcasech;
                    }
                } else {
                    if ((options & 0xFF) == 0) {
                        if (ch == 73 || ch == 304) {
                            return 105;
                        }
                    } else {
                        if (ch == 73) {
                            return 305;
                        }
                        if (ch == 304) {
                            return 105;
                        }
                    }
                    return ch;
                }
            }
            if (PROPERTY_.hasExceptionValue(index, 1)) {
                return PROPERTY_.getException(index, 1);
            }
        }
        return ch;
    }

    public static final String foldCase(String str, int options) {
        int size = str.length();
        StringBuffer result = new StringBuffer(size);
        int offset = 0;
        while (offset < size) {
            int ch = UTF16.charAt((String)str, (int)offset);
            offset += UTF16.getCharCount((int)ch);
            int props = UCharacter.getProperty(ch);
            if ((props & 0x20) == 0) {
                int type = 0x1F & props;
                if (type == 1 || type == 3) {
                    ch += UCharacterProperty.getSignedValue(props);
                }
            } else {
                int index = UCharacterProperty.getExceptionIndex(props);
                if (PROPERTY_.hasExceptionValue(index, 8)) {
                    int exception = PROPERTY_.getException(index, 8);
                    if (exception != 0) {
                        PROPERTY_.getFoldCase(exception & 0xFFFF, exception >> 24, result);
                        continue;
                    }
                    if (ch != 73 && ch != 304) {
                        UTF16.append((StringBuffer)result, (int)ch);
                        continue;
                    }
                    if ((options & 0xFF) == 0) {
                        if (ch == 73) {
                            result.append('i');
                            continue;
                        }
                        if (ch != 304) continue;
                        result.append('i');
                        result.append('\u0307');
                        continue;
                    }
                    if (ch == 73) {
                        result.append('\u0131');
                        continue;
                    }
                    if (ch != 304) continue;
                    result.append('i');
                    continue;
                }
                if (PROPERTY_.hasExceptionValue(index, 1)) {
                    ch = PROPERTY_.getException(index, 1);
                }
            }
            UTF16.append((StringBuffer)result, (int)ch);
        }
        return result.toString();
    }

    public static int getHanNumericValue(int ch) {
        switch (ch) {
            case 12295: 
            case 38646: {
                return 0;
            }
            case 19968: 
            case 22777: {
                return 1;
            }
            case 20108: 
            case 36019: {
                return 2;
            }
            case 19977: 
            case 21443: {
                return 3;
            }
            case 22232: 
            case 32902: {
                return 4;
            }
            case 20116: 
            case 20237: {
                return 5;
            }
            case 20845: 
            case 38520: {
                return 6;
            }
            case 19971: 
            case 26578: {
                return 7;
            }
            case 20843: 
            case 25420: {
                return 8;
            }
            case 20061: 
            case 29590: {
                return 9;
            }
            case 21313: 
            case 25342: {
                return 10;
            }
            case 20336: 
            case 30334: {
                return 100;
            }
            case 20191: 
            case 21315: {
                return 1000;
            }
            case 33356: {
                return 10000;
            }
            case 20740: {
                return 100000000;
            }
        }
        return -1;
    }

    public static RangeValueIterator getTypeIterator() {
        return new UCharacterTypeIterator(PROPERTY_);
    }

    public static ValueIterator getNameIterator() {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return new UCharacterNameIterator(NAME_, 0);
    }

    public static ValueIterator getName1_0Iterator() {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return new UCharacterNameIterator(NAME_, 1);
    }

    public static ValueIterator getExtendedNameIterator() {
        if (NAME_ == null) {
            throw new RuntimeException("Could not load unames.icu");
        }
        return new UCharacterNameIterator(NAME_, 2);
    }

    public static VersionInfo getAge(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.getAge(ch);
    }

    public static boolean hasBinaryProperty(int ch, int property) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.hasBinaryProperty(ch, property);
    }

    public static boolean isUAlphabetic(int ch) {
        return UCharacter.hasBinaryProperty(ch, 0);
    }

    public static boolean isULowercase(int ch) {
        return UCharacter.hasBinaryProperty(ch, 22);
    }

    public static boolean isUUppercase(int ch) {
        return UCharacter.hasBinaryProperty(ch, 30);
    }

    public static boolean isUWhiteSpace(int ch) {
        return UCharacter.hasBinaryProperty(ch, 31);
    }

    public static int getIntPropertyValue(int ch, int type) {
        if (type < 0) {
            return 0;
        }
        if (type < 35) {
            return UCharacter.hasBinaryProperty(ch, type) ? 1 : 0;
        }
        if (type < 4096) {
            return 0;
        }
        if (type < 4108) {
            switch (type) {
                case 4096: {
                    return UCharacter.getDirection(ch);
                }
                case 4097: {
                    return UnicodeBlock.of((int)ch).getID();
                }
                case 4098: {
                    return UCharacter.getCombiningClass(ch);
                }
                case 4099: {
                    return PROPERTY_.getAdditional(ch, 2) & 0x1F;
                }
                case 4100: {
                    return (PROPERTY_.getAdditional(ch, 0) & 0x38000) >> 15;
                }
                case 4101: {
                    return UCharacter.getType(ch);
                }
                case 4102: {
                    return (PROPERTY_.getAdditional(ch, 2) & 0x7E0) >> 5;
                }
                case 4103: {
                    return (PROPERTY_.getAdditional(ch, 2) & 0x3800) >> 11;
                }
                case 4104: {
                    return (PROPERTY_.getAdditional(ch, 0) & 0x7C0000) >> 18;
                }
                case 4105: {
                    return UCharacter.getNumericType(PROPERTY_.getProperty(ch));
                }
                case 4106: {
                    return UScript.getScript((int)ch);
                }
                case 4107: {
                    if (ch >= 4352) {
                        if (ch <= 4607) {
                            if (ch <= 4447) {
                                if (ch == 4447 || ch <= 4441 || UCharacter.getType(ch) == 5) {
                                    return 1;
                                }
                            } else if (ch <= 4519) {
                                if (ch <= 4514 || UCharacter.getType(ch) == 5) {
                                    return 2;
                                }
                            } else if (ch <= 4601 || UCharacter.getType(ch) == 5) {
                                return 3;
                            }
                        } else if ((ch -= 44032) >= 0 && ch < 11172) {
                            return ch % 28 == 0 ? 4 : 5;
                        }
                    }
                    return 0;
                }
            }
            return 0;
        }
        if (type == 8192) {
            return UCharacterProperty.getMask(UCharacter.getType(ch));
        }
        return 0;
    }

    public static int getIntPropertyMinValue(int type) {
        return 0;
    }

    public static int getIntPropertyMaxValue(int type) {
        if (type < 0) {
            return -1;
        }
        if (type < 35) {
            return 1;
        }
        if (type < 4096) {
            return -1;
        }
        if (type < 4108) {
            int max = 0;
            switch (type) {
                case 4096: {
                    return 18;
                }
                case 4097: {
                    max = (PROPERTY_.getMaxValues(0) & 0x7F80) >> 7;
                    return max != 0 ? max : 125;
                }
                case 4098: {
                    return 255;
                }
                case 4099: {
                    max = PROPERTY_.getMaxValues(2) & 0x1F;
                    return max != 0 ? max : 17;
                }
                case 4100: {
                    max = (PROPERTY_.getMaxValues(0) & 0x38000) >> 15;
                    return max != 0 ? max : 5;
                }
                case 4101: {
                    return 29;
                }
                case 4102: {
                    max = (PROPERTY_.getMaxValues(2) & 0x7E0) >> 5;
                    return max != 0 ? max : 53;
                }
                case 4103: {
                    max = (PROPERTY_.getMaxValues(2) & 0x3800) >> 11;
                    return max != 0 ? max : 5;
                }
                case 4104: {
                    max = (PROPERTY_.getMaxValues(0) & 0x7C0000) >> 18;
                    return max != 0 ? max : 30;
                }
                case 4105: {
                    return 3;
                }
                case 4106: {
                    max = PROPERTY_.getMaxValues(0) & 0x7F;
                    return max != 0 ? max : 53;
                }
                case 4107: {
                    return 5;
                }
            }
        }
        return -1;
    }

    private UCharacter() {
    }

    private static int getEuropeanDigit(int ch) {
        if (ch > 122 && ch < 65313 || ch < 65 || ch > 90 && ch < 97 || ch > 65370 || ch > 65329 && ch < 65345) {
            return -1;
        }
        if (ch <= 122) {
            return ch + 10 - (ch <= 90 ? 65 : 97);
        }
        if (ch <= 65338) {
            return ch + 10 - 65313;
        }
        return ch + 10 - 65345;
    }

    private static int getNumericType(int props) {
        return (props & 0x7000) >> 12;
    }

    private static boolean isNotExceptionIndicator(int props) {
        return (props & 0x20) == 0;
    }

    private static int getProperty(int ch) {
        if (ch < 55296 || ch > 56319 && ch < 65536) {
            try {
                return PROPERTY_DATA_[PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[ch >> 5] << 2) + (ch & 0x1F)]];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return PROPERTY_INITIAL_VALUE_;
            }
        }
        if (ch <= 56319) {
            return PROPERTY_DATA_[PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[320 + (ch >> 5)] << 2) + (ch & 0x1F)]];
        }
        if (ch <= 0x10FFFF) {
            return PROPERTY_DATA_[UCharacter.PROPERTY_.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate((int)ch), (char)(ch & 0x3FF))];
        }
        return PROPERTY_INITIAL_VALUE_;
    }

    static /* synthetic */ UCharacterProperty access$000() {
        return PROPERTY_;
    }

    static {
        try {
            PNAMES_ = new UPropertyAliases();
            NAME_ = UCharacterName.getInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            PROPERTY_ = UCharacterProperty.getInstance();
            PROPERTY_TRIE_INDEX_ = UCharacter.PROPERTY_.m_trieIndex_;
            PROPERTY_TRIE_DATA_ = UCharacter.PROPERTY_.m_trieData_;
            PROPERTY_DATA_ = UCharacter.PROPERTY_.m_property_;
            PROPERTY_INITIAL_VALUE_ = PROPERTY_DATA_[UCharacter.PROPERTY_.m_trieInitialValue_];
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

