/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.axis;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.AdminClient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class AdminClientTask
extends MatchingTask {
    private boolean failOnError = true;
    private String hostname;
    private int port = 0;
    private String servletPath;
    private File srcDir = null;
    private File xmlFile;
    private String transportChain;
    private String username;
    private String password;
    private String fileProtocol;
    private String action = "";
    private String url;
    private boolean debug;
    private String newPassword;
    private LinkedList argslist;
    private boolean fork = false;
    private Path classpath = null;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setFileProtocol(String fileProtocol) {
        this.fileProtocol = fileProtocol;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public void setTransportChain(String transportChain) {
        this.transportChain = transportChain;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setFork(boolean f) {
        this.fork = f;
    }

    protected void validate() throws BuildException {
        if (this.srcDir != null) {
            if (!this.srcDir.exists()) {
                throw new BuildException("srcdir does not exist!");
            }
            if (!this.srcDir.isDirectory()) {
                throw new BuildException("srcdir is not a directory!");
            }
        }
    }

    public void traceParams(int logLevel) {
        this.log("Running axis-admin with parameters:", logLevel);
        this.log("  action:" + this.action, logLevel);
        this.log("  url:" + this.url, logLevel);
        this.log("  hostname:" + this.hostname, logLevel);
        this.log("  port:" + this.port, logLevel);
        this.log("  servletPath:" + this.servletPath, logLevel);
        this.log("  fileProtocol:" + this.fileProtocol, logLevel);
        this.log("  username:" + this.username, logLevel);
        this.log("  password:" + this.password, logLevel);
        this.log("  transportChain:" + this.transportChain, logLevel);
        this.log("  debug:" + this.debug, logLevel);
    }

    public void execute() throws BuildException {
        this.traceParams(3);
        this.validate();
        this.argslist = new LinkedList();
        this.addArgs("-l", this.url, this.url != null);
        this.addArgs("-h", this.hostname, this.hostname != null);
        this.addArgs("-p", Integer.toString(this.port), this.port != 0);
        this.addArgs("-s", this.servletPath, this.servletPath != null);
        this.addArgs("-f", this.fileProtocol, this.fileProtocol != null);
        this.addArgs("-u", this.username, this.username != null);
        this.addArgs("-w", this.password, this.password != null);
        this.addArgs("-t", this.transportChain, this.transportChain != null);
        this.addArg("-d", this.debug);
        this.addArg(this.action, this.action != null);
        if ("passwd".equals(this.action)) {
            if (this.newPassword == null) {
                throw new BuildException("No newpassword set for passwd");
            }
            this.addArg(this.newPassword);
        } else if (this.newPassword != null) {
            throw new BuildException("newpassword is only used when action=passwd");
        }
        if (this.xmlFile != null) {
            if (!this.xmlFile.exists()) {
                throw new BuildException("File " + this.xmlFile + " no found");
            }
            this.addArg(this.xmlFile.toString());
        }
        if (this.srcDir != null) {
            DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File srcFile = new File(this.srcDir, files[i]);
                if (!srcFile.exists()) {
                    throw new BuildException("File " + srcFile + " no found");
                }
                this.addArg(srcFile.getAbsolutePath());
            }
        }
        int counter = 0;
        String[] args = new String[this.argslist.size()];
        Iterator it = this.argslist.iterator();
        while (it.hasNext()) {
            String arg;
            args[counter] = arg = (String)it.next();
            ++counter;
        }
        if (this.fork) {
            this.executeInForkedVM(args);
        } else {
            this.executeInCurrentVM(args);
        }
    }

    private void executeInForkedVM(String[] args) {
        try {
            Java java = (Java)this.getProject().createTask("java");
            this.getProject().log("using classpath: " + this.classpath, 4);
            java.setClasspath(this.classpath);
            java.setClassname("org.apache.axis.client.AdminClient");
            for (int i = 0; i < args.length; ++i) {
                java.createArg().setValue(args[i]);
            }
            java.setFailonerror(this.failOnError);
            java.setFork(true);
            java.setTaskName("AdminClient");
            java.execute();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException("Exception in " + this.getTaskName(), e);
        }
    }

    private void executeInCurrentVM(String[] args) {
        AdminClient admin = null;
        try {
            admin = new AdminClient(true);
        }
        catch (ServiceException e) {
            throw new BuildException("failed to start the axis engine", e);
        }
        String result = null;
        try {
            result = admin.process(args);
            if (result != null) {
                this.log(result);
            } else {
                this.logOrThrow(this.getTaskName() + " got a null response");
            }
        }
        catch (AxisFault fault) {
            this.log(fault.dumpToString(), 0);
            this.traceParams(0);
            this.logOrThrow(this.getTaskName() + " failed with  " + fault.getFaultCode().toString() + " " + fault.getFaultString());
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException("Exception in " + this.getTaskName(), e);
        }
    }

    private void logOrThrow(String text) throws BuildException {
        if (this.failOnError) {
            throw new BuildException(text);
        }
        this.log(text, 0);
    }

    protected void addArg(String argument) {
        this.argslist.add(argument);
    }

    protected void addArg(String argument, boolean test) {
        if (test) {
            this.argslist.add(argument);
        }
    }

    protected void addArgs(String argument, String param) {
        this.addArg(argument);
        this.addArg(param);
    }

    protected void addArgs(String argument, String param, boolean test) {
        if (test) {
            this.addArg(argument);
            this.addArg(param);
        }
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }
}

