/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.client;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.biomoby.client.CentralImpl;
import org.biomoby.registry.meta.RegistryCache;
import org.biomoby.shared.MobyException;

public class CentralCachedCallsImpl
extends CentralImpl {
    protected static String CHAR_ENCODING = "UTF-8";
    protected static final String SYNTAX_TYPE = "xml";
    protected static final long THE_EPOCH = 0L;
    protected static final Properties PROPERTIES = null;
    protected Map<String, String> inProgressCalls = new HashMap<String, String>();

    public CentralCachedCallsImpl() throws MobyException {
        super("http://moby.ucalgary.ca/moby/MOBY-Central.pl", "http://moby.ucalgary.ca/MOBY/Central");
    }

    public CentralCachedCallsImpl(String endpoint) throws MobyException {
        super(endpoint, "http://moby.ucalgary.ca/MOBY/Central");
    }

    public CentralCachedCallsImpl(String endpoint, String namespace) throws MobyException {
        super(endpoint, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doCall(String method, Object[] parameters) throws MobyException {
        Object result = null;
        String callKey = this.createId(method, parameters);
        if (this.getCacheMode()) {
            if (this.existsInCache(callKey)) {
                return this.getContents(callKey);
            }
            String inProgressCall = null;
            Object object = this.inProgressCalls;
            synchronized (object) {
                String threadName = this.inProgressCalls.get(callKey);
                if (threadName == null) {
                    threadName = Thread.currentThread().getName();
                    this.inProgressCalls.put(callKey, threadName);
                }
                inProgressCall = threadName;
            }
            object = inProgressCall;
            synchronized (object) {
                if (this.existsInCache(callKey)) {
                    return this.getContents(callKey);
                }
                try {
                    result = super.doCall(method, parameters);
                    this.setContents(callKey, result);
                }
                finally {
                    this.inProgressCalls.remove(callKey);
                }
            }
        }
        result = super.doCall(method, parameters);
        return result;
    }

    public boolean existsInCache(String id) {
        if (!this.getCacheMode()) {
            return false;
        }
        if (super.existsInCache(id)) {
            return true;
        }
        File cachedDataFile = RegistryCache.getCentralCallFile(this.getRegistryEndpoint(), id);
        if (cachedDataFile != null) {
            try {
                Object cachedValue = this.loadDataFromFile(cachedDataFile);
                super.setContents(id, cachedValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Could not load data from cache file " + cachedDataFile);
                return false;
            }
            return true;
        }
        return false;
    }

    protected Object loadDataFromFile(File cacheFile) throws Exception {
        char[] contentsBuffer = new char[(int)cacheFile.length()];
        FileReader cacheFileReader = new FileReader(cacheFile);
        cacheFileReader.read(contentsBuffer);
        return new String(contentsBuffer);
    }

    protected void storeDataToFile(File cacheFile, Object data) throws Exception {
        if (!(data instanceof CharSequence)) {
            if (data instanceof Serializable) {
                throw new Exception("Serialization in cache not yet implemented");
            }
            throw new Exception("Asked to serialize data that is neither a CharSequence, nor serializable.  Found " + data.getClass().getName());
        }
        FileWriter cacheFileWriter = new FileWriter(cacheFile);
        cacheFileWriter.write(((Object)((CharSequence)data)).toString());
        cacheFileWriter.close();
    }

    public void setContents(String id, Object data) {
        if (!this.getCacheMode()) {
            return;
        }
        super.setContents(id, data);
        File cachedDataFile = RegistryCache.calcCentralCallFile(this.getRegistryEndpoint(), id);
        try {
            this.storeDataToFile(cachedDataFile, data);
        }
        catch (Exception e) {
            System.err.println("Could not store data to cache file " + cachedDataFile);
        }
    }

    protected String createId(String method, Object[] parameters) {
        StringBuffer semanticType = new StringBuffer();
        for (int i = 0; parameters != null && i < parameters.length; ++i) {
            semanticType.append(parameters[i]);
        }
        return this.createId(method, semanticType.toString(), SYNTAX_TYPE, 0L, PROPERTIES);
    }

    public String createId(String rootName, String semanticType, String syntaxType, long lastModified, Properties props) {
        return rootName + semanticType + syntaxType + lastModified + props;
    }
}

