/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.biomoby.client.SimpleCache;
import org.biomoby.shared.Central;
import org.biomoby.shared.MobyData;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.MobyRelationship;
import org.biomoby.shared.MobyResourceRef;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.MobyServiceType;
import org.biomoby.shared.NoSuccessException;
import org.biomoby.shared.PendingCurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentralImpl
implements Central,
SimpleCache {
    private URL endpoint;
    private String uri;
    protected boolean debug = false;
    public static final String DEFAULT_ENDPOINT = "http://moby.ucalgary.ca/moby/MOBY-Central.pl";
    public static final String DEFAULT_NAMESPACE = "http://moby.ucalgary.ca/MOBY/Central";
    public static ThreadLocal DOCUMENT_BUILDER_FACTORIES = new ThreadLocal(){

        protected synchronized Object initialValue() {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf;
        }
    };
    private Hashtable<String, Object> cache;
    private boolean useCache;
    private static String CHECKED_URL = null;
    private static String CHECKED_URI = null;

    public CentralImpl() throws MobyException {
        this(DEFAULT_ENDPOINT, DEFAULT_NAMESPACE);
    }

    public CentralImpl(String endpoint) throws MobyException {
        this(endpoint, DEFAULT_NAMESPACE);
    }

    public CentralImpl(String endpoint, String namespace) throws MobyException {
        if (endpoint == null || "".equals(endpoint.trim())) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (namespace == null || "".equals(namespace.trim())) {
            namespace = DEFAULT_NAMESPACE;
        }
        try {
            this.endpoint = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new MobyException("Bad URL: " + endpoint);
        }
        this.uri = namespace;
        this.cache = new Hashtable();
        this.useCache = true;
    }

    public static Document loadDocument(InputStream input) throws MobyException {
        try {
            DocumentBuilderFactory dbf = (DocumentBuilderFactory)DOCUMENT_BUILDER_FACTORIES.get();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(input);
        }
        catch (Exception e) {
            throw new MobyException("Problem with reading XML input: " + e.toString(), e);
        }
    }

    protected Object doCall(String method, Object[] parameters) throws MobyException {
        Call call = null;
        try {
            Service service = new Service();
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(this.endpoint);
            call.setTimeout(new Integer(0));
            call.setSOAPActionURI(this.uri + "#" + method);
            if (this.debug) {
                System.err.println("METHOD CALL: " + method);
                System.err.println("------------");
                if (parameters.length > 0) {
                    System.err.println(parameters[0] + "\n");
                }
                System.err.println("------------\n");
                Object result = call.invoke(this.uri, method, parameters);
                System.err.println("METHOD RETURN:");
                System.err.println("------------");
                if (result != null) {
                    System.err.println(result + "\n");
                }
                System.err.println("------------\n");
                return CentralImpl.resultToString(result);
            }
            return CentralImpl.resultToString(call.invoke(this.uri, method, parameters));
        }
        catch (AxisFault e) {
            throw new MobyException(CentralImpl.formatFault(e, this.endpoint.toString(), call == null ? null : call.getOperationName()), e);
        }
        catch (Exception e) {
            throw new MobyException(e.toString(), e);
        }
    }

    protected String[] checkRegistration(String xml, Object culprit) throws MobyException, NoSuccessException, PendingCurationException {
        String id = "";
        String success = "0";
        String message = "";
        String rdf = "";
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(xml.getBytes()));
        Element root = document.getDocumentElement();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element elem = (Element)children.item(i);
            if (elem.getNodeName().equals("id")) {
                if (elem.getFirstChild() == null) continue;
                id = elem.getFirstChild().getNodeValue();
                continue;
            }
            if (elem.getNodeName().equals("success")) {
                if (elem.getFirstChild() == null) continue;
                success = elem.getFirstChild().getNodeValue();
                continue;
            }
            if (elem.getNodeName().equals("message")) {
                if (elem.getFirstChild() == null) continue;
                message = elem.getFirstChild().getNodeValue();
                continue;
            }
            if (!elem.getNodeName().equals("RDF") || elem.getFirstChild() == null) continue;
            rdf = elem.getFirstChild().getNodeValue();
        }
        if (success.equals("0")) {
            throw new NoSuccessException(message, culprit);
        }
        if (success.equals("-1")) {
            throw new PendingCurationException();
        }
        return new String[]{id, rdf};
    }

    protected String buildPrimaryInputTag(MobyService service) {
        StringBuffer buf = new StringBuffer();
        MobyPrimaryData[] primaryInputs = service.getPrimaryInputs();
        buf.append("<Input>\n");
        for (int i = 0; i < primaryInputs.length; ++i) {
            buf.append(primaryInputs[i].toXML());
        }
        buf.append("</Input>\n");
        return new String(buf);
    }

    protected String buildSecondaryInputTag(MobyService service) {
        StringBuffer buf = new StringBuffer();
        MobySecondaryData[] secInputs = service.getSecondaryInputs();
        buf.append("<secondaryArticles>\n");
        for (int i = 0; i < secInputs.length; ++i) {
            buf.append(((MobyData)secInputs[i]).toXML());
        }
        buf.append("</secondaryArticles>\n");
        return new String(buf);
    }

    protected String buildOutputTag(MobyService service) {
        StringBuffer buf = new StringBuffer();
        MobyPrimaryData[] primaryOutputs = service.getPrimaryOutputs();
        buf.append("<Output>\n");
        for (int i = 0; i < primaryOutputs.length; ++i) {
            buf.append(primaryOutputs[i].toXML());
        }
        buf.append("</Output>\n");
        return new String(buf);
    }

    protected String buildQueryObject(MobyService service, String[] keywords, boolean expandObjects, boolean expandServices, boolean authoritative) {
        String sigURL;
        if (service == null) {
            service = new MobyService("dummy");
            service.setCategory("");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<inputObjects>\n<Input>\n");
        MobyPrimaryData[] pi = service.getPrimaryInputs();
        if (pi.length > 0) {
            for (int i = 0; i < pi.length; ++i) {
                buf.append(pi[i].toXML());
            }
        }
        buf.append("</Input>\n</inputObjects>\n");
        buf.append("<outputObjects>\n<Output>\n");
        MobyPrimaryData[] po = service.getPrimaryOutputs();
        if (po.length > 0) {
            for (int i = 0; i < po.length; ++i) {
                buf.append(po[i].toXML());
            }
        }
        buf.append("</Output>\n</outputObjects>\n");
        buf.append("<serviceType>" + service.getType() + "</serviceType>\n");
        String name = service.getName();
        if (!(name.equals("") || name.equals("dummy") || name.equals("_dummy_"))) {
            buf.append("<serviceName>" + service.getName() + "</serviceName>\n");
        }
        if (!(sigURL = service.getSignatureURL()).equals("")) {
            buf.append("<signatureURL>" + sigURL + "</signatureURL>\n");
        }
        buf.append("<Category>" + service.getCategory() + "</Category>\n");
        buf.append("<authURI>" + service.getAuthority() + "</authURI>\n");
        buf.append("<expandObjects>");
        buf.append(expandObjects ? "1" : "0");
        buf.append("</expandObjects>\n");
        buf.append("<expandServices>");
        buf.append(expandServices ? "1" : "0");
        buf.append("</expandServices>\n");
        buf.append("<authoritative>");
        buf.append(authoritative ? "1" : "0");
        buf.append("</authoritative>\n");
        buf.append("<keywords>\n");
        if (keywords != null && keywords.length > 0) {
            for (int i = 0; i < keywords.length; ++i) {
                buf.append("<keyword>");
                buf.append(keywords[i]);
                buf.append("</keyword>\n");
            }
        }
        buf.append("</keywords>\n");
        return new String(buf);
    }

    public MobyService[] extractServices(String xml) throws MobyException {
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(xml.getBytes()));
        NodeList list = document.getElementsByTagName("Service");
        MobyService[] results = new MobyService[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            MobyService service = new MobyService(elem.getAttribute("serviceName"));
            service.setAuthority(elem.getAttribute("authURI"));
            service.setLSID(elem.getAttribute("lsid"));
            NodeList children = elem.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                MobyData data;
                NodeList inputs;
                String nodeName = children.item(j).getNodeName();
                if (nodeName.equals("Description")) {
                    service.setDescription(this.getFirstValue(children.item(j)));
                    continue;
                }
                if (nodeName.equals("Category")) {
                    service.setCategory(this.getFirstValue(children.item(j)));
                    continue;
                }
                if (nodeName.equals("URL")) {
                    service.setURL(this.getFirstValue(children.item(j)));
                    continue;
                }
                if (nodeName.equals("signatureURL")) {
                    service.setSignatureURL(this.getFirstValue(children.item(j)));
                    continue;
                }
                if (nodeName.equals("contactEmail")) {
                    service.setEmailContact(this.getFirstValue(children.item(j)));
                    continue;
                }
                if (nodeName.equals("serviceType")) {
                    Node node;
                    service.setType(this.getFirstValue(children.item(j)));
                    MobyServiceType mst = new MobyServiceType(service.getType());
                    NamedNodeMap map = children.item(j).getAttributes();
                    if (map != null && (node = map.getNamedItemNS(children.item(j).getNamespaceURI(), "lsid")) != null) {
                        mst.setLSID(node.getNodeValue());
                    }
                    service.setServiceType(mst);
                    continue;
                }
                if (nodeName.equals("authoritative")) {
                    String authoritative = this.getFirstValue(children.item(j));
                    service.setAuthoritative(authoritative.equals("1"));
                    continue;
                }
                if (nodeName.equals("Input")) {
                    inputs = children.item(j).getChildNodes();
                    for (int k = 0; k < inputs.getLength(); ++k) {
                        if (inputs.item(k).getNodeName().equals("Simple")) {
                            data = new MobyPrimaryDataSimple((Element)inputs.item(k));
                            service.addInput(data);
                            continue;
                        }
                        if (!inputs.item(k).getNodeName().equals("Collection")) continue;
                        data = new MobyPrimaryDataSet((Element)inputs.item(k));
                        service.addInput(data);
                    }
                    continue;
                }
                if (nodeName.equals("Output")) {
                    inputs = children.item(j).getChildNodes();
                    for (int k = 0; k < inputs.getLength(); ++k) {
                        if (inputs.item(k).getNodeName().equals("Simple")) {
                            data = new MobyPrimaryDataSimple((Element)inputs.item(k));
                            service.addOutput(data);
                            continue;
                        }
                        if (!inputs.item(k).getNodeName().equals("Collection")) continue;
                        data = new MobyPrimaryDataSet((Element)inputs.item(k));
                        service.addOutput(data);
                    }
                    continue;
                }
                if (!nodeName.equals("secondaryArticles")) continue;
                NodeList parameters = children.item(j).getChildNodes();
                for (int k = 0; k < parameters.getLength(); ++k) {
                    if (!parameters.item(k).getNodeName().equals("Parameter")) continue;
                    data = new MobySecondaryData((Element)parameters.item(k));
                    service.addInput(data);
                }
            }
            results[i] = service;
        }
        return results;
    }

    protected String getFirstValue(Node child) {
        Node node = child.getFirstChild();
        if (node == null) {
            return "";
        }
        String value = node.getNodeValue();
        if (value == null) {
            return "";
        }
        return value;
    }

    protected String getFirstValue(NodeList children) {
        if (children.item(0) != null && children.item(0).hasChildNodes()) {
            children.item(0).normalize();
            return this.getFirstValue(children.item(0));
        }
        return "";
    }

    @Override
    public String createId(String rootName, String semanticType, String syntaxType, long lastModified, Properties props) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsInCache(String id) {
        Hashtable<String, Object> hashtable = this.cache;
        synchronized (hashtable) {
            if (this.useCache) {
                return this.cache.containsKey(id);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getContents(String id) {
        Hashtable<String, Object> hashtable = this.cache;
        synchronized (hashtable) {
            if (this.useCache) {
                return this.cache.get(id);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(String id, Object data) {
        Hashtable<String, Object> hashtable = this.cache;
        synchronized (hashtable) {
            if (this.useCache) {
                this.cache.put(id, data);
            }
        }
    }

    @Override
    public void removeFromCache(String id) {
        this.cache.clear();
    }

    @Override
    public void setCacheMode(boolean shouldCache) {
        this.useCache = shouldCache;
        if (!this.useCache) {
            this.removeFromCache(null);
        }
    }

    @Override
    public boolean getCacheMode() {
        return this.useCache;
    }

    @Override
    public Map<String, String> getServiceNames() throws MobyException {
        String result = (String)this.doCall("retrieveServiceNames", new Object[0]);
        TreeMap<String, String> results = new TreeMap<String, String>(CentralImpl.getStringComparator());
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("serviceName");
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            results.put(elem.getAttribute("name"), elem.getAttribute("authURI"));
        }
        return results;
    }

    public Map getServiceNamesByAuthority() throws MobyException {
        String result = this.getServiceNamesByAuthorityAsXML();
        return this.createServicesByAuthorityFromXML(result, true);
    }

    public Map getServicesByAuthority() throws MobyException {
        String result = this.getServiceNamesByAuthorityAsXML();
        return this.createServicesByAuthorityFromXML(result, false);
    }

    protected String getServiceNamesByAuthorityAsXML() throws MobyException {
        return (String)this.doCall("retrieveServiceNames", new Object[0]);
    }

    protected Map createServicesByAuthorityFromXML(String result, boolean onlyNames) throws MobyException {
        TreeMap<String, Vector> results = new TreeMap<String, Vector>(CentralImpl.getStringComparator());
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("serviceName");
        for (int i = 0; i < list.getLength(); ++i) {
            Vector v;
            Element element = (Element)list.item(i);
            String name = element.getAttribute("name");
            String auth = element.getAttribute("authURI");
            Vector vector = v = results.containsKey(auth) ? (Vector)results.get(auth) : new Vector();
            if (onlyNames) {
                v.addElement(name);
            } else {
                MobyService ms = new MobyService(name);
                ms.setAuthority(auth);
                ms.setLSID(element.getAttribute("lsid"));
                v.addElement(ms);
            }
            results.put(auth, v);
        }
        for (Map.Entry entry : results.entrySet()) {
            Vector v = (Vector)entry.getValue();
            if (onlyNames) {
                Object[] sNames = new String[v.size()];
                v.copyInto(sNames);
                entry.setValue(sNames);
                continue;
            }
            Object[] mss = new MobyService[v.size()];
            v.copyInto(mss);
            entry.setValue(mss);
        }
        return results;
    }

    @Override
    public String[] getProviders() throws MobyException {
        String cacheId = "retrieveServiceProviders";
        String[] cachedResults = (String[])this.getContents(cacheId);
        if (cachedResults != null) {
            return cachedResults;
        }
        String result = (String)this.doCall("retrieveServiceProviders", new Object[0]);
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("serviceProvider");
        String[] results = new String[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            results[i] = ((Element)list.item(i)).getAttribute("name");
        }
        this.setContents(cacheId, results);
        return results;
    }

    public Map getServiceTypes() throws MobyException {
        String result = this.getServiceTypesAsXML();
        TreeMap<String, String> results = new TreeMap<String, String>(CentralImpl.getStringComparator());
        MobyServiceType[] types = this.createServiceTypesFromXML(result);
        for (int i = 0; i < types.length; ++i) {
            results.put(types[i].getName(), types[i].getDescription());
        }
        return results;
    }

    protected String getServiceTypesAsXML() throws MobyException {
        return (String)this.doCall("retrieveServiceTypes", new Object[0]);
    }

    protected MobyServiceType[] createServiceTypesFromXML(String result) throws MobyException {
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("serviceType");
        if (list == null || list.getLength() == 0) {
            return new MobyServiceType[0];
        }
        Object[] results = new MobyServiceType[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            MobyServiceType st = new MobyServiceType(elem.getAttribute("name"));
            st.setLSID(elem.getAttribute("lsid"));
            st.setDescription(this.getFirstValue(elem.getElementsByTagName("Description")));
            st.setEmailContact(this.getFirstValue(elem.getElementsByTagName("contactEmail")));
            st.setAuthority(this.getFirstValue(elem.getElementsByTagName("authURI")));
            results[i] = st;
        }
        Arrays.sort(results);
        return results;
    }

    @Override
    public MobyNamespace[] getFullNamespaces() throws MobyException {
        String result = this.getNamespacesAsXML();
        return this.createNamespacesFromXML(result);
    }

    protected String getNamespacesAsXML() throws MobyException {
        return (String)this.doCall("retrieveNamespaces", new Object[0]);
    }

    protected MobyNamespace[] createNamespacesFromXML(String result) throws MobyException {
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getDocumentElement().getElementsByTagName("Namespace");
        if (list == null || list.getLength() == 0) {
            return new MobyNamespace[0];
        }
        Object[] results = new MobyNamespace[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            MobyNamespace nm = new MobyNamespace(elem.getAttribute("name"));
            nm.setLSID(elem.getAttribute("lsid"));
            nm.setDescription(this.getFirstValue(elem.getElementsByTagName("Description")));
            nm.setEmailContact(this.getFirstValue(elem.getElementsByTagName("contactEmail")));
            nm.setAuthority(this.getFirstValue(elem.getElementsByTagName("authURI")));
            results[i] = nm;
        }
        Arrays.sort(results);
        return results;
    }

    public Map getNamespaces() throws MobyException {
        TreeMap<String, String> results = new TreeMap<String, String>(CentralImpl.getStringComparator());
        MobyNamespace[] namespaces = this.getFullNamespaces();
        for (int i = 0; i < namespaces.length; ++i) {
            results.put(namespaces[i].getName(), namespaces[i].getDescription());
        }
        return results;
    }

    public Map getDataTypeNames() throws MobyException {
        String result = this.getDataTypeNamesAsXML();
        return this.createDataTypeNamesFromXML(result, true);
    }

    protected String getDataTypeNamesAsXML() throws MobyException {
        return (String)this.doCall("retrieveObjectNames", new Object[0]);
    }

    protected Map createDataTypeNamesFromXML(String result, boolean onlyNames) throws MobyException {
        TreeMap<String, Object> results = new TreeMap<String, Object>(CentralImpl.getStringComparator());
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("Object");
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            String name = elem.getAttribute("name");
            if (name == null) continue;
            String desc = "";
            NodeList children = elem.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("Description")) continue;
                desc = this.getFirstValue(children.item(j));
                break;
            }
            if (onlyNames) {
                results.put(name, desc);
                continue;
            }
            MobyDataType dt = new MobyDataType(name);
            dt.setDescription(desc);
            dt.setLSID(elem.getAttribute("lsid"));
            results.put(name, dt);
        }
        return results;
    }

    @Override
    public MobyDataType getDataType(String dataTypeName) throws MobyException, NoSuccessException {
        String result = this.getDataTypeAsXML(dataTypeName);
        return this.createDataTypeFromXML(result, dataTypeName);
    }

    protected String getDataTypeAsXML(String dataTypeName) throws MobyException, NoSuccessException {
        return (String)this.doCall("retrieveObjectDefinition", new Object[]{"<retrieveObjectDefinition><objectType>" + dataTypeName + "</objectType>" + "</retrieveObjectDefinition>"});
    }

    protected MobyDataType createDataTypeFromXML(String xmlSource, String dataTypeName) throws MobyException, NoSuccessException {
        String nodeName;
        int j;
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(xmlSource.getBytes()));
        NodeList list = document.getElementsByTagName("retrieveObjectDefinition");
        if (list == null || list.getLength() == 0) {
            throw new NoSuccessException("Data Type name was not found.", dataTypeName);
        }
        MobyDataType data = null;
        Element elem = (Element)list.item(0);
        NodeList children = elem.getChildNodes();
        for (j = 0; j < children.getLength(); ++j) {
            nodeName = children.item(j).getNodeName();
            if (!nodeName.equals("objectType")) continue;
            data = new MobyDataType(this.getFirstValue(children.item(j)));
            data.setLSID(((Element)children.item(j)).getAttribute("lsid"));
            break;
        }
        if (data == null) {
            data = new MobyDataType(dataTypeName);
        }
        for (j = 0; j < children.getLength(); ++j) {
            NodeList belows;
            int k;
            nodeName = children.item(j).getNodeName();
            if (nodeName.equals("Description")) {
                data.setDescription(this.getFirstValue(children.item(j)));
                continue;
            }
            if (nodeName.equals("authURI")) {
                data.setAuthority(this.getFirstValue(children.item(j)));
                continue;
            }
            if (nodeName.equals("contactEmail")) {
                data.setEmailContact(this.getFirstValue(children.item(j)));
                continue;
            }
            if (!nodeName.equals("Relationship")) continue;
            String relationshipType = ((Element)children.item(j)).getAttribute("relationshipType");
            if (relationshipType.endsWith("isa")) {
                NodeList parents = children.item(j).getChildNodes();
                for (k = 0; k < parents.getLength(); ++k) {
                    if (!parents.item(k).getNodeName().equals("objectType")) continue;
                    data.addParentName(this.getFirstValue(parents.item(k)));
                }
                continue;
            }
            if (relationshipType.endsWith("hasa")) {
                belows = children.item(j).getChildNodes();
                for (k = 0; k < belows.getLength(); ++k) {
                    if (!belows.item(k).getNodeName().equals("objectType")) continue;
                    data.addChild(((Element)belows.item(k)).getAttribute("articleName"), this.getFirstValue(belows.item(k)), 2);
                }
                continue;
            }
            if (!relationshipType.endsWith("has")) continue;
            belows = children.item(j).getChildNodes();
            for (k = 0; k < belows.getLength(); ++k) {
                if (!belows.item(k).getNodeName().equals("objectType")) continue;
                data.addChild(((Element)belows.item(k)).getAttribute("articleName"), belows.item(k).getFirstChild().getNodeValue(), 3);
            }
        }
        return data;
    }

    @Override
    public String getServiceWSDL(String serviceName) throws MobyException, NoSuccessException {
        Map<String, String> names = this.getServiceNames();
        for (Map.Entry<String, String> entry : names.entrySet()) {
            if (!entry.getKey().equals(serviceName)) continue;
            return this.getServiceWSDL(serviceName, entry.getValue());
        }
        throw new NoSuccessException("Service not found.", serviceName);
    }

    @Override
    public String getServiceWSDL(String serviceName, String authority) throws MobyException, NoSuccessException {
        String cacheId = "getServiceWSDL" + serviceName + ":" + authority;
        String cachedResults = (String)this.getContents(cacheId);
        if (cachedResults != null) {
            return cachedResults;
        }
        String result = (String)this.doCall("retrieveService", new Object[]{"<retrieveService><Service authURI=\"" + authority + "\" serviceName=\"" + serviceName + "\"/>" + "</retrieveService>"});
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        Element service = document.getDocumentElement();
        Node wsdl = service.getFirstChild();
        if (wsdl == null) {
            throw new NoSuccessException("Service not found OR WSDL is not available.", serviceName + " (" + authority + ")");
        }
        String results = wsdl.getNodeValue();
        this.setContents(cacheId, results);
        return results;
    }

    public String getRegisterDataTypeXML(MobyDataType dataType) {
        String[] names = dataType.getParentNames();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            buf.append("<objectType>");
            buf.append(names[i]);
            buf.append("</objectType>");
            buf.append("\n");
        }
        MobyRelationship[] children = dataType.getChildren();
        StringBuffer buf2 = new StringBuffer();
        StringBuffer buf3 = new StringBuffer();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getRelationshipType() == 2) {
                buf2.append("<objectType articleName=\"");
                buf2.append(children[i].getName());
                buf2.append("\">");
                buf2.append(children[i].getDataTypeName());
                buf2.append("</objectType>");
                continue;
            }
            if (children[i].getRelationshipType() != 3) continue;
            buf3.append("<objectType articleName=\"");
            buf3.append(children[i].getName());
            buf3.append("\">");
            buf3.append(children[i].getDataTypeName());
            buf3.append("</objectType>");
        }
        return "<registerObjectClass><objectType>" + dataType.getName() + "</objectType>" + "<Description><![CDATA[" + dataType.getDescription() + "]]>" + "</Description>" + "<Relationship relationshipType=\"ISA\">" + new String(buf) + "</Relationship>" + "<Relationship relationshipType=\"HASA\">" + new String(buf2) + "</Relationship>" + "<Relationship relationshipType=\"HAS\">" + new String(buf3) + "</Relationship>" + "<authURI>" + dataType.getAuthority() + "</authURI>" + "<contactEmail>" + dataType.getEmailContact() + "</contactEmail>" + "</registerObjectClass>";
    }

    @Override
    public void registerDataType(MobyDataType dataType) throws MobyException, NoSuccessException, PendingCurationException {
        String result = (String)this.doCall("registerObjectClass", new Object[]{this.getRegisterDataTypeXML(dataType)});
        dataType.setId(this.checkRegistration(result, dataType)[0]);
    }

    @Override
    public void unregisterDataType(MobyDataType dataType) throws MobyException, NoSuccessException, PendingCurationException {
        String result = (String)this.doCall("deregisterObjectClass", new Object[]{"<deregisterObjectClass><objectType>" + dataType.getName() + "</objectType>" + "</deregisterObjectClass>"});
        this.checkRegistration(result, dataType);
    }

    public String getRegisterServiceTypeXML(MobyServiceType serviceType) {
        String[] names = serviceType.getParentNames();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            buf.append("<serviceType>");
            buf.append(names[i]);
            buf.append("</serviceType>");
            buf.append("\n");
        }
        return "<registerServiceType><serviceType>" + serviceType.getName() + "</serviceType>" + "<contactEmail>" + serviceType.getEmailContact() + "</contactEmail>" + "<authURI>" + serviceType.getAuthority() + "</authURI>" + "<Description><![CDATA[" + serviceType.getDescription() + "]]>" + "</Description>" + "<Relationship relationshipType=\"ISA\">" + new String(buf) + "</Relationship>" + "</registerServiceType>";
    }

    @Override
    public void registerServiceType(MobyServiceType serviceType) throws MobyException, NoSuccessException, PendingCurationException {
        String result = (String)this.doCall("registerServiceType", new Object[]{this.getRegisterServiceTypeXML(serviceType)});
        serviceType.setId(this.checkRegistration(result, serviceType)[0]);
    }

    @Override
    public void unregisterServiceType(MobyServiceType serviceType) throws MobyException, NoSuccessException, PendingCurationException {
        String result = (String)this.doCall("deregisterServiceType", new Object[]{"<deregisterServiceType><serviceType>" + serviceType.getName() + "</serviceType>" + "</deregisterServiceType>"});
        this.checkRegistration(result, serviceType);
    }

    public String getRegisterNamespaceXML(MobyNamespace namespace) {
        return "<registerNamespace><namespaceType>" + namespace.getName() + "</namespaceType>" + "<contactEmail>" + namespace.getEmailContact() + "</contactEmail>" + "<authURI>" + namespace.getAuthority() + "</authURI>" + "<Description><![CDATA[" + namespace.getDescription() + "]]>" + "</Description>" + "</registerNamespace>";
    }

    @Override
    public void registerNamespace(MobyNamespace namespace) throws MobyException, NoSuccessException, PendingCurationException {
        String result = (String)this.doCall("registerNamespace", new Object[]{this.getRegisterNamespaceXML(namespace)});
        namespace.setId(this.checkRegistration(result, namespace)[0]);
    }

    @Override
    public void unregisterNamespace(MobyNamespace namespace) throws MobyException, NoSuccessException, PendingCurationException {
        String result = (String)this.doCall("deregisterNamespace", new Object[]{"<deregisterNamespace><namespaceType>" + namespace.getName() + "</namespaceType>" + "</deregisterNamespace>"});
        this.checkRegistration(result, namespace);
    }

    public String getRegisterServiceXML(MobyService service) {
        return "<registerService><Category>" + service.getCategory() + "</Category>" + "<serviceName>" + service.getName() + "</serviceName>" + "<serviceType>" + service.getType() + "</serviceType>" + "<serviceLSID>" + (service.getLSID() == null ? "" : service.getLSID().trim()) + "</serviceLSID>" + "<authURI>" + service.getAuthority() + "</authURI>" + "<signatureURL>" + this.escapeXML(service.getSignatureURL()) + "</signatureURL>" + "<URL>" + this.escapeXML(service.getURL()) + "</URL>" + "<contactEmail>" + service.getEmailContact() + "</contactEmail>" + "<authoritativeService>" + (service.isAuthoritative() ? "1" : "0") + "</authoritativeService>" + "<Description><![CDATA[" + service.getDescription() + "]]>" + "</Description>" + this.buildPrimaryInputTag(service) + this.buildSecondaryInputTag(service) + this.buildOutputTag(service) + "</registerService>";
    }

    @Override
    public void registerService(MobyService service) throws MobyException, NoSuccessException, PendingCurationException {
        String result = (String)this.doCall("registerService", new Object[]{this.getRegisterServiceXML(service)});
        String[] registered = this.checkRegistration(result, service);
        service.setId(registered[0]);
        service.setRDF(registered[1]);
        String pathToRDF = service.getPathToRDF();
        if (!pathToRDF.equals("")) {
            File fileRDF = new File(pathToRDF);
            try {
                PrintStream fileout = new PrintStream(new FileOutputStream(fileRDF));
                fileout.println(registered[1]);
                fileout.close();
            }
            catch (IOException e) {
                StringBuffer buf = new StringBuffer(100);
                buf.append("Failed to save RDF in '");
                buf.append(fileRDF.getAbsolutePath() + "'. ");
                buf.append(e.toString());
                try {
                    File tmpFile = File.createTempFile(service.getName() + "-", ".rdf");
                    PrintStream fileout = new PrintStream(new FileOutputStream(tmpFile));
                    fileout.println(registered[1]);
                    fileout.close();
                    buf.append("\nReturned RDF file was therefore stored in: ");
                    buf.append(tmpFile.getAbsolutePath());
                }
                catch (IOException e2) {
                    buf.append("\nEven saving in a temporary file failed: ");
                    buf.append(e2.toString());
                }
                throw new MobyException(buf.toString());
            }
        }
    }

    @Override
    public void unregisterService(MobyService service) throws MobyException, NoSuccessException, PendingCurationException {
        String result = (String)this.doCall("deregisterService", new Object[]{"<deregisterService><authURI>" + service.getAuthority() + "</authURI>" + "<serviceName>" + service.getName() + "</serviceName>" + "</deregisterService>"});
        this.checkRegistration(result, service);
    }

    @Override
    public MobyService[] findService(String serviceType) throws MobyException {
        if (serviceType == null) {
            return new MobyService[0];
        }
        MobyService pattern = new MobyService("dummy");
        pattern.setCategory("");
        pattern.setType(serviceType);
        return this.findService(pattern, null);
    }

    @Override
    public MobyService[] findService(String[] keywords) throws MobyException {
        if (keywords == null) {
            return new MobyService[0];
        }
        return this.findService(null, keywords);
    }

    @Override
    public MobyService[] findService(MobyService pattern) throws MobyException {
        if (pattern == null) {
            return new MobyService[0];
        }
        return this.findService(pattern, null);
    }

    @Override
    public MobyService[] findService(MobyService pattern, String[] keywords) throws MobyException {
        return this.findService(pattern, keywords, true, true);
    }

    @Override
    public MobyService[] findService(MobyService pattern, String[] keywords, boolean includeChildrenServiceTypes, boolean includeParentDataTypes) throws MobyException {
        if (pattern == null) {
            pattern = new MobyService("dummy");
            pattern.setCategory("");
        }
        String result = this.getServicesAsXML(pattern, keywords, includeChildrenServiceTypes, includeParentDataTypes);
        MobyService[] services = this.extractServices(result);
        return services;
    }

    protected String getServicesAsXML(MobyService pattern, String[] keywords, boolean includeChildrenServiceTypes, boolean includeParentDataTypes) throws MobyException {
        Object[] query = new String[]{"<findService>" + this.buildQueryObject(pattern, keywords, includeParentDataTypes, includeChildrenServiceTypes, false) + "</findService>"};
        return (String)this.doCall("findService", query);
    }

    @Override
    public String call(String methodName, String inputXML) throws MobyException {
        Object result = inputXML == null || inputXML.equals("") ? this.doCall(methodName, new Object[0]) : this.doCall(methodName, new Object[]{inputXML});
        return (String)result;
    }

    protected static String resultToString(Object result) throws MobyException {
        if (result == null) {
            throw new MobyException("Returned result is null.");
        }
        if (result instanceof String) {
            return (String)result;
        }
        if (result instanceof String[]) {
            String[] tmp = (String[])result;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < tmp.length; ++i) {
                buf.append(tmp[i]);
            }
            return new String(buf);
        }
        if (result instanceof byte[]) {
            return new String((byte[])result);
        }
        throw new MobyException("Unknown type of result: " + result.getClass().getName());
    }

    @Override
    public boolean setDebug(boolean enabled) {
        boolean oldMode = this.debug;
        this.debug = enabled;
        return oldMode;
    }

    @Override
    public String[] getServiceTypeRelationships(String serviceTypeName, boolean expand) throws MobyException {
        String result = this.getServiceTypeRelationshipsAsXML(serviceTypeName, expand);
        return this.createServiceTypeRelationshipsFromXML(result);
    }

    protected String getServiceTypeRelationshipsAsXML(String serviceTypeName, boolean expand) throws MobyException {
        return (String)this.doCall("Relationships", new Object[]{"<Relationship><serviceType>" + serviceTypeName + "</serviceType>" + "<relationshipType>" + "ISA" + "</relationshipType>" + "<expandRelationship>" + (expand ? "1" : "0") + "</expandRelationship>" + "</Relationship>"});
    }

    protected String[] createServiceTypeRelationshipsFromXML(String result) throws MobyException {
        Vector<String> v = new Vector<String>();
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("Relationship");
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            NodeList children = elem.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("serviceType")) continue;
                v.addElement(this.getFirstValue(children.item(j)));
            }
        }
        Object[] results = new String[v.size()];
        v.copyInto(results);
        return results;
    }

    public Map getDataTypeRelationships(String dataTypeName) throws MobyException {
        String cacheId = "getDataTypeRelationships_" + dataTypeName;
        Map cachedResults = (Map)this.getContents(cacheId);
        if (cachedResults != null) {
            return cachedResults;
        }
        String result = (String)this.doCall("Relationships", new Object[]{"<Relationships><objectType>" + dataTypeName + "</objectType>" + "<relationshipType>" + "ISA" + "</relationshipType>" + "<relationshipType>" + "HASA" + "</relationshipType>" + "<relationshipType>" + "HAS" + "</relationshipType>" + "<expandRelationship>1</expandRelationship>" + "</Relationships>"});
        HashMap<String, Object[]> results = new HashMap<String, Object[]>();
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("Relationship");
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            String relType = elem.getAttribute("relationshipType");
            NodeList children = elem.getChildNodes();
            Vector<String> v = new Vector<String>();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("objectType")) continue;
                v.addElement(this.getFirstValue(children.item(j)));
            }
            Object[] names = new String[v.size()];
            v.copyInto(names);
            results.put(relType, names);
        }
        this.setContents(cacheId, results);
        return results;
    }

    @Override
    public String[] getDataTypeRelationships(String dataTypeName, String relationshipType) throws MobyException {
        String cacheId = "getDataTypeRelationships_" + dataTypeName + ":" + relationshipType;
        String[] cachedResults = (String[])this.getContents(cacheId);
        if (cachedResults != null) {
            return cachedResults;
        }
        String result = (String)this.doCall("Relationships", new Object[]{"<Relationships><objectType>" + dataTypeName + "</objectType>" + "<relationshipType>" + relationshipType + "</relationshipType>" + "<expandRelationship>1</expandRelationship>" + "</Relationships>"});
        Vector<String> v = new Vector<String>();
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("Relationship");
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            NodeList children = elem.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("objectType")) continue;
                v.addElement(this.getFirstValue(children.item(j)));
            }
        }
        Object[] results = new String[v.size()];
        v.copyInto(results);
        this.setContents(cacheId, results);
        return results;
    }

    @Override
    public String getRegistryEndpoint() {
        return this.endpoint.toString();
    }

    @Override
    public String getRegistryNamespace() {
        return this.uri;
    }

    @Override
    public MobyResourceRef[] getResourceRefs() throws MobyException {
        String cacheId = "retrieveResourceURLs";
        MobyResourceRef[] cachedResults = (MobyResourceRef[])this.getContents(cacheId);
        if (cachedResults != null) {
            return cachedResults;
        }
        String result = (String)this.doCall("retrieveResourceURLs", new Object[0]);
        Vector<MobyResourceRef> v = new Vector<MobyResourceRef>();
        Document document = CentralImpl.loadDocument(new ByteArrayInputStream(result.getBytes()));
        NodeList list = document.getElementsByTagName("Resource");
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            try {
                v.addElement(new MobyResourceRef(elem.getAttribute("name"), new URL(elem.getAttribute("url")), elem.getAttribute("type")));
                continue;
            }
            catch (MalformedURLException e2) {
                if (!this.debug) continue;
                System.err.println("Bad URL: " + elem.getAttribute("url"));
            }
        }
        Object[] results = new MobyResourceRef[v.size()];
        v.copyInto(results);
        this.setContents(cacheId, results);
        return results;
    }

    @Override
    public InputStream getResource(String resourceName) throws MobyException {
        MobyResourceRef[] resourceRefs = this.getResourceRefs();
        for (int i = 0; i < resourceRefs.length; ++i) {
            if (!resourceName.equalsIgnoreCase(resourceRefs[i].getResourceName())) continue;
            URL url = resourceRefs[i].getResourceLocation();
            try {
                return url.openStream();
            }
            catch (IOException e2) {
                throw new MobyException(e2.toString(), e2);
            }
        }
        throw new MobyException("No resource found for '" + resourceName + "'.");
    }

    protected static Comparator getStringComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultURL() {
        boolean check = false;
        try {
            check = Boolean.getBoolean("moby.check.default");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (check) {
            if (CHECKED_URL != null && CHECKED_URL.trim() != "") {
                return CHECKED_URL;
            }
            HttpClient client = new HttpClient();
            HeadMethod method = new HeadMethod("http://biomoby.org/mobycentral");
            method.setFollowRedirects(false);
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            method.getParams().setParameter("http.useragent", (Object)"jMoby/1.0");
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 301) {
                    System.err.println("Method failed: " + method.getStatusLine());
                }
                try {
                    String location;
                    CHECKED_URL = location = method.getResponseHeader("location").getValue();
                    try {
                        CHECKED_URI = "http://" + new URL(CHECKED_URL).getAuthority() + "/MOBY/Central";
                    }
                    catch (MalformedURLException murle) {
                        CHECKED_URI = DEFAULT_NAMESPACE;
                    }
                    String string = CHECKED_URL;
                    return string;
                }
                catch (NullPointerException npe) {
                    String string;
                    try {
                        string = DEFAULT_ENDPOINT;
                    }
                    catch (HttpException e) {
                        System.err.println("Fatal protocol violation: " + e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        System.err.println("Fatal transport error: " + e.getMessage());
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    method.releaseConnection();
                    return string;
                }
            }
            finally {
                method.releaseConnection();
            }
        } else {
            return DEFAULT_ENDPOINT;
        }
        return DEFAULT_ENDPOINT;
    }

    public static String getDefaultURI() {
        boolean check = false;
        try {
            check = Boolean.getBoolean("moby.check.default");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (check) {
            if (CHECKED_URI != null && CHECKED_URI.trim() != "") {
                return CHECKED_URI;
            }
            CentralImpl.getDefaultURL();
            return CHECKED_URI;
        }
        return DEFAULT_NAMESPACE;
    }

    public String escapeXML(String str) {
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public static String formatFault(AxisFault e, String endpoint, QName method) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CentralImpl.formatFault(e, new PrintStream(baos), endpoint, method);
        return baos.toString();
    }

    public static void formatFault(AxisFault e, PrintStream out, String endpoint, QName method) {
        out.println("===ERROR===");
        out.println("Fault details:");
        String faultString = e.getFaultString();
        if (!faultString.startsWith("java.net.ConnectException") && faultString.indexOf("Could not find class for the service named:") == -1) {
            Element[] details = e.getFaultDetails();
            for (int i = 0; i < details.length; ++i) {
                String s = details[i].toString().replaceAll("&lt;", "<");
                s = s.replaceAll("&gt;", ">");
                out.println(s);
            }
        }
        out.println("Fault string: " + faultString);
        out.println("Fault code:   " + e.getFaultCode());
        out.println("Fault actor:  " + e.getFaultActor());
        if (endpoint != null || method != null) {
            out.println("When calling:");
        }
        if (endpoint != null) {
            out.println("\t" + endpoint);
        }
        if (method != null) {
            out.println("\t" + method);
        }
        out.println("===========");
    }
}

