/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.registry.meta;

import java.util.Enumeration;
import org.apache.commons.discovery.tools.Service;
import org.biomoby.registry.meta.Registries;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyException;

public class RegistriesList
implements Registries {
    Registry[] registries = new Registry[]{new Registry("default", "", "", "", "", true, ""), new Registry("Calgary", "http://moby.ucalgary.ca/moby/MOBY-Central.pl", "http://moby.ucalgary.ca/MOBY/Central", "Sun Center of Excellence for Visual Genomics, University of Calgary", "Edward Kawas (edward.kawas@gmail.com)", true, "A curated public registry hosted at the University of Calgary"), new Registry("IRRI", "http://cropwiki.irri.org/cgi-bin/MOBY-Central.pl", "http://cropwiki.irri.org/MOBY/Central", "IRRI, Philippines", "Mylah Rystie Anacleto (m.anacleto@cgiar.org)", true, "The MOBY registry at the International Rice Research Institute (IRRI) is intended mostly for Generation Challenge Program (GCP) developers. It allows the registration of experimental moby entities within GCP."), new Registry("INAB", "http://moby-dev.inab.org/cgi-bin/MOBY-Central.pl", "http://moby-dev.inab.org/MOBY/Central", "INAB, Spain", "", true, "The MOBY registry at the Instituto Nacional de Bioinform\u00e1tica, Spain."), new Registry("testing", "http://bioinfo.icapture.ubc.ca/cgi-bin/mobycentral/MOBY-Central.pl", "http://bioinfo.icapture.ubc.ca/MOBY/Central", "Testing BioMoby registry", "Edward Kawas (edward.kawas@gmail.com)", true, "")};

    public RegistriesList() {
        int fromIndex = 1;
        int toIndex = 0;
        this.registries[toIndex].setEndpoint(this.registries[fromIndex].getEndpoint());
        this.registries[toIndex].setNamespace(this.registries[fromIndex].getNamespace());
        this.registries[toIndex].setContact(this.registries[fromIndex].getContact());
        this.registries[toIndex].setDescription(this.registries[fromIndex].getDescription());
        this.registries[toIndex].setLongName(this.registries[fromIndex].getLongName());
    }

    public RegistriesList(Registry[] additionalRegistries) {
        this();
        int lenCurr = this.registries.length;
        int lenAdd = additionalRegistries.length;
        Registry[] extended = new Registry[lenCurr + lenAdd];
        System.arraycopy(this.registries, 0, extended, 0, lenCurr);
        System.arraycopy(additionalRegistries, 0, extended, lenCurr, lenAdd);
        this.registries = extended;
    }

    public static Registries getInstance() {
        Enumeration spe = Service.providers(Registries.class);
        if (spe.hasMoreElements()) {
            return (Registries)spe.nextElement();
        }
        return new RegistriesList();
    }

    public String[] list() {
        String[] results = new String[this.registries.length];
        for (int i = 0; i < this.registries.length; ++i) {
            results[i] = this.registries[i].getSynonym();
        }
        return results;
    }

    public Registry get(String synonym) throws MobyException {
        if (synonym == null) {
            synonym = "default";
        }
        for (int i = 0; i < this.registries.length; ++i) {
            String name = this.registries[i].getSynonym();
            if (name == null || !name.equalsIgnoreCase(synonym)) continue;
            return this.registries[i];
        }
        return null;
    }

    public Registry[] getAll() {
        return this.registries;
    }
}

