/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared;

import java.util.Enumeration;
import java.util.Vector;
import org.biomoby.shared.MobyData;
import org.biomoby.shared.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MobySecondaryData
extends MobyData {
    public static final String INTEGER_TYPE = "Integer";
    public static final String FLOAT_TYPE = "Float";
    public static final String STRING_TYPE = "String";
    public static final String DATETIME_TYPE = "DateTime";
    public static final String BOOLEAN_TYPE = "Boolean";
    protected String dataType = "String";
    protected String defaultValue = "";
    protected String minimumValue = "";
    protected String maximumValue = "";
    protected Vector<String> allowedValues = new Vector();
    protected String description = "";

    public MobySecondaryData(String name) {
        super(name);
    }

    public MobySecondaryData(Element elem) {
        super(elem.getAttribute("articleName"));
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String childName = children.item(i).getNodeName();
            if (childName.equals("datatype")) {
                if (children.item(i).getFirstChild() == null) continue;
                try {
                    this.setDataType(children.item(i).getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (childName.equals("description")) {
                if (children.item(i).getFirstChild() == null) continue;
                this.setDescription(children.item(i).getFirstChild().getNodeValue());
                continue;
            }
            if (childName.equals("default")) {
                if (children.item(i).getFirstChild() == null) continue;
                this.setDefaultValue(children.item(i).getFirstChild().getNodeValue());
                continue;
            }
            if (childName.equals("max")) {
                if (children.item(i).getFirstChild() == null) continue;
                this.setMaxValue(children.item(i).getFirstChild().getNodeValue());
                continue;
            }
            if (childName.equals("min")) {
                if (children.item(i).getFirstChild() == null) continue;
                this.setMinValue(children.item(i).getFirstChild().getNodeValue());
                continue;
            }
            if (!childName.equals("enum") || children.item(i).getFirstChild() == null) continue;
            this.addAllowedValue(children.item(i).getFirstChild().getNodeValue());
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String value) throws Exception {
        if (value.equalsIgnoreCase(INTEGER_TYPE)) {
            this.dataType = INTEGER_TYPE;
        } else if (value.equalsIgnoreCase(FLOAT_TYPE)) {
            this.dataType = FLOAT_TYPE;
        } else if (value.equalsIgnoreCase(STRING_TYPE)) {
            this.dataType = STRING_TYPE;
        } else if (value.equalsIgnoreCase(DATETIME_TYPE)) {
            this.dataType = DATETIME_TYPE;
        } else if (value.equalsIgnoreCase(BOOLEAN_TYPE)) {
            this.dataType = BOOLEAN_TYPE;
        } else {
            throw new Exception("Data type for secondary parameter '" + this.getName() + "' was not valid (\"" + value + "\"), must be one of " + INTEGER_TYPE + ", " + FLOAT_TYPE + ", " + STRING_TYPE + ", " + DATETIME_TYPE + ", " + BOOLEAN_TYPE);
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value == null ? "" : value;
    }

    public int getMinimumValue() {
        try {
            return Integer.valueOf(this.minimumValue);
        }
        catch (Exception e) {
            return Integer.MIN_VALUE;
        }
    }

    public void setMinimumValue(int value) {
        this.minimumValue = value + "";
    }

    public String getMinValue() {
        return this.minimumValue;
    }

    public void setMinValue(String value) {
        this.minimumValue = value == null ? "" : value;
    }

    public int getMaximumValue() {
        try {
            return Integer.valueOf(this.maximumValue);
        }
        catch (Exception e) {
            return Integer.MAX_VALUE;
        }
    }

    public void setMaximumValue(int value) {
        this.maximumValue = value + "";
    }

    public String getMaxValue() {
        return this.maximumValue;
    }

    public void setMaxValue(String value) {
        this.maximumValue = value == null ? "" : value;
    }

    public String[] getAllowedValues() {
        Object[] result = new String[this.allowedValues.size()];
        this.allowedValues.copyInto(result);
        return result;
    }

    public void setAllowedValues(String[] value) {
        if (value == null) {
            this.allowedValues.clear();
        } else {
            for (int i = 0; i < value.length; ++i) {
                this.allowedValues.addElement(value[i]);
            }
        }
    }

    public void addAllowedValue(String value) {
        this.allowedValues.addElement(value);
    }

    public boolean isPrimary() {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value == null ? "" : value;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<Parameter articleName=\"");
        buf.append(this.name);
        buf.append("\">\n");
        buf.append("<datatype>");
        buf.append(this.dataType);
        buf.append("</datatype>\n");
        buf.append("<description>");
        buf.append(this.description);
        buf.append("</description>\n");
        if (!this.defaultValue.equals("")) {
            buf.append("<default>" + this.defaultValue + "</default>\n");
        }
        if (!"".equals(this.maximumValue)) {
            buf.append("<max>" + this.maximumValue + "</max>\n");
        }
        if (!"".equals(this.minimumValue)) {
            buf.append("<min>" + this.minimumValue + "</min>\n");
        }
        if (this.allowedValues.size() > 0) {
            Enumeration<String> en = this.allowedValues.elements();
            while (en.hasMoreElements()) {
                buf.append("<enum>");
                buf.append((Object)en.nextElement());
                buf.append("</enum>\n");
            }
        }
        buf.append("</Parameter>\n");
        return new String(buf);
    }

    public String format(int indent) {
        return Utils.format((Object)this, (int)indent);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null && this.name.length() > 0) {
            buf.append("Name:      " + this.name + "\n");
        }
        if (this.id != null) {
            buf.append("ID:        " + this.id + "\n");
        }
        buf.append("Data Type: " + this.dataType + "\n");
        if (this.description != null && this.description.length() > 0) {
            buf.append("Desc:      " + this.description + "\n");
        }
        if (this.defaultValue != null && this.defaultValue.length() > 0) {
            buf.append("Default:   " + this.defaultValue + "\n");
        }
        if (this.minimumValue != null && this.minimumValue.length() > 0) {
            buf.append("Min:       " + this.minimumValue + "\n");
        }
        if (this.maximumValue != null && this.maximumValue.length() > 0) {
            buf.append("Max:       " + this.maximumValue + "\n");
        }
        if (this.allowedValues.size() > 0) {
            buf.append("Allowed values: ");
            Enumeration<String> en = this.allowedValues.elements();
            while (en.hasMoreElements()) {
                buf.append(en.nextElement() + " ");
            }
            buf.append("\n");
        }
        return new String(buf);
    }
}

