/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataJob;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataSecondaryInstance;
import org.biomoby.shared.data.MobyServiceException;
import org.biomoby.shared.parser.ServiceException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyContentInstance
implements Map<String, MobyDataJob> {
    private static boolean debug = false;
    private static PrintStream debugPS = System.err;
    private String serviceAuthURI = null;
    private String serviceNotes = null;
    private int xmlMode = 891;
    private HashMap<String, MobyDataJob> members = new HashMap();
    private int autoID = 1;
    private Vector<ServiceException> exceptions = new Vector();

    public MobyContentInstance() {
    }

    public MobyContentInstance(MobyDataInstance mdi, String paramName) throws MobyException {
        this();
        if (!(mdi == null || mdi instanceof MobyDataSecondaryInstance || mdi instanceof MobyDataObject || mdi instanceof MobyDataObjectSet)) {
            throw new MobyException("The input Moby data instance class (" + mdi.getClass().getName() + ") was neither MobyDataObject nor MobyDataObjectSet nor " + "MobyDataSecondaryInstance as required");
        }
        MobyDataJob queryParams = new MobyDataJob();
        if (mdi != null) {
            if (paramName == null) {
                paramName = "";
            }
            queryParams.put(paramName, mdi);
        }
        this.put("" + this.autoID++, queryParams);
    }

    public MobyContentInstance(Element objectTag) throws MobyException {
        this(objectTag, null);
    }

    public MobyContentInstance(Element objectTag, Registry registry) throws MobyException {
        this();
        if (!"mobyContent".equals(objectTag.getLocalName())) {
            throw new MobyException("The content element provided (" + objectTag.getLocalName() + ") was not " + "mobyContent");
        }
        if (!"http://www.biomoby.org/moby".equals(objectTag.getNamespaceURI())) {
            if (!"http://www.biomoby.org/moby-s".equals(objectTag.getNamespaceURI())) {
                throw new MobyException("The content element's namespace (" + objectTag.getNamespaceURI() + ") did not have the MOBY namespace " + "http://www.biomoby.org/moby");
            }
            System.err.println("Invalid namespace used for content element (was " + objectTag.getNamespaceURI() + ", but should be " + "http://www.biomoby.org/moby" + ", proceeding anyway");
        }
        this.members = new HashMap();
        NodeList mobyData = MobyPrefixResolver.getChildElements(objectTag, "mobyData");
        for (int i = 0; i < mobyData.getLength(); ++i) {
            Element dataGroup = (Element)mobyData.item(i);
            if (dataGroup == null) {
                System.err.println("Warning: found null element in DOM results (very strange)");
                continue;
            }
            this.parseDataGroup(dataGroup, registry);
        }
        try {
            this.setServiceAuthorityURI(objectTag.getAttributeNS("http://www.biomoby.org/moby", "authority"));
        }
        catch (DOMException dome) {
            System.err.println("Warning: DOM exception while looking for authority attribute in tag mobyContent");
        }
        NodeList notes = MobyPrefixResolver.getChildElements(objectTag, "serviceNotes");
        if (notes.getLength() > 0) {
            StringBuffer notesText = new StringBuffer();
            boolean hasNotes = false;
            for (int i = 0; i < notes.getLength(); ++i) {
                Element noteTag = (Element)notes.item(i);
                NodeList noteparts = MobyPrefixResolver.getChildElements(noteTag, "Notes");
                for (int j = 0; j < noteparts.getLength(); ++j) {
                    notesText.append(((Element)noteparts.item(j)).getTextContent());
                    hasNotes = true;
                }
                NodeList exs = MobyPrefixResolver.getChildElements(noteTag, "mobyException");
                for (int j = 0; j < exs.getLength(); ++j) {
                    this.addException(new MobyServiceException((Element)exs.item(j)));
                }
            }
            if (hasNotes) {
                this.setServiceNotes(notesText.toString());
            }
        }
    }

    public static void setDebugMode(boolean mode) {
        debug = mode;
    }

    public static void setDebugPrintStream(PrintStream ps) throws IllegalArgumentException {
        if (ps == null) {
            throw new IllegalArgumentException("The OutputStream specified to MobyContentInstance was null");
        }
        debugPS = ps;
    }

    public void parseDataGroup(Element dataGroupTag, Registry registry) throws MobyException {
        String groupID = null;
        MobyDataJob job = new MobyDataJob();
        groupID = dataGroupTag.getAttributeNS("http://www.biomoby.org/moby", "queryID");
        if (groupID == null) {
            groupID = dataGroupTag.getAttributeNS("http://www.biomoby.org/moby-s", "queryID");
        }
        if (groupID == null || groupID.length() == 0) {
            groupID = dataGroupTag.getAttributeNS("", "queryID");
        }
        if (groupID == null || groupID.length() == 0) {
            groupID = dataGroupTag.getAttributeNS(null, "queryID");
        }
        if (groupID == null) {
            groupID = "" + this.autoID++;
        }
        job.setID(groupID);
        NodeList collections = MobyPrefixResolver.getChildElements(dataGroupTag, "Collection");
        for (int j = 0; collections != null && j < collections.getLength(); ++j) {
            if (debug && j == 0) {
                debugPS.println("There are " + collections.getLength() + " collections in response " + groupID);
            }
            Element collectionTag = (Element)collections.item(j);
            MobyDataObjectSet collection = (MobyDataObjectSet)MobyDataObject.createInstanceFromDOM(collectionTag, registry);
            job.put(collection.getName(), collection);
        }
        NodeList simples = MobyPrefixResolver.getChildElements(dataGroupTag, "Simple");
        if (!(collections != null && collections.getLength() != 0 || simples != null && simples.getLength() != 0)) {
            debugPS.println("WARNING: There appears to be no output data in the mobyData");
        }
        for (int j = 0; simples != null && j < simples.getLength(); ++j) {
            String name;
            if (debug && j == 0) {
                debugPS.println("There are " + simples.getLength() + " simples in the response");
            }
            if ((name = MobyPrefixResolver.getAttr((Element)simples.item(j), "articleName")) != null) {
                if (job.containsKey(name)) {
                    throw new MobyException("Illegal XML: there is more than one tag in the response " + groupID + " with the articleName " + name);
                }
                job.put(name, MobyDataObject.createInstanceFromDOM((Element)simples.item(j), registry));
                continue;
            }
            if (!job.containsKey("")) {
                job.put("", MobyDataObject.createInstanceFromDOM((Element)simples.item(j), registry));
                continue;
            }
            debugPS.println("More than one anonymous member, ignoring simple #" + j);
        }
        NodeList parameters = MobyPrefixResolver.getChildElements(dataGroupTag, "Parameter");
        for (int j = 0; parameters != null && j < parameters.getLength(); ++j) {
            if (debug && j == 0) {
                debugPS.println("There are " + parameters.getLength() + " parameters in the response");
            }
            MobyDataSecondaryInstance paramObject = (MobyDataSecondaryInstance)MobyDataObject.createInstanceFromDOM((Element)parameters.item(j));
            job.put(paramObject.getName(), paramObject);
        }
        this.put(groupID, job);
    }

    public MobyDataObjectSet retrieveObjects() {
        MobyDataObjectSet contents = new MobyDataObjectSet("");
        for (String responseName : this.keySet()) {
            MobyDataJob response = this.get(responseName);
            if (response == null) continue;
            MobyDataInstance[] primaries = response.getPrimaryData();
            for (int j = 0; primaries != null && j < primaries.length; ++j) {
                MobyDataInstance data = primaries[j];
                if (data instanceof MobyDataObject) {
                    contents.add((MobyDataObject)data);
                    continue;
                }
                if (data instanceof MobyDataObjectSet) {
                    contents.addAll((MobyDataObjectSet)data);
                    continue;
                }
                System.err.println("Encountered unexpected data type: " + data.getClass());
            }
        }
        return contents;
    }

    public String getServiceAuthorityURI() {
        return this.serviceAuthURI;
    }

    public void setServiceAuthorityURI(String uri) {
        this.serviceAuthURI = uri;
    }

    public String getServiceNotes() {
        return this.serviceNotes;
    }

    public void setServiceNotes(String notes) {
        this.serviceNotes = notes;
    }

    public void setExceptions(ServiceException[] mes) {
        this.exceptions.clear();
        for (int i = 0; mes != null && i < mes.length; ++i) {
            this.exceptions.add(mes[i]);
        }
    }

    public void addException(ServiceException me) {
        this.exceptions.add(me);
    }

    public ServiceException[] getExceptions() {
        return this.exceptions.toArray(new ServiceException[this.exceptions.size()]);
    }

    public boolean hasExceptions() {
        return this.exceptions != null && this.exceptions.size() > 0;
    }

    public boolean hasExceptions(int severity) {
        if (this.exceptions == null || this.exceptions.size() == 0) {
            return false;
        }
        for (ServiceException se : this.exceptions) {
            if (se.getSeverity() > severity) continue;
            return true;
        }
        return false;
    }

    public void setXmlMode(int mode) throws IllegalArgumentException {
        if (mode != 124 && mode != 891) {
            throw new IllegalArgumentException("Value passed to setXmlMode was neither MobyDataInstance.CENTRAL_XML_MODE nor MobyDataInstance.SERVICE_XML_MODE");
        }
        this.xmlMode = mode;
    }

    public int getXmlMode() {
        return this.xmlMode;
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer("          <moby:mobyContent" + (this.serviceAuthURI == null ? "" : " moby:authority=\"" + this.serviceAuthURI + "\"") + ">\n");
        ServiceException[] exs = this.getExceptions();
        if (this.serviceNotes != null || exs.length != 0) {
            xml.append("    <moby:serviceNotes>");
            if (this.serviceNotes != null) {
                xml.append("<moby:Notes>" + this.serviceNotes + "</moby:" + "Notes" + ">");
            }
            for (int i = 0; i < exs.length; ++i) {
                xml.append(exs[i].toXMLString());
            }
            xml.append("</moby:serviceNotes>");
        }
        for (String queryName : this.keySet()) {
            xml.append("    <moby:mobyData queryID=\"" + queryName + "\">");
            MobyDataJob queryParams = this.get(queryName);
            for (String paramName : ((AbstractMap)queryParams).keySet()) {
                MobyDataInstance dataObject = (MobyDataInstance)((AbstractMap)queryParams).get(paramName);
                int oldXmlMode = dataObject.getXmlMode();
                if (oldXmlMode != 891) {
                    dataObject.setXmlMode(891);
                }
                if (dataObject instanceof MobyDataObject) {
                    xml.append("       <Simple articleName='" + paramName.replaceAll("'", "&apos;") + "'>" + dataObject.toXML() + "</Simple>");
                } else if (dataObject instanceof MobyDataObjectSet) {
                    String oldName = dataObject.getName();
                    dataObject.setName(paramName);
                    xml.append(dataObject.toXML());
                    dataObject.setName(oldName);
                } else {
                    xml.append(dataObject.toXML());
                }
                if (oldXmlMode == 891) continue;
                dataObject.setXmlMode(oldXmlMode);
            }
            xml.append("    </moby:mobyData>");
        }
        xml.append("          </moby:mobyContent>\n");
        return xml.toString();
    }

    @Override
    public void clear() {
        this.members.clear();
    }

    @Override
    public boolean containsKey(Object fieldName) {
        return this.members.containsKey(fieldName);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.members.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, MobyDataJob>> entrySet() {
        return this.members.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.members.equals(o);
    }

    @Override
    public MobyDataJob get(Object fieldName) {
        return this.members.get(fieldName);
    }

    @Override
    public int hashCode() {
        return this.members.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.members.keySet();
    }

    @Override
    public MobyDataJob put(String queryID, MobyDataJob value) {
        if (!(value instanceof AbstractMap)) {
            throw new IllegalArgumentException("Data passed as value of query " + queryID + "was not an AbstractMap as required in " + this.getClass());
        }
        if (queryID == null || !(queryID instanceof String) || queryID.length() == 0) {
            return this.members.put("" + this.autoID++, value);
        }
        return this.members.put(queryID, value);
    }

    public void put(MobyDataJob value) {
        this.put(null, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends MobyDataJob> map) {
        this.members.putAll(map);
    }

    @Override
    public MobyDataJob remove(Object fieldName) {
        return this.members.remove(fieldName);
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public Collection<MobyDataJob> values() {
        return this.members.values();
    }
}

