/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.MobyRelationship;
import org.biomoby.shared.data.MobyDataObject;
import org.biomoby.shared.data.MobyDataObjectSAI;
import org.biomoby.shared.data.MobyDataObjectSet;
import org.biomoby.shared.data.MobyDataObjectVector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyDataComposite
extends MobyDataObject
implements ConcurrentMap<String, MobyDataObject> {
    private ConcurrentHashMap<String, MobyDataObject> members;

    public MobyDataComposite(Element element) throws MobyException {
        this(element, null);
    }

    public MobyDataComposite(Element element, Registry registry) throws MobyException {
        this(MobyDataType.getDataType(element.getLocalName(), registry), MobyDataComposite.getName(element), MobyDataComposite.getNamespace(element, registry), MobyDataComposite.getId(element));
        if (this.getDataType() == null) {
            throw new MobyException("Attempted to build a composite MOBY object from XML, but the tag (" + element.getLocalName() + ") does not " + "correspond to an existing data type in the registry (" + (registry == null ? "default" : registry.getLongName()) + ").  Please check the spelling and capitalization of the " + "XML tag, to match a registered data type.");
        }
        this.populateMembersFromDOM(element, registry);
    }

    protected void populateMembersFromDOM(Element element, Registry registry) throws MobyException {
        NodeList substructures = MobyPrefixResolver.getChildElements(element, "*");
        int numSubstructures = substructures.getLength();
        for (int i = 0; i < numSubstructures; ++i) {
            Element child = (Element)substructures.item(i);
            if (child.getLocalName().equals("CrossReference")) {
                this.addCrossReferences(child, registry);
                continue;
            }
            if (child.getLocalName().equals("ProvisionInformation")) {
                this.addProvisionInfo(child);
                continue;
            }
            String fieldName = MobyDataComposite.getName(child);
            if (fieldName == null || fieldName.length() == 0) {
                throw new MobyException("The subelement with index " + i + " does not have an article " + "name, which is required (tag " + element.getNodeName() + ")");
            }
            MobyDataObject childObject = (MobyDataObject)MobyDataComposite.createInstanceFromDOM(child, registry);
            if (childObject == null) {
                throw new MobyException("The object member '" + fieldName + "' for object '" + this.getName() + " could not be properly parsed into a MOBY object");
            }
            this.put(fieldName, childObject);
        }
    }

    public MobyDataComposite(MobyDataType type, String name, MobyNamespace namespace, String id) {
        super(namespace.getName(), id, type.getRegistry());
        this.setName(name);
        this.setDataType(type);
        this.members = new ConcurrentHashMap();
    }

    public MobyDataComposite(MobyDataType type, String name, String namespace, String id) {
        super(namespace, id, type.getRegistry());
        this.setName(name);
        this.setDataType(type);
        this.members = new ConcurrentHashMap();
    }

    public MobyDataComposite(String typeName, String name, String namespace, String id) {
        this(typeName, name, namespace, id, null);
    }

    public MobyDataComposite(String typeName, String name, String namespace, String id, Registry registry) {
        super(namespace, id, registry);
        this.setName(name);
        this.setDataType(MobyDataType.getDataType(typeName, registry));
        this.members = new ConcurrentHashMap();
    }

    public MobyDataComposite(MobyDataType type, MobyNamespace namespace, String id, Object ... memberStrings) throws IllegalArgumentException, MobyException {
        super(namespace.getName(), id);
        if (type == null) {
            throw new IllegalArgumentException("MOBY data type given in composite object constructor was null (not in the ontology?)");
        }
        this.setDataType(type);
        this.members = new ConcurrentHashMap();
        MobyDataType dt = MobyDataType.getDataType(type.getName(), type.getRegistry());
        MobyRelationship[] children = dt.getAllChildren();
        if (memberStrings.length == 1) {
            if (children.length != 1) {
                throw new IllegalArgumentException("Only one member was specified to  MobyDataComposite constructor, but " + children.length + " are required " + "for data type " + type.getName());
            }
            if (memberStrings[0] instanceof MobyDataObject) {
                this.put(children[0].getName(), (MobyDataObject)memberStrings[0]);
            } else {
                this.put(children[0].getName(), MobyDataObject.createInstanceFromString(children[0].getDataTypeName(), memberStrings[0].toString()));
            }
            return;
        }
        for (int i = 0; i < memberStrings.length; ++i) {
            Object arg1 = memberStrings[i];
            if (!(arg1 instanceof String)) {
                throw new IllegalArgumentException("Argument was not a string (member name) as expected: " + arg1);
            }
            String name = (String)arg1;
            Object arg2 = memberStrings[++i];
            for (int j = 0; i < memberStrings.length && j < children.length; ++j) {
                MobyRelationship relationship = children[j];
                if (!name.equals(relationship.getName())) continue;
                int relationshipType = relationship.getRelationshipType();
                if (this.get(name) != null) {
                    throw new IllegalArgumentException("Datatype member " + name + " is repeated in the constructor");
                }
                if (relationshipType == 3) {
                    do {
                        if (arg2 instanceof MobyDataObject) {
                            if (!((MobyDataObject)arg2).getDataType().inheritsFrom(relationship.getDataTypeName())) {
                                throw new IllegalArgumentException("Argument " + arg2 + "is not of the required data type (" + relationship.getDataTypeName() + ")");
                            }
                            this.put(name, (MobyDataObject)arg2);
                            continue;
                        }
                        this.put(name, MobyDataObject.createInstanceFromString(relationship.getDataTypeName(), arg2.toString()));
                    } while (i + 1 < memberStrings.length && memberStrings[++i] != null);
                    continue;
                }
                if (arg2 instanceof MobyDataObject) {
                    if (!((MobyDataObject)arg2).getDataType().inheritsFrom(relationship.getDataTypeName())) {
                        throw new IllegalArgumentException("Argument " + arg2 + "is not of the required data type (" + relationship.getDataTypeName() + ")");
                    }
                    this.put(name, (MobyDataObject)arg2);
                    continue;
                }
                this.put(name, MobyDataObject.createInstanceFromString(relationship.getDataTypeName(), arg2.toString()));
            }
        }
    }

    public MobyDataComposite(MobyDataType type, String name) {
        this(type, name, "", "");
    }

    public MobyDataComposite(String typeName, String name) {
        this(typeName, name, null);
    }

    public MobyDataComposite(String typeName, String name, Registry r) {
        this(MobyDataType.getDataType(typeName, r), name);
    }

    public MobyDataComposite(MobyDataType type) {
        this(type, "");
    }

    public MobyDataComposite(String typeName) {
        this(typeName, (Registry)null);
    }

    public MobyDataComposite(String typeName, Registry r) {
        this(MobyDataType.getDataType(typeName, r));
    }

    @Override
    public Object clone() {
        MobyDataComposite theClone = new MobyDataComposite(this.getDataType(), this.getName(), "", this.getId());
        theClone.setNamespaces(this.getNamespaces());
        theClone.putAll((Map<? extends String, ? extends MobyDataObject>)this.members);
        return theClone;
    }

    public boolean isObjectValid() {
        return true;
    }

    @Override
    public String toXML() {
        if (this.xmlMode == 124) {
            return super.toXML();
        }
        if (this.isEmpty()) {
            return super.toXML();
        }
        Object[] fieldNames = this.members.keySet().toArray();
        Arrays.sort(fieldNames);
        StringBuffer instanceXML = new StringBuffer();
        instanceXML.append("<" + this.getDataType().getName() + " " + this.getAttrXML() + ">\n");
        instanceXML.append(this.getCRIBXML());
        instanceXML.append(this.getProvisionInfo() == null ? "" : this.getProvisionInfo().toXML());
        for (int i = 0; i < fieldNames.length; ++i) {
            int oldXmlMode;
            MobyDataObject mdsi = this.members.get(fieldNames[i]);
            if (!fieldNames[i].toString().equals(mdsi.getName())) {
                mdsi.setName(fieldNames[i].toString());
            }
            if ((oldXmlMode = mdsi.getXmlMode()) != 891) {
                mdsi.setXmlMode(891);
            }
            instanceXML.append(mdsi.toXML() + "\n");
            if (oldXmlMode == 891) continue;
            mdsi.setXmlMode(oldXmlMode);
        }
        instanceXML.append("</" + this.getDataType().getName() + ">");
        return instanceXML.toString();
    }

    @Override
    public Object getObject() {
        return this.members;
    }

    @Override
    public void clear() {
        this.members.clear();
    }

    @Override
    public boolean containsKey(Object fieldName) {
        return this.members.containsKey(fieldName);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.members.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, MobyDataObject>> entrySet() {
        return this.members.entrySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        MobyDataComposite other = null;
        if (o instanceof MobyDataComposite) {
            other = (MobyDataComposite)o;
        } else {
            if (!(o instanceof MobyDataObjectSAI)) return false;
            if (!(((MobyDataObjectSAI)o).getDataInstance() instanceof MobyDataComposite)) return false;
            other = (MobyDataComposite)((MobyDataObjectSAI)o).getDataInstance();
        }
        if (other.getDataType() == this.getDataType()) return this.members.equals(other);
        return false;
    }

    @Override
    public MobyDataObject get(Object fieldName) {
        return this.members.get(fieldName);
    }

    @Override
    public int hashCode() {
        return this.members.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.members.keySet();
    }

    @Override
    public MobyDataObject put(String fieldName, MobyDataObject value) {
        if (value == null) {
            return null;
        }
        MobyRelationship relationship = this.getDataType().getChild(fieldName);
        if (relationship == null && (relationship = MobyDataType.getDataType(this.getDataType().getName(), this.getDataType().getRegistry()).getChild(fieldName)) == null) {
            String memberNames = "";
            for (MobyRelationship rel : this.getDataType().getChildren()) {
                memberNames = memberNames + " " + rel.getName();
            }
            throw new IllegalArgumentException("The member '" + fieldName + "' for object '" + this.getName() + "' does not exist in the Moby ontology definition for " + this.getDataType().getName() + ", valid member names are:" + memberNames);
        }
        MobyDataType childDataType = MobyDataType.getDataType(relationship.getDataTypeName(), this.getDataType().getRegistry());
        if (!value.getDataType().inheritsFrom(childDataType)) {
            throw new IllegalArgumentException("The member '" + fieldName + "' for object '" + this.getName() + "' does not inherit from the required data type " + "(found data type " + value.getDataType().getName() + ", but require subclass of " + childDataType.getName() + ")");
        }
        if (this.members.containsKey(fieldName)) {
            MobyDataObject existingMember = this.members.get(fieldName);
            if (existingMember instanceof MobyDataObjectVector) {
                ((MobyDataObjectVector)existingMember).add(value);
                return existingMember;
            }
            MobyDataType dt = this.getDataType();
            if (dt == null) {
                return this.members.put(fieldName, value);
            }
            if (relationship == null) {
                return this.members.put(fieldName, value);
            }
            int relationshipType = relationship.getRelationshipType();
            if (relationshipType == 3) {
                MobyDataObjectVector HASList = new MobyDataObjectVector("", this.getDataType().getRegistry());
                this.members.put(fieldName, HASList);
                HASList.add(existingMember);
                HASList.add(value);
                return HASList;
            }
            return this.members.put(fieldName, value);
        }
        return this.members.put(fieldName, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends MobyDataObject> map) {
        this.members.putAll(map);
    }

    @Override
    public MobyDataObject remove(Object fieldName) {
        return this.members.remove(fieldName);
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public Collection<MobyDataObject> values() {
        return new MobyDataObjectSet("", this.members.values());
    }

    @Override
    public MobyDataObject putIfAbsent(String key, MobyDataObject value) {
        return this.members.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.members.remove(key, value);
    }

    @Override
    public MobyDataObject replace(String fieldName, MobyDataObject value) {
        return this.members.replace(fieldName, value);
    }

    @Override
    public boolean replace(String fieldName, MobyDataObject oldValue, MobyDataObject newValue) {
        return this.members.replace(fieldName, oldValue, newValue);
    }
}

