/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.MobyPrimaryDataSet;
import org.biomoby.shared.MobyPrimaryDataSimple;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyDataObjectSet
extends MobyPrimaryDataSet
implements MobyDataInstance,
Collection<MobyDataObject> {
    Vector<MobyDataObject> bag;
    Registry registry;
    private int xmlMode = 124;

    public MobyDataObjectSet(Element e) throws MobyException {
        this(e, null);
    }

    public MobyDataObjectSet(Element e, Registry registry) throws MobyException {
        this(MobyDataObject.getName(e), MobyDataObjectSet.getChildren(e, registry));
        if (this.getName() == null) {
            throw new MobyException("Anonymous collections are not allowed (need articleName), input was :\n" + e);
        }
    }

    public static Collection<? extends MobyDataObject> getChildren(Element e, Registry registry) throws MobyException {
        Vector<MobyDataObject> members = new Vector<MobyDataObject>();
        NodeList children = MobyPrefixResolver.getChildElements(e, "*");
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            MobyDataInstance mdi = MobyDataObject.createInstanceFromDOM((Element)children.item(i), registry);
            if (!(mdi instanceof MobyDataObject)) continue;
            members.add((MobyDataObject)mdi);
        }
        return members;
    }

    public MobyDataObjectSet(String name) {
        this(name, (Registry)null);
    }

    public MobyDataObjectSet(String name, Registry reg) {
        super(name);
        this.registry = reg;
        this.bag = new Vector();
    }

    public MobyDataObjectSet(String name, MobyDataObject[] values) throws NullPointerException {
        this(name, values.length == 0 ? null : values[0].getDataType().getRegistry());
        this.setElements(values);
    }

    public MobyDataObjectSet(String name, Collection<? extends MobyDataObject> c) throws ClassCastException, NullPointerException {
        this(name, c.isEmpty() ? null : c.iterator().next().getDataType().getRegistry());
        this.addAll(c);
    }

    public Object clone() {
        return new MobyDataObjectSet(this.getName(), this.bag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MobyDataType getDataType() {
        MobyDataType[] lineage = null;
        boolean first = true;
        Vector<MobyDataObject> vector = this.bag;
        synchronized (vector) {
            if (this.bag.size() > 0) {
                MobyDataType[] objLineage;
                MobyDataObject member;
                MobyDataType objType;
                Iterator<MobyDataObject> i$ = this.bag.iterator();
                while (i$.hasNext() && (objType = (member = i$.next()).getDataType()) != null && (objLineage = objType.getLineage()) != null) {
                    if (first) {
                        lineage = objLineage;
                        first = false;
                    } else {
                        for (int i = 0; i < lineage.length; ++i) {
                            if (i < objLineage.length && lineage[i].equals(objLineage[i])) continue;
                            lineage = new MobyDataType[i];
                            System.arraycopy(objLineage, 0, lineage, 0, i);
                            break;
                        }
                    }
                    if (lineage.length >= 2) continue;
                    break;
                }
                if (lineage != null && lineage.length == 0) {
                    return MobyDataType.getDataType("Object", this.registry);
                }
                return lineage == null ? null : lineage[lineage.length - 1];
            }
            return MobyDataType.getDataType("Object", this.registry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MobyNamespace[] getNamespaces() {
        Vector namespaces = new Vector();
        boolean first = true;
        Vector<MobyDataObject> vector = this.bag;
        synchronized (vector) {
            for (MobyDataObject member : this.bag) {
                MobyNamespace[] nsInstances = member.getNamespaces();
                Vector<MobyNamespace> newNames = new Vector<MobyNamespace>();
                for (int i = 0; nsInstances != null && i < nsInstances.length; ++i) {
                    newNames.add(nsInstances[i]);
                }
                if (first) {
                    namespaces.addAll(newNames);
                    first = false;
                } else {
                    namespaces.retainAll(newNames);
                }
                if (namespaces.size() != 0) continue;
                break;
            }
        }
        return namespaces.toArray(new MobyNamespace[namespaces.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNamespaces(MobyNamespace[] values) {
        Vector<MobyDataObject> vector = this.bag;
        synchronized (vector) {
            for (MobyDataObject member : this.bag) {
                member.setNamespaces(values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNamespace(MobyNamespace value) {
        Vector<MobyDataObject> vector = this.bag;
        synchronized (vector) {
            for (MobyDataObject member : this.bag) {
                member.addNamespace(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNamespace(String namespaceName) {
        Vector<MobyDataObject> vector = this.bag;
        synchronized (vector) {
            for (MobyDataObject member : this.bag) {
                member.removeNamespace(namespaceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNamespace(MobyNamespace value) {
        Vector<MobyDataObject> vector = this.bag;
        synchronized (vector) {
            for (MobyDataObject member : this.bag) {
                member.removeNamespace(value);
            }
        }
    }

    public void setElements(MobyDataObject[] values) throws NullPointerException {
        int i;
        if (values == null) {
            throw new NullPointerException("An attempt was made to set a  MobyDataObjectSet's members from a null array, which is disallowed");
        }
        for (i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new NullPointerException("An attempt was made to set a MobyDataObjectSet's members from an array, but the element at index " + i + " was null, which is disallowed.");
        }
        this.bag.clear();
        for (i = 0; i < values.length; ++i) {
            this.bag.add(values[i]);
        }
    }

    @Override
    public Object getObject() {
        return this.bag;
    }

    @Override
    public MobyPrimaryDataSimple[] getElements() {
        return this.getElementInstances();
    }

    public MobyDataObject[] getElementInstances() {
        MobyDataObject[] instances = new MobyDataObject[this.bag.size()];
        return this.bag.toArray(instances);
    }

    private void checkInputClass(String action, Object mdsi) throws ClassCastException, NullPointerException {
        if (mdsi == null) {
            throw new NullPointerException("An attempt to " + action + " a null object was made, but null " + "objects are disallowed in MobyDataObjectSet collections.");
        }
        if (!(mdsi instanceof MobyDataObject)) {
            throw new ClassCastException("The MobyDataObjectSet collection can only contain MobyDataObject objects, but an attempt to " + action + " a " + mdsi.getClass().getName() + " was made.");
        }
    }

    private void checkCollectionClass(String action, Collection c) throws ClassCastException, NullPointerException {
        if (c == null) {
            throw new NullPointerException("An attempt to " + action + " a null collection was made, but null " + "collection operations in MobyDataObjectSet are disallowed.");
        }
        for (Object element : c) {
            if (element instanceof MobyDataObject) continue;
            throw new ClassCastException("Attempted to " + action + " a " + element.getClass().getName() + "to a MobyDataObjectSet as part of a collection (" + c.getClass().getName() + "), which is disallowed");
        }
    }

    @Override
    public boolean add(MobyDataObject mdo) throws NullPointerException {
        this.checkInputClass("add", mdo);
        return this.bag.add(mdo);
    }

    @Override
    public boolean addAll(Collection<? extends MobyDataObject> c) throws NullPointerException {
        this.checkCollectionClass("add", c);
        return this.bag.addAll(c);
    }

    @Override
    public void clear() {
        this.bag.clear();
    }

    @Override
    public boolean contains(Object mdsi) throws ClassCastException, NullPointerException {
        this.checkInputClass("check for the presence of", mdsi);
        return this.bag.contains(mdsi);
    }

    @Override
    public boolean containsAll(Collection c) throws ClassCastException, NullPointerException {
        this.checkCollectionClass("check for presence of", c);
        return this.bag.containsAll(c);
    }

    @Override
    public boolean equals(Object set) throws ClassCastException, NullPointerException {
        if (this == set) {
            return true;
        }
        if (!(set instanceof Collection)) {
            throw new ClassCastException("An attempt to check the equivalency of a " + set.getClass().getName() + " to a MobyDataObjectSet was made, but that class is not a Collection.");
        }
        this.checkInputClass("check for equivalency of", set);
        Object[] mdsis = this.getElementInstances();
        Arrays.sort(mdsis);
        this.setElements((MobyDataObject[])mdsis);
        Object[] inputMdsis = (MobyDataObject[])((Collection)set).toArray();
        Arrays.sort(inputMdsis);
        Vector<Object> sortedInput = new Vector<Object>();
        for (int i = 0; i < inputMdsis.length; ++i) {
            sortedInput.add(inputMdsis[i]);
        }
        return this.bag.equals(sortedInput);
    }

    @Override
    public int hashCode() {
        return this.bag == null ? super.hashCode() : this.bag.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.bag.isEmpty();
    }

    @Override
    public Iterator<MobyDataObject> iterator() {
        return this.bag.iterator();
    }

    @Override
    public boolean remove(Object mdsi) throws ClassCastException, NullPointerException {
        this.checkInputClass("remove", mdsi);
        return this.bag.remove(mdsi);
    }

    @Override
    public boolean removeAll(Collection c) throws ClassCastException, NullPointerException {
        this.checkCollectionClass("remove", c);
        return this.bag.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        this.checkCollectionClass("intersect", c);
        return this.bag.retainAll(c);
    }

    @Override
    public int size() {
        return this.bag.size();
    }

    @Override
    public Object[] toArray() {
        MobyDataObject[] mdsis = new MobyDataObject[this.bag.size()];
        return this.bag.toArray(mdsis);
    }

    @Override
    public <T> T[] toArray(T[] classArray) throws ArrayStoreException, NullPointerException {
        return this.bag.toArray(classArray);
    }

    @Override
    public void setXmlMode(int mode) throws IllegalArgumentException {
        if (mode != 124 && mode != 891) {
            throw new IllegalArgumentException("Value passed to setXmlMode was neither MobyDataInstance.CENTRAL_XML_MODE nor MobyDataInstance.SERVICE_XML_MODE");
        }
        this.xmlMode = mode;
    }

    @Override
    public int getXmlMode() {
        return this.xmlMode;
    }

    @Override
    public String toXML() {
        StringBuffer collectionXml = new StringBuffer();
        if (this.xmlMode == 891) {
            collectionXml.append("<moby:Collection xmlns:moby=\"http://www.biomoby.org/moby" + (this.getName() != null ? "\" moby:articleName=\"" + this.getName() : "") + "\">\n");
            for (MobyDataObject mdsi : this.bag) {
                mdsi.setXmlMode(this.xmlMode);
                collectionXml.append("<Simple>" + mdsi.toXML() + "</" + "Simple" + ">");
            }
            collectionXml.append("\n</moby:Collection>\n");
        } else {
            collectionXml.append("<Collection>\n");
            MobyPrimaryDataSimple commonDataTemplate = new MobyPrimaryDataSimple("");
            commonDataTemplate.setDataType(this.getDataType());
            commonDataTemplate.setNamespaces(this.getNamespaces());
            collectionXml.append(commonDataTemplate.toXML());
            collectionXml.append("</Collection>\n");
        }
        return collectionXml.toString();
    }
}

