/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.data.MobyDataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobyDataObjectVector
extends MobyDataObject
implements List<MobyDataObject> {
    private Vector<MobyDataObject> members;

    public MobyDataObjectVector(String name) {
        this(name, (Registry)null);
    }

    public MobyDataObjectVector(String name, Registry registry) {
        this(name, 5, registry);
    }

    public MobyDataObjectVector(String name, int initialCapacity) {
        this(name, initialCapacity, null);
    }

    public MobyDataObjectVector(String name, int initialCapacity, Registry registry) {
        super(name, registry);
        this.members = new Vector(initialCapacity);
    }

    @Override
    public String toXML() {
        StringBuffer concatXML = new StringBuffer();
        for (MobyDataObject mdsi : this.members) {
            int oldXmlMode;
            if (!this.getName().equals(mdsi.getName())) {
                mdsi.setName(this.getName());
            }
            if ((oldXmlMode = mdsi.getXmlMode()) != this.xmlMode) {
                mdsi.setXmlMode(this.xmlMode);
            }
            concatXML.append(mdsi.toXML() + "\n");
            if (oldXmlMode == this.xmlMode) continue;
            mdsi.setXmlMode(oldXmlMode);
        }
        return concatXML.toString();
    }

    @Override
    public boolean add(MobyDataObject mdo) {
        if (mdo instanceof MobyDataObjectVector) {
            return this.addAll((MobyDataObjectVector)mdo);
        }
        return this.members.add(mdo);
    }

    @Override
    public void add(int index, MobyDataObject mdo) {
        if (mdo instanceof MobyDataObjectVector) {
            this.addAll(index, (MobyDataObjectVector)mdo);
        } else {
            this.members.add(index, mdo);
        }
    }

    @Override
    public boolean addAll(Collection<? extends MobyDataObject> c) {
        return this.members.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends MobyDataObject> c) {
        return this.members.addAll(index, c);
    }

    @Override
    public void clear() {
        this.members.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.members.contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.members.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.members.equals(o);
    }

    @Override
    public MobyDataObject get(int index) {
        return this.members.get(index);
    }

    @Override
    public int hashCode() {
        return this.members.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.members.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public Iterator<MobyDataObject> iterator() {
        return this.members.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.members.lastIndexOf(o);
    }

    @Override
    public ListIterator<MobyDataObject> listIterator() {
        return this.members.listIterator();
    }

    @Override
    public ListIterator<MobyDataObject> listIterator(int index) {
        return this.members.listIterator(index);
    }

    @Override
    public MobyDataObject remove(int index) {
        return this.members.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.members.remove(o);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.members.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.members.retainAll(c);
    }

    @Override
    public MobyDataObject set(int index, MobyDataObject element) {
        if (element instanceof MobyDataObjectVector) {
            MobyDataObject removedObject = this.remove(index);
            this.addAll(index, (MobyDataObjectVector)element);
            return removedObject;
        }
        return this.members.set(index, element);
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public List<MobyDataObject> subList(int fromIndex, int toIndex) {
        return this.members.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.members.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) throws ClassCastException {
        return this.members.toArray(a);
    }
}

